/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.tk.Toolkit;
import com.sun.scenario.effect.Identity;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;

public class ImageInput
extends Effect {
    private ObjectProperty<Image> source;
    private final AbstractNotifyListener platformImageChangeListener = new AbstractNotifyListener(){

        public void invalidated(Observable valueModel) {
            ImageInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
            ImageInput.this.effectBoundsChanged();
        }
    };
    private Image oldImage;
    private DoubleProperty x;
    private DoubleProperty y;

    public ImageInput() {
    }

    public ImageInput(Image source) {
        this.setSource(source);
    }

    public ImageInput(Image source, double x, double y) {
        this.setSource(source);
        this.setX(x);
        this.setY(y);
    }

    @Override
    Identity createPeer() {
        return new Identity(null);
    }

    public final void setSource(Image value) {
        this.sourceProperty().set((Object)value);
    }

    public final Image getSource() {
        return this.source == null ? null : (Image)this.source.get();
    }

    public final ObjectProperty<Image> sourceProperty() {
        if (this.source == null) {
            this.source = new ObjectPropertyBase<Image>(){
                private boolean needsListeners = false;

                public void invalidated() {
                    Image _image = (Image)this.get();
                    Toolkit.ImageAccessor accessor = Toolkit.getImageAccessor();
                    if (this.needsListeners) {
                        accessor.getImageProperty(ImageInput.this.oldImage).removeListener(ImageInput.this.platformImageChangeListener.getWeakListener());
                    }
                    this.needsListeners = _image != null && (accessor.isAnimation(_image) || _image.getProgress() < 1.0);
                    ImageInput.this.oldImage = _image;
                    if (this.needsListeners) {
                        accessor.getImageProperty(_image).addListener(ImageInput.this.platformImageChangeListener.getWeakListener());
                    }
                    ImageInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ImageInput.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return ImageInput.this;
                }

                public String getName() {
                    return "source";
                }
            };
        }
        return this.source;
    }

    public final void setX(double value) {
        this.xProperty().set(value);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                public void invalidated() {
                    ImageInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ImageInput.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return ImageInput.this;
                }

                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double value) {
        this.yProperty().set(value);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                public void invalidated() {
                    ImageInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ImageInput.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return ImageInput.this;
                }

                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    @Override
    void update() {
        Identity peer = (Identity)this.getPeer();
        Image localSource = this.getSource();
        if (localSource != null && Toolkit.getImageAccessor().getPlatformImage(localSource) != null) {
            peer.setSource(Toolkit.getToolkit().toFilterable(localSource));
        } else {
            peer.setSource(null);
        }
        peer.setLocation(new Point2D((float)this.getX(), (float)this.getY()));
    }

    @Override
    boolean checkChainContains(Effect e) {
        return false;
    }

    @Override
    BaseBounds getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        Image localSource = this.getSource();
        if (localSource != null && Toolkit.getImageAccessor().getPlatformImage(localSource) != null) {
            float localX = (float)this.getX();
            float localY = (float)this.getY();
            float localWidth = (float)localSource.getWidth();
            float localHeight = (float)localSource.getHeight();
            RectBounds r = new RectBounds(localX, localY, localX + localWidth, localY + localHeight);
            return ImageInput.transformBounds(tx, r);
        }
        return new RectBounds();
    }

    @Override
    Effect copy() {
        return new ImageInput(this.getSource(), this.getX(), this.getY());
    }
}

