/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.tk.Toolkit;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.util.Callback;

public class PixelBuffer<T extends Buffer> {
    private final T buffer;
    private final int width;
    private final int height;
    private final PixelFormat<T> pixelFormat;
    private final List<WeakReference<WritableImage>> imageRefs;

    public PixelBuffer(int width, int height, T buffer, PixelFormat<T> pixelFormat) {
        Objects.requireNonNull(buffer, "buffer must not be null.");
        Objects.requireNonNull(pixelFormat, "pixelFormat must not be null.");
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("PixelBuffer dimensions must be positive (w,h > 0)");
        }
        switch (pixelFormat.getType()) {
            case BYTE_BGRA_PRE: {
                if (((Buffer)buffer).capacity() / width / 4 < height) {
                    throw new IllegalArgumentException("Insufficient memory allocated for ByteBuffer.");
                }
                if (buffer instanceof ByteBuffer) break;
                throw new IllegalArgumentException("PixelFormat<ByteBuffer> requires a ByteBuffer.");
            }
            case INT_ARGB_PRE: {
                if (((Buffer)buffer).capacity() / width < height) {
                    throw new IllegalArgumentException("Insufficient memory allocated for IntBuffer.");
                }
                if (buffer instanceof IntBuffer) break;
                throw new IllegalArgumentException("PixelFormat<IntBuffer> requires an IntBuffer.");
            }
            default: {
                throw new IllegalArgumentException("Unsupported PixelFormat: " + pixelFormat.getType());
            }
        }
        this.buffer = buffer;
        this.width = width;
        this.height = height;
        this.pixelFormat = pixelFormat;
        this.imageRefs = new LinkedList<WeakReference<WritableImage>>();
    }

    public T getBuffer() {
        return this.buffer;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public PixelFormat<T> getPixelFormat() {
        return this.pixelFormat;
    }

    public void updateBuffer(Callback<PixelBuffer<T>, Rectangle2D> callback) {
        Toolkit.getToolkit().checkFxUserThread();
        Objects.requireNonNull(callback, "callback must not be null.");
        Rectangle2D rect2D = (Rectangle2D)callback.call((Object)this);
        if (rect2D != null) {
            if (rect2D.getWidth() > 0.0 && rect2D.getHeight() > 0.0) {
                int x1 = (int)Math.floor(rect2D.getMinX());
                int y1 = (int)Math.floor(rect2D.getMinY());
                int x2 = (int)Math.ceil(rect2D.getMaxX());
                int y2 = (int)Math.ceil(rect2D.getMaxY());
                this.bufferDirty(new Rectangle(x1, y1, x2 - x1, y2 - y1));
            }
        } else {
            this.bufferDirty(null);
        }
    }

    private void bufferDirty(Rectangle rect) {
        Iterator<WeakReference<WritableImage>> iter = this.imageRefs.iterator();
        while (iter.hasNext()) {
            WritableImage image = (WritableImage)iter.next().get();
            if (image != null) {
                image.bufferDirty(rect);
                continue;
            }
            iter.remove();
        }
    }

    void addImage(WritableImage image) {
        this.imageRefs.add(new WeakReference<WritableImage>(image));
        this.imageRefs.removeIf(imageRef -> imageRef.get() == null);
    }
}

