/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.InputEvent;
import javafx.scene.input.InputMethodTextRun;

public final class InputMethodEvent
extends InputEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<InputMethodEvent> INPUT_METHOD_TEXT_CHANGED = new EventType(InputEvent.ANY, "INPUT_METHOD_TEXT_CHANGED");
    public static final EventType<InputMethodEvent> ANY = INPUT_METHOD_TEXT_CHANGED;
    private transient ObservableList<InputMethodTextRun> composed;
    private final String committed;
    private final int caretPosition;

    public InputMethodEvent(@NamedArg(value="source") Object source, @NamedArg(value="target") EventTarget target, @NamedArg(value="eventType") EventType<InputMethodEvent> eventType, @NamedArg(value="composed") List<InputMethodTextRun> composed, @NamedArg(value="committed") String committed, @NamedArg(value="caretPosition") int caretPosition) {
        super(source, target, eventType);
        this.composed = FXCollections.unmodifiableObservableList((ObservableList)FXCollections.observableArrayList(composed));
        this.committed = committed;
        this.caretPosition = caretPosition;
    }

    public InputMethodEvent(@NamedArg(value="eventType") EventType<InputMethodEvent> eventType, @NamedArg(value="composed") List<InputMethodTextRun> composed, @NamedArg(value="committed") String committed, @NamedArg(value="caretPosition") int caretPosition) {
        this(null, null, eventType, composed, committed, caretPosition);
    }

    public final ObservableList<InputMethodTextRun> getComposed() {
        return this.composed;
    }

    public final String getCommitted() {
        return this.committed;
    }

    public final int getCaretPosition() {
        return this.caretPosition;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InputMethodEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        sb.append(", composed = ").append(this.getComposed());
        sb.append(", committed = ").append(this.getCommitted());
        sb.append(", caretPosition = ").append(this.getCaretPosition());
        return sb.append("]").toString();
    }

    public InputMethodEvent copyFor(Object newSource, EventTarget newTarget) {
        return (InputMethodEvent)super.copyFor(newSource, newTarget);
    }

    public EventType<InputMethodEvent> getEventType() {
        return super.getEventType();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(new ArrayList<InputMethodTextRun>((Collection<InputMethodTextRun>)this.composed));
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        ArrayList o = (ArrayList)ois.readObject();
        this.composed = FXCollections.unmodifiableObservableList((ObservableList)FXCollections.observableArrayList((Collection)o));
    }
}

