/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.UnmodifiableArrayList;
import com.sun.javafx.css.SubCssMetaData;
import com.sun.javafx.scene.layout.region.BorderImageSlices;
import com.sun.javafx.scene.layout.region.BorderImageWidthConverter;
import com.sun.javafx.scene.layout.region.CornerRadiiConverter;
import com.sun.javafx.scene.layout.region.LayeredBorderPaintConverter;
import com.sun.javafx.scene.layout.region.LayeredBorderStyleConverter;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.RepeatStruct;
import com.sun.javafx.scene.layout.region.RepeatStructConverter;
import com.sun.javafx.scene.layout.region.SliceSequenceConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.converter.InsetsConverter;
import javafx.css.converter.URLConverter;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BorderImage;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Paint;

public final class Border {
    static final CssMetaData<Node, Paint[]> BORDER_COLOR = new SubCssMetaData<Paint[]>("-fx-border-color", (StyleConverter)LayeredBorderPaintConverter.getInstance());
    static final CssMetaData<Node, BorderStrokeStyle[][]> BORDER_STYLE = new SubCssMetaData<BorderStrokeStyle[][]>("-fx-border-style", (StyleConverter)LayeredBorderStyleConverter.getInstance());
    static final CssMetaData<Node, Margins[]> BORDER_WIDTH = new SubCssMetaData<Margins[]>("-fx-border-width", (StyleConverter)Margins.SequenceConverter.getInstance());
    static final CssMetaData<Node, CornerRadii[]> BORDER_RADIUS = new SubCssMetaData<CornerRadii[]>("-fx-border-radius", (StyleConverter)CornerRadiiConverter.getInstance());
    static final CssMetaData<Node, Insets[]> BORDER_INSETS = new SubCssMetaData<Insets[]>("-fx-border-insets", (StyleConverter)InsetsConverter.SequenceConverter.getInstance());
    static final CssMetaData<Node, String[]> BORDER_IMAGE_SOURCE = new SubCssMetaData<String[]>("-fx-border-image-source", (StyleConverter)URLConverter.SequenceConverter.getInstance());
    static final CssMetaData<Node, RepeatStruct[]> BORDER_IMAGE_REPEAT = new SubCssMetaData<RepeatStruct[]>("-fx-border-image-repeat", (StyleConverter)RepeatStructConverter.getInstance(), new RepeatStruct[]{new RepeatStruct(BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT)});
    static final CssMetaData<Node, BorderImageSlices[]> BORDER_IMAGE_SLICE = new SubCssMetaData<BorderImageSlices[]>("-fx-border-image-slice", (StyleConverter)SliceSequenceConverter.getInstance(), new BorderImageSlices[]{BorderImageSlices.DEFAULT});
    static final CssMetaData<Node, BorderWidths[]> BORDER_IMAGE_WIDTH = new SubCssMetaData<BorderWidths[]>("-fx-border-image-width", (StyleConverter)BorderImageWidthConverter.getInstance(), new BorderWidths[]{BorderWidths.DEFAULT});
    static final CssMetaData<Node, Insets[]> BORDER_IMAGE_INSETS = new SubCssMetaData<Insets[]>("-fx-border-image-insets", (StyleConverter)InsetsConverter.SequenceConverter.getInstance(), new Insets[]{Insets.EMPTY});
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES = Collections.unmodifiableList(Arrays.asList(BORDER_COLOR, BORDER_STYLE, BORDER_WIDTH, BORDER_RADIUS, BORDER_INSETS, BORDER_IMAGE_SOURCE, BORDER_IMAGE_REPEAT, BORDER_IMAGE_SLICE, BORDER_IMAGE_WIDTH, BORDER_IMAGE_INSETS));
    public static final Border EMPTY = new Border((BorderStroke[])null, null);
    final List<BorderStroke> strokes;
    final List<BorderImage> images;
    final Insets outsets;
    final Insets insets;
    private final int hash;

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public final List<BorderStroke> getStrokes() {
        return this.strokes;
    }

    public final List<BorderImage> getImages() {
        return this.images;
    }

    public final Insets getOutsets() {
        return this.outsets;
    }

    public final Insets getInsets() {
        return this.insets;
    }

    public final boolean isEmpty() {
        return this.strokes.isEmpty() && this.images.isEmpty();
    }

    public Border(BorderStroke ... strokes) {
        this(strokes, (BorderImage[])null);
    }

    public Border(BorderImage ... images) {
        this((BorderStroke[])null, images);
    }

    public Border(@NamedArg(value="strokes") List<BorderStroke> strokes, @NamedArg(value="images") List<BorderImage> images) {
        this(strokes == null ? null : strokes.toArray(new BorderStroke[strokes.size()]), images == null ? null : images.toArray(new BorderImage[images.size()]));
    }

    public Border(@NamedArg(value="strokes") BorderStroke[] strokes, @NamedArg(value="images") BorderImage[] images) {
        int i;
        int size;
        Object[] noNulls;
        double innerTop = 0.0;
        double innerRight = 0.0;
        double innerBottom = 0.0;
        double innerLeft = 0.0;
        double outerTop = 0.0;
        double outerRight = 0.0;
        double outerBottom = 0.0;
        double outerLeft = 0.0;
        if (strokes == null || strokes.length == 0) {
            this.strokes = Collections.emptyList();
        } else {
            noNulls = new BorderStroke[strokes.length];
            size = 0;
            for (i = 0; i < strokes.length; ++i) {
                BorderStroke stroke = strokes[i];
                if (stroke == null) continue;
                noNulls[size++] = stroke;
                double strokeInnerTop = stroke.innerEdge.getTop();
                double strokeInnerRight = stroke.innerEdge.getRight();
                double strokeInnerBottom = stroke.innerEdge.getBottom();
                double strokeInnerLeft = stroke.innerEdge.getLeft();
                innerTop = innerTop >= strokeInnerTop ? innerTop : strokeInnerTop;
                innerRight = innerRight >= strokeInnerRight ? innerRight : strokeInnerRight;
                innerBottom = innerBottom >= strokeInnerBottom ? innerBottom : strokeInnerBottom;
                innerLeft = innerLeft >= strokeInnerLeft ? innerLeft : strokeInnerLeft;
                double strokeOuterTop = stroke.outerEdge.getTop();
                double strokeOuterRight = stroke.outerEdge.getRight();
                double strokeOuterBottom = stroke.outerEdge.getBottom();
                double strokeOuterLeft = stroke.outerEdge.getLeft();
                outerTop = outerTop >= strokeOuterTop ? outerTop : strokeOuterTop;
                outerRight = outerRight >= strokeOuterRight ? outerRight : strokeOuterRight;
                outerBottom = outerBottom >= strokeOuterBottom ? outerBottom : strokeOuterBottom;
                outerLeft = outerLeft >= strokeOuterLeft ? outerLeft : strokeOuterLeft;
            }
            this.strokes = new UnmodifiableArrayList(noNulls, size);
        }
        if (images == null || images.length == 0) {
            this.images = Collections.emptyList();
        } else {
            noNulls = new BorderImage[images.length];
            size = 0;
            for (i = 0; i < images.length; ++i) {
                BorderImage image = images[i];
                if (image == null) continue;
                noNulls[size++] = image;
                double imageInnerTop = image.innerEdge.getTop();
                double imageInnerRight = image.innerEdge.getRight();
                double imageInnerBottom = image.innerEdge.getBottom();
                double imageInnerLeft = image.innerEdge.getLeft();
                innerTop = innerTop >= imageInnerTop ? innerTop : imageInnerTop;
                innerRight = innerRight >= imageInnerRight ? innerRight : imageInnerRight;
                innerBottom = innerBottom >= imageInnerBottom ? innerBottom : imageInnerBottom;
                innerLeft = innerLeft >= imageInnerLeft ? innerLeft : imageInnerLeft;
                double imageOuterTop = image.outerEdge.getTop();
                double imageOuterRight = image.outerEdge.getRight();
                double imageOuterBottom = image.outerEdge.getBottom();
                double imageOuterLeft = image.outerEdge.getLeft();
                outerTop = outerTop >= imageOuterTop ? outerTop : imageOuterTop;
                outerRight = outerRight >= imageOuterRight ? outerRight : imageOuterRight;
                outerBottom = outerBottom >= imageOuterBottom ? outerBottom : imageOuterBottom;
                outerLeft = outerLeft >= imageOuterLeft ? outerLeft : imageOuterLeft;
            }
            this.images = new UnmodifiableArrayList(noNulls, size);
        }
        this.outsets = new Insets(outerTop, outerRight, outerBottom, outerLeft);
        this.insets = new Insets(innerTop, innerRight, innerBottom, innerLeft);
        int result = this.strokes.hashCode();
        this.hash = result = 31 * result + this.images.hashCode();
    }

    public static Border stroke(Paint stroke) {
        return new Border(new BorderStroke(stroke, BorderStrokeStyle.SOLID, null, null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Border border = (Border)o;
        if (this.hash != border.hash) {
            return false;
        }
        if (!this.images.equals(border.images)) {
            return false;
        }
        return this.strokes.equals(border.strokes);
    }

    public int hashCode() {
        return this.hash;
    }
}

