/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.Vec2d;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.layout.RegionHelper;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGRegion;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.TempState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.InsetsConverter;
import javafx.css.converter.ShapeConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundConverter;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderConverter;
import javafx.scene.layout.BorderImage;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.stage.Window;
import javafx.util.Callback;

public class Region
extends Parent {
    public static final double USE_PREF_SIZE = Double.NEGATIVE_INFINITY;
    public static final double USE_COMPUTED_SIZE = -1.0;
    static Vec2d TEMP_VEC2D;
    private static final double EPSILON = 1.0E-14;
    private InvalidationListener imageChangeListener = observable -> {
        ReadOnlyObjectPropertyBase imageProperty = (ReadOnlyObjectPropertyBase)observable;
        Image image = (Image)imageProperty.getBean();
        Toolkit.ImageAccessor acc = Toolkit.getImageAccessor();
        if (image.getProgress() == 1.0 && !acc.isAnimation(image)) {
            this.removeImageListener(image);
        }
        NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
    };
    private BooleanProperty snapToPixel;
    private boolean _snapToPixel;
    private ObjectProperty<Insets> padding;
    private final ObjectProperty<Background> background;
    private final ObjectProperty<Border> border;
    private ObjectProperty<Insets> opaqueInsets;
    private final InsetsProperty insets;
    private double snappedTopInset;
    private double snappedRightInset;
    private double snappedBottomInset;
    private double snappedLeftInset;
    private double lastUsedSnapScaleY;
    private double lastUsedSnapScaleX;
    private ReadOnlyDoubleWrapper width;
    private double _width;
    private ReadOnlyDoubleWrapper height;
    private double _height;
    private DoubleProperty minWidth;
    private double _minWidth;
    private DoubleProperty minHeight;
    private double _minHeight;
    private DoubleProperty prefWidth;
    private double _prefWidth;
    private DoubleProperty prefHeight;
    private double _prefHeight;
    private DoubleProperty maxWidth;
    private double _maxWidth;
    private DoubleProperty maxHeight;
    private double _maxHeight;
    private ObjectProperty<javafx.scene.shape.Shape> shape;
    private javafx.scene.shape.Shape _shape;
    private BooleanProperty scaleShape;
    private BooleanProperty centerShape;
    private BooleanProperty cacheShape;
    private boolean cornersValid;
    private List<CornerRadii> normalizedFillCorners;
    private List<CornerRadii> normalizedStrokeCorners;
    private Bounds boundingBox;

    static double boundedSize(double min, double pref, double max) {
        double a = pref >= min ? pref : min;
        double b = min >= max ? min : max;
        return a <= b ? a : b;
    }

    double adjustWidthByMargin(double width, Insets margin) {
        if (margin == null || margin == Insets.EMPTY) {
            return width;
        }
        boolean isSnapToPixel = this.isSnapToPixel();
        return width - this.snapSpaceX(margin.getLeft(), isSnapToPixel) - this.snapSpaceX(margin.getRight(), isSnapToPixel);
    }

    double adjustHeightByMargin(double height, Insets margin) {
        if (margin == null || margin == Insets.EMPTY) {
            return height;
        }
        boolean isSnapToPixel = this.isSnapToPixel();
        return height - this.snapSpaceY(margin.getTop(), isSnapToPixel) - this.snapSpaceY(margin.getBottom(), isSnapToPixel);
    }

    private static double getSnapScaleX(Node n) {
        return Region._getSnapScaleXimpl(n.getScene());
    }

    private static double _getSnapScaleXimpl(Scene scene) {
        if (scene == null) {
            return 1.0;
        }
        Window window = scene.getWindow();
        if (window == null) {
            return 1.0;
        }
        return window.getRenderScaleX();
    }

    private static double getSnapScaleY(Node n) {
        return Region._getSnapScaleYimpl(n.getScene());
    }

    private static double _getSnapScaleYimpl(Scene scene) {
        if (scene == null) {
            return 1.0;
        }
        Window window = scene.getWindow();
        if (window == null) {
            return 1.0;
        }
        return window.getRenderScaleY();
    }

    private double getSnapScaleX() {
        return Region._getSnapScaleXimpl(this.getScene());
    }

    private double getSnapScaleY() {
        return Region._getSnapScaleYimpl(this.getScene());
    }

    private static double scaledRound(double value, double scale) {
        return (double)Math.round(value * scale) / scale;
    }

    private static double scaledFloor(double value, double scale) {
        return Math.floor(value * scale + 1.0E-14) / scale;
    }

    private static double scaledCeil(double value, double scale) {
        return Math.ceil(value * scale - 1.0E-14) / scale;
    }

    private double snapSpaceX(double value, boolean snapToPixel) {
        return snapToPixel ? Region.scaledRound(value, this.getSnapScaleX()) : value;
    }

    private double snapSpaceY(double value, boolean snapToPixel) {
        return snapToPixel ? Region.scaledRound(value, this.getSnapScaleY()) : value;
    }

    private static double snapSpace(double value, boolean snapToPixel, double snapScale) {
        return snapToPixel ? Region.scaledRound(value, snapScale) : value;
    }

    private double snapSizeX(double value, boolean snapToPixel) {
        return snapToPixel ? Region.scaledCeil(value, this.getSnapScaleX()) : value;
    }

    private double snapSizeY(double value, boolean snapToPixel) {
        return snapToPixel ? Region.scaledCeil(value, this.getSnapScaleY()) : value;
    }

    private static double snapSize(double value, boolean snapToPixel, double snapScale) {
        return snapToPixel ? Region.scaledCeil(value, snapScale) : value;
    }

    private double snapPositionX(double value, boolean snapToPixel) {
        return snapToPixel ? Region.scaledRound(value, this.getSnapScaleX()) : value;
    }

    private double snapPositionY(double value, boolean snapToPixel) {
        return snapToPixel ? Region.scaledRound(value, this.getSnapScaleY()) : value;
    }

    private static double snapPosition(double value, boolean snapToPixel, double snapScale) {
        return snapToPixel ? Region.scaledRound(value, snapScale) : value;
    }

    private double snapPortionX(double value, boolean snapToPixel) {
        if (!snapToPixel || value == 0.0) {
            return value;
        }
        double s = this.getSnapScaleX();
        value = (value *= s) > 0.0 ? Math.max(1.0, Math.floor(value + 1.0E-14)) : Math.min(-1.0, Math.ceil(value - 1.0E-14));
        return value / s;
    }

    private double snapPortionY(double value, boolean snapToPixel) {
        if (!snapToPixel || value == 0.0) {
            return value;
        }
        double s = this.getSnapScaleY();
        value = (value *= s) > 0.0 ? Math.max(1.0, Math.floor(value + 1.0E-14)) : Math.min(-1.0, Math.ceil(value - 1.0E-14));
        return value / s;
    }

    double getAreaBaselineOffset(List<Node> children, Callback<Node, Insets> margins, Function<Integer, Double> positionToWidth, double areaHeight, boolean fillHeight) {
        return Region.getAreaBaselineOffset(children, margins, positionToWidth, areaHeight, fillHeight, this.isSnapToPixel());
    }

    static double getAreaBaselineOffset(List<Node> children, Callback<Node, Insets> margins, Function<Integer, Double> positionToWidth, double areaHeight, boolean fillHeight, boolean snapToPixel) {
        return Region.getAreaBaselineOffset(children, margins, positionToWidth, areaHeight, fillHeight, Region.getMinBaselineComplement(children), snapToPixel);
    }

    double getAreaBaselineOffset(List<Node> children, Callback<Node, Insets> margins, Function<Integer, Double> positionToWidth, double areaHeight, boolean fillHeight, double minComplement) {
        return Region.getAreaBaselineOffset(children, margins, positionToWidth, areaHeight, fillHeight, minComplement, this.isSnapToPixel());
    }

    static double getAreaBaselineOffset(List<Node> children, Callback<Node, Insets> margins, Function<Integer, Double> positionToWidth, double areaHeight, boolean fillHeight, double minComplement, boolean snapToPixel) {
        return Region.getAreaBaselineOffset(children, margins, positionToWidth, areaHeight, t -> fillHeight, minComplement, snapToPixel);
    }

    double getAreaBaselineOffset(List<Node> children, Callback<Node, Insets> margins, Function<Integer, Double> positionToWidth, double areaHeight, Function<Integer, Boolean> fillHeight, double minComplement) {
        return Region.getAreaBaselineOffset(children, margins, positionToWidth, areaHeight, fillHeight, minComplement, this.isSnapToPixel());
    }

    static double getAreaBaselineOffset(List<Node> children, Callback<Node, Insets> margins, Function<Integer, Double> positionToWidth, double areaHeight, Function<Integer, Boolean> fillHeight, double minComplement, boolean snapToPixel) {
        double b = 0.0;
        double snapScaleV = 0.0;
        for (int i = 0; i < children.size(); ++i) {
            Insets margin;
            Node n = children.get(i);
            if (snapToPixel && i == 0) {
                snapScaleV = Region.getSnapScaleY(n.getParent());
            }
            double top = (margin = (Insets)margins.call((Object)n)) != null ? Region.snapSpace(margin.getTop(), snapToPixel, snapScaleV) : 0.0;
            double bottom = margin != null ? Region.snapSpace(margin.getBottom(), snapToPixel, snapScaleV) : 0.0;
            double bo = n.getBaselineOffset();
            if (bo == Double.NEGATIVE_INFINITY) {
                double alt = -1.0;
                if (n.getContentBias() == Orientation.HORIZONTAL) {
                    alt = positionToWidth.apply(i);
                }
                if (fillHeight.apply(i).booleanValue()) {
                    b = Math.max(b, top + Region.boundedSize(n.minHeight(alt), areaHeight - minComplement - top - bottom, n.maxHeight(alt)));
                    continue;
                }
                b = Math.max(b, top + Region.boundedSize(n.minHeight(alt), n.prefHeight(alt), Math.min(n.maxHeight(alt), areaHeight - minComplement - top - bottom)));
                continue;
            }
            b = Math.max(b, top + bo);
        }
        return b;
    }

    static double getMinBaselineComplement(List<Node> children) {
        return Region.getBaselineComplement(children, true, false);
    }

    static double getPrefBaselineComplement(List<Node> children) {
        return Region.getBaselineComplement(children, false, false);
    }

    static double getMaxBaselineComplement(List<Node> children) {
        return Region.getBaselineComplement(children, false, true);
    }

    private static double getBaselineComplement(List<Node> children, boolean min, boolean max) {
        double bc = 0.0;
        for (Node n : children) {
            double bo = n.getBaselineOffset();
            if (bo == Double.NEGATIVE_INFINITY) continue;
            if (n.isResizable()) {
                bc = Math.max(bc, (min ? n.minHeight(-1.0) : (max ? n.maxHeight(-1.0) : n.prefHeight(-1.0))) - bo);
                continue;
            }
            bc = Math.max(bc, n.getLayoutBounds().getHeight() - bo);
        }
        return bc;
    }

    static double computeXOffset(double width, double contentWidth, HPos hpos) {
        switch (hpos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (width - contentWidth) / 2.0;
            }
            case RIGHT: {
                return width - contentWidth;
            }
        }
        throw new AssertionError((Object)"Unhandled hPos");
    }

    static double computeYOffset(double height, double contentHeight, VPos vpos) {
        switch (vpos) {
            case BASELINE: 
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (height - contentHeight) / 2.0;
            }
            case BOTTOM: {
                return height - contentHeight;
            }
        }
        throw new AssertionError((Object)"Unhandled vPos");
    }

    static double[] createDoubleArray(int length, double value) {
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = value;
        }
        return array;
    }

    public Region() {
        RegionHelper.initHelper(this);
        this._snapToPixel = true;
        this.padding = new StyleableObjectProperty<Insets>(Insets.EMPTY){
            private Insets lastValidValue;
            {
                this.lastValidValue = Insets.EMPTY;
            }

            public Object getBean() {
                return Region.this;
            }

            public String getName() {
                return "padding";
            }

            @Override
            public CssMetaData<Region, Insets> getCssMetaData() {
                return StyleableProperties.PADDING;
            }

            public void invalidated() {
                Insets newValue = (Insets)this.get();
                if (newValue == null) {
                    if (this.isBound()) {
                        this.unbind();
                    }
                    this.set(this.lastValidValue);
                    throw new NullPointerException("cannot set padding to null");
                }
                if (!newValue.equals(this.lastValidValue)) {
                    this.lastValidValue = newValue;
                    Region.this.insets.fireValueChanged();
                }
            }
        };
        this.background = new StyleableObjectProperty<Background>(null){
            private Background old;
            {
                this.old = null;
            }

            public Object getBean() {
                return Region.this;
            }

            public String getName() {
                return "background";
            }

            @Override
            public CssMetaData<Region, Background> getCssMetaData() {
                return StyleableProperties.BACKGROUND;
            }

            protected void invalidated() {
                Background b = (Background)this.get();
                if (this.old != null ? !this.old.equals(b) : b != null) {
                    if (this.old == null || b == null || !this.old.getOutsets().equals(b.getOutsets())) {
                        NodeHelper.geomChanged(Region.this);
                        Region.this.insets.fireValueChanged();
                    }
                    if (b != null) {
                        for (BackgroundImage i : b.getImages()) {
                            Image image = i.image;
                            Toolkit.ImageAccessor acc = Toolkit.getImageAccessor();
                            if (!acc.isAnimation(image) && !(image.getProgress() < 1.0)) continue;
                            Region.this.addImageListener(image);
                        }
                    }
                    if (this.old != null) {
                        for (BackgroundImage i : this.old.getImages()) {
                            Region.this.removeImageListener(i.image);
                        }
                    }
                    NodeHelper.markDirty(Region.this, DirtyBits.SHAPE_FILL);
                    Region.this.cornersValid = false;
                    this.old = b;
                }
            }
        };
        this.border = new StyleableObjectProperty<Border>(null){
            private Border old;
            {
                this.old = null;
            }

            public Object getBean() {
                return Region.this;
            }

            public String getName() {
                return "border";
            }

            @Override
            public CssMetaData<Region, Border> getCssMetaData() {
                return StyleableProperties.BORDER;
            }

            protected void invalidated() {
                Border b = (Border)this.get();
                if (this.old != null ? !this.old.equals(b) : b != null) {
                    if (this.old == null || b == null || !this.old.getOutsets().equals(b.getOutsets())) {
                        NodeHelper.geomChanged(Region.this);
                    }
                    if (this.old == null || b == null || !this.old.getInsets().equals(b.getInsets())) {
                        Region.this.insets.fireValueChanged();
                    }
                    if (b != null) {
                        for (BorderImage i : b.getImages()) {
                            Image image = i.image;
                            Toolkit.ImageAccessor acc = Toolkit.getImageAccessor();
                            if (!acc.isAnimation(image) && !(image.getProgress() < 1.0)) continue;
                            Region.this.addImageListener(image);
                        }
                    }
                    if (this.old != null) {
                        for (BorderImage i : this.old.getImages()) {
                            Region.this.removeImageListener(i.image);
                        }
                    }
                    NodeHelper.markDirty(Region.this, DirtyBits.SHAPE_STROKE);
                    Region.this.cornersValid = false;
                    this.old = b;
                }
            }
        };
        this.insets = new InsetsProperty();
        this.snappedTopInset = 0.0;
        this.snappedRightInset = 0.0;
        this.snappedBottomInset = 0.0;
        this.snappedLeftInset = 0.0;
        this.lastUsedSnapScaleY = 0.0;
        this.lastUsedSnapScaleX = 0.0;
        this._minWidth = -1.0;
        this._minHeight = -1.0;
        this._prefWidth = -1.0;
        this._prefHeight = -1.0;
        this._maxWidth = -1.0;
        this._maxHeight = -1.0;
        this.shape = null;
        this.scaleShape = null;
        this.centerShape = null;
        this.cacheShape = null;
        this.setPickOnBounds(true);
    }

    public final boolean isSnapToPixel() {
        return this._snapToPixel;
    }

    public final void setSnapToPixel(boolean value) {
        if (this.snapToPixel == null) {
            if (this._snapToPixel != value) {
                this._snapToPixel = value;
                this.updateSnappedInsets();
                this.requestParentLayout();
            }
        } else {
            this.snapToPixel.set(value);
        }
    }

    public final BooleanProperty snapToPixelProperty() {
        if (this.snapToPixel == null) {
            this.snapToPixel = new StyleableBooleanProperty(this._snapToPixel){

                public Object getBean() {
                    return Region.this;
                }

                public String getName() {
                    return "snapToPixel";
                }

                @Override
                public CssMetaData<Region, Boolean> getCssMetaData() {
                    return StyleableProperties.SNAP_TO_PIXEL;
                }

                public void invalidated() {
                    boolean value = this.get();
                    if (Region.this._snapToPixel != value) {
                        Region.this._snapToPixel = value;
                        Region.this.updateSnappedInsets();
                        Region.this.requestParentLayout();
                    }
                }
            };
        }
        return this.snapToPixel;
    }

    public final void setPadding(Insets value) {
        this.padding.set((Object)value);
    }

    public final Insets getPadding() {
        return (Insets)this.padding.get();
    }

    public final ObjectProperty<Insets> paddingProperty() {
        return this.padding;
    }

    public final void setBackground(Background value) {
        this.background.set((Object)value);
    }

    public final Background getBackground() {
        return (Background)this.background.get();
    }

    public final ObjectProperty<Background> backgroundProperty() {
        return this.background;
    }

    public final void setBorder(Border value) {
        this.border.set((Object)value);
    }

    public final Border getBorder() {
        return (Border)this.border.get();
    }

    public final ObjectProperty<Border> borderProperty() {
        return this.border;
    }

    void addImageListener(Image image) {
        Toolkit.ImageAccessor acc = Toolkit.getImageAccessor();
        acc.getImageProperty(image).addListener(this.imageChangeListener);
    }

    void removeImageListener(Image image) {
        Toolkit.ImageAccessor acc = Toolkit.getImageAccessor();
        acc.getImageProperty(image).removeListener(this.imageChangeListener);
    }

    public final ObjectProperty<Insets> opaqueInsetsProperty() {
        if (this.opaqueInsets == null) {
            this.opaqueInsets = new StyleableObjectProperty<Insets>(){

                public Object getBean() {
                    return Region.this;
                }

                public String getName() {
                    return "opaqueInsets";
                }

                @Override
                public CssMetaData<Region, Insets> getCssMetaData() {
                    return StyleableProperties.OPAQUE_INSETS;
                }

                protected void invalidated() {
                    NodeHelper.markDirty(Region.this, DirtyBits.SHAPE_FILL);
                }
            };
        }
        return this.opaqueInsets;
    }

    public final void setOpaqueInsets(Insets value) {
        this.opaqueInsetsProperty().set((Object)value);
    }

    public final Insets getOpaqueInsets() {
        return this.opaqueInsets == null ? null : (Insets)this.opaqueInsets.get();
    }

    public final Insets getInsets() {
        return this.insets.get();
    }

    public final ReadOnlyObjectProperty<Insets> insetsProperty() {
        return this.insets;
    }

    private void updateSnappedInsets() {
        this.lastUsedSnapScaleX = this.getSnapScaleX();
        this.lastUsedSnapScaleY = this.getSnapScaleY();
        Insets insets = this.getInsets();
        boolean snap = this.isSnapToPixel();
        this.snappedTopInset = this.snapSpaceY(insets.getTop(), snap);
        this.snappedRightInset = this.snapSpaceX(insets.getRight(), snap);
        this.snappedBottomInset = this.snapSpaceY(insets.getBottom(), snap);
        this.snappedLeftInset = this.snapSpaceX(insets.getLeft(), snap);
    }

    protected void setWidth(double value) {
        if (this.width == null) {
            this.widthChanged(value);
        } else {
            this.width.set(value);
        }
    }

    private void widthChanged(double value) {
        if (value != this._width) {
            this._width = value;
            this.cornersValid = false;
            this.boundingBox = null;
            NodeHelper.layoutBoundsChanged(this);
            NodeHelper.geomChanged(this);
            NodeHelper.markDirty(this, DirtyBits.NODE_GEOMETRY);
            this.setNeedsLayout(true);
            this.requestParentLayout();
        }
    }

    public final double getWidth() {
        return this.width == null ? this._width : this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new ReadOnlyDoubleWrapper(this._width){

                protected void invalidated() {
                    Region.this.widthChanged(this.get());
                }

                public Object getBean() {
                    return Region.this;
                }

                public String getName() {
                    return "width";
                }
            };
        }
        return this.width.getReadOnlyProperty();
    }

    protected void setHeight(double value) {
        if (this.height == null) {
            this.heightChanged(value);
        } else {
            this.height.set(value);
        }
    }

    private void heightChanged(double value) {
        if (this._height != value) {
            this._height = value;
            this.cornersValid = false;
            this.boundingBox = null;
            NodeHelper.geomChanged(this);
            NodeHelper.layoutBoundsChanged(this);
            NodeHelper.markDirty(this, DirtyBits.NODE_GEOMETRY);
            this.setNeedsLayout(true);
            this.requestParentLayout();
        }
    }

    public final double getHeight() {
        return this.height == null ? this._height : this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new ReadOnlyDoubleWrapper(this._height){

                protected void invalidated() {
                    Region.this.heightChanged(this.get());
                }

                public Object getBean() {
                    return Region.this;
                }

                public String getName() {
                    return "height";
                }
            };
        }
        return this.height.getReadOnlyProperty();
    }

    public final void setMinWidth(double value) {
        if (this.minWidth == null) {
            this._minWidth = value;
            this.requestParentLayout();
        } else {
            this.minWidth.set(value);
        }
    }

    public final double getMinWidth() {
        return this.minWidth == null ? this._minWidth : this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new MinPrefMaxProperty("minWidth", this._minWidth, StyleableProperties.MIN_WIDTH);
        }
        return this.minWidth;
    }

    public final void setMinHeight(double value) {
        if (this.minHeight == null) {
            this._minHeight = value;
            this.requestParentLayout();
        } else {
            this.minHeight.set(value);
        }
    }

    public final double getMinHeight() {
        return this.minHeight == null ? this._minHeight : this.minHeight.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new MinPrefMaxProperty("minHeight", this._minHeight, StyleableProperties.MIN_HEIGHT);
        }
        return this.minHeight;
    }

    public void setMinSize(double minWidth, double minHeight) {
        this.setMinWidth(minWidth);
        this.setMinHeight(minHeight);
    }

    public final void setPrefWidth(double value) {
        if (this.prefWidth == null) {
            this._prefWidth = value;
            this.requestParentLayout();
        } else {
            this.prefWidth.set(value);
        }
    }

    public final double getPrefWidth() {
        return this.prefWidth == null ? this._prefWidth : this.prefWidth.get();
    }

    public final DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new MinPrefMaxProperty("prefWidth", this._prefWidth, StyleableProperties.PREF_WIDTH);
        }
        return this.prefWidth;
    }

    public final void setPrefHeight(double value) {
        if (this.prefHeight == null) {
            this._prefHeight = value;
            this.requestParentLayout();
        } else {
            this.prefHeight.set(value);
        }
    }

    public final double getPrefHeight() {
        return this.prefHeight == null ? this._prefHeight : this.prefHeight.get();
    }

    public final DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new MinPrefMaxProperty("prefHeight", this._prefHeight, StyleableProperties.PREF_HEIGHT);
        }
        return this.prefHeight;
    }

    public void setPrefSize(double prefWidth, double prefHeight) {
        this.setPrefWidth(prefWidth);
        this.setPrefHeight(prefHeight);
    }

    public final void setMaxWidth(double value) {
        if (this.maxWidth == null) {
            this._maxWidth = value;
            this.requestParentLayout();
        } else {
            this.maxWidth.set(value);
        }
    }

    public final double getMaxWidth() {
        return this.maxWidth == null ? this._maxWidth : this.maxWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new MinPrefMaxProperty("maxWidth", this._maxWidth, StyleableProperties.MAX_WIDTH);
        }
        return this.maxWidth;
    }

    public final void setMaxHeight(double value) {
        if (this.maxHeight == null) {
            this._maxHeight = value;
            this.requestParentLayout();
        } else {
            this.maxHeight.set(value);
        }
    }

    public final double getMaxHeight() {
        return this.maxHeight == null ? this._maxHeight : this.maxHeight.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new MinPrefMaxProperty("maxHeight", this._maxHeight, StyleableProperties.MAX_HEIGHT);
        }
        return this.maxHeight;
    }

    public void setMaxSize(double maxWidth, double maxHeight) {
        this.setMaxWidth(maxWidth);
        this.setMaxHeight(maxHeight);
    }

    public final javafx.scene.shape.Shape getShape() {
        return this.shape == null ? this._shape : (javafx.scene.shape.Shape)this.shape.get();
    }

    public final void setShape(javafx.scene.shape.Shape value) {
        this.shapeProperty().set((Object)value);
    }

    public final ObjectProperty<javafx.scene.shape.Shape> shapeProperty() {
        if (this.shape == null) {
            this.shape = new ShapeProperty();
        }
        return this.shape;
    }

    public final void setScaleShape(boolean value) {
        this.scaleShapeProperty().set(value);
    }

    public final boolean isScaleShape() {
        return this.scaleShape == null ? true : this.scaleShape.get();
    }

    public final BooleanProperty scaleShapeProperty() {
        if (this.scaleShape == null) {
            this.scaleShape = new StyleableBooleanProperty(true){

                public Object getBean() {
                    return Region.this;
                }

                public String getName() {
                    return "scaleShape";
                }

                @Override
                public CssMetaData<Region, Boolean> getCssMetaData() {
                    return StyleableProperties.SCALE_SHAPE;
                }

                public void invalidated() {
                    NodeHelper.geomChanged(Region.this);
                    NodeHelper.markDirty(Region.this, DirtyBits.REGION_SHAPE);
                }
            };
        }
        return this.scaleShape;
    }

    public final void setCenterShape(boolean value) {
        this.centerShapeProperty().set(value);
    }

    public final boolean isCenterShape() {
        return this.centerShape == null ? true : this.centerShape.get();
    }

    public final BooleanProperty centerShapeProperty() {
        if (this.centerShape == null) {
            this.centerShape = new StyleableBooleanProperty(true){

                public Object getBean() {
                    return Region.this;
                }

                public String getName() {
                    return "centerShape";
                }

                @Override
                public CssMetaData<Region, Boolean> getCssMetaData() {
                    return StyleableProperties.POSITION_SHAPE;
                }

                public void invalidated() {
                    NodeHelper.geomChanged(Region.this);
                    NodeHelper.markDirty(Region.this, DirtyBits.REGION_SHAPE);
                }
            };
        }
        return this.centerShape;
    }

    public final void setCacheShape(boolean value) {
        this.cacheShapeProperty().set(value);
    }

    public final boolean isCacheShape() {
        return this.cacheShape == null ? true : this.cacheShape.get();
    }

    public final BooleanProperty cacheShapeProperty() {
        if (this.cacheShape == null) {
            this.cacheShape = new StyleableBooleanProperty(true){

                public Object getBean() {
                    return Region.this;
                }

                public String getName() {
                    return "cacheShape";
                }

                @Override
                public CssMetaData<Region, Boolean> getCssMetaData() {
                    return StyleableProperties.CACHE_SHAPE;
                }
            };
        }
        return this.cacheShape;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(double width, double height) {
        this.setWidth(width);
        this.setHeight(height);
        PlatformLogger logger = Logging.getLayoutLogger();
        if (logger.isLoggable(PlatformLogger.Level.FINER)) {
            logger.finer(this.toString() + " resized to " + width + " x " + height);
        }
    }

    @Override
    public final double minWidth(double height) {
        double override = this.getMinWidth();
        if (override == -1.0) {
            return super.minWidth(height);
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(height);
        }
        return Double.isNaN(override) || override < 0.0 ? 0.0 : override;
    }

    @Override
    public final double minHeight(double width) {
        double override = this.getMinHeight();
        if (override == -1.0) {
            return super.minHeight(width);
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(width);
        }
        return Double.isNaN(override) || override < 0.0 ? 0.0 : override;
    }

    @Override
    public final double prefWidth(double height) {
        double override = this.getPrefWidth();
        if (override == -1.0) {
            return super.prefWidth(height);
        }
        return Double.isNaN(override) || override < 0.0 ? 0.0 : override;
    }

    @Override
    public final double prefHeight(double width) {
        double override = this.getPrefHeight();
        if (override == -1.0) {
            return super.prefHeight(width);
        }
        return Double.isNaN(override) || override < 0.0 ? 0.0 : override;
    }

    @Override
    public final double maxWidth(double height) {
        double override = this.getMaxWidth();
        if (override == -1.0) {
            return this.computeMaxWidth(height);
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(height);
        }
        return Double.isNaN(override) || override < 0.0 ? 0.0 : override;
    }

    @Override
    public final double maxHeight(double width) {
        double override = this.getMaxHeight();
        if (override == -1.0) {
            return this.computeMaxHeight(width);
        }
        if (override == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(width);
        }
        return Double.isNaN(override) || override < 0.0 ? 0.0 : override;
    }

    @Override
    protected double computeMinWidth(double height) {
        return this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double width) {
        return this.getInsets().getTop() + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double height) {
        double w = super.computePrefWidth(height);
        return this.getInsets().getLeft() + w + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double width) {
        double h = super.computePrefHeight(width);
        return this.getInsets().getTop() + h + this.getInsets().getBottom();
    }

    protected double computeMaxWidth(double height) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxHeight(double width) {
        return Double.MAX_VALUE;
    }

    @Deprecated(since="9")
    protected double snapSpace(double value) {
        return this.snapSpaceX(value, this.isSnapToPixel());
    }

    public double snapSpaceX(double value) {
        return this.snapSpaceX(value, this.isSnapToPixel());
    }

    public double snapSpaceY(double value) {
        return this.snapSpaceY(value, this.isSnapToPixel());
    }

    @Deprecated(since="9")
    protected double snapSize(double value) {
        return this.snapSizeX(value, this.isSnapToPixel());
    }

    public double snapSizeX(double value) {
        return this.snapSizeX(value, this.isSnapToPixel());
    }

    public double snapSizeY(double value) {
        return this.snapSizeY(value, this.isSnapToPixel());
    }

    @Deprecated(since="9")
    protected double snapPosition(double value) {
        return this.snapPositionX(value, this.isSnapToPixel());
    }

    public double snapPositionX(double value) {
        return this.snapPositionX(value, this.isSnapToPixel());
    }

    public double snapPositionY(double value) {
        return this.snapPositionY(value, this.isSnapToPixel());
    }

    double snapPortionX(double value) {
        return this.snapPortionX(value, this.isSnapToPixel());
    }

    double snapPortionY(double value) {
        return this.snapPortionY(value, this.isSnapToPixel());
    }

    public final double snappedTopInset() {
        if (this.lastUsedSnapScaleY != this.getSnapScaleY()) {
            this.updateSnappedInsets();
        }
        return this.snappedTopInset;
    }

    public final double snappedBottomInset() {
        if (this.lastUsedSnapScaleY != this.getSnapScaleY()) {
            this.updateSnappedInsets();
        }
        return this.snappedBottomInset;
    }

    public final double snappedLeftInset() {
        if (this.lastUsedSnapScaleX != this.getSnapScaleX()) {
            this.updateSnappedInsets();
        }
        return this.snappedLeftInset;
    }

    public final double snappedRightInset() {
        if (this.lastUsedSnapScaleX != this.getSnapScaleX()) {
            this.updateSnappedInsets();
        }
        return this.snappedRightInset;
    }

    double computeChildMinAreaWidth(Node child, Insets margin) {
        return this.computeChildMinAreaWidth(child, -1.0, margin, -1.0, false);
    }

    double computeChildMinAreaWidth(Node child, double baselineComplement, Insets margin, double height, boolean fillHeight) {
        boolean snap = this.isSnapToPixel();
        double left = margin != null ? this.snapSpaceX(margin.getLeft(), snap) : 0.0;
        double right = margin != null ? this.snapSpaceX(margin.getRight(), snap) : 0.0;
        double alt = -1.0;
        if (height != -1.0 && child.isResizable() && child.getContentBias() == Orientation.VERTICAL) {
            double top = margin != null ? this.snapSpaceY(margin.getTop(), snap) : 0.0;
            double bottom = margin != null ? this.snapSpaceY(margin.getBottom(), snap) : 0.0;
            double bo = child.getBaselineOffset();
            double contentHeight = bo == Double.NEGATIVE_INFINITY && baselineComplement != -1.0 ? height - top - bottom - baselineComplement : height - top - bottom;
            alt = fillHeight ? this.snapSizeY(Region.boundedSize(child.minHeight(-1.0), contentHeight, child.maxHeight(-1.0))) : this.snapSizeY(Region.boundedSize(child.minHeight(-1.0), child.prefHeight(-1.0), Math.min(child.maxHeight(-1.0), contentHeight)));
        }
        return left + this.snapSizeX(child.minWidth(alt)) + right;
    }

    double computeChildMinAreaHeight(Node child, Insets margin) {
        return this.computeChildMinAreaHeight(child, -1.0, margin, -1.0);
    }

    double computeChildMinAreaHeight(Node child, double minBaselineComplement, Insets margin, double width) {
        boolean snap = this.isSnapToPixel();
        double top = margin != null ? this.snapSpaceY(margin.getTop(), snap) : 0.0;
        double bottom = margin != null ? this.snapSpaceY(margin.getBottom(), snap) : 0.0;
        double alt = -1.0;
        if (child.isResizable() && child.getContentBias() == Orientation.HORIZONTAL) {
            double left = margin != null ? this.snapSpaceX(margin.getLeft(), snap) : 0.0;
            double right = margin != null ? this.snapSpaceX(margin.getRight(), snap) : 0.0;
            alt = this.snapSizeX(width != -1.0 ? Region.boundedSize(child.minWidth(-1.0), width - left - right, child.maxWidth(-1.0)) : child.maxWidth(-1.0));
        }
        if (minBaselineComplement != -1.0) {
            double baseline = child.getBaselineOffset();
            if (child.isResizable() && baseline == Double.NEGATIVE_INFINITY) {
                return top + this.snapSizeY(child.minHeight(alt)) + bottom + minBaselineComplement;
            }
            return baseline + minBaselineComplement;
        }
        return top + this.snapSizeY(child.minHeight(alt)) + bottom;
    }

    double computeChildPrefAreaWidth(Node child, Insets margin) {
        return this.computeChildPrefAreaWidth(child, -1.0, margin, -1.0, false);
    }

    double computeChildPrefAreaWidth(Node child, double baselineComplement, Insets margin, double height, boolean fillHeight) {
        boolean snap = this.isSnapToPixel();
        double left = margin != null ? this.snapSpaceX(margin.getLeft(), snap) : 0.0;
        double right = margin != null ? this.snapSpaceX(margin.getRight(), snap) : 0.0;
        double alt = -1.0;
        if (height != -1.0 && child.isResizable() && child.getContentBias() == Orientation.VERTICAL) {
            double top = margin != null ? this.snapSpaceY(margin.getTop(), snap) : 0.0;
            double bottom = margin != null ? this.snapSpaceY(margin.getBottom(), snap) : 0.0;
            double bo = child.getBaselineOffset();
            double contentHeight = bo == Double.NEGATIVE_INFINITY && baselineComplement != -1.0 ? height - top - bottom - baselineComplement : height - top - bottom;
            alt = fillHeight ? this.snapSizeY(Region.boundedSize(child.minHeight(-1.0), contentHeight, child.maxHeight(-1.0))) : this.snapSizeY(Region.boundedSize(child.minHeight(-1.0), child.prefHeight(-1.0), Math.min(child.maxHeight(-1.0), contentHeight)));
        }
        return left + this.snapSizeX(Region.boundedSize(child.minWidth(alt), child.prefWidth(alt), child.maxWidth(alt))) + right;
    }

    double computeChildPrefAreaHeight(Node child, Insets margin) {
        return this.computeChildPrefAreaHeight(child, -1.0, margin, -1.0);
    }

    double computeChildPrefAreaHeight(Node child, double prefBaselineComplement, Insets margin, double width) {
        boolean snap = this.isSnapToPixel();
        double top = margin != null ? this.snapSpaceY(margin.getTop(), snap) : 0.0;
        double bottom = margin != null ? this.snapSpaceY(margin.getBottom(), snap) : 0.0;
        double alt = -1.0;
        if (child.isResizable() && child.getContentBias() == Orientation.HORIZONTAL) {
            double left = margin != null ? this.snapSpaceX(margin.getLeft(), snap) : 0.0;
            double right = margin != null ? this.snapSpaceX(margin.getRight(), snap) : 0.0;
            alt = this.snapSizeX(Region.boundedSize(child.minWidth(-1.0), width != -1.0 ? width - left - right : child.prefWidth(-1.0), child.maxWidth(-1.0)));
        }
        if (prefBaselineComplement != -1.0) {
            double baseline = child.getBaselineOffset();
            if (child.isResizable() && baseline == Double.NEGATIVE_INFINITY) {
                return top + this.snapSizeY(Region.boundedSize(child.minHeight(alt), child.prefHeight(alt), child.maxHeight(alt))) + bottom + prefBaselineComplement;
            }
            return top + baseline + prefBaselineComplement + bottom;
        }
        return top + this.snapSizeY(Region.boundedSize(child.minHeight(alt), child.prefHeight(alt), child.maxHeight(alt))) + bottom;
    }

    double computeChildMaxAreaWidth(Node child, double baselineComplement, Insets margin, double height, boolean fillHeight) {
        double max = child.maxWidth(-1.0);
        if (max == Double.MAX_VALUE) {
            return max;
        }
        boolean snap = this.isSnapToPixel();
        double left = margin != null ? this.snapSpaceX(margin.getLeft(), snap) : 0.0;
        double right = margin != null ? this.snapSpaceX(margin.getRight(), snap) : 0.0;
        double alt = -1.0;
        if (height != -1.0 && child.isResizable() && child.getContentBias() == Orientation.VERTICAL) {
            double top = margin != null ? this.snapSpaceY(margin.getTop(), snap) : 0.0;
            double bottom = margin != null ? this.snapSpaceY(margin.getBottom(), snap) : 0.0;
            double bo = child.getBaselineOffset();
            double contentHeight = bo == Double.NEGATIVE_INFINITY && baselineComplement != -1.0 ? height - top - bottom - baselineComplement : height - top - bottom;
            alt = fillHeight ? this.snapSizeY(Region.boundedSize(child.minHeight(-1.0), contentHeight, child.maxHeight(-1.0))) : this.snapSizeY(Region.boundedSize(child.minHeight(-1.0), child.prefHeight(-1.0), Math.min(child.maxHeight(-1.0), contentHeight)));
            max = child.maxWidth(alt);
        }
        return left + this.snapSizeX(Region.boundedSize(child.minWidth(alt), max, Double.MAX_VALUE)) + right;
    }

    double computeChildMaxAreaHeight(Node child, double maxBaselineComplement, Insets margin, double width) {
        double max = child.maxHeight(-1.0);
        if (max == Double.MAX_VALUE) {
            return max;
        }
        boolean snap = this.isSnapToPixel();
        double top = margin != null ? this.snapSpaceY(margin.getTop(), snap) : 0.0;
        double bottom = margin != null ? this.snapSpaceY(margin.getBottom(), snap) : 0.0;
        double alt = -1.0;
        if (child.isResizable() && child.getContentBias() == Orientation.HORIZONTAL) {
            double left = margin != null ? this.snapSpaceX(margin.getLeft(), snap) : 0.0;
            double right = margin != null ? this.snapSpaceX(margin.getRight(), snap) : 0.0;
            alt = this.snapSizeX(width != -1.0 ? Region.boundedSize(child.minWidth(-1.0), width - left - right, child.maxWidth(-1.0)) : child.minWidth(-1.0));
            max = child.maxHeight(alt);
        }
        if (maxBaselineComplement != -1.0) {
            double baseline = child.getBaselineOffset();
            if (child.isResizable() && baseline == Double.NEGATIVE_INFINITY) {
                return top + this.snapSizeY(Region.boundedSize(child.minHeight(alt), child.maxHeight(alt), Double.MAX_VALUE)) + bottom + maxBaselineComplement;
            }
            return top + baseline + maxBaselineComplement + bottom;
        }
        return top + this.snapSizeY(Region.boundedSize(child.minHeight(alt), max, Double.MAX_VALUE)) + bottom;
    }

    double computeMaxMinAreaWidth(List<Node> children, Callback<Node, Insets> margins) {
        return this.getMaxAreaWidth(children, margins, new double[]{-1.0}, false, true);
    }

    double computeMaxMinAreaWidth(List<Node> children, Callback<Node, Insets> margins, double height, boolean fillHeight) {
        return this.getMaxAreaWidth(children, margins, new double[]{height}, fillHeight, true);
    }

    double computeMaxMinAreaWidth(List<Node> children, Callback<Node, Insets> childMargins, double[] childHeights, boolean fillHeight) {
        return this.getMaxAreaWidth(children, childMargins, childHeights, fillHeight, true);
    }

    double computeMaxMinAreaHeight(List<Node> children, Callback<Node, Insets> margins, VPos valignment) {
        return this.getMaxAreaHeight(children, margins, null, valignment, true);
    }

    double computeMaxMinAreaHeight(List<Node> children, Callback<Node, Insets> margins, VPos valignment, double width) {
        return this.getMaxAreaHeight(children, margins, new double[]{width}, valignment, true);
    }

    double computeMaxMinAreaHeight(List<Node> children, Callback<Node, Insets> childMargins, double[] childWidths, VPos valignment) {
        return this.getMaxAreaHeight(children, childMargins, childWidths, valignment, true);
    }

    double computeMaxPrefAreaWidth(List<Node> children, Callback<Node, Insets> margins) {
        return this.getMaxAreaWidth(children, margins, new double[]{-1.0}, false, false);
    }

    double computeMaxPrefAreaWidth(List<Node> children, Callback<Node, Insets> margins, double height, boolean fillHeight) {
        return this.getMaxAreaWidth(children, margins, new double[]{height}, fillHeight, false);
    }

    double computeMaxPrefAreaWidth(List<Node> children, Callback<Node, Insets> childMargins, double[] childHeights, boolean fillHeight) {
        return this.getMaxAreaWidth(children, childMargins, childHeights, fillHeight, false);
    }

    double computeMaxPrefAreaHeight(List<Node> children, Callback<Node, Insets> margins, VPos valignment) {
        return this.getMaxAreaHeight(children, margins, null, valignment, false);
    }

    double computeMaxPrefAreaHeight(List<Node> children, Callback<Node, Insets> margins, double width, VPos valignment) {
        return this.getMaxAreaHeight(children, margins, new double[]{width}, valignment, false);
    }

    double computeMaxPrefAreaHeight(List<Node> children, Callback<Node, Insets> childMargins, double[] childWidths, VPos valignment) {
        return this.getMaxAreaHeight(children, childMargins, childWidths, valignment, false);
    }

    static Vec2d boundedNodeSizeWithBias(Node node, double areaWidth, double areaHeight, boolean fillWidth, boolean fillHeight, Vec2d result) {
        if (result == null) {
            result = new Vec2d();
        }
        Orientation bias = node.getContentBias();
        double childWidth = 0.0;
        double childHeight = 0.0;
        if (bias == null) {
            childWidth = Region.boundedSize(node.minWidth(-1.0), fillWidth ? areaWidth : Math.min(areaWidth, node.prefWidth(-1.0)), node.maxWidth(-1.0));
            childHeight = Region.boundedSize(node.minHeight(-1.0), fillHeight ? areaHeight : Math.min(areaHeight, node.prefHeight(-1.0)), node.maxHeight(-1.0));
        } else if (bias == Orientation.HORIZONTAL) {
            childWidth = Region.boundedSize(node.minWidth(-1.0), fillWidth ? areaWidth : Math.min(areaWidth, node.prefWidth(-1.0)), node.maxWidth(-1.0));
            childHeight = Region.boundedSize(node.minHeight(childWidth), fillHeight ? areaHeight : Math.min(areaHeight, node.prefHeight(childWidth)), node.maxHeight(childWidth));
        } else {
            childHeight = Region.boundedSize(node.minHeight(-1.0), fillHeight ? areaHeight : Math.min(areaHeight, node.prefHeight(-1.0)), node.maxHeight(-1.0));
            childWidth = Region.boundedSize(node.minWidth(childHeight), fillWidth ? areaWidth : Math.min(areaWidth, node.prefWidth(childHeight)), node.maxWidth(childHeight));
        }
        result.set(childWidth, childHeight);
        return result;
    }

    private double getMaxAreaHeight(List<Node> children, Callback<Node, Insets> childMargins, double[] childWidths, VPos valignment, boolean minimum) {
        double singleChildWidth;
        double d = childWidths == null ? -1.0 : (singleChildWidth = childWidths.length == 1 ? childWidths[0] : Double.NaN);
        if (valignment == VPos.BASELINE) {
            double maxAbove = 0.0;
            double maxBelow = 0.0;
            int maxPos = children.size();
            for (int i = 0; i < maxPos; ++i) {
                double childHeight;
                Node child = children.get(i);
                double childWidth = Double.isNaN(singleChildWidth) ? childWidths[i] : singleChildWidth;
                Insets margin = (Insets)childMargins.call((Object)child);
                double top = margin != null ? this.snapSpaceY(margin.getTop()) : 0.0;
                double bottom = margin != null ? this.snapSpaceY(margin.getBottom()) : 0.0;
                double baseline = child.getBaselineOffset();
                double d2 = childHeight = minimum ? this.snapSizeY(child.minHeight(childWidth)) : this.snapSizeY(child.prefHeight(childWidth));
                if (baseline == Double.NEGATIVE_INFINITY) {
                    maxAbove = Math.max(maxAbove, childHeight + top);
                    continue;
                }
                maxAbove = Math.max(maxAbove, baseline + top);
                maxBelow = Math.max(maxBelow, this.snapSpaceY(minimum ? this.snapSizeY(child.minHeight(childWidth)) : this.snapSizeY(child.prefHeight(childWidth))) - baseline + bottom);
            }
            return maxAbove + maxBelow;
        }
        double max = 0.0;
        int maxPos = children.size();
        for (int i = 0; i < maxPos; ++i) {
            Node child = children.get(i);
            Insets margin = (Insets)childMargins.call((Object)child);
            double childWidth = Double.isNaN(singleChildWidth) ? childWidths[i] : singleChildWidth;
            max = Math.max(max, minimum ? this.computeChildMinAreaHeight(child, -1.0, margin, childWidth) : this.computeChildPrefAreaHeight(child, -1.0, margin, childWidth));
        }
        return max;
    }

    private double getMaxAreaWidth(List<Node> children, Callback<Node, Insets> childMargins, double[] childHeights, boolean fillHeight, boolean minimum) {
        double singleChildHeight = childHeights == null ? -1.0 : (childHeights.length == 1 ? childHeights[0] : Double.NaN);
        double max = 0.0;
        int maxPos = children.size();
        for (int i = 0; i < maxPos; ++i) {
            Node child = children.get(i);
            Insets margin = (Insets)childMargins.call((Object)child);
            double childHeight = Double.isNaN(singleChildHeight) ? childHeights[i] : singleChildHeight;
            max = Math.max(max, minimum ? this.computeChildMinAreaWidth(children.get(i), -1.0, margin, childHeight, fillHeight) : this.computeChildPrefAreaWidth(child, -1.0, margin, childHeight, fillHeight));
        }
        return max;
    }

    protected void positionInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, HPos halignment, VPos valignment) {
        Region.positionInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, Insets.EMPTY, halignment, valignment, this.isSnapToPixel());
    }

    public static void positionInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, Insets margin, HPos halignment, VPos valignment, boolean isSnapToPixel) {
        Insets childMargin = margin != null ? margin : Insets.EMPTY;
        double snapScaleX = isSnapToPixel ? Region.getSnapScaleX(child) : 1.0;
        double snapScaleY = isSnapToPixel ? Region.getSnapScaleY(child) : 1.0;
        Region.position(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, Region.snapSpace(childMargin.getTop(), isSnapToPixel, snapScaleY), Region.snapSpace(childMargin.getRight(), isSnapToPixel, snapScaleX), Region.snapSpace(childMargin.getBottom(), isSnapToPixel, snapScaleY), Region.snapSpace(childMargin.getLeft(), isSnapToPixel, snapScaleX), halignment, valignment, isSnapToPixel);
    }

    protected void layoutInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, HPos halignment, VPos valignment) {
        this.layoutInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, Insets.EMPTY, halignment, valignment);
    }

    protected void layoutInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, Insets margin, HPos halignment, VPos valignment) {
        this.layoutInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, margin, true, true, halignment, valignment);
    }

    protected void layoutInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, Insets margin, boolean fillWidth, boolean fillHeight, HPos halignment, VPos valignment) {
        Region.layoutInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, margin, fillWidth, fillHeight, halignment, valignment, this.isSnapToPixel());
    }

    public static void layoutInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, Insets margin, boolean fillWidth, boolean fillHeight, HPos halignment, VPos valignment, boolean isSnapToPixel) {
        Insets childMargin = margin != null ? margin : Insets.EMPTY;
        double snapScaleX = isSnapToPixel ? Region.getSnapScaleX(child) : 1.0;
        double snapScaleY = isSnapToPixel ? Region.getSnapScaleY(child) : 1.0;
        double top = Region.snapSpace(childMargin.getTop(), isSnapToPixel, snapScaleY);
        double bottom = Region.snapSpace(childMargin.getBottom(), isSnapToPixel, snapScaleY);
        double left = Region.snapSpace(childMargin.getLeft(), isSnapToPixel, snapScaleX);
        double right = Region.snapSpace(childMargin.getRight(), isSnapToPixel, snapScaleX);
        if (valignment == VPos.BASELINE) {
            double bo = child.getBaselineOffset();
            if (bo == Double.NEGATIVE_INFINITY) {
                if (child.isResizable()) {
                    bottom += Region.snapSpace(areaHeight - areaBaselineOffset, isSnapToPixel, snapScaleY);
                } else {
                    top = Region.snapSpace(areaBaselineOffset - child.getLayoutBounds().getHeight(), isSnapToPixel, snapScaleY);
                }
            } else {
                top = Region.snapSpace(areaBaselineOffset - bo, isSnapToPixel, snapScaleY);
            }
        }
        if (child.isResizable()) {
            Vec2d size = Region.boundedNodeSizeWithBias(child, areaWidth - left - right, areaHeight - top - bottom, fillWidth, fillHeight, TEMP_VEC2D);
            child.resize(Region.snapSize(size.x, isSnapToPixel, snapScaleX), Region.snapSize(size.y, isSnapToPixel, snapScaleX));
        }
        Region.position(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, top, right, bottom, left, halignment, valignment, isSnapToPixel);
    }

    private static void position(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, double topMargin, double rightMargin, double bottomMargin, double leftMargin, HPos hpos, VPos vpos, boolean isSnapToPixel) {
        double bo;
        double xoffset = leftMargin + Region.computeXOffset(areaWidth - leftMargin - rightMargin, child.getLayoutBounds().getWidth(), hpos);
        double yoffset = vpos == VPos.BASELINE ? ((bo = child.getBaselineOffset()) == Double.NEGATIVE_INFINITY ? areaBaselineOffset - child.getLayoutBounds().getHeight() : areaBaselineOffset - bo) : topMargin + Region.computeYOffset(areaHeight - topMargin - bottomMargin, child.getLayoutBounds().getHeight(), vpos);
        double x = areaX + xoffset;
        double y = areaY + yoffset;
        if (isSnapToPixel) {
            x = Region.snapPosition(x, true, Region.getSnapScaleX(child));
            y = Region.snapPosition(y, true, Region.getSnapScaleY(child));
        }
        child.relocate(x, y);
    }

    private void doUpdatePeer() {
        boolean shapeChanged;
        boolean sizeChanged;
        if (this._shape != null) {
            NodeHelper.syncPeer(this._shape);
        }
        NGRegion pg = (NGRegion)NodeHelper.getPeer(this);
        if (!this.cornersValid) {
            this.validateCorners();
        }
        if (sizeChanged = NodeHelper.isDirty(this, DirtyBits.NODE_GEOMETRY)) {
            pg.setSize((float)this.getWidth(), (float)this.getHeight());
        }
        if (shapeChanged = NodeHelper.isDirty(this, DirtyBits.REGION_SHAPE)) {
            pg.updateShape(this._shape, this.isScaleShape(), this.isCenterShape(), this.isCacheShape());
        }
        pg.updateFillCorners(this.normalizedFillCorners);
        boolean backgroundChanged = NodeHelper.isDirty(this, DirtyBits.SHAPE_FILL);
        Background bg = this.getBackground();
        if (backgroundChanged) {
            pg.updateBackground(bg);
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_CONTENTS)) {
            pg.imagesUpdated();
        }
        pg.updateStrokeCorners(this.normalizedStrokeCorners);
        if (NodeHelper.isDirty(this, DirtyBits.SHAPE_STROKE)) {
            pg.updateBorder(this.getBorder());
        }
        if (sizeChanged || backgroundChanged || shapeChanged) {
            Insets i = this.getOpaqueInsets();
            if (this._shape != null) {
                if (i != null) {
                    pg.setOpaqueInsets((float)i.getTop(), (float)i.getRight(), (float)i.getBottom(), (float)i.getLeft());
                } else {
                    pg.setOpaqueInsets(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
                }
            } else if (bg == null || bg.isEmpty()) {
                pg.setOpaqueInsets(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
            } else {
                double[] trbl = new double[4];
                bg.computeOpaqueInsets(this.getWidth(), this.getHeight(), trbl);
                if (i != null) {
                    double d = Double.isNaN(trbl[0]) ? i.getTop() : (trbl[0] = Double.isNaN(i.getTop()) ? trbl[0] : Math.min(trbl[0], i.getTop()));
                    double d2 = Double.isNaN(trbl[1]) ? i.getRight() : (trbl[1] = Double.isNaN(i.getRight()) ? trbl[1] : Math.min(trbl[1], i.getRight()));
                    double d3 = Double.isNaN(trbl[2]) ? i.getBottom() : (trbl[2] = Double.isNaN(i.getBottom()) ? trbl[2] : Math.min(trbl[2], i.getBottom()));
                    trbl[3] = Double.isNaN(trbl[3]) ? i.getLeft() : (Double.isNaN(i.getLeft()) ? trbl[3] : Math.min(trbl[3], i.getLeft()));
                }
                pg.setOpaqueInsets((float)trbl[0], (float)trbl[1], (float)trbl[2], (float)trbl[3]);
            }
        }
    }

    private NGNode doCreatePeer() {
        return new NGRegion();
    }

    private boolean shapeContains(Shape shape, double x, double y, double topOffset, double rightOffset, double bottomOffset, double leftOffset) {
        double resX = x;
        double resY = y;
        RectBounds bounds = shape.getBounds();
        if (this.isScaleShape()) {
            resX -= leftOffset;
            resY -= topOffset;
            resX *= (double)bounds.getWidth() / (this.getWidth() - leftOffset - rightOffset);
            resY *= (double)bounds.getHeight() / (this.getHeight() - topOffset - bottomOffset);
            if (this.isCenterShape()) {
                resX += (double)bounds.getMinX();
                resY += (double)bounds.getMinY();
            }
        } else if (this.isCenterShape()) {
            double boundsWidth = bounds.getWidth();
            double boundsHeight = bounds.getHeight();
            double scaleFactorX = boundsWidth / (boundsWidth - leftOffset - rightOffset);
            double scaleFactorY = boundsHeight / (boundsHeight - topOffset - bottomOffset);
            resX = scaleFactorX * (resX - (leftOffset + (this.getWidth() - boundsWidth) / 2.0)) + (double)bounds.getMinX();
            resY = scaleFactorY * (resY - (topOffset + (this.getHeight() - boundsHeight) / 2.0)) + (double)bounds.getMinY();
        } else if (topOffset != 0.0 || rightOffset != 0.0 || bottomOffset != 0.0 || leftOffset != 0.0) {
            double scaleFactorX = (double)bounds.getWidth() / ((double)bounds.getWidth() - leftOffset - rightOffset);
            double scaleFactorY = (double)bounds.getHeight() / ((double)bounds.getHeight() - topOffset - bottomOffset);
            resX = scaleFactorX * (resX - leftOffset - (double)bounds.getMinX()) + (double)bounds.getMinX();
            resY = scaleFactorY * (resY - topOffset - (double)bounds.getMinY()) + (double)bounds.getMinY();
        }
        return shape.contains((float)resX, (float)resY);
    }

    private boolean doComputeContains(double localX, double localY) {
        Border border;
        double x2 = this.getWidth();
        double y2 = this.getHeight();
        Background background = this.getBackground();
        if (this._shape != null) {
            if (background != null && !background.getFills().isEmpty()) {
                List<BackgroundFill> fills = background.getFills();
                double topO = Double.MAX_VALUE;
                double leftO = Double.MAX_VALUE;
                double bottomO = Double.MAX_VALUE;
                double rightO = Double.MAX_VALUE;
                int max = fills.size();
                for (int i = 0; i < max; ++i) {
                    BackgroundFill bf = fills.get(0);
                    topO = Math.min(topO, bf.getInsets().getTop());
                    leftO = Math.min(leftO, bf.getInsets().getLeft());
                    bottomO = Math.min(bottomO, bf.getInsets().getBottom());
                    rightO = Math.min(rightO, bf.getInsets().getRight());
                }
                return this.shapeContains(ShapeHelper.configShape(this._shape), localX, localY, topO, leftO, bottomO, rightO);
            }
            return false;
        }
        if (background != null) {
            List<BackgroundFill> fills = background.getFills();
            int max = fills.size();
            for (int i = 0; i < max; ++i) {
                BackgroundFill bgFill = fills.get(i);
                if (!this.contains(localX, localY, 0.0, 0.0, x2, y2, bgFill.getInsets(), this.getNormalizedFillCorner(i))) continue;
                return true;
            }
        }
        if ((border = this.getBorder()) != null) {
            List<BorderStroke> strokes = border.getStrokes();
            int max = strokes.size();
            for (int i = 0; i < max; ++i) {
                BorderStroke strokeBorder = strokes.get(i);
                if (!this.contains(localX, localY, 0.0, 0.0, x2, y2, strokeBorder.getWidths(), false, strokeBorder.getInsets(), this.getNormalizedStrokeCorner(i))) continue;
                return true;
            }
            List<BorderImage> images = border.getImages();
            int max2 = images.size();
            for (int i = 0; i < max2; ++i) {
                BorderImage borderImage = images.get(i);
                if (!this.contains(localX, localY, 0.0, 0.0, x2, y2, borderImage.getWidths(), borderImage.isFilled(), borderImage.getInsets(), CornerRadii.EMPTY)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(double px, double py, double x1, double y1, double x2, double y2, BorderWidths widths, boolean filled, Insets insets, CornerRadii rad) {
        if (filled) {
            if (this.contains(px, py, x1, y1, x2, y2, insets, rad)) {
                return true;
            }
        } else {
            boolean insideOuterEdge = this.contains(px, py, x1, y1, x2, y2, insets, rad);
            if (insideOuterEdge) {
                boolean outsideInnerEdge;
                boolean bl = outsideInnerEdge = !this.contains(px, py, x1 + (widths.isLeftAsPercentage() ? this.getWidth() * widths.getLeft() : widths.getLeft()), y1 + (widths.isTopAsPercentage() ? this.getHeight() * widths.getTop() : widths.getTop()), x2 - (widths.isRightAsPercentage() ? this.getWidth() * widths.getRight() : widths.getRight()), y2 - (widths.isBottomAsPercentage() ? this.getHeight() * widths.getBottom() : widths.getBottom()), insets, rad);
                if (outsideInnerEdge) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean contains(double px, double py, double x1, double y1, double x2, double y2, Insets insets, CornerRadii rad) {
        double rrx0 = x1 + insets.getLeft();
        double rry0 = y1 + insets.getTop();
        double rrx1 = x2 - insets.getRight();
        double rry1 = y2 - insets.getBottom();
        if (px >= rrx0 && py >= rry0 && px <= rrx1 && py <= rry1) {
            double b;
            double a;
            double centerY;
            double centerX;
            double tlhr = rad.getTopLeftHorizontalRadius();
            if (rad.isUniform() && tlhr == 0.0) {
                return true;
            }
            double tlvr = rad.getTopLeftVerticalRadius();
            double trhr = rad.getTopRightHorizontalRadius();
            double trvr = rad.getTopRightVerticalRadius();
            double blhr = rad.getBottomLeftHorizontalRadius();
            double blvr = rad.getBottomLeftVerticalRadius();
            double brhr = rad.getBottomRightHorizontalRadius();
            double brvr = rad.getBottomRightVerticalRadius();
            if (px <= rrx0 + tlhr && py <= rry0 + tlvr) {
                centerX = rrx0 + tlhr;
                centerY = rry0 + tlvr;
                a = tlhr;
                b = tlvr;
            } else if (px >= rrx1 - trhr && py <= rry0 + trvr) {
                centerX = rrx1 - trhr;
                centerY = rry0 + trvr;
                a = trhr;
                b = trvr;
            } else if (px >= rrx1 - brhr && py >= rry1 - brvr) {
                centerX = rrx1 - brhr;
                centerY = rry1 - brvr;
                a = brhr;
                b = brvr;
            } else if (px <= rrx0 + blhr && py >= rry1 - blvr) {
                centerX = rrx0 + blhr;
                centerY = rry1 - blvr;
                a = blhr;
                b = blvr;
            } else {
                return true;
            }
            double x = px - centerX;
            double y = py - centerY;
            double result = x * x / (a * a) + y * y / (b * b);
            if (result - 1.0E-7 <= 1.0) {
                return true;
            }
        }
        return false;
    }

    private CornerRadii getNormalizedFillCorner(int i) {
        if (!this.cornersValid) {
            this.validateCorners();
        }
        return this.normalizedFillCorners == null ? this.getBackground().getFills().get(i).getRadii() : this.normalizedFillCorners.get(i);
    }

    private CornerRadii getNormalizedStrokeCorner(int i) {
        if (!this.cornersValid) {
            this.validateCorners();
        }
        return this.normalizedStrokeCorners == null ? this.getBorder().getStrokes().get(i).getRadii() : this.normalizedStrokeCorners.get(i);
    }

    private void validateCorners() {
        int i;
        double width = this.getWidth();
        double height = this.getHeight();
        List<Object> newFillCorners = null;
        List<Object> newStrokeCorners = null;
        Background background = this.getBackground();
        List<BackgroundFill> fills = background == null ? Collections.EMPTY_LIST : background.getFills();
        for (int i2 = 0; i2 < fills.size(); ++i2) {
            Insets origInsets;
            CornerRadii newRadii;
            BackgroundFill fill = fills.get(i2);
            CornerRadii origRadii = fill.getRadii();
            if (origRadii == (newRadii = Region.normalize(origRadii, origInsets = fill.getInsets(), width, height))) continue;
            if (newFillCorners == null) {
                newFillCorners = Arrays.asList(new CornerRadii[fills.size()]);
            }
            newFillCorners.set(i2, newRadii);
        }
        Border border = this.getBorder();
        List<BorderStroke> strokes = border == null ? Collections.EMPTY_LIST : border.getStrokes();
        for (i = 0; i < strokes.size(); ++i) {
            Insets origInsets;
            CornerRadii newRadii;
            BorderStroke stroke = strokes.get(i);
            CornerRadii origRadii = stroke.getRadii();
            if (origRadii == (newRadii = Region.normalize(origRadii, origInsets = stroke.getInsets(), width, height))) continue;
            if (newStrokeCorners == null) {
                newStrokeCorners = Arrays.asList(new CornerRadii[strokes.size()]);
            }
            newStrokeCorners.set(i, newRadii);
        }
        if (newFillCorners != null) {
            for (i = 0; i < fills.size(); ++i) {
                if (newFillCorners.get(i) != null) continue;
                newFillCorners.set(i, fills.get(i).getRadii());
            }
            newFillCorners = Collections.unmodifiableList(newFillCorners);
        }
        if (newStrokeCorners != null) {
            for (i = 0; i < strokes.size(); ++i) {
                if (newStrokeCorners.get(i) != null) continue;
                newStrokeCorners.set(i, strokes.get(i).getRadii());
            }
            newStrokeCorners = Collections.unmodifiableList(newStrokeCorners);
        }
        this.normalizedFillCorners = newFillCorners;
        this.normalizedStrokeCorners = newStrokeCorners;
        this.cornersValid = true;
    }

    private static CornerRadii normalize(CornerRadii radii, Insets insets, double width, double height) {
        height -= insets.getTop() + insets.getBottom();
        if ((width -= insets.getLeft() + insets.getRight()) <= 0.0 || height <= 0.0) {
            return CornerRadii.EMPTY;
        }
        double tlvr = radii.getTopLeftVerticalRadius();
        double tlhr = radii.getTopLeftHorizontalRadius();
        double trvr = radii.getTopRightVerticalRadius();
        double trhr = radii.getTopRightHorizontalRadius();
        double brvr = radii.getBottomRightVerticalRadius();
        double brhr = radii.getBottomRightHorizontalRadius();
        double blvr = radii.getBottomLeftVerticalRadius();
        double blhr = radii.getBottomLeftHorizontalRadius();
        if (radii.hasPercentBasedRadii) {
            if (radii.isTopLeftVerticalRadiusAsPercentage()) {
                tlvr *= height;
            }
            if (radii.isTopLeftHorizontalRadiusAsPercentage()) {
                tlhr *= width;
            }
            if (radii.isTopRightVerticalRadiusAsPercentage()) {
                trvr *= height;
            }
            if (radii.isTopRightHorizontalRadiusAsPercentage()) {
                trhr *= width;
            }
            if (radii.isBottomRightVerticalRadiusAsPercentage()) {
                brvr *= height;
            }
            if (radii.isBottomRightHorizontalRadiusAsPercentage()) {
                brhr *= width;
            }
            if (radii.isBottomLeftVerticalRadiusAsPercentage()) {
                blvr *= height;
            }
            if (radii.isBottomLeftHorizontalRadiusAsPercentage()) {
                blhr *= width;
            }
        }
        double scale = 1.0;
        if (tlhr + trhr > width) {
            scale = Math.min(scale, width / (tlhr + trhr));
        }
        if (blhr + brhr > width) {
            scale = Math.min(scale, width / (blhr + brhr));
        }
        if (tlvr + blvr > height) {
            scale = Math.min(scale, height / (tlvr + blvr));
        }
        if (trvr + brvr > height) {
            scale = Math.min(scale, height / (trvr + brvr));
        }
        if (scale < 1.0) {
            tlvr *= scale;
            tlhr *= scale;
            trvr *= scale;
            trhr *= scale;
            brvr *= scale;
            brhr *= scale;
            blvr *= scale;
            blhr *= scale;
        }
        if (radii.hasPercentBasedRadii || scale < 1.0) {
            return new CornerRadii(tlhr, tlvr, trvr, trhr, brhr, brvr, blvr, blhr, false, false, false, false, false, false, false, false);
        }
        return radii;
    }

    private void doPickNodeLocal(PickRay pickRay, PickResultChooser result) {
        double boundsDistance = NodeHelper.intersectsBounds(this, pickRay);
        if (!Double.isNaN(boundsDistance) && ParentHelper.pickChildrenNode(this, pickRay, result)) {
            NodeHelper.intersects(this, pickRay, result);
        }
    }

    private Bounds doComputeLayoutBounds() {
        if (this.boundingBox == null) {
            this.boundingBox = new BoundingBox(0.0, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0);
        }
        return this.boundingBox;
    }

    private void doNotifyLayoutBoundsChanged() {
    }

    private BaseBounds computeShapeBounds(BaseBounds bounds) {
        Border b;
        Shape s = ShapeHelper.configShape(this._shape);
        float[] bbox = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        Background bg = this.getBackground();
        if (bg != null) {
            RectBounds sBounds = s.getBounds();
            Insets bgOutsets = bg.getOutsets();
            bbox[0] = sBounds.getMinX() - (float)bgOutsets.getLeft();
            bbox[1] = sBounds.getMinY() - (float)bgOutsets.getTop();
            bbox[2] = sBounds.getMaxX() + (float)bgOutsets.getBottom();
            bbox[3] = sBounds.getMaxY() + (float)bgOutsets.getRight();
        }
        if ((b = this.getBorder()) != null && b.getStrokes().size() > 0) {
            for (BorderStroke bs : b.getStrokes()) {
                BorderStrokeStyle bss = bs.getTopStyle() != null ? bs.getTopStyle() : (bs.getLeftStyle() != null ? bs.getLeftStyle() : (bs.getBottomStyle() != null ? bs.getBottomStyle() : (bs.getRightStyle() != null ? bs.getRightStyle() : null)));
                if (bss == null || bss == BorderStrokeStyle.NONE) continue;
                StrokeType type = bss.getType();
                double sw = Math.max(bs.getWidths().top, 0.0);
                StrokeLineCap cap = bss.getLineCap();
                StrokeLineJoin join = bss.getLineJoin();
                float miterlimit = (float)Math.max(bss.getMiterLimit(), 1.0);
                Toolkit.getToolkit().accumulateStrokeBounds(s, bbox, type, sw, cap, join, miterlimit, BaseTransform.IDENTITY_TRANSFORM);
            }
        }
        if (bbox[2] < bbox[0] || bbox[3] < bbox[1]) {
            return bounds.makeEmpty();
        }
        return bounds.deriveWithNewBounds(bbox[0], bbox[1], 0.0f, bbox[2], bbox[3], 0.0f);
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        double bx1 = 0.0;
        double by1 = 0.0;
        double bx2 = this.getWidth();
        double by2 = this.getHeight();
        if (this._shape != null && !this.isScaleShape()) {
            BaseBounds shapeBounds = this.computeShapeBounds(bounds);
            double shapeWidth = shapeBounds.getWidth();
            double shapeHeight = shapeBounds.getHeight();
            if (this.isCenterShape()) {
                bx1 = (bx2 - shapeWidth) / 2.0;
                by1 = (by2 - shapeHeight) / 2.0;
                bx2 = bx1 + shapeWidth;
                by2 = by1 + shapeHeight;
            } else {
                bx1 = shapeBounds.getMinX();
                by1 = shapeBounds.getMinY();
                bx2 = shapeBounds.getMaxX();
                by2 = shapeBounds.getMaxY();
            }
        } else {
            Background background = this.getBackground();
            Border border = this.getBorder();
            Insets backgroundOutsets = background == null ? Insets.EMPTY : background.getOutsets();
            Insets borderOutsets = border == null ? Insets.EMPTY : border.getOutsets();
            bx1 -= Math.max(backgroundOutsets.getLeft(), borderOutsets.getLeft());
            by1 -= Math.max(backgroundOutsets.getTop(), borderOutsets.getTop());
            bx2 += Math.max(backgroundOutsets.getRight(), borderOutsets.getRight());
            by2 += Math.max(backgroundOutsets.getBottom(), borderOutsets.getBottom());
        }
        BaseBounds cb = RegionHelper.superComputeGeomBounds(this, bounds, tx);
        if (cb.isEmpty()) {
            bounds = bounds.deriveWithNewBounds((float)bx1, (float)by1, 0.0f, (float)bx2, (float)by2, 0.0f);
            bounds = tx.transform(bounds, bounds);
            return bounds;
        }
        BaseBounds tempBounds = TempState.getInstance().bounds;
        tempBounds = tempBounds.deriveWithNewBounds((float)bx1, (float)by1, 0.0f, (float)bx2, (float)by2, 0.0f);
        BaseBounds bb = tx.transform(tempBounds, tempBounds);
        cb = cb.deriveWithUnion(bb);
        return cb;
    }

    public String getUserAgentStylesheet() {
        return null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Region.getClassCssMetaData();
    }

    static {
        RegionHelper.setRegionAccessor(new RegionHelper.RegionAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((Region)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((Region)node).doUpdatePeer();
            }

            @Override
            public Bounds doComputeLayoutBounds(Node node) {
                return ((Region)node).doComputeLayoutBounds();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((Region)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((Region)node).doComputeContains(localX, localY);
            }

            @Override
            public void doNotifyLayoutBoundsChanged(Node node) {
                ((Region)node).doNotifyLayoutBoundsChanged();
            }

            @Override
            public void doPickNodeLocal(Node node, PickRay localPickRay, PickResultChooser result) {
                ((Region)node).doPickNodeLocal(localPickRay, result);
            }
        });
        TEMP_VEC2D = new Vec2d();
    }

    private static class StyleableProperties {
        private static final CssMetaData<Region, Insets> PADDING = new CssMetaData<Region, Insets>("-fx-padding", InsetsConverter.getInstance(), Insets.EMPTY){

            @Override
            public boolean isSettable(Region node) {
                return node.padding == null || !node.padding.isBound();
            }

            @Override
            public StyleableProperty<Insets> getStyleableProperty(Region node) {
                return (StyleableProperty)node.paddingProperty();
            }
        };
        private static final CssMetaData<Region, Insets> OPAQUE_INSETS = new CssMetaData<Region, Insets>("-fx-opaque-insets", InsetsConverter.getInstance(), null){

            @Override
            public boolean isSettable(Region node) {
                return node.opaqueInsets == null || !node.opaqueInsets.isBound();
            }

            @Override
            public StyleableProperty<Insets> getStyleableProperty(Region node) {
                return (StyleableProperty)node.opaqueInsetsProperty();
            }
        };
        private static final CssMetaData<Region, Background> BACKGROUND = new CssMetaData<Region, Background>("-fx-region-background", BackgroundConverter.INSTANCE, null, false, Background.getClassCssMetaData()){

            @Override
            public boolean isSettable(Region node) {
                return !node.background.isBound();
            }

            @Override
            public StyleableProperty<Background> getStyleableProperty(Region node) {
                return (StyleableProperty)node.background;
            }
        };
        private static final CssMetaData<Region, Border> BORDER = new CssMetaData<Region, Border>("-fx-region-border", (StyleConverter)BorderConverter.getInstance(), null, false, Border.getClassCssMetaData()){

            @Override
            public boolean isSettable(Region node) {
                return !node.border.isBound();
            }

            @Override
            public StyleableProperty<Border> getStyleableProperty(Region node) {
                return (StyleableProperty)node.border;
            }
        };
        private static final CssMetaData<Region, javafx.scene.shape.Shape> SHAPE = new CssMetaData<Region, javafx.scene.shape.Shape>("-fx-shape", ShapeConverter.getInstance()){

            @Override
            public boolean isSettable(Region node) {
                return node.shape == null || !node.shape.isBound();
            }

            @Override
            public StyleableProperty<javafx.scene.shape.Shape> getStyleableProperty(Region node) {
                return (StyleableProperty)node.shapeProperty();
            }
        };
        private static final CssMetaData<Region, Boolean> SCALE_SHAPE = new CssMetaData<Region, Boolean>("-fx-scale-shape", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Region node) {
                return node.scaleShape == null || !node.scaleShape.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Region node) {
                return (StyleableProperty)node.scaleShapeProperty();
            }
        };
        private static final CssMetaData<Region, Boolean> POSITION_SHAPE = new CssMetaData<Region, Boolean>("-fx-position-shape", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Region node) {
                return node.centerShape == null || !node.centerShape.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Region node) {
                return (StyleableProperty)node.centerShapeProperty();
            }
        };
        private static final CssMetaData<Region, Boolean> CACHE_SHAPE = new CssMetaData<Region, Boolean>("-fx-cache-shape", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Region node) {
                return node.cacheShape == null || !node.cacheShape.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Region node) {
                return (StyleableProperty)node.cacheShapeProperty();
            }
        };
        private static final CssMetaData<Region, Boolean> SNAP_TO_PIXEL = new CssMetaData<Region, Boolean>("-fx-snap-to-pixel", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Region node) {
                return node.snapToPixel == null || !node.snapToPixel.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Region node) {
                return (StyleableProperty)node.snapToPixelProperty();
            }
        };
        private static final CssMetaData<Region, Number> MIN_HEIGHT = new CssMetaData<Region, Number>("-fx-min-height", SizeConverter.getInstance(), (Number)-1.0){

            @Override
            public boolean isSettable(Region node) {
                return node.minHeight == null || !node.minHeight.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Region node) {
                return (StyleableProperty)node.minHeightProperty();
            }
        };
        private static final CssMetaData<Region, Number> PREF_HEIGHT = new CssMetaData<Region, Number>("-fx-pref-height", SizeConverter.getInstance(), (Number)-1.0){

            @Override
            public boolean isSettable(Region node) {
                return node.prefHeight == null || !node.prefHeight.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Region node) {
                return (StyleableProperty)node.prefHeightProperty();
            }
        };
        private static final CssMetaData<Region, Number> MAX_HEIGHT = new CssMetaData<Region, Number>("-fx-max-height", SizeConverter.getInstance(), (Number)-1.0){

            @Override
            public boolean isSettable(Region node) {
                return node.maxHeight == null || !node.maxHeight.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Region node) {
                return (StyleableProperty)node.maxHeightProperty();
            }
        };
        private static final CssMetaData<Region, Number> MIN_WIDTH = new CssMetaData<Region, Number>("-fx-min-width", SizeConverter.getInstance(), (Number)-1.0){

            @Override
            public boolean isSettable(Region node) {
                return node.minWidth == null || !node.minWidth.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Region node) {
                return (StyleableProperty)node.minWidthProperty();
            }
        };
        private static final CssMetaData<Region, Number> PREF_WIDTH = new CssMetaData<Region, Number>("-fx-pref-width", SizeConverter.getInstance(), (Number)-1.0){

            @Override
            public boolean isSettable(Region node) {
                return node.prefWidth == null || !node.prefWidth.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Region node) {
                return (StyleableProperty)node.prefWidthProperty();
            }
        };
        private static final CssMetaData<Region, Number> MAX_WIDTH = new CssMetaData<Region, Number>("-fx-max-width", SizeConverter.getInstance(), (Number)-1.0){

            @Override
            public boolean isSettable(Region node) {
                return node.maxWidth == null || !node.maxWidth.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Region node) {
                return (StyleableProperty)node.maxWidthProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Parent.getClassCssMetaData());
            styleables.add(PADDING);
            styleables.add(BACKGROUND);
            styleables.add(BORDER);
            styleables.add(OPAQUE_INSETS);
            styleables.add(SHAPE);
            styleables.add(SCALE_SHAPE);
            styleables.add(POSITION_SHAPE);
            styleables.add(SNAP_TO_PIXEL);
            styleables.add(MIN_WIDTH);
            styleables.add(PREF_WIDTH);
            styleables.add(MAX_WIDTH);
            styleables.add(MIN_HEIGHT);
            styleables.add(PREF_HEIGHT);
            styleables.add(MAX_HEIGHT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    private final class ShapeProperty
    extends StyleableObjectProperty<javafx.scene.shape.Shape>
    implements Runnable {
        private ShapeProperty() {
        }

        public Object getBean() {
            return Region.this;
        }

        public String getName() {
            return "shape";
        }

        @Override
        public CssMetaData<Region, javafx.scene.shape.Shape> getCssMetaData() {
            return StyleableProperties.SHAPE;
        }

        protected void invalidated() {
            javafx.scene.shape.Shape value = (javafx.scene.shape.Shape)this.get();
            if (Region.this._shape != value) {
                if (Region.this._shape != null) {
                    ShapeHelper.setShapeChangeListener(Region.this._shape, null);
                }
                if (value != null) {
                    ShapeHelper.setShapeChangeListener(value, this);
                }
                this.run();
                if (Region.this._shape == null || value == null) {
                    Region.this.insets.fireValueChanged();
                }
                Region.this._shape = value;
            }
        }

        @Override
        public void run() {
            NodeHelper.geomChanged(Region.this);
            NodeHelper.markDirty(Region.this, DirtyBits.REGION_SHAPE);
        }
    }

    private final class MinPrefMaxProperty
    extends StyleableDoubleProperty {
        private final String name;
        private final CssMetaData<? extends Styleable, Number> cssMetaData;

        MinPrefMaxProperty(String name, double initialValue, CssMetaData<? extends Styleable, Number> cssMetaData) {
            super(initialValue);
            this.name = name;
            this.cssMetaData = cssMetaData;
        }

        public void invalidated() {
            Region.this.requestParentLayout();
        }

        public Object getBean() {
            return Region.this;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return this.cssMetaData;
        }
    }

    private final class InsetsProperty
    extends ReadOnlyObjectProperty<Insets> {
        private Insets cache = null;
        private ExpressionHelper<Insets> helper = null;

        private InsetsProperty() {
        }

        public Object getBean() {
            return Region.this;
        }

        public String getName() {
            return "insets";
        }

        public void addListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.addListener(this.helper, (ObservableValue)this, (InvalidationListener)listener);
        }

        public void removeListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, (InvalidationListener)listener);
        }

        public void addListener(ChangeListener<? super Insets> listener) {
            this.helper = ExpressionHelper.addListener(this.helper, (ObservableValue)this, listener);
        }

        public void removeListener(ChangeListener<? super Insets> listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        void fireValueChanged() {
            this.cache = null;
            Region.this.updateSnappedInsets();
            Region.this.requestLayout();
            ExpressionHelper.fireValueChangedEvent(this.helper);
        }

        public Insets get() {
            if (Region.this._shape != null) {
                return Region.this.getPadding();
            }
            Border b = Region.this.getBorder();
            if (b == null || Insets.EMPTY.equals(b.getInsets())) {
                return Region.this.getPadding();
            }
            if (this.cache == null) {
                Insets borderInsets = b.getInsets();
                Insets paddingInsets = Region.this.getPadding();
                this.cache = new Insets(borderInsets.getTop() + paddingInsets.getTop(), borderInsets.getRight() + paddingInsets.getRight(), borderInsets.getBottom() + paddingInsets.getBottom(), borderInsets.getLeft() + paddingInsets.getLeft());
            }
            return this.cache;
        }
    }
}

