/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.PathElementHelper;
import com.sun.javafx.scene.shape.PathHelper;
import com.sun.javafx.scene.shape.PathUtils;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPath;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.StyleableProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;

public class Path
extends Shape {
    private Path2D path2d = null;
    private ObjectProperty<FillRule> fillRule;
    private boolean isPathValid;
    private final ObservableList<PathElement> elements;

    public Path() {
        PathHelper.initHelper(this);
        ((StyleableProperty)this.fillProperty()).applyStyle(null, null);
        ((StyleableProperty)this.strokeProperty()).applyStyle(null, Color.BLACK);
        this.elements = new TrackableObservableList<PathElement>(){

            protected void onChanged(ListChangeListener.Change<PathElement> c) {
                ObservableList list = c.getList();
                boolean firstElementChanged = false;
                while (c.next()) {
                    int i;
                    List removed = c.getRemoved();
                    for (i = 0; i < c.getRemovedSize(); ++i) {
                        ((PathElement)removed.get(i)).removeNode(Path.this);
                    }
                    for (i = c.getFrom(); i < c.getTo(); ++i) {
                        ((PathElement)list.get(i)).addNode(Path.this);
                    }
                    firstElementChanged |= c.getFrom() == 0;
                }
                if (Path.this.path2d != null) {
                    c.reset();
                    c.next();
                    if (c.getFrom() == c.getList().size() && !c.wasRemoved() && c.wasAdded()) {
                        for (int i = c.getFrom(); i < c.getTo(); ++i) {
                            PathElementHelper.addTo((PathElement)list.get(i), Path.this.path2d);
                        }
                    } else {
                        Path.this.path2d = null;
                    }
                }
                if (firstElementChanged) {
                    Path.this.isPathValid = Path.this.isFirstPathElementValid();
                }
                NodeHelper.markDirty(Path.this, DirtyBits.NODE_CONTENTS);
                NodeHelper.geomChanged(Path.this);
            }
        };
    }

    public Path(PathElement ... elements) {
        PathHelper.initHelper(this);
        ((StyleableProperty)this.fillProperty()).applyStyle(null, null);
        ((StyleableProperty)this.strokeProperty()).applyStyle(null, Color.BLACK);
        this.elements = new /* invalid duplicate definition of identical inner class */;
        if (elements != null) {
            this.elements.addAll((Object[])elements);
        }
    }

    public Path(Collection<? extends PathElement> elements) {
        PathHelper.initHelper(this);
        ((StyleableProperty)this.fillProperty()).applyStyle(null, null);
        ((StyleableProperty)this.strokeProperty()).applyStyle(null, Color.BLACK);
        this.elements = new /* invalid duplicate definition of identical inner class */;
        if (elements != null) {
            this.elements.addAll(elements);
        }
    }

    void markPathDirty() {
        this.path2d = null;
        NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
        NodeHelper.geomChanged(this);
    }

    public final void setFillRule(FillRule value) {
        if (this.fillRule != null || value != FillRule.NON_ZERO) {
            this.fillRuleProperty().set((Object)value);
        }
    }

    public final FillRule getFillRule() {
        return this.fillRule == null ? FillRule.NON_ZERO : (FillRule)((Object)this.fillRule.get());
    }

    public final ObjectProperty<FillRule> fillRuleProperty() {
        if (this.fillRule == null) {
            this.fillRule = new ObjectPropertyBase<FillRule>(FillRule.NON_ZERO){

                public void invalidated() {
                    NodeHelper.markDirty(Path.this, DirtyBits.NODE_CONTENTS);
                    NodeHelper.geomChanged(Path.this);
                }

                public Object getBean() {
                    return Path.this;
                }

                public String getName() {
                    return "fillRule";
                }
            };
        }
        return this.fillRule;
    }

    public final ObservableList<PathElement> getElements() {
        return this.elements;
    }

    private NGNode doCreatePeer() {
        return new NGPath();
    }

    private Path2D doConfigShape() {
        if (this.isPathValid) {
            if (this.path2d == null) {
                this.path2d = PathUtils.configShape(this.getElements(), this.getFillRule() == FillRule.EVEN_ODD);
            } else {
                this.path2d.setWindingRule(this.getFillRule() == FillRule.NON_ZERO ? 1 : 0);
            }
            return this.path2d;
        }
        return new Path2D();
    }

    private Bounds doComputeLayoutBounds() {
        if (this.isPathValid) {
            return null;
        }
        return new BoundingBox(0.0, 0.0, -1.0, -1.0);
    }

    private boolean isFirstPathElementValid() {
        ObservableList<PathElement> _elements = this.getElements();
        if (_elements != null && _elements.size() > 0) {
            PathElement firstElement = (PathElement)_elements.get(0);
            if (!firstElement.isAbsolute()) {
                System.err.printf("First element of the path can not be relative. Path: %s\n", this);
                return false;
            }
            if (firstElement instanceof MoveTo) {
                return true;
            }
            System.err.printf("Missing initial moveto in path definition. Path: %s\n", this);
            return false;
        }
        return true;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.NODE_CONTENTS)) {
            NGPath peer = (NGPath)NodeHelper.getPeer(this);
            if (peer.acceptsPath2dOnUpdate()) {
                peer.updateWithPath2d((Path2D)ShapeHelper.configShape(this));
            } else {
                peer.reset();
                if (this.isPathValid) {
                    peer.setFillRule(this.getFillRule());
                    for (PathElement elt : this.getElements()) {
                        elt.addTo(peer);
                    }
                    peer.update();
                }
            }
        }
    }

    private Paint doCssGetFillInitialValue() {
        return null;
    }

    private Paint doCssGetStrokeInitialValue() {
        return Color.BLACK;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Path[");
        String id = this.getId();
        if (id != null) {
            sb.append("id=").append(id).append(", ");
        }
        sb.append("elements=").append(this.getElements());
        sb.append(", fill=").append(this.getFill());
        sb.append(", fillRule=").append((Object)this.getFillRule());
        Paint stroke = this.getStroke();
        if (stroke != null) {
            sb.append(", stroke=").append(stroke);
            sb.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return sb.append("]").toString();
    }

    static {
        PathHelper.setPathAccessor(new PathHelper.PathAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((Path)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((Path)node).doUpdatePeer();
            }

            @Override
            public Bounds doComputeLayoutBounds(Node node) {
                return ((Path)node).doComputeLayoutBounds();
            }

            @Override
            public Paint doCssGetFillInitialValue(Shape shape) {
                return ((Path)shape).doCssGetFillInitialValue();
            }

            @Override
            public Paint doCssGetStrokeInitialValue(Shape shape) {
                return ((Path)shape).doCssGetStrokeInitialValue();
            }

            @Override
            public com.sun.javafx.geom.Shape doConfigShape(Shape shape) {
                return ((Path)shape).doConfigShape();
            }
        });
    }
}

