/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.transform;

import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;

public class Rotate
extends Transform {
    public static final Point3D X_AXIS = new Point3D(1.0, 0.0, 0.0);
    public static final Point3D Y_AXIS = new Point3D(0.0, 1.0, 0.0);
    public static final Point3D Z_AXIS = new Point3D(0.0, 0.0, 1.0);
    private MatrixCache cache;
    private MatrixCache inverseCache;
    private DoubleProperty angle;
    private DoubleProperty pivotX;
    private DoubleProperty pivotY;
    private DoubleProperty pivotZ;
    private ObjectProperty<Point3D> axis;

    public Rotate() {
    }

    public Rotate(double angle) {
        this.setAngle(angle);
    }

    public Rotate(double angle, Point3D axis) {
        this.setAngle(angle);
        this.setAxis(axis);
    }

    public Rotate(double angle, double pivotX, double pivotY) {
        this.setAngle(angle);
        this.setPivotX(pivotX);
        this.setPivotY(pivotY);
    }

    public Rotate(double angle, double pivotX, double pivotY, double pivotZ) {
        this(angle, pivotX, pivotY);
        this.setPivotZ(pivotZ);
    }

    public Rotate(double angle, double pivotX, double pivotY, double pivotZ, Point3D axis) {
        this(angle, pivotX, pivotY);
        this.setPivotZ(pivotZ);
        this.setAxis(axis);
    }

    public final void setAngle(double value) {
        this.angleProperty().set(value);
    }

    public final double getAngle() {
        return this.angle == null ? 0.0 : this.angle.get();
    }

    public final DoubleProperty angleProperty() {
        if (this.angle == null) {
            this.angle = new DoublePropertyBase(){

                public void invalidated() {
                    Rotate.this.transformChanged();
                }

                public Object getBean() {
                    return Rotate.this;
                }

                public String getName() {
                    return "angle";
                }
            };
        }
        return this.angle;
    }

    public final void setPivotX(double value) {
        this.pivotXProperty().set(value);
    }

    public final double getPivotX() {
        return this.pivotX == null ? 0.0 : this.pivotX.get();
    }

    public final DoubleProperty pivotXProperty() {
        if (this.pivotX == null) {
            this.pivotX = new DoublePropertyBase(){

                public void invalidated() {
                    Rotate.this.transformChanged();
                }

                public Object getBean() {
                    return Rotate.this;
                }

                public String getName() {
                    return "pivotX";
                }
            };
        }
        return this.pivotX;
    }

    public final void setPivotY(double value) {
        this.pivotYProperty().set(value);
    }

    public final double getPivotY() {
        return this.pivotY == null ? 0.0 : this.pivotY.get();
    }

    public final DoubleProperty pivotYProperty() {
        if (this.pivotY == null) {
            this.pivotY = new DoublePropertyBase(){

                public void invalidated() {
                    Rotate.this.transformChanged();
                }

                public Object getBean() {
                    return Rotate.this;
                }

                public String getName() {
                    return "pivotY";
                }
            };
        }
        return this.pivotY;
    }

    public final void setPivotZ(double value) {
        this.pivotZProperty().set(value);
    }

    public final double getPivotZ() {
        return this.pivotZ == null ? 0.0 : this.pivotZ.get();
    }

    public final DoubleProperty pivotZProperty() {
        if (this.pivotZ == null) {
            this.pivotZ = new DoublePropertyBase(){

                public void invalidated() {
                    Rotate.this.transformChanged();
                }

                public Object getBean() {
                    return Rotate.this;
                }

                public String getName() {
                    return "pivotZ";
                }
            };
        }
        return this.pivotZ;
    }

    public final void setAxis(Point3D value) {
        this.axisProperty().set((Object)value);
    }

    public final Point3D getAxis() {
        return this.axis == null ? Z_AXIS : (Point3D)this.axis.get();
    }

    public final ObjectProperty<Point3D> axisProperty() {
        if (this.axis == null) {
            this.axis = new ObjectPropertyBase<Point3D>(Z_AXIS){

                public void invalidated() {
                    Rotate.this.transformChanged();
                }

                public Object getBean() {
                    return Rotate.this;
                }

                public String getName() {
                    return "axis";
                }
            };
        }
        return this.axis;
    }

    @Override
    public double getMxx() {
        this.updateCache();
        return this.cache.mxx;
    }

    @Override
    public double getMxy() {
        this.updateCache();
        return this.cache.mxy;
    }

    @Override
    public double getMxz() {
        this.updateCache();
        return this.cache.mxz;
    }

    @Override
    public double getTx() {
        this.updateCache();
        return this.cache.tx;
    }

    @Override
    public double getMyx() {
        this.updateCache();
        return this.cache.myx;
    }

    @Override
    public double getMyy() {
        this.updateCache();
        return this.cache.myy;
    }

    @Override
    public double getMyz() {
        this.updateCache();
        return this.cache.myz;
    }

    @Override
    public double getTy() {
        this.updateCache();
        return this.cache.ty;
    }

    @Override
    public double getMzx() {
        this.updateCache();
        return this.cache.mzx;
    }

    @Override
    public double getMzy() {
        this.updateCache();
        return this.cache.mzy;
    }

    @Override
    public double getMzz() {
        this.updateCache();
        return this.cache.mzz;
    }

    @Override
    public double getTz() {
        this.updateCache();
        return this.cache.tz;
    }

    @Override
    boolean computeIs2D() {
        Point3D a = this.getAxis();
        return a.getX() == 0.0 && a.getY() == 0.0 || this.getAngle() == 0.0;
    }

    @Override
    boolean computeIsIdentity() {
        if (this.getAngle() == 0.0) {
            return true;
        }
        Point3D a = this.getAxis();
        return a.getX() == 0.0 && a.getY() == 0.0 && a.getZ() == 0.0;
    }

    @Override
    void fill2DArray(double[] array) {
        this.updateCache();
        array[0] = this.cache.mxx;
        array[1] = this.cache.mxy;
        array[2] = this.cache.tx;
        array[3] = this.cache.myx;
        array[4] = this.cache.myy;
        array[5] = this.cache.ty;
    }

    @Override
    void fill3DArray(double[] array) {
        this.updateCache();
        array[0] = this.cache.mxx;
        array[1] = this.cache.mxy;
        array[2] = this.cache.mxz;
        array[3] = this.cache.tx;
        array[4] = this.cache.myx;
        array[5] = this.cache.myy;
        array[6] = this.cache.myz;
        array[7] = this.cache.ty;
        array[8] = this.cache.mzx;
        array[9] = this.cache.mzy;
        array[10] = this.cache.mzz;
        array[11] = this.cache.tz;
    }

    @Override
    public Transform createConcatenation(Transform transform) {
        if (transform instanceof Rotate) {
            Rotate r = (Rotate)transform;
            double px = this.getPivotX();
            double py = this.getPivotY();
            double pz = this.getPivotZ();
            if ((r.getAxis() == this.getAxis() || r.getAxis().normalize().equals(this.getAxis().normalize())) && px == r.getPivotX() && py == r.getPivotY() && pz == r.getPivotZ()) {
                return new Rotate(this.getAngle() + r.getAngle(), px, py, pz, this.getAxis());
            }
        }
        if (transform instanceof Affine) {
            Affine a = (Affine)transform.clone();
            a.prepend(this);
            return a;
        }
        return super.createConcatenation(transform);
    }

    @Override
    public Transform createInverse() throws NonInvertibleTransformException {
        return new Rotate(-this.getAngle(), this.getPivotX(), this.getPivotY(), this.getPivotZ(), this.getAxis());
    }

    @Override
    public Rotate clone() {
        return new Rotate(this.getAngle(), this.getPivotX(), this.getPivotY(), this.getPivotZ(), this.getAxis());
    }

    @Override
    public Point2D transform(double x, double y) {
        this.ensureCanTransform2DPoint();
        this.updateCache();
        return new Point2D(this.cache.mxx * x + this.cache.mxy * y + this.cache.tx, this.cache.myx * x + this.cache.myy * y + this.cache.ty);
    }

    @Override
    public Point3D transform(double x, double y, double z) {
        this.updateCache();
        return new Point3D(this.cache.mxx * x + this.cache.mxy * y + this.cache.mxz * z + this.cache.tx, this.cache.myx * x + this.cache.myy * y + this.cache.myz * z + this.cache.ty, this.cache.mzx * x + this.cache.mzy * y + this.cache.mzz * z + this.cache.tz);
    }

    @Override
    void transform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        this.updateCache();
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = this.cache.mxx * x + this.cache.mxy * y + this.cache.tx;
            dstPts[dstOff++] = this.cache.myx * x + this.cache.myy * y + this.cache.ty;
        }
    }

    @Override
    void transform3DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        this.updateCache();
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            double z = srcPts[srcOff++];
            dstPts[dstOff++] = this.cache.mxx * x + this.cache.mxy * y + this.cache.mxz * z + this.cache.tx;
            dstPts[dstOff++] = this.cache.myx * x + this.cache.myy * y + this.cache.myz * z + this.cache.ty;
            dstPts[dstOff++] = this.cache.mzx * x + this.cache.mzy * y + this.cache.mzz * z + this.cache.tz;
        }
    }

    @Override
    public Point2D deltaTransform(double x, double y) {
        this.ensureCanTransform2DPoint();
        this.updateCache();
        return new Point2D(this.cache.mxx * x + this.cache.mxy * y, this.cache.myx * x + this.cache.myy * y);
    }

    @Override
    public Point3D deltaTransform(double x, double y, double z) {
        this.updateCache();
        return new Point3D(this.cache.mxx * x + this.cache.mxy * y + this.cache.mxz * z, this.cache.myx * x + this.cache.myy * y + this.cache.myz * z, this.cache.mzx * x + this.cache.mzy * y + this.cache.mzz * z);
    }

    @Override
    public Point2D inverseTransform(double x, double y) {
        this.ensureCanTransform2DPoint();
        this.updateInverseCache();
        return new Point2D(this.inverseCache.mxx * x + this.inverseCache.mxy * y + this.inverseCache.tx, this.inverseCache.myx * x + this.inverseCache.myy * y + this.inverseCache.ty);
    }

    @Override
    public Point3D inverseTransform(double x, double y, double z) {
        this.updateInverseCache();
        return new Point3D(this.inverseCache.mxx * x + this.inverseCache.mxy * y + this.inverseCache.mxz * z + this.inverseCache.tx, this.inverseCache.myx * x + this.inverseCache.myy * y + this.inverseCache.myz * z + this.inverseCache.ty, this.inverseCache.mzx * x + this.inverseCache.mzy * y + this.inverseCache.mzz * z + this.inverseCache.tz);
    }

    @Override
    void inverseTransform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        this.updateInverseCache();
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = this.inverseCache.mxx * x + this.inverseCache.mxy * y + this.inverseCache.tx;
            dstPts[dstOff++] = this.inverseCache.myx * x + this.inverseCache.myy * y + this.inverseCache.ty;
        }
    }

    @Override
    void inverseTransform3DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        this.updateInverseCache();
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            double z = srcPts[srcOff++];
            dstPts[dstOff++] = this.inverseCache.mxx * x + this.inverseCache.mxy * y + this.inverseCache.mxz * z + this.inverseCache.tx;
            dstPts[dstOff++] = this.inverseCache.myx * x + this.inverseCache.myy * y + this.inverseCache.myz * z + this.inverseCache.ty;
            dstPts[dstOff++] = this.inverseCache.mzx * x + this.inverseCache.mzy * y + this.inverseCache.mzz * z + this.inverseCache.tz;
        }
    }

    @Override
    public Point2D inverseDeltaTransform(double x, double y) {
        this.ensureCanTransform2DPoint();
        this.updateInverseCache();
        return new Point2D(this.inverseCache.mxx * x + this.inverseCache.mxy * y, this.inverseCache.myx * x + this.inverseCache.myy * y);
    }

    @Override
    public Point3D inverseDeltaTransform(double x, double y, double z) {
        this.updateInverseCache();
        return new Point3D(this.inverseCache.mxx * x + this.inverseCache.mxy * y + this.inverseCache.mxz * z, this.inverseCache.myx * x + this.inverseCache.myy * y + this.inverseCache.myz * z, this.inverseCache.mzx * x + this.inverseCache.mzy * y + this.inverseCache.mzz * z);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Rotate [");
        sb.append("angle=").append(this.getAngle());
        sb.append(", pivotX=").append(this.getPivotX());
        sb.append(", pivotY=").append(this.getPivotY());
        sb.append(", pivotZ=").append(this.getPivotZ());
        sb.append(", axis=").append(this.getAxis());
        return sb.append("]").toString();
    }

    @Override
    void apply(Affine3D trans) {
        double localPivotX = this.getPivotX();
        double localPivotY = this.getPivotY();
        double localPivotZ = this.getPivotZ();
        double localAngle = this.getAngle();
        if (localPivotX != 0.0 || localPivotY != 0.0 || localPivotZ != 0.0) {
            trans.translate(localPivotX, localPivotY, localPivotZ);
            trans.rotate(Math.toRadians(localAngle), this.getAxis().getX(), this.getAxis().getY(), this.getAxis().getZ());
            trans.translate(-localPivotX, -localPivotY, -localPivotZ);
        } else {
            trans.rotate(Math.toRadians(localAngle), this.getAxis().getX(), this.getAxis().getY(), this.getAxis().getZ());
        }
    }

    @Override
    BaseTransform derive(BaseTransform trans) {
        if (this.isIdentity()) {
            return trans;
        }
        double localPivotX = this.getPivotX();
        double localPivotY = this.getPivotY();
        double localPivotZ = this.getPivotZ();
        double localAngle = this.getAngle();
        if (localPivotX != 0.0 || localPivotY != 0.0 || localPivotZ != 0.0) {
            trans = trans.deriveWithTranslation(localPivotX, localPivotY, localPivotZ);
            trans = trans.deriveWithRotation(Math.toRadians(localAngle), this.getAxis().getX(), this.getAxis().getY(), this.getAxis().getZ());
            return trans.deriveWithTranslation(-localPivotX, -localPivotY, -localPivotZ);
        }
        return trans.deriveWithRotation(Math.toRadians(localAngle), this.getAxis().getX(), this.getAxis().getY(), this.getAxis().getZ());
    }

    @Override
    void validate() {
        this.getAxis();
        this.getAngle();
        this.getPivotX();
        this.getPivotY();
        this.getPivotZ();
    }

    @Override
    protected void transformChanged() {
        if (this.cache != null) {
            this.cache.invalidate();
        }
        super.transformChanged();
    }

    @Override
    void appendTo(Affine a) {
        a.appendRotation(this.getAngle(), this.getPivotX(), this.getPivotY(), this.getPivotZ(), this.getAxis());
    }

    @Override
    void prependTo(Affine a) {
        a.prependRotation(this.getAngle(), this.getPivotX(), this.getPivotY(), this.getPivotZ(), this.getAxis());
    }

    private void updateCache() {
        if (this.cache == null) {
            this.cache = new MatrixCache();
        }
        if (!this.cache.valid) {
            this.cache.update(this.getAngle(), this.getAxis(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
        }
    }

    private void updateInverseCache() {
        if (this.inverseCache == null) {
            this.inverseCache = new MatrixCache();
        }
        if (!this.inverseCache.valid) {
            this.inverseCache.update(-this.getAngle(), this.getAxis(), this.getPivotX(), this.getPivotY(), this.getPivotZ());
        }
    }

    private static class MatrixCache {
        boolean valid = false;
        boolean is3D = false;
        double mxx;
        double mxy;
        double mxz;
        double tx;
        double myx;
        double myy;
        double myz;
        double ty;
        double mzx;
        double mzy;
        double mzz = 1.0;
        double tz;

        public void update(double angle, Point3D axis, double px, double py, double pz) {
            double axisZ;
            double axisY;
            double axisX;
            double rads = Math.toRadians(angle);
            double sin = Math.sin(rads);
            double cos = Math.cos(rads);
            if (axis == Z_AXIS || axis.getX() == 0.0 && axis.getY() == 0.0 && axis.getZ() > 0.0) {
                this.mxx = cos;
                this.mxy = -sin;
                this.tx = px * (1.0 - cos) + py * sin;
                this.myx = sin;
                this.myy = cos;
                this.ty = py * (1.0 - cos) - px * sin;
                if (this.is3D) {
                    this.mxz = 0.0;
                    this.myz = 0.0;
                    this.mzx = 0.0;
                    this.mzy = 0.0;
                    this.mzz = 1.0;
                    this.tz = 0.0;
                    this.is3D = false;
                }
                this.valid = true;
                return;
            }
            this.is3D = true;
            if (axis == X_AXIS || axis == Y_AXIS || axis == Z_AXIS) {
                axisX = axis.getX();
                axisY = axis.getY();
                axisZ = axis.getZ();
            } else {
                double mag = Math.sqrt(axis.getX() * axis.getX() + axis.getY() * axis.getY() + axis.getZ() * axis.getZ());
                if (mag == 0.0) {
                    this.mxx = 1.0;
                    this.mxy = 0.0;
                    this.mxz = 0.0;
                    this.tx = 0.0;
                    this.myx = 0.0;
                    this.myy = 1.0;
                    this.myz = 0.0;
                    this.ty = 0.0;
                    this.mzx = 0.0;
                    this.mzy = 0.0;
                    this.mzz = 1.0;
                    this.tz = 0.0;
                    this.valid = true;
                    return;
                }
                axisX = axis.getX() / mag;
                axisY = axis.getY() / mag;
                axisZ = axis.getZ() / mag;
            }
            this.mxx = cos + axisX * axisX * (1.0 - cos);
            this.mxy = axisX * axisY * (1.0 - cos) - axisZ * sin;
            this.mxz = axisX * axisZ * (1.0 - cos) + axisY * sin;
            this.tx = px * (1.0 - this.mxx) - py * this.mxy - pz * this.mxz;
            this.myx = axisY * axisX * (1.0 - cos) + axisZ * sin;
            this.myy = cos + axisY * axisY * (1.0 - cos);
            this.myz = axisY * axisZ * (1.0 - cos) - axisX * sin;
            this.ty = py * (1.0 - this.myy) - px * this.myx - pz * this.myz;
            this.mzx = axisZ * axisX * (1.0 - cos) - axisY * sin;
            this.mzy = axisZ * axisY * (1.0 - cos) + axisX * sin;
            this.mzz = cos + axisZ * axisZ * (1.0 - cos);
            this.tz = pz * (1.0 - this.mzz) - px * this.mzx - py * this.mzy;
            this.valid = true;
        }

        public void invalidate() {
            this.valid = false;
        }
    }
}

