/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.FXPermissions;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.stage.EmbeddedWindow;
import com.sun.javafx.stage.WindowEventDispatcher;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.stage.WindowPeerListener;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.WindowEvent;

public class Window
implements EventTarget {
    private static ObservableList<Window> windows = FXCollections.observableArrayList();
    private static ObservableList<Window> unmodifiableWindows = FXCollections.unmodifiableObservableList(windows);
    private WindowHelper windowHelper = null;
    final AccessControlContext acc = AccessController.getContext();
    private WindowPeerListener peerListener;
    private TKStage peer;
    private TKBoundsConfigurator peerBoundsConfigurator = new TKBoundsConfigurator();
    private boolean sizeToScene = false;
    private static final float CENTER_ON_SCREEN_X_FRACTION = 0.5f;
    private static final float CENTER_ON_SCREEN_Y_FRACTION = 0.33333334f;
    private ReadOnlyDoubleWrapper outputScaleX = new ReadOnlyDoubleWrapper((Object)this, "outputScaleX", 1.0);
    private ReadOnlyDoubleWrapper outputScaleY = new ReadOnlyDoubleWrapper((Object)this, "outputScaleY", 1.0);
    private BooleanProperty forceIntegerRenderScale = new SimpleBooleanProperty(this, "forceIntegerRenderScale", false){

        protected void invalidated() {
            Window.this.updateRenderScales(Window.this.getOutputScaleX(), Window.this.getOutputScaleY());
        }
    };
    private DoubleProperty renderScaleX = new SimpleDoubleProperty(this, "renderScaleX", 1.0){

        protected void invalidated() {
            Window.this.peerBoundsConfigurator.setRenderScaleX(this.get());
        }
    };
    private DoubleProperty renderScaleY = new SimpleDoubleProperty(this, "renderScaleY", 1.0){

        protected void invalidated() {
            Window.this.peerBoundsConfigurator.setRenderScaleY(this.get());
        }
    };
    private boolean xExplicit = false;
    private ReadOnlyDoubleWrapper x = new ReadOnlyDoubleWrapper((Object)this, "x", Double.NaN);
    private boolean yExplicit = false;
    private ReadOnlyDoubleWrapper y = new ReadOnlyDoubleWrapper((Object)this, "y", Double.NaN);
    private boolean widthExplicit = false;
    private ReadOnlyDoubleWrapper width = new ReadOnlyDoubleWrapper((Object)this, "width", Double.NaN);
    private boolean heightExplicit = false;
    private ReadOnlyDoubleWrapper height = new ReadOnlyDoubleWrapper((Object)this, "height", Double.NaN);
    private ReadOnlyBooleanWrapper focused = new ReadOnlyBooleanWrapper(){

        protected void invalidated() {
            Window.this.focusChanged(this.get());
        }

        public Object getBean() {
            return Window.this;
        }

        public String getName() {
            return "focused";
        }
    };
    private static final Object USER_DATA_KEY;
    private ObservableMap<Object, Object> properties;
    private SceneModel scene = new SceneModel();
    private DoubleProperty opacity;
    private ObjectProperty<EventHandler<WindowEvent>> onCloseRequest;
    private ObjectProperty<EventHandler<WindowEvent>> onShowing;
    private ObjectProperty<EventHandler<WindowEvent>> onShown;
    private ObjectProperty<EventHandler<WindowEvent>> onHiding;
    private ObjectProperty<EventHandler<WindowEvent>> onHidden;
    private ReadOnlyBooleanWrapper showing = new ReadOnlyBooleanWrapper(){
        private boolean oldVisible;

        protected void invalidated() {
            boolean newVisible = this.get();
            if (this.oldVisible == newVisible) {
                return;
            }
            if (!this.oldVisible && newVisible) {
                Window.this.fireEvent(new WindowEvent(Window.this, WindowEvent.WINDOW_SHOWING));
            } else {
                Window.this.fireEvent(new WindowEvent(Window.this, WindowEvent.WINDOW_HIDING));
            }
            this.oldVisible = newVisible;
            WindowHelper.visibleChanging(Window.this, newVisible);
            if (newVisible) {
                Window.this.hasBeenVisible = true;
                windows.add((Object)Window.this);
            } else {
                windows.remove((Object)Window.this);
            }
            Toolkit tk = Toolkit.getToolkit();
            if (Window.this.peer != null) {
                if (newVisible) {
                    if (Window.this.peerListener == null) {
                        Window.this.peerListener = new WindowPeerListener(Window.this);
                    }
                    Window.this.peer.setTKStageListener(Window.this.peerListener);
                    tk.addStageTkPulseListener(Window.this.peerBoundsConfigurator);
                    boolean isEmbeddedWindow = Window.this instanceof EmbeddedWindow;
                    if (isEmbeddedWindow && Window.this.getScene() != null) {
                        SceneHelper.initPeer(Window.this.getScene());
                        Window.this.peer.setScene(SceneHelper.getPeer(Window.this.getScene()));
                        SceneHelper.preferredSize(Window.this.getScene());
                    }
                    Window.this.updateOutputScales(Window.this.peer.getOutputScaleX(), Window.this.peer.getOutputScaleY());
                    Window.this.peerBoundsConfigurator.setRenderScaleX(Window.this.getRenderScaleX());
                    Window.this.peerBoundsConfigurator.setRenderScaleY(Window.this.getRenderScaleY());
                    if (!isEmbeddedWindow && Window.this.getScene() != null) {
                        SceneHelper.initPeer(Window.this.getScene());
                        Window.this.peer.setScene(SceneHelper.getPeer(Window.this.getScene()));
                        SceneHelper.preferredSize(Window.this.getScene());
                    }
                    if (!(Window.this.getScene() == null || Window.this.widthExplicit && Window.this.heightExplicit)) {
                        Window.this.adjustSize(true);
                    } else {
                        Window.this.peerBoundsConfigurator.setSize(Window.this.getWidth(), Window.this.getHeight(), -1.0, -1.0);
                    }
                    if (!Window.this.xExplicit && !Window.this.yExplicit) {
                        Window.this.centerOnScreen();
                    } else {
                        Window.this.peerBoundsConfigurator.setLocation(Window.this.getX(), Window.this.getY(), 0.0f, 0.0f);
                    }
                    Window.this.applyBounds();
                    Window.this.peer.setOpacity((float)Window.this.getOpacity());
                    Window.this.peer.setVisible(true);
                    Window.this.fireEvent(new WindowEvent(Window.this, WindowEvent.WINDOW_SHOWN));
                } else {
                    Window.this.peer.setVisible(false);
                    Window.this.fireEvent(new WindowEvent(Window.this, WindowEvent.WINDOW_HIDDEN));
                    if (Window.this.getScene() != null) {
                        Window.this.peer.setScene(null);
                        SceneHelper.disposePeer(Window.this.getScene());
                        StyleManager.getInstance().forget(Window.this.getScene());
                    }
                    tk.removeStageTkPulseListener(Window.this.peerBoundsConfigurator);
                    Window.this.peer.setTKStageListener(null);
                    Window.this.peer.close();
                }
            }
            if (newVisible) {
                tk.requestNextPulse();
            }
            WindowHelper.visibleChanged(Window.this, newVisible);
            if (Window.this.sizeToScene) {
                if (newVisible) {
                    Window.this.sizeToScene();
                }
                Window.this.sizeToScene = false;
            }
        }

        public Object getBean() {
            return Window.this;
        }

        public String getName() {
            return "showing";
        }
    };
    boolean hasBeenVisible = false;
    private ObjectProperty<EventDispatcher> eventDispatcher;
    private WindowEventDispatcher internalEventDispatcher;
    private int focusGrabCounter;
    private final ReadOnlyObjectWrapper<Screen> screen = new ReadOnlyObjectWrapper((Object)Screen.getPrimary());

    public static ObservableList<Window> getWindows() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)FXPermissions.ACCESS_WINDOW_LIST_PERMISSION);
        }
        return unmodifiableWindows;
    }

    protected Window() {
        this.initializeInternalEventDispatcher();
        WindowHelper.initHelper(this);
    }

    WindowPeerListener getPeerListener() {
        return this.peerListener;
    }

    void setPeerListener(WindowPeerListener peerListener) {
        this.peerListener = peerListener;
    }

    TKStage getPeer() {
        return this.peer;
    }

    void setPeer(TKStage peer) {
        this.peer = peer;
    }

    public void sizeToScene() {
        if (this.getScene() != null && this.peer != null) {
            SceneHelper.preferredSize(this.getScene());
            this.adjustSize(false);
        } else {
            this.sizeToScene = true;
        }
    }

    private void adjustSize(boolean selfSizePriority) {
        if (this.getScene() == null) {
            return;
        }
        if (this.peer != null) {
            double sceneWidth = this.getScene().getWidth();
            double cw = sceneWidth > 0.0 ? sceneWidth : -1.0;
            double w = -1.0;
            if (selfSizePriority && this.widthExplicit) {
                w = this.getWidth();
            } else if (cw <= 0.0) {
                w = this.widthExplicit ? this.getWidth() : -1.0;
            } else {
                this.widthExplicit = false;
            }
            double sceneHeight = this.getScene().getHeight();
            double ch = sceneHeight > 0.0 ? sceneHeight : -1.0;
            double h = -1.0;
            if (selfSizePriority && this.heightExplicit) {
                h = this.getHeight();
            } else if (ch <= 0.0) {
                h = this.heightExplicit ? this.getHeight() : -1.0;
            } else {
                this.heightExplicit = false;
            }
            this.peerBoundsConfigurator.setSize(w, h, cw, ch);
            this.applyBounds();
        }
    }

    public void centerOnScreen() {
        this.xExplicit = false;
        this.yExplicit = false;
        if (this.peer != null) {
            Rectangle2D bounds = this.getWindowScreen().getVisualBounds();
            double centerX = bounds.getMinX() + (bounds.getWidth() - this.getWidth()) * 0.5;
            double centerY = bounds.getMinY() + (bounds.getHeight() - this.getHeight()) * 0.3333333432674408;
            this.x.set(centerX);
            this.y.set(centerY);
            this.peerBoundsConfigurator.setLocation(centerX, centerY, 0.5f, 0.33333334f);
            this.applyBounds();
        }
    }

    private void updateOutputScales(double sx, double sy) {
        this.updateRenderScales(sx, sy);
        this.outputScaleX.set(sx);
        this.outputScaleY.set(sy);
    }

    void updateRenderScales(double sx, double sy) {
        boolean forceInt = this.forceIntegerRenderScale.get();
        if (!this.renderScaleX.isBound()) {
            this.renderScaleX.set(forceInt ? Math.ceil(sx) : sx);
        }
        if (!this.renderScaleY.isBound()) {
            this.renderScaleY.set(forceInt ? Math.ceil(sy) : sy);
        }
    }

    public final double getOutputScaleX() {
        return this.outputScaleX.get();
    }

    public final ReadOnlyDoubleProperty outputScaleXProperty() {
        return this.outputScaleX.getReadOnlyProperty();
    }

    public final double getOutputScaleY() {
        return this.outputScaleY.get();
    }

    public final ReadOnlyDoubleProperty outputScaleYProperty() {
        return this.outputScaleY.getReadOnlyProperty();
    }

    public final void setForceIntegerRenderScale(boolean forced) {
        this.forceIntegerRenderScale.set(forced);
    }

    public final boolean isForceIntegerRenderScale() {
        return this.forceIntegerRenderScale.get();
    }

    public final BooleanProperty forceIntegerRenderScaleProperty() {
        return this.forceIntegerRenderScale;
    }

    public final void setRenderScaleX(double scale) {
        this.renderScaleX.set(scale);
    }

    public final double getRenderScaleX() {
        return this.renderScaleX.get();
    }

    public final DoubleProperty renderScaleXProperty() {
        return this.renderScaleX;
    }

    public final void setRenderScaleY(double scale) {
        this.renderScaleY.set(scale);
    }

    public final double getRenderScaleY() {
        return this.renderScaleY.get();
    }

    public final DoubleProperty renderScaleYProperty() {
        return this.renderScaleY;
    }

    public final void setX(double value) {
        this.setXInternal(value);
    }

    public final double getX() {
        return this.x.get();
    }

    public final ReadOnlyDoubleProperty xProperty() {
        return this.x.getReadOnlyProperty();
    }

    void setXInternal(double value) {
        this.x.set(value);
        this.peerBoundsConfigurator.setX(value, 0.0f);
        this.xExplicit = true;
    }

    public final void setY(double value) {
        this.setYInternal(value);
    }

    public final double getY() {
        return this.y.get();
    }

    public final ReadOnlyDoubleProperty yProperty() {
        return this.y.getReadOnlyProperty();
    }

    void setYInternal(double value) {
        this.y.set(value);
        this.peerBoundsConfigurator.setY(value, 0.0f);
        this.yExplicit = true;
    }

    void notifyLocationChanged(double newX, double newY) {
        this.x.set(newX);
        this.y.set(newY);
    }

    public final void setWidth(double value) {
        this.width.set(value);
        this.peerBoundsConfigurator.setWindowWidth(value);
        this.widthExplicit = true;
    }

    public final double getWidth() {
        return this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.width.getReadOnlyProperty();
    }

    public final void setHeight(double value) {
        this.height.set(value);
        this.peerBoundsConfigurator.setWindowHeight(value);
        this.heightExplicit = true;
    }

    public final double getHeight() {
        return this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.height.getReadOnlyProperty();
    }

    void notifySizeChanged(double newWidth, double newHeight) {
        this.width.set(newWidth);
        this.height.set(newHeight);
    }

    final void setFocused(boolean value) {
        this.focused.set(value);
    }

    public final void requestFocus() {
        if (this.peer != null) {
            this.peer.requestFocus();
        }
    }

    public final boolean isFocused() {
        return this.focused.get();
    }

    public final ReadOnlyBooleanProperty focusedProperty() {
        return this.focused.getReadOnlyProperty();
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object value) {
        this.getProperties().put(USER_DATA_KEY, value);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    protected void setScene(Scene value) {
        this.scene.set(value);
    }

    public final Scene getScene() {
        return (Scene)this.scene.get();
    }

    public final ReadOnlyObjectProperty<Scene> sceneProperty() {
        return this.scene.getReadOnlyProperty();
    }

    public final void setOpacity(double value) {
        this.opacityProperty().set(value);
    }

    public final double getOpacity() {
        return this.opacity == null ? 1.0 : this.opacity.get();
    }

    public final DoubleProperty opacityProperty() {
        if (this.opacity == null) {
            this.opacity = new DoublePropertyBase(1.0){

                protected void invalidated() {
                    if (Window.this.peer != null) {
                        Window.this.peer.setOpacity((float)this.get());
                    }
                }

                public Object getBean() {
                    return Window.this;
                }

                public String getName() {
                    return "opacity";
                }
            };
        }
        return this.opacity;
    }

    public final void setOnCloseRequest(EventHandler<WindowEvent> value) {
        this.onCloseRequestProperty().set(value);
    }

    public final EventHandler<WindowEvent> getOnCloseRequest() {
        return this.onCloseRequest != null ? (EventHandler)this.onCloseRequest.get() : null;
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onCloseRequestProperty() {
        if (this.onCloseRequest == null) {
            this.onCloseRequest = new ObjectPropertyBase<EventHandler<WindowEvent>>(){

                protected void invalidated() {
                    Window.this.setEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, (EventHandler)this.get());
                }

                public Object getBean() {
                    return Window.this;
                }

                public String getName() {
                    return "onCloseRequest";
                }
            };
        }
        return this.onCloseRequest;
    }

    public final void setOnShowing(EventHandler<WindowEvent> value) {
        this.onShowingProperty().set(value);
    }

    public final EventHandler<WindowEvent> getOnShowing() {
        return this.onShowing == null ? null : (EventHandler)this.onShowing.get();
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onShowingProperty() {
        if (this.onShowing == null) {
            this.onShowing = new ObjectPropertyBase<EventHandler<WindowEvent>>(){

                protected void invalidated() {
                    Window.this.setEventHandler(WindowEvent.WINDOW_SHOWING, (EventHandler)this.get());
                }

                public Object getBean() {
                    return Window.this;
                }

                public String getName() {
                    return "onShowing";
                }
            };
        }
        return this.onShowing;
    }

    public final void setOnShown(EventHandler<WindowEvent> value) {
        this.onShownProperty().set(value);
    }

    public final EventHandler<WindowEvent> getOnShown() {
        return this.onShown == null ? null : (EventHandler)this.onShown.get();
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onShownProperty() {
        if (this.onShown == null) {
            this.onShown = new ObjectPropertyBase<EventHandler<WindowEvent>>(){

                protected void invalidated() {
                    Window.this.setEventHandler(WindowEvent.WINDOW_SHOWN, (EventHandler)this.get());
                }

                public Object getBean() {
                    return Window.this;
                }

                public String getName() {
                    return "onShown";
                }
            };
        }
        return this.onShown;
    }

    public final void setOnHiding(EventHandler<WindowEvent> value) {
        this.onHidingProperty().set(value);
    }

    public final EventHandler<WindowEvent> getOnHiding() {
        return this.onHiding == null ? null : (EventHandler)this.onHiding.get();
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onHidingProperty() {
        if (this.onHiding == null) {
            this.onHiding = new ObjectPropertyBase<EventHandler<WindowEvent>>(){

                protected void invalidated() {
                    Window.this.setEventHandler(WindowEvent.WINDOW_HIDING, (EventHandler)this.get());
                }

                public Object getBean() {
                    return Window.this;
                }

                public String getName() {
                    return "onHiding";
                }
            };
        }
        return this.onHiding;
    }

    public final void setOnHidden(EventHandler<WindowEvent> value) {
        this.onHiddenProperty().set(value);
    }

    public final EventHandler<WindowEvent> getOnHidden() {
        return this.onHidden == null ? null : (EventHandler)this.onHidden.get();
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onHiddenProperty() {
        if (this.onHidden == null) {
            this.onHidden = new ObjectPropertyBase<EventHandler<WindowEvent>>(){

                protected void invalidated() {
                    Window.this.setEventHandler(WindowEvent.WINDOW_HIDDEN, (EventHandler)this.get());
                }

                public Object getBean() {
                    return Window.this;
                }

                public String getName() {
                    return "onHidden";
                }
            };
        }
        return this.onHidden;
    }

    private void setShowing(boolean value) {
        Toolkit.getToolkit().checkFxUserThread();
        this.showing.set(value);
    }

    public final boolean isShowing() {
        return this.showing.get();
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    protected void show() {
        this.setShowing(true);
    }

    public void hide() {
        this.setShowing(false);
    }

    private void doVisibleChanging(boolean visible) {
        if (visible && this.getScene() != null) {
            NodeHelper.reapplyCSS(this.getScene().getRoot());
        }
    }

    private void doVisibleChanged(boolean visible) {
        assert (this.peer != null);
        if (!visible) {
            this.peerListener = null;
            this.peer = null;
        }
    }

    public final void setEventDispatcher(EventDispatcher value) {
        this.eventDispatcherProperty().set((Object)value);
    }

    public final EventDispatcher getEventDispatcher() {
        return (EventDispatcher)this.eventDispatcherProperty().get();
    }

    public final ObjectProperty<EventDispatcher> eventDispatcherProperty() {
        this.initializeInternalEventDispatcher();
        return this.eventDispatcher;
    }

    public final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventFilter(eventType, eventFilter);
    }

    public final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventFilter(eventType, eventFilter);
    }

    protected final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().setEventHandler(eventType, eventHandler);
    }

    WindowEventDispatcher getInternalEventDispatcher() {
        this.initializeInternalEventDispatcher();
        return this.internalEventDispatcher;
    }

    private void initializeInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = this.createInternalEventDispatcher();
            this.eventDispatcher = new SimpleObjectProperty((Object)this, "eventDispatcher", (Object)this.internalEventDispatcher);
        }
    }

    WindowEventDispatcher createInternalEventDispatcher() {
        return new WindowEventDispatcher(this);
    }

    public final void fireEvent(Event event) {
        Event.fireEvent((EventTarget)this, (Event)event);
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        EventDispatcher eventDispatcherValue;
        if (this.eventDispatcher != null && (eventDispatcherValue = (EventDispatcher)this.eventDispatcher.get()) != null) {
            tail = tail.prepend(eventDispatcherValue);
        }
        return tail;
    }

    void increaseFocusGrabCounter() {
        if (++this.focusGrabCounter == 1 && this.peer != null && this.isFocused()) {
            this.peer.grabFocus();
        }
    }

    void decreaseFocusGrabCounter() {
        if (--this.focusGrabCounter == 0 && this.peer != null) {
            this.peer.ungrabFocus();
        }
    }

    private void focusChanged(boolean newIsFocused) {
        if (this.focusGrabCounter > 0 && this.peer != null && newIsFocused) {
            this.peer.grabFocus();
        }
    }

    final void applyBounds() {
        this.peerBoundsConfigurator.apply();
    }

    Window getWindowOwner() {
        return null;
    }

    private Screen getWindowScreen() {
        Window window = this;
        do {
            if (Double.isNaN(window.getX()) || Double.isNaN(window.getY()) || Double.isNaN(window.getWidth()) || Double.isNaN(window.getHeight())) continue;
            return Utils.getScreenForRectangle(new Rectangle2D(window.getX(), window.getY(), window.getWidth(), window.getHeight()));
        } while ((window = window.getWindowOwner()) != null);
        return Screen.getPrimary();
    }

    private ReadOnlyObjectProperty<Screen> screenProperty() {
        return this.screen.getReadOnlyProperty();
    }

    private void notifyScreenChanged(Object from, Object to) {
        this.screen.set((Object)Screen.getScreenForNative(to));
    }

    static {
        WindowHelper.setWindowAccessor(new WindowHelper.WindowAccessor(){

            @Override
            public WindowHelper getHelper(Window window) {
                return window.windowHelper;
            }

            @Override
            public void setHelper(Window window, WindowHelper windowHelper) {
                window.windowHelper = windowHelper;
            }

            @Override
            public void doVisibleChanging(Window window, boolean visible) {
                window.doVisibleChanging(visible);
            }

            @Override
            public void doVisibleChanged(Window window, boolean visible) {
                window.doVisibleChanged(visible);
            }

            @Override
            public TKStage getPeer(Window window) {
                return window.getPeer();
            }

            @Override
            public void setPeer(Window window, TKStage peer) {
                window.setPeer(peer);
            }

            @Override
            public WindowPeerListener getPeerListener(Window window) {
                return window.getPeerListener();
            }

            @Override
            public void setPeerListener(Window window, WindowPeerListener peerListener) {
                window.setPeerListener(peerListener);
            }

            @Override
            public void setFocused(Window window, boolean value) {
                window.setFocused(value);
            }

            @Override
            public void notifyLocationChanged(Window window, double x, double y) {
                window.notifyLocationChanged(x, y);
            }

            @Override
            public void notifySizeChanged(Window window, double width, double height) {
                window.notifySizeChanged(width, height);
            }

            @Override
            public void notifyScaleChanged(Window window, double newOutputScaleX, double newOutputScaleY) {
                window.updateOutputScales(newOutputScaleX, newOutputScaleY);
            }

            @Override
            public void notifyScreenChanged(Window window, Object from, Object to) {
                window.notifyScreenChanged(from, to);
            }

            @Override
            public float getPlatformScaleX(Window window) {
                TKStage peer = window.getPeer();
                return peer == null ? 1.0f : peer.getPlatformScaleX();
            }

            @Override
            public float getPlatformScaleY(Window window) {
                TKStage peer = window.getPeer();
                return peer == null ? 1.0f : peer.getPlatformScaleY();
            }

            @Override
            public ReadOnlyObjectProperty<Screen> screenProperty(Window window) {
                return window.screenProperty();
            }

            @Override
            public AccessControlContext getAccessControlContext(Window window) {
                return window.acc;
            }
        });
        USER_DATA_KEY = new Object();
    }

    private final class TKBoundsConfigurator
    implements TKPulseListener {
        private double renderScaleX;
        private double renderScaleY;
        private double x;
        private double y;
        private float xGravity;
        private float yGravity;
        private double windowWidth;
        private double windowHeight;
        private double clientWidth;
        private double clientHeight;
        private boolean dirty;

        public TKBoundsConfigurator() {
            this.reset();
        }

        public void setRenderScaleX(double renderScaleX) {
            this.renderScaleX = renderScaleX;
            this.setDirty();
        }

        public void setRenderScaleY(double renderScaleY) {
            this.renderScaleY = renderScaleY;
            this.setDirty();
        }

        public void setX(double x, float xGravity) {
            this.x = x;
            this.xGravity = xGravity;
            this.setDirty();
        }

        public void setY(double y, float yGravity) {
            this.y = y;
            this.yGravity = yGravity;
            this.setDirty();
        }

        public void setWindowWidth(double windowWidth) {
            this.windowWidth = windowWidth;
            this.setDirty();
        }

        public void setWindowHeight(double windowHeight) {
            this.windowHeight = windowHeight;
            this.setDirty();
        }

        public void setClientWidth(double clientWidth) {
            this.clientWidth = clientWidth;
            this.setDirty();
        }

        public void setClientHeight(double clientHeight) {
            this.clientHeight = clientHeight;
            this.setDirty();
        }

        public void setLocation(double x, double y, float xGravity, float yGravity) {
            this.x = x;
            this.y = y;
            this.xGravity = xGravity;
            this.yGravity = yGravity;
            this.setDirty();
        }

        public void setSize(double windowWidth, double windowHeight, double clientWidth, double clientHeight) {
            this.windowWidth = windowWidth;
            this.windowHeight = windowHeight;
            this.clientWidth = clientWidth;
            this.clientHeight = clientHeight;
            this.setDirty();
        }

        public void apply() {
            if (this.dirty) {
                if (Window.this.peer == null) {
                    this.reset();
                    return;
                }
                boolean xSet = !Double.isNaN(this.x);
                float newX = xSet ? (float)this.x : 0.0f;
                boolean ySet = !Double.isNaN(this.y);
                float newY = ySet ? (float)this.y : 0.0f;
                float newWW = (float)this.windowWidth;
                float newWH = (float)this.windowHeight;
                float newCW = (float)this.clientWidth;
                float newCH = (float)this.clientHeight;
                float newXG = this.xGravity;
                float newYG = this.yGravity;
                float newRX = (float)this.renderScaleX;
                float newRY = (float)this.renderScaleY;
                this.reset();
                Window.this.peer.setBounds(newX, newY, xSet, ySet, newWW, newWH, newCW, newCH, newXG, newYG, newRX, newRY);
            }
        }

        @Override
        public void pulse() {
            this.apply();
        }

        private void reset() {
            this.renderScaleX = 0.0;
            this.renderScaleY = 0.0;
            this.x = Double.NaN;
            this.y = Double.NaN;
            this.xGravity = 0.0f;
            this.yGravity = 0.0f;
            this.windowWidth = -1.0;
            this.windowHeight = -1.0;
            this.clientWidth = -1.0;
            this.clientHeight = -1.0;
            this.dirty = false;
        }

        private void setDirty() {
            if (!this.dirty) {
                Toolkit.getToolkit().requestNextPulse();
                this.dirty = true;
            }
        }
    }

    private final class SceneModel
    extends ReadOnlyObjectWrapper<Scene> {
        private Scene oldScene;

        private SceneModel() {
        }

        protected void invalidated() {
            Scene newScene = (Scene)this.get();
            if (this.oldScene == newScene) {
                return;
            }
            if (Window.this.peer != null) {
                Toolkit.getToolkit().checkFxUserThread();
            }
            this.updatePeerScene(null);
            if (this.oldScene != null) {
                SceneHelper.setWindow(this.oldScene, null);
                StyleManager.getInstance().forget(this.oldScene);
            }
            if (newScene != null) {
                Window oldWindow = newScene.getWindow();
                if (oldWindow != null) {
                    oldWindow.setScene(null);
                }
                SceneHelper.setWindow(newScene, Window.this);
                this.updatePeerScene(SceneHelper.getPeer(newScene));
                if (Window.this.isShowing()) {
                    NodeHelper.reapplyCSS(newScene.getRoot());
                    if (!Window.this.widthExplicit || !Window.this.heightExplicit) {
                        SceneHelper.preferredSize(Window.this.getScene());
                        Window.this.adjustSize(true);
                    }
                }
            }
            this.oldScene = newScene;
        }

        public Object getBean() {
            return Window.this;
        }

        public String getName() {
            return "scene";
        }

        private void updatePeerScene(TKScene tkScene) {
            if (Window.this.peer != null) {
                Window.this.peer.setScene(tkScene);
            }
        }
    }
}

