/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.gtk.GtkCommonDialogs;
import com.sun.glass.ui.gtk.GtkCursor;
import com.sun.glass.ui.gtk.GtkPixels;
import com.sun.glass.ui.gtk.GtkRobot;
import com.sun.glass.ui.gtk.GtkTimer;
import com.sun.glass.ui.gtk.GtkView;
import com.sun.glass.ui.gtk.GtkWindow;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import com.sun.prism.impl.PrismSettings;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

final class GtkApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    private static final String SWT_INTERNAL_CLASS = "org.eclipse.swt.internal.gtk.OS";
    private static final int forcedGtkVersion;
    private static boolean gtk2WarningIssued;
    private static final String GTK2_ALREADY_LOADED_WARNING = "WARNING: Found GTK 2 library already loaded";
    private static final String GTK2_SPECIFIED_WARNING = "WARNING: A command line option has enabled the GTK 2 library";
    private static final String GTK2_FALLBACK_WARNING = "WARNING: Using GTK 2 library because GTK 3 cannot be loaded ";
    private static final String GTK2_DEPRECATION_WARNING = "WARNING: The JavaFX GTK 2 library is deprecated and will be removed in a future release";
    public static int screen;
    public static long display;
    public static long visualID;
    static float overrideUIScale;
    private final InvokeLaterDispatcher invokeLaterDispatcher;
    private static final int QUERY_ERROR = -2;
    private static final int QUERY_NO_DISPLAY = -1;
    private static final int QUERY_USE_CURRENT = 1;
    private static final int QUERY_LOAD_GTK2 = 2;
    private static final int QUERY_LOAD_GTK3 = 3;
    private Object eventLoopExitEnterPassValue;

    private static float getFloat(String propname, float defval, String description) {
        String str = System.getProperty(propname);
        if (str == null) {
            str = System.getenv(propname);
        }
        if (str == null) {
            return defval;
        }
        float val = (str = str.trim()).endsWith("%") ? (float)Integer.parseInt(str.substring(0, str.length() - 1)) / 100.0f : (str.endsWith("DPI") || str.endsWith("dpi") ? (float)Integer.parseInt(str.substring(0, str.length() - 3)) / 96.0f : Float.parseFloat(str));
        if (PrismSettings.verbose) {
            System.out.println(description + val);
        }
        return val;
    }

    GtkApplication() {
        float tmp;
        int gtkVersion;
        int n = gtkVersion = forcedGtkVersion == 0 ? AccessController.doPrivileged(() -> {
            String v = System.getProperty("jdk.gtk.version", "3");
            int ret = 0;
            if ("3".equals(v) || v.startsWith("3.")) {
                ret = 3;
            } else if ("2".equals(v) || v.startsWith("2.")) {
                ret = 2;
            }
            return ret;
        }) : forcedGtkVersion;
        if (gtkVersion == 2 && !gtk2WarningIssued) {
            System.err.println(GTK2_SPECIFIED_WARNING);
            System.err.println(GTK2_DEPRECATION_WARNING);
            gtk2WarningIssued = true;
        }
        boolean gtkVersionVerbose = AccessController.doPrivileged(() -> Boolean.getBoolean("jdk.gtk.verbose"));
        overrideUIScale = PrismSettings.allowHiDPIScaling ? (tmp = AccessController.doPrivileged(() -> Float.valueOf(GtkApplication.getFloat("glass.gtk.uiScale", -1.0f, "Forcing UI scaling factor: "))).floatValue()) : -1.0f;
        int libraryToLoad = GtkApplication._queryLibrary(gtkVersion, gtkVersionVerbose);
        Void dummy = AccessController.doPrivileged(() -> {
            if (libraryToLoad == -1) {
                throw new UnsupportedOperationException("Unable to open DISPLAY");
            }
            if (libraryToLoad == 1) {
                if (gtkVersionVerbose) {
                    System.out.println("Glass GTK library to load is already loaded");
                }
            } else if (libraryToLoad == 2) {
                if (gtkVersionVerbose) {
                    System.out.println("Glass GTK library to load is glassgtk2");
                }
                NativeLibLoader.loadLibrary("glassgtk2");
                if (!gtk2WarningIssued) {
                    System.err.println(GTK2_FALLBACK_WARNING);
                    System.err.println(GTK2_DEPRECATION_WARNING);
                    gtk2WarningIssued = true;
                }
            } else if (libraryToLoad == 3) {
                if (gtkVersionVerbose) {
                    System.out.println("Glass GTK library to load is glassgtk3");
                }
                NativeLibLoader.loadLibrary("glassgtk3");
            } else {
                throw new UnsupportedOperationException("Internal Error");
            }
            return null;
        });
        int version = GtkApplication._initGTK(gtkVersion, gtkVersionVerbose, overrideUIScale);
        if (version == -1) {
            throw new RuntimeException("Error loading GTK libraries");
        }
        boolean isEventThread = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        if (!isEventThread) {
            this.invokeLaterDispatcher = new InvokeLaterDispatcher(this);
            this.invokeLaterDispatcher.start();
        } else {
            this.invokeLaterDispatcher = null;
        }
    }

    private static native int _queryLibrary(int var0, boolean var1);

    private static native int _initGTK(int var0, boolean var1, float var2);

    private void initDisplay() {
        Map ds = GtkApplication.getDeviceDetails();
        if (ds != null) {
            Object value = ds.get("XDisplay");
            if (value != null) {
                display = (Long)value;
            }
            if ((value = ds.get("XVisualID")) != null) {
                visualID = (Long)value;
            }
            if ((value = ds.get("XScreenID")) != null) {
                screen = (Integer)value;
            }
        }
    }

    private void init() {
        this.initDisplay();
        long eventProc = 0L;
        Map map = GtkApplication.getDeviceDetails();
        if (map != null) {
            Long result = (Long)map.get("javafx.embed.eventProc");
            eventProc = result == null ? 0L : result;
        }
        boolean disableGrab = AccessController.doPrivileged(() -> Boolean.getBoolean("sun.awt.disablegrab") || Boolean.getBoolean("glass.disableGrab"));
        this._init(eventProc, disableGrab);
    }

    @Override
    protected void runLoop(Runnable launchable) {
        boolean isEventThread = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        if (isEventThread) {
            this.init();
            GtkApplication.setEventThread(Thread.currentThread());
            launchable.run();
            return;
        }
        boolean noErrorTrap = AccessController.doPrivileged(() -> Boolean.getBoolean("glass.noErrorTrap"));
        Thread toolkitThread = AccessController.doPrivileged(() -> new Thread(() -> {
            this.init();
            this._runLoop(launchable, noErrorTrap);
        }, "GtkNativeMainLoopThread"));
        GtkApplication.setEventThread(toolkitThread);
        toolkitThread.start();
    }

    @Override
    protected void finishTerminating() {
        Thread toolkitThread = GtkApplication.getEventThread();
        if (toolkitThread != null) {
            this._terminateLoop();
            GtkApplication.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    public boolean shouldUpdateWindow() {
        return true;
    }

    private native void _terminateLoop();

    private native void _init(long var1, boolean var3);

    private native void _runLoop(Runnable var1, boolean var2);

    @Override
    protected void _invokeAndWait(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeAndWait(runnable);
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            this.submitForLaterInvocation(() -> {
                if (runnable != null) {
                    runnable.run();
                }
                latch.countDown();
            });
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private native void _submitForLaterInvocation(Runnable var1);

    @Override
    public void submitForLaterInvocation(Runnable r) {
        this._submitForLaterInvocation(r);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeLater(runnable);
        } else {
            this.submitForLaterInvocation(runnable);
        }
    }

    private native void enterNestedEventLoopImpl();

    private native void leaveNestedEventLoopImpl();

    @Override
    protected Object _enterNestedEventLoop() {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        }
        try {
            this.enterNestedEventLoopImpl();
            Object retValue = this.eventLoopExitEnterPassValue;
            this.eventLoopExitEnterPassValue = null;
            Object object = retValue;
            return object;
        }
        finally {
            if (this.invokeLaterDispatcher != null) {
                this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
            }
        }
    }

    @Override
    protected void _leaveNestedEventLoop(Object retValue) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        }
        this.eventLoopExitEnterPassValue = retValue;
        this.leaveNestedEventLoopImpl();
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new GtkWindow(owner, screen, styleMask);
    }

    @Override
    public View createView() {
        return new GtkView();
    }

    @Override
    public Cursor createCursor(int type) {
        return new GtkCursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new GtkCursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        return GtkCursor._getBestSize(width, height);
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new GtkPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new GtkPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data, float scalex, float scaley) {
        return new GtkPixels(width, height, data, scalex, scaley);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return 1;
    }

    @Override
    public GlassRobot createRobot() {
        return new GtkRobot();
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new GtkTimer(runnable);
    }

    @Override
    protected native int staticTimer_getMinPeriod();

    @Override
    protected native int staticTimer_getMaxPeriod();

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected native Screen[] staticScreen_getScreens();

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window owner, String folder, String filename, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters, int defaultFilterIndex) {
        return GtkCommonDialogs.showFileChooser(owner, folder, filename, title, type, multipleMode, extensionFilters, defaultFilterIndex);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window owner, String folder, String title) {
        return GtkCommonDialogs.showFolderChooser(owner, folder, title);
    }

    @Override
    protected native long staticView_getMultiClickTime();

    @Override
    protected native int staticView_getMultiClickMaxX();

    @Override
    protected native int staticView_getMultiClickMaxY();

    @Override
    protected boolean _supportsInputMethods() {
        return true;
    }

    @Override
    protected native boolean _supportsTransparentWindows();

    @Override
    protected boolean _supportsUnifiedWindows() {
        return false;
    }

    @Override
    protected native int _getKeyCodeForChar(char var1);

    @Override
    protected native int _isKeyLocked(int var1);

    static {
        gtk2WarningIssued = false;
        Class OS2 = AccessController.doPrivileged(() -> {
            try {
                return Class.forName(SWT_INTERNAL_CLASS, true, ClassLoader.getSystemClassLoader());
            }
            catch (Exception exception) {
                try {
                    return Class.forName(SWT_INTERNAL_CLASS, true, Thread.currentThread().getContextClassLoader());
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        });
        if (OS2 != null) {
            PlatformLogger logger = Logging.getJavaFXLogger();
            logger.fine("SWT-GTK library found. Try to obtain GTK version.");
            Method method = AccessController.doPrivileged(() -> {
                try {
                    return OS2.getMethod("gtk_major_version", new Class[0]);
                }
                catch (Exception e) {
                    return null;
                }
            });
            int ver = 0;
            if (method != null) {
                try {
                    ver = ((Number)method.invoke((Object)OS2, new Object[0])).intValue();
                }
                catch (Exception e) {
                    logger.warning("Method gtk_major_version() of the org.eclipse.swt.internal.gtk.OS class returns error. SWT GTK version cannot be detected. GTK3 will be used as default.");
                    ver = 3;
                }
            }
            if (ver < 2 || ver > 3) {
                logger.warning("SWT-GTK uses unsupported major GTK version " + ver + ". GTK3 will be used as default.");
                ver = 3;
            }
            forcedGtkVersion = ver;
            if (ver == 2 && !gtk2WarningIssued) {
                System.err.println(GTK2_ALREADY_LOADED_WARNING);
                System.err.println(GTK2_DEPRECATION_WARNING);
                gtk2WarningIssued = true;
            }
        } else {
            forcedGtkVersion = 0;
        }
        Void void_ = AccessController.doPrivileged(() -> {
            Application.loadNativeLibrary();
            return null;
        });
        screen = -1;
        display = 0L;
        visualID = 0L;
    }
}

