/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;

public abstract class TransformedShape
extends Shape {
    protected final Shape delegate;
    private Shape cachedTransformedShape;

    public static TransformedShape transformedShape(Shape original, BaseTransform tx) {
        if (tx.isTranslateOrIdentity()) {
            return TransformedShape.translatedShape(original, tx.getMxt(), tx.getMyt());
        }
        return new General(original, tx.copy());
    }

    public static TransformedShape translatedShape(Shape original, double tx, double ty) {
        return new Translate(original, (float)tx, (float)ty);
    }

    protected TransformedShape(Shape delegate) {
        this.delegate = delegate;
    }

    public Shape getDelegateNoClone() {
        return this.delegate;
    }

    public abstract BaseTransform getTransformNoClone();

    public abstract BaseTransform adjust(BaseTransform var1);

    protected Point2D untransform(float x, float y) {
        Point2D p = new Point2D(x, y);
        try {
            p = this.getTransformNoClone().inverseTransform(p, p);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return p;
    }

    protected BaseBounds untransformedBounds(float x, float y, float w, float h) {
        RectBounds b = new RectBounds(x, y, x + w, y + h);
        try {
            return this.getTransformNoClone().inverseTransform(b, b);
        }
        catch (NoninvertibleTransformException e) {
            return b.makeEmpty();
        }
    }

    @Override
    public RectBounds getBounds() {
        float[] box = new float[4];
        Shape.accumulate(box, this.delegate, this.getTransformNoClone());
        return new RectBounds(box[0], box[1], box[2], box[3]);
    }

    @Override
    public boolean contains(float x, float y) {
        return this.delegate.contains(this.untransform(x, y));
    }

    private Shape getCachedTransformedShape() {
        if (this.cachedTransformedShape == null) {
            this.cachedTransformedShape = this.copy();
        }
        return this.cachedTransformedShape;
    }

    @Override
    public boolean intersects(float x, float y, float w, float h) {
        return this.getCachedTransformedShape().intersects(x, y, w, h);
    }

    @Override
    public boolean contains(float x, float y, float w, float h) {
        return this.getCachedTransformedShape().contains(x, y, w, h);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform transform) {
        return this.delegate.getPathIterator(this.adjust(transform));
    }

    @Override
    public PathIterator getPathIterator(BaseTransform transform, float flatness) {
        return this.delegate.getPathIterator(this.adjust(transform), flatness);
    }

    @Override
    public Shape copy() {
        return this.getTransformNoClone().createTransformedShape(this.delegate);
    }

    static final class General
    extends TransformedShape {
        BaseTransform transform;

        General(Shape delegate, BaseTransform transform) {
            super(delegate);
            this.transform = transform;
        }

        @Override
        public BaseTransform getTransformNoClone() {
            return this.transform;
        }

        @Override
        public BaseTransform adjust(BaseTransform transform) {
            if (transform == null || transform.isIdentity()) {
                return this.transform.copy();
            }
            return transform.copy().deriveWithConcatenation(this.transform);
        }
    }

    static final class Translate
    extends TransformedShape {
        private final float tx;
        private final float ty;
        private BaseTransform cachedTx;

        public Translate(Shape delegate, float tx, float ty) {
            super(delegate);
            this.tx = tx;
            this.ty = ty;
        }

        @Override
        public BaseTransform getTransformNoClone() {
            if (this.cachedTx == null) {
                this.cachedTx = BaseTransform.getTranslateInstance(this.tx, this.ty);
            }
            return this.cachedTx;
        }

        @Override
        public BaseTransform adjust(BaseTransform transform) {
            if (transform == null || transform.isIdentity()) {
                return BaseTransform.getTranslateInstance(this.tx, this.ty);
            }
            return transform.copy().deriveWithTranslation(this.tx, this.ty);
        }

        @Override
        public RectBounds getBounds() {
            RectBounds rb = this.delegate.getBounds();
            rb.setBounds(rb.getMinX() + this.tx, rb.getMinY() + this.ty, rb.getMaxX() + this.tx, rb.getMaxY() + this.ty);
            return rb;
        }

        @Override
        public boolean contains(float x, float y) {
            return this.delegate.contains(x - this.tx, y - this.ty);
        }

        @Override
        public boolean intersects(float x, float y, float w, float h) {
            return this.delegate.intersects(x - this.tx, y - this.ty, w, h);
        }

        @Override
        public boolean contains(float x, float y, float w, float h) {
            return this.delegate.contains(x - this.tx, y - this.ty, w, h);
        }
    }
}

