/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageLoaderFactory;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.iio.bmp.BMPImageLoaderFactory;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.gif.GIFImageLoaderFactory;
import com.sun.javafx.iio.ios.IosImageLoaderFactory;
import com.sun.javafx.iio.jpeg.JPEGImageLoaderFactory;
import com.sun.javafx.iio.png.PNGImageLoaderFactory;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.DataURI;
import com.sun.javafx.util.Logging;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ImageStorage {
    private final HashMap<ImageFormatDescription.Signature, ImageLoaderFactory> loaderFactoriesBySignature;
    private final HashMap<String, ImageLoaderFactory> loaderFactoriesByMimeSubtype;
    private final ImageLoaderFactory[] loaderFactories = isIOS ? new ImageLoaderFactory[]{IosImageLoaderFactory.getInstance()} : new ImageLoaderFactory[]{GIFImageLoaderFactory.getInstance(), JPEGImageLoaderFactory.getInstance(), PNGImageLoaderFactory.getInstance(), BMPImageLoaderFactory.getInstance()};
    private int maxSignatureLength;
    private static final boolean isIOS = PlatformUtil.isIOS();

    public static ImageStorage getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public ImageStorage() {
        this.loaderFactoriesBySignature = new HashMap(this.loaderFactories.length);
        this.loaderFactoriesByMimeSubtype = new HashMap(this.loaderFactories.length);
        for (int i = 0; i < this.loaderFactories.length; ++i) {
            this.addImageLoaderFactory(this.loaderFactories[i]);
        }
    }

    public ImageFormatDescription[] getSupportedDescriptions() {
        ImageFormatDescription[] formats = new ImageFormatDescription[this.loaderFactories.length];
        for (int i = 0; i < this.loaderFactories.length; ++i) {
            formats[i] = this.loaderFactories[i].getFormatDescription();
        }
        return formats;
    }

    public int getNumBands(ImageType type) {
        int numBands = -1;
        switch (type) {
            case GRAY: 
            case PALETTE: 
            case PALETTE_ALPHA: 
            case PALETTE_ALPHA_PRE: 
            case PALETTE_TRANS: {
                numBands = 1;
                break;
            }
            case GRAY_ALPHA: 
            case GRAY_ALPHA_PRE: {
                numBands = 2;
                break;
            }
            case RGB: {
                numBands = 3;
                break;
            }
            case RGBA: 
            case RGBA_PRE: {
                numBands = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ImageType " + type);
            }
        }
        return numBands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageLoaderFactory(ImageLoaderFactory factory) {
        ImageFormatDescription desc = factory.getFormatDescription();
        for (ImageFormatDescription.Signature signature : desc.getSignatures()) {
            this.loaderFactoriesBySignature.put(signature, factory);
        }
        for (String subtype : desc.getMIMESubtypes()) {
            this.loaderFactoriesByMimeSubtype.put(subtype.toLowerCase(), factory);
        }
        Class<ImageStorage> clazz = ImageStorage.class;
        synchronized (ImageStorage.class) {
            this.maxSignatureLength = -1;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public ImageFrame[] loadAll(InputStream input, ImageLoadListener listener, double width, double height, boolean preserveAspectRatio, float pixelScale, boolean smooth) throws ImageStorageException {
        ImageFrame[] images;
        block8: {
            ImageLoader loader = null;
            images = null;
            try {
                loader = isIOS ? IosImageLoaderFactory.getInstance().createImageLoader(input) : this.getLoaderBySignature(input, listener);
                if (loader != null) {
                    images = this.loadAll(loader, width, height, preserveAspectRatio, pixelScale, smooth);
                    break block8;
                }
                throw new ImageStorageException("No loader for image data");
            }
            catch (ImageStorageException ise) {
                throw ise;
            }
            catch (IOException e) {
                throw new ImageStorageException(e.getMessage(), e);
            }
            finally {
                if (loader != null) {
                    loader.dispose();
                }
            }
        }
        return images;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageFrame[] loadAll(String input, ImageLoadListener listener, double width, double height, boolean preserveAspectRatio, float devPixelScale, boolean smooth) throws ImageStorageException {
        ImageFrame[] images;
        block24: {
            if (input == null || input.isEmpty()) {
                throw new ImageStorageException("URL can't be null or empty");
            }
            images = null;
            InputStream theStream = null;
            ImageLoader loader = null;
            try {
                float imgPixelScale;
                block23: {
                    imgPixelScale = 1.0f;
                    try {
                        DataURI dataUri = DataURI.tryParse(input);
                        if (dataUri != null) {
                            if (!"image".equalsIgnoreCase(dataUri.getMimeType())) {
                                throw new IllegalArgumentException("Unexpected MIME type: " + dataUri.getMimeType());
                            }
                            ImageLoaderFactory factory = this.loaderFactoriesByMimeSubtype.get(dataUri.getMimeSubtype().toLowerCase());
                            if (factory == null) {
                                throw new IllegalArgumentException("Unsupported MIME subtype: image/" + dataUri.getMimeSubtype());
                            }
                            theStream = new ByteArrayInputStream(dataUri.getData());
                            ImageLoader loaderBySignature = this.getLoaderBySignature(theStream, listener);
                            if (loaderBySignature != null) {
                                PlatformLogger logger;
                                boolean imageTypeMismatch;
                                boolean bl = imageTypeMismatch = !factory.getFormatDescription().getFormatName().equals(loaderBySignature.getFormatDescription().getFormatName());
                                if (imageTypeMismatch && (logger = Logging.getJavaFXLogger()).isLoggable(PlatformLogger.Level.WARNING)) {
                                    logger.warning(String.format("Image format '%s' does not match MIME type '%s/%s' in URI '%s'", loaderBySignature.getFormatDescription().getFormatName(), dataUri.getMimeType(), dataUri.getMimeSubtype(), dataUri));
                                }
                                loader = loaderBySignature;
                            } else {
                                theStream.close();
                                theStream = new ByteArrayInputStream(dataUri.getData());
                                loader = factory.createImageLoader(theStream);
                            }
                            break block23;
                        }
                        if (devPixelScale >= 1.5f) {
                            try {
                                String name2x = ImageTools.getScaledImageName(input);
                                theStream = ImageTools.createInputStream(name2x);
                                imgPixelScale = 2.0f;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (theStream == null) {
                            theStream = ImageTools.createInputStream(input);
                        }
                        loader = isIOS ? IosImageLoaderFactory.getInstance().createImageLoader(theStream) : this.getLoaderBySignature(theStream, listener);
                    }
                    catch (Exception e) {
                        throw new ImageStorageException(e.getMessage(), e);
                    }
                }
                if (loader != null) {
                    images = this.loadAll(loader, width, height, preserveAspectRatio, imgPixelScale, smooth);
                    break block24;
                }
                throw new ImageStorageException("No loader for image data");
            }
            finally {
                if (loader != null) {
                    loader.dispose();
                }
                try {
                    if (theStream != null) {
                        theStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return images;
    }

    private synchronized int getMaxSignatureLength() {
        if (this.maxSignatureLength < 0) {
            this.maxSignatureLength = 0;
            for (ImageFormatDescription.Signature signature : this.loaderFactoriesBySignature.keySet()) {
                int signatureLength = signature.getLength();
                if (this.maxSignatureLength >= signatureLength) continue;
                this.maxSignatureLength = signatureLength;
            }
        }
        return this.maxSignatureLength;
    }

    private ImageFrame[] loadAll(ImageLoader loader, double width, double height, boolean preserveAspectRatio, float pixelScale, boolean smooth) throws ImageStorageException {
        ImageFrame[] images = null;
        ArrayList<ImageFrame> list = new ArrayList<ImageFrame>();
        int imageIndex = 0;
        ImageFrame image = null;
        int imgw = (int)Math.round(width * (double)pixelScale);
        int imgh = (int)Math.round(height * (double)pixelScale);
        while (true) {
            try {
                image = loader.load(imageIndex++, imgw, imgh, preserveAspectRatio, smooth);
            }
            catch (Exception e) {
                if (imageIndex > 1) break;
                throw new ImageStorageException(e.getMessage(), e);
            }
            if (image == null) break;
            image.setPixelScale(pixelScale);
            list.add(image);
        }
        int numImages = list.size();
        if (numImages > 0) {
            images = new ImageFrame[numImages];
            list.toArray(images);
        }
        return images;
    }

    private ImageLoader getLoaderBySignature(InputStream stream, ImageLoadListener listener) throws IOException {
        byte[] header = new byte[this.getMaxSignatureLength()];
        try {
            ImageTools.readFully(stream, header);
        }
        catch (EOFException ignored) {
            return null;
        }
        for (Map.Entry<ImageFormatDescription.Signature, ImageLoaderFactory> factoryRegistration : this.loaderFactoriesBySignature.entrySet()) {
            if (!factoryRegistration.getKey().matches(header)) continue;
            ByteArrayInputStream headerStream = new ByteArrayInputStream(header);
            SequenceInputStream seqStream = new SequenceInputStream(headerStream, stream);
            ImageLoader loader = factoryRegistration.getValue().createImageLoader(seqStream);
            if (listener != null) {
                loader.addListener(listener);
            }
            return loader;
        }
        return null;
    }

    private static class InstanceHolder {
        static final ImageStorage INSTANCE = new ImageStorage();

        private InstanceHolder() {
        }
    }

    public static enum ImageType {
        GRAY,
        GRAY_ALPHA,
        GRAY_ALPHA_PRE,
        PALETTE,
        PALETTE_ALPHA,
        PALETTE_ALPHA_PRE,
        PALETTE_TRANS,
        RGB,
        RGBA,
        RGBA_PRE;

    }
}

