/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.gif;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.gif.GIFDescriptor;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class GIFImageLoader2
extends ImageLoaderImpl {
    static final byte[] FILE_SIG87 = new byte[]{71, 73, 70, 56, 55, 97};
    static final byte[] FILE_SIG89 = new byte[]{71, 73, 70, 56, 57, 97};
    static final byte[] NETSCAPE_SIG = new byte[]{78, 69, 84, 83, 67, 65, 80, 69, 50, 46, 48};
    static final int DEFAULT_FPS = 25;
    InputStream stream = null;
    int screenW;
    int screenH;
    int bgColor;
    byte[][] globalPalette;
    byte[] image;
    int loopCount = 1;

    public GIFImageLoader2(InputStream input) throws IOException {
        super(GIFDescriptor.getInstance());
        this.stream = input;
        this.readGlobalHeader();
    }

    private void readGlobalHeader() throws IOException {
        byte[] signature = this.readBytes(new byte[6]);
        if (!Arrays.equals(FILE_SIG87, signature) && !Arrays.equals(FILE_SIG89, signature)) {
            throw new IOException("Bad GIF signature!");
        }
        this.screenW = this.readShort();
        this.screenH = this.readShort();
        int cInfo = this.readByte();
        this.bgColor = this.readByte();
        int aspectR = this.readByte();
        if ((cInfo & 0x80) != 0) {
            this.globalPalette = this.readPalete(2 << (cInfo & 7), -1);
        }
        this.image = new byte[this.screenW * this.screenH * 4];
    }

    private byte[][] readPalete(int size, int trnsIndex) throws IOException {
        byte[][] palette = new byte[4][size];
        byte[] paletteData = this.readBytes(new byte[size * 3]);
        int idx = 0;
        for (int i = 0; i != size; ++i) {
            for (int k = 0; k != 3; ++k) {
                palette[k][i] = paletteData[idx++];
            }
            palette[3][i] = i == trnsIndex ? 0 : -1;
        }
        return palette;
    }

    private void consumeAnExtension() throws IOException {
        int blSize = this.readByte();
        while (blSize != 0) {
            this.skipBytes(blSize);
            blSize = this.readByte();
        }
    }

    private void readAppExtension() throws IOException {
        int size = this.readByte();
        byte[] buf = this.readBytes(new byte[size]);
        if (Arrays.equals(NETSCAPE_SIG, buf)) {
            int subBlockSize = this.readByte();
            while (subBlockSize != 0) {
                byte[] subBlock = this.readBytes(new byte[subBlockSize]);
                byte subBlockId = subBlock[0];
                if (subBlockSize == 3 && subBlockId == 1) {
                    this.loopCount = subBlock[1] & 0xFF | (subBlock[2] & 0xFF) << 8;
                }
                subBlockSize = this.readByte();
            }
        } else {
            this.consumeAnExtension();
        }
    }

    private int readControlCode() throws IOException {
        int size = this.readByte();
        int pField = this.readByte();
        int frameDelay = this.readShort();
        int trnsIndex = this.readByte();
        if (size != 4 || this.readByte() != 0) {
            throw new IOException("Bad GIF GraphicControlExtension");
        }
        return ((pField & 0x1F) << 24) + (trnsIndex << 16) + frameDelay;
    }

    private int waitForImageFrame() throws IOException {
        int ch;
        int controlData = 0;
        block9: while (true) {
            ch = this.stream.read();
            switch (ch) {
                case 44: {
                    return controlData;
                }
                case 33: {
                    switch (this.readByte()) {
                        case 249: {
                            controlData = this.readControlCode();
                            continue block9;
                        }
                        case 255: {
                            this.readAppExtension();
                            continue block9;
                        }
                    }
                    this.consumeAnExtension();
                    continue block9;
                }
                case -1: 
                case 59: {
                    return -1;
                }
            }
            break;
        }
        throw new IOException("Unexpected GIF control characher 0x" + String.format("%02X", ch));
    }

    private void decodeImage(byte[] image, int w, int h, int[] interlace) throws IOException {
        LZWDecoder dec = new LZWDecoder();
        byte[] data = dec.getString();
        int y = 0;
        int iPos = 0;
        int xr = w;
        block0: while (true) {
            int len;
            if ((len = dec.readString()) == -1) {
                dec.waitForTerminator();
                return;
            }
            int pos = 0;
            while (true) {
                if (pos == len) continue block0;
                int ax = xr < len - pos ? xr : len - pos;
                System.arraycopy(data, pos, image, iPos, ax);
                iPos += ax;
                pos += ax;
                if ((xr -= ax) != 0) continue;
                if (++y == h) {
                    dec.waitForTerminator();
                    return;
                }
                int iY = interlace == null ? y : interlace[y];
                iPos = iY * w;
                xr = w;
            }
            break;
        }
    }

    private int[] computeInterlaceReIndex(int h) {
        int i;
        int[] data = new int[h];
        int pos = 0;
        for (i = 0; i < h; i += 8) {
            data[pos++] = i;
        }
        for (i = 4; i < h; i += 8) {
            data[pos++] = i;
        }
        for (i = 2; i < h; i += 4) {
            data[pos++] = i;
        }
        for (i = 1; i < h; i += 2) {
            data[pos++] = i;
        }
        return data;
    }

    @Override
    public ImageFrame load(int imageIndex, int width, int height, boolean preserveAspectRatio, boolean smooth) throws IOException {
        int imageControlCode = this.waitForImageFrame();
        if (imageControlCode < 0) {
            return null;
        }
        int left = this.readShort();
        int top = this.readShort();
        int w = this.readShort();
        int h = this.readShort();
        if (left + w > this.screenW || top + h > this.screenH) {
            throw new IOException("Wrong GIF image frame size");
        }
        int imgCtrl = this.readByte();
        boolean isTRNS = (imageControlCode >>> 24 & 1) == 1;
        int trnsIndex = isTRNS ? imageControlCode >>> 16 & 0xFF : -1;
        boolean localPalette = (imgCtrl & 0x80) != 0;
        boolean isInterlaced = (imgCtrl & 0x40) != 0;
        byte[][] palette = localPalette ? this.readPalete(2 << (imgCtrl & 7), trnsIndex) : this.globalPalette;
        int[] outWH = ImageTools.computeDimensions(this.screenW, this.screenH, width, height, preserveAspectRatio);
        width = outWH[0];
        height = outWH[1];
        ImageMetadata metadata = this.updateMetadata(width, height, imageControlCode & 0xFFFF);
        int disposalCode = imageControlCode >>> 26 & 7;
        byte[] pImage = new byte[w * h];
        this.decodeImage(pImage, w, h, isInterlaced ? this.computeInterlaceReIndex(h) : null);
        ByteBuffer img = this.decodePalette(pImage, palette, trnsIndex, left, top, w, h, disposalCode);
        if (this.screenW != width || this.screenH != height) {
            img = ImageTools.scaleImage(img, this.screenW, this.screenH, 4, width, height, smooth);
        }
        return new ImageFrame(ImageStorage.ImageType.RGBA, img, width, height, width * 4, null, metadata);
    }

    private int readByte() throws IOException {
        int ch = this.stream.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    private int readShort() throws IOException {
        int lsb = this.readByte();
        int msb = this.readByte();
        return lsb + (msb << 8);
    }

    private byte[] readBytes(byte[] data) throws IOException {
        return this.readBytes(data, 0, data.length);
    }

    private byte[] readBytes(byte[] data, int offs, int size) throws IOException {
        while (size > 0) {
            int sz = this.stream.read(data, offs, size);
            if (sz < 0) {
                throw new EOFException();
            }
            offs += sz;
            size -= sz;
        }
        return data;
    }

    private void skipBytes(int n) throws IOException {
        ImageTools.skipFully(this.stream, n);
    }

    @Override
    public void dispose() {
    }

    private void restoreToBackground(byte[] img, int left, int top, int w, int h) {
        for (int y = 0; y != h; ++y) {
            int iPos = ((top + y) * this.screenW + left) * 4;
            for (int x = 0; x != w; ++x) {
                img[iPos + 3] = 0;
                iPos += 4;
            }
        }
    }

    private ByteBuffer decodePalette(byte[] srcImage, byte[][] palette, int trnsIndex, int left, int top, int w, int h, int disposalCode) {
        byte[] img = disposalCode == 3 ? (byte[])this.image.clone() : this.image;
        for (int y = 0; y != h; ++y) {
            int index;
            int x;
            int iPos = ((top + y) * this.screenW + left) * 4;
            int i = y * w;
            if (trnsIndex < 0) {
                for (x = 0; x != w; ++x) {
                    index = 0xFF & srcImage[i + x];
                    img[iPos + 0] = palette[0][index];
                    img[iPos + 1] = palette[1][index];
                    img[iPos + 2] = palette[2][index];
                    img[iPos + 3] = palette[3][index];
                    iPos += 4;
                }
                continue;
            }
            for (x = 0; x != w; ++x) {
                index = 0xFF & srcImage[i + x];
                if (index != trnsIndex) {
                    img[iPos + 0] = palette[0][index];
                    img[iPos + 1] = palette[1][index];
                    img[iPos + 2] = palette[2][index];
                    img[iPos + 3] = palette[3][index];
                }
                iPos += 4;
            }
        }
        if (disposalCode != 3) {
            img = (byte[])img.clone();
        }
        if (disposalCode == 2) {
            this.restoreToBackground(this.image, left, top, w, h);
        }
        return ByteBuffer.wrap(img);
    }

    private ImageMetadata updateMetadata(int w, int h, int delayTime) {
        ImageMetadata metaData = new ImageMetadata(null, true, null, null, null, delayTime != 0 ? delayTime * 10 : 40, this.loopCount, w, h, null, null, null);
        this.updateImageMetadata(metaData);
        return metaData;
    }

    class LZWDecoder {
        private final int initCodeSize;
        private final int clearCode;
        private final int eofCode;
        private int codeSize;
        private int codeMask;
        private int tableIndex;
        private int oldCode;
        private int blockLength = 0;
        private int blockPos = 0;
        private byte[] block = new byte[255];
        private int inData = 0;
        private int inBits = 0;
        private int[] prefix = new int[4096];
        private byte[] suffix = new byte[4096];
        private byte[] initial = new byte[4096];
        private int[] length = new int[4096];
        private byte[] string = new byte[4096];

        public LZWDecoder() throws IOException {
            this.initCodeSize = GIFImageLoader2.this.readByte();
            this.clearCode = 1 << this.initCodeSize;
            this.eofCode = this.clearCode + 1;
            this.initTable();
        }

        public final int readString() throws IOException {
            int code = this.getCode();
            if (code == this.eofCode) {
                return -1;
            }
            if (code == this.clearCode) {
                this.initTable();
                code = this.getCode();
                if (code == this.eofCode) {
                    return -1;
                }
            } else {
                int newSuffixIndex;
                if (code < this.tableIndex) {
                    newSuffixIndex = code;
                } else {
                    newSuffixIndex = this.oldCode;
                    if (code != this.tableIndex) {
                        throw new IOException("Bad GIF LZW: Out-of-sequence code!");
                    }
                }
                if (this.tableIndex < 4096) {
                    int oc;
                    int ti = this.tableIndex++;
                    this.prefix[ti] = oc = this.oldCode;
                    this.suffix[ti] = this.initial[newSuffixIndex];
                    this.initial[ti] = this.initial[oc];
                    this.length[ti] = this.length[oc] + 1;
                    if (this.tableIndex == 1 << this.codeSize && this.tableIndex < 4096) {
                        ++this.codeSize;
                        this.codeMask = (1 << this.codeSize) - 1;
                    }
                }
            }
            int c = code;
            int len = this.length[c];
            for (int i = len - 1; i >= 0; --i) {
                this.string[i] = this.suffix[c];
                c = this.prefix[c];
            }
            this.oldCode = code;
            return len;
        }

        public final byte[] getString() {
            return this.string;
        }

        public final void waitForTerminator() throws IOException {
            GIFImageLoader2.this.consumeAnExtension();
        }

        private void initTable() {
            int i;
            int numEntries = 1 << this.initCodeSize;
            for (i = 0; i < numEntries; ++i) {
                this.prefix[i] = -1;
                this.suffix[i] = (byte)i;
                this.initial[i] = (byte)i;
                this.length[i] = 1;
            }
            for (i = numEntries; i < 4096; ++i) {
                this.prefix[i] = -1;
                this.length[i] = 1;
            }
            this.codeSize = this.initCodeSize + 1;
            this.codeMask = (1 << this.codeSize) - 1;
            this.tableIndex = numEntries + 2;
            this.oldCode = 0;
        }

        private int getCode() throws IOException {
            while (this.inBits < this.codeSize) {
                this.inData |= this.nextByte() << this.inBits;
                this.inBits += 8;
            }
            int code = this.inData & this.codeMask;
            this.inBits -= this.codeSize;
            this.inData >>>= this.codeSize;
            return code;
        }

        private int nextByte() throws IOException {
            if (this.blockPos == this.blockLength) {
                this.readData();
            }
            return this.block[this.blockPos++] & 0xFF;
        }

        private void readData() throws IOException {
            this.blockPos = 0;
            this.blockLength = GIFImageLoader2.this.readByte();
            if (this.blockLength <= 0) {
                throw new EOFException();
            }
            GIFImageLoader2.this.readBytes(this.block, 0, this.blockLength);
        }
    }
}

