/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.BytePixelAccessor;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import java.nio.ByteBuffer;

abstract class BaseByteToByteConverter
implements ByteToBytePixelConverter {
    protected final BytePixelGetter getter;
    protected final BytePixelSetter setter;
    protected final int nSrcElems;
    protected final int nDstElems;

    BaseByteToByteConverter(BytePixelGetter getter, BytePixelSetter setter) {
        this.getter = getter;
        this.setter = setter;
        this.nSrcElems = getter.getNumElements();
        this.nDstElems = setter.getNumElements();
    }

    public final BytePixelGetter getGetter() {
        return this.getter;
    }

    public final BytePixelSetter getSetter() {
        return this.setter;
    }

    abstract void doConvert(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6, int var7, int var8);

    abstract void doConvert(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8);

    @Override
    public final void convert(byte[] srcarr, int srcoff, int srcscanbytes, byte[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (srcscanbytes == w * this.nSrcElems && dstscanbytes == w * this.nDstElems) {
            w *= h;
            h = 1;
        }
        this.doConvert(srcarr, srcoff, srcscanbytes, dstarr, dstoff, dstscanbytes, w, h);
    }

    @Override
    public final void convert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, ByteBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (srcscanbytes == w * this.nSrcElems && dstscanbytes == w * this.nDstElems) {
            w *= h;
            h = 1;
        }
        if (srcbuf.hasArray() && dstbuf.hasArray()) {
            this.doConvert(srcbuf.array(), srcoff += srcbuf.arrayOffset(), srcscanbytes, dstbuf.array(), dstoff += dstbuf.arrayOffset(), dstscanbytes, w, h);
        } else {
            this.doConvert(srcbuf, srcoff, srcscanbytes, dstbuf, dstoff, dstscanbytes, w, h);
        }
    }

    @Override
    public final void convert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, byte[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (srcscanbytes == w * this.nSrcElems && dstscanbytes == w * this.nDstElems) {
            w *= h;
            h = 1;
        }
        if (srcbuf.hasArray()) {
            byte[] srcarr = srcbuf.array();
            this.doConvert(srcarr, srcoff += srcbuf.arrayOffset(), srcscanbytes, dstarr, dstoff, dstscanbytes, w, h);
        } else {
            ByteBuffer dstbuf = ByteBuffer.wrap(dstarr);
            this.doConvert(srcbuf, srcoff, srcscanbytes, dstbuf, dstoff, dstscanbytes, w, h);
        }
    }

    @Override
    public final void convert(byte[] srcarr, int srcoff, int srcscanbytes, ByteBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        if (srcscanbytes == w * this.nSrcElems && dstscanbytes == w * this.nDstElems) {
            w *= h;
            h = 1;
        }
        if (dstbuf.hasArray()) {
            byte[] dstarr = dstbuf.array();
            this.doConvert(srcarr, srcoff, srcscanbytes, dstarr, dstoff += dstbuf.arrayOffset(), dstscanbytes, w, h);
        } else {
            ByteBuffer srcbuf = ByteBuffer.wrap(srcarr);
            this.doConvert(srcbuf, srcoff, srcscanbytes, dstbuf, dstoff, dstscanbytes, w, h);
        }
    }

    static ByteToBytePixelConverter create(BytePixelAccessor fmt) {
        return new ByteAnyToSameConverter(fmt);
    }

    public static ByteToBytePixelConverter createReorderer(BytePixelGetter getter, BytePixelSetter setter, int c0, int c1, int c2, int c3) {
        return new FourByteReorderer(getter, setter, c0, c1, c2, c3);
    }

    static class ByteAnyToSameConverter
    extends BaseByteToByteConverter {
        ByteAnyToSameConverter(BytePixelAccessor fmt) {
            super(fmt, fmt);
        }

        @Override
        void doConvert(byte[] srcarr, int srcoff, int srcscanbytes, byte[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
            while (--h >= 0) {
                System.arraycopy(srcarr, srcoff, dstarr, dstoff, w * this.nSrcElems);
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void doConvert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, ByteBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
            int srclimit = srcbuf.limit();
            int origsrcpos = srcbuf.position();
            int origdstpos = dstbuf.position();
            try {
                while (--h >= 0) {
                    int newlimit = srcoff + w * this.nSrcElems;
                    if (newlimit > srclimit) {
                        throw new IndexOutOfBoundsException("" + srclimit);
                    }
                    srcbuf.limit(newlimit);
                    srcbuf.position(srcoff);
                    dstbuf.position(dstoff);
                    dstbuf.put(srcbuf);
                    srcoff += srcscanbytes;
                    dstoff += dstscanbytes;
                }
            }
            finally {
                srcbuf.limit(srclimit);
                srcbuf.position(origsrcpos);
                dstbuf.position(origdstpos);
            }
        }
    }

    static class FourByteReorderer
    extends BaseByteToByteConverter {
        private final int c0;
        private final int c1;
        private final int c2;
        private final int c3;

        FourByteReorderer(BytePixelGetter getter, BytePixelSetter setter, int c0, int c1, int c2, int c3) {
            super(getter, setter);
            this.c0 = c0;
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
        }

        @Override
        void doConvert(byte[] srcarr, int srcoff, int srcscanbytes, byte[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= w * 4;
            dstscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    byte b0 = srcarr[srcoff + this.c0];
                    byte b1 = srcarr[srcoff + this.c1];
                    byte b2 = srcarr[srcoff + this.c2];
                    byte b3 = srcarr[srcoff + this.c3];
                    dstarr[dstoff++] = b0;
                    dstarr[dstoff++] = b1;
                    dstarr[dstoff++] = b2;
                    dstarr[dstoff++] = b3;
                    srcoff += 4;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }

        @Override
        void doConvert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, ByteBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= w * 4;
            dstscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    byte b0 = srcbuf.get(srcoff + this.c0);
                    byte b1 = srcbuf.get(srcoff + this.c1);
                    byte b2 = srcbuf.get(srcoff + this.c2);
                    byte b3 = srcbuf.get(srcoff + this.c3);
                    dstbuf.put(dstoff, b0);
                    dstbuf.put(dstoff + 1, b1);
                    dstbuf.put(dstoff + 2, b2);
                    dstbuf.put(dstoff + 3, b3);
                    srcoff += 4;
                    dstoff += 4;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }
    }
}

