/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelAccessor;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.ByteToIntPixelConverter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.BaseByteToByteConverter;
import com.sun.javafx.image.impl.BaseByteToIntConverter;
import com.sun.javafx.image.impl.ByteBgra;
import com.sun.javafx.image.impl.IntArgb;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class ByteBgraPre {
    public static final BytePixelGetter getter = Accessor.instance;
    public static final BytePixelSetter setter = Accessor.instance;
    public static final BytePixelAccessor accessor = Accessor.instance;
    private static ByteToBytePixelConverter ToByteBgraPreObj;

    public static ByteToBytePixelConverter ToByteBgraConverter() {
        return ToByteBgraConv.instance;
    }

    public static ByteToBytePixelConverter ToByteBgraPreConverter() {
        if (ToByteBgraPreObj == null) {
            ToByteBgraPreObj = BaseByteToByteConverter.create(accessor);
        }
        return ToByteBgraPreObj;
    }

    public static ByteToIntPixelConverter ToIntArgbConverter() {
        return ToIntArgbConv.instance;
    }

    public static ByteToIntPixelConverter ToIntArgbPreConverter() {
        return ByteBgra.ToIntArgbSameConv.premul;
    }

    public static class ToByteBgraConv
    extends BaseByteToByteConverter {
        public static final ByteToBytePixelConverter instance = new ToByteBgraConv();

        private ToByteBgraConv() {
            super(getter, ByteBgra.setter);
        }

        @Override
        void doConvert(byte[] srcarr, int srcoff, int srcscanbytes, byte[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= w * 4;
            dstscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    int a;
                    byte b = srcarr[srcoff++];
                    byte g = srcarr[srcoff++];
                    byte r = srcarr[srcoff++];
                    if ((a = srcarr[srcoff++] & 0xFF) > 0 && a < 255) {
                        int halfa = a >> 1;
                        b = (byte)(((b & 0xFF) * 255 + halfa) / a);
                        g = (byte)(((g & 0xFF) * 255 + halfa) / a);
                        r = (byte)(((r & 0xFF) * 255 + halfa) / a);
                    }
                    dstarr[dstoff++] = b;
                    dstarr[dstoff++] = g;
                    dstarr[dstoff++] = r;
                    dstarr[dstoff++] = (byte)a;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }

        @Override
        void doConvert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, ByteBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= w * 4;
            dstscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    byte b = srcbuf.get(srcoff);
                    byte g = srcbuf.get(srcoff + 1);
                    byte r = srcbuf.get(srcoff + 2);
                    int a = srcbuf.get(srcoff + 3) & 0xFF;
                    srcoff += 4;
                    if (a > 0 && a < 255) {
                        int halfa = a >> 1;
                        b = (byte)(((b & 0xFF) * 255 + halfa) / a);
                        g = (byte)(((g & 0xFF) * 255 + halfa) / a);
                        r = (byte)(((r & 0xFF) * 255 + halfa) / a);
                    }
                    dstbuf.put(dstoff, b);
                    dstbuf.put(dstoff + 1, g);
                    dstbuf.put(dstoff + 2, r);
                    dstbuf.put(dstoff + 3, (byte)a);
                    dstoff += 4;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }
    }

    public static class ToIntArgbConv
    extends BaseByteToIntConverter {
        public static final ByteToIntPixelConverter instance = new ToIntArgbConv();

        private ToIntArgbConv() {
            super(getter, IntArgb.setter);
        }

        @Override
        void doConvert(byte[] srcarr, int srcoff, int srcscanbytes, int[] dstarr, int dstoff, int dstscanints, int w, int h) {
            srcscanbytes -= w * 4;
            dstscanints -= w;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    int a;
                    int b = srcarr[srcoff++] & 0xFF;
                    int g = srcarr[srcoff++] & 0xFF;
                    int r = srcarr[srcoff++] & 0xFF;
                    if ((a = srcarr[srcoff++] & 0xFF) > 0 && a < 255) {
                        int halfa = a >> 1;
                        r = (r * 255 + halfa) / a;
                        g = (g * 255 + halfa) / a;
                        b = (b * 255 + halfa) / a;
                    }
                    dstarr[dstoff++] = a << 24 | r << 16 | g << 8 | b;
                }
                dstoff += dstscanints;
                srcoff += srcscanbytes;
            }
        }

        @Override
        void doConvert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, IntBuffer dstbuf, int dstoff, int dstscanints, int w, int h) {
            srcscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    int b = srcbuf.get(srcoff) & 0xFF;
                    int g = srcbuf.get(srcoff + 1) & 0xFF;
                    int r = srcbuf.get(srcoff + 2) & 0xFF;
                    int a = srcbuf.get(srcoff + 3) & 0xFF;
                    srcoff += 4;
                    if (a > 0 && a < 255) {
                        int halfa = a >> 1;
                        r = (r * 255 + halfa) / a;
                        g = (g * 255 + halfa) / a;
                        b = (b * 255 + halfa) / a;
                    }
                    dstbuf.put(dstoff + x, a << 24 | r << 16 | g << 8 | b);
                }
                dstoff += dstscanints;
                srcoff += srcscanbytes;
            }
        }
    }

    static class Accessor
    implements BytePixelAccessor {
        static final BytePixelAccessor instance = new Accessor();

        private Accessor() {
        }

        @Override
        public AlphaType getAlphaType() {
            return AlphaType.PREMULTIPLIED;
        }

        @Override
        public int getNumElements() {
            return 4;
        }

        @Override
        public int getArgb(byte[] arr, int offset) {
            return PixelUtils.PretoNonPre(this.getArgbPre(arr, offset));
        }

        @Override
        public int getArgbPre(byte[] arr, int offset) {
            return arr[offset] & 0xFF | (arr[offset + 1] & 0xFF) << 8 | (arr[offset + 2] & 0xFF) << 16 | arr[offset + 3] << 24;
        }

        @Override
        public int getArgb(ByteBuffer buffer, int offset) {
            return PixelUtils.PretoNonPre(this.getArgbPre(buffer, offset));
        }

        @Override
        public int getArgbPre(ByteBuffer buffer, int offset) {
            return buffer.get(offset) & 0xFF | (buffer.get(offset + 1) & 0xFF) << 8 | (buffer.get(offset + 2) & 0xFF) << 16 | buffer.get(offset + 3) << 24;
        }

        @Override
        public void setArgb(byte[] arr, int offset, int argb) {
            this.setArgbPre(arr, offset, PixelUtils.NonPretoPre(argb));
        }

        @Override
        public void setArgbPre(byte[] arr, int offset, int argbpre) {
            arr[offset] = (byte)argbpre;
            arr[offset + 1] = (byte)(argbpre >> 8);
            arr[offset + 2] = (byte)(argbpre >> 16);
            arr[offset + 3] = (byte)(argbpre >> 24);
        }

        @Override
        public void setArgb(ByteBuffer buffer, int offset, int argb) {
            this.setArgbPre(buffer, offset, PixelUtils.NonPretoPre(argb));
        }

        @Override
        public void setArgbPre(ByteBuffer buffer, int offset, int argbpre) {
            buffer.put(offset, (byte)argbpre);
            buffer.put(offset + 1, (byte)(argbpre >> 8));
            buffer.put(offset + 2, (byte)(argbpre >> 16));
            buffer.put(offset + 3, (byte)(argbpre >> 24));
        }
    }
}

