/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.collections.ObservableListWrapper;
import com.sun.javafx.collections.ObservableMapWrapper;
import com.sun.javafx.event.BasicEventDispatcher;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalMethod;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.Mnemonic;

public final class KeyboardShortcutsHandler
extends BasicEventDispatcher {
    private ObservableMap<KeyCombination, Runnable> accelerators;
    private CopyOnWriteMap<KeyCombination, Runnable> acceleratorsBackingMap;
    private ObservableMap<KeyCombination, ObservableList<Mnemonic>> mnemonics;
    private boolean mnemonicsDisplayEnabled = false;

    public void addMnemonic(Mnemonic m) {
        ObservableList mnemonicsList = (ObservableList)this.getMnemonics().get((Object)m.getKeyCombination());
        if (mnemonicsList == null) {
            mnemonicsList = new ObservableListWrapper(new ArrayList());
            this.getMnemonics().put((Object)m.getKeyCombination(), (Object)mnemonicsList);
        }
        boolean foundMnemonic = false;
        for (Mnemonic mnemonic : mnemonicsList) {
            if (mnemonic != m) continue;
            foundMnemonic = true;
            break;
        }
        if (!foundMnemonic) {
            mnemonicsList.add((Object)m);
        }
    }

    public void removeMnemonic(Mnemonic m) {
        ObservableList mnemonicsList = (ObservableList)this.getMnemonics().get((Object)m.getKeyCombination());
        if (mnemonicsList != null) {
            for (int i = 0; i < mnemonicsList.size(); ++i) {
                if (((Mnemonic)mnemonicsList.get(i)).getNode() != m.getNode()) continue;
                mnemonicsList.remove(i);
            }
        }
    }

    public ObservableMap<KeyCombination, ObservableList<Mnemonic>> getMnemonics() {
        if (this.mnemonics == null) {
            this.mnemonics = new ObservableMapWrapper(new HashMap());
        }
        return this.mnemonics;
    }

    public ObservableMap<KeyCombination, Runnable> getAccelerators() {
        if (this.accelerators == null) {
            this.acceleratorsBackingMap = new CopyOnWriteMap();
            this.accelerators = new ObservableMapWrapper(this.acceleratorsBackingMap);
        }
        return this.accelerators;
    }

    private void traverse(Event event, Node node, Direction dir) {
        if (NodeHelper.traverse(node, dir, TraversalMethod.KEY)) {
            event.consume();
        }
    }

    public void processTraversal(Event event) {
        if (event.getEventType() != KeyEvent.KEY_PRESSED) {
            return;
        }
        if (!(event instanceof KeyEvent)) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)event;
        if (!(keyEvent.isMetaDown() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
            EventTarget obj = event.getTarget();
            if (!(obj instanceof Node)) {
                return;
            }
            Node node = (Node)obj;
            switch (keyEvent.getCode()) {
                case TAB: {
                    if (keyEvent.isShiftDown()) {
                        this.traverse(event, node, Direction.PREVIOUS);
                        break;
                    }
                    this.traverse(event, node, Direction.NEXT);
                    break;
                }
                case UP: {
                    this.traverse(event, node, Direction.UP);
                    break;
                }
                case DOWN: {
                    this.traverse(event, node, Direction.DOWN);
                    break;
                }
                case LEFT: {
                    this.traverse(event, node, Direction.LEFT);
                    break;
                }
                case RIGHT: {
                    this.traverse(event, node, Direction.RIGHT);
                    break;
                }
            }
        }
    }

    public Event dispatchBubblingEvent(Event event) {
        if (!(event instanceof KeyEvent)) {
            return event;
        }
        boolean keyPressedEvent = event.getEventType() == KeyEvent.KEY_PRESSED;
        KeyEvent keyEvent = (KeyEvent)event;
        if (keyPressedEvent) {
            if (!event.isConsumed()) {
                this.processAccelerators(keyEvent);
            }
            if (!event.isConsumed()) {
                this.processTraversal(event);
            }
        }
        return event;
    }

    public Event dispatchCapturingEvent(Event event) {
        if (!(event instanceof KeyEvent)) {
            return event;
        }
        boolean keyPressedEvent = event.getEventType() == KeyEvent.KEY_PRESSED;
        boolean keyTypedEvent = event.getEventType() == KeyEvent.KEY_TYPED;
        boolean keyReleasedEvent = event.getEventType() == KeyEvent.KEY_RELEASED;
        KeyEvent keyEvent = (KeyEvent)event;
        if (keyPressedEvent || keyTypedEvent) {
            if (PlatformUtil.isMac()) {
                if (keyEvent.isMetaDown()) {
                    this.processMnemonics(keyEvent);
                }
            } else if (keyEvent.isAltDown() || this.isMnemonicsDisplayEnabled()) {
                this.processMnemonics(keyEvent);
            }
        }
        if (!PlatformUtil.isMac() && !event.isConsumed()) {
            if (keyPressedEvent) {
                if (keyEvent.isAltDown()) {
                    if (!this.isMnemonicsDisplayEnabled()) {
                        this.setMnemonicsDisplayEnabled(true);
                    } else if (PlatformUtil.isWindows()) {
                        this.setMnemonicsDisplayEnabled(!this.isMnemonicsDisplayEnabled());
                    }
                } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                    this.setMnemonicsDisplayEnabled(false);
                }
            }
            if (keyReleasedEvent && !keyEvent.isAltDown() && !PlatformUtil.isWindows()) {
                this.setMnemonicsDisplayEnabled(false);
            }
        }
        return event;
    }

    private void processMnemonics(KeyEvent event) {
        if (this.mnemonics == null) {
            return;
        }
        KeyEvent lookupEvent = event;
        if (event.getEventType() == KeyEvent.KEY_TYPED) {
            lookupEvent = new KeyEvent(null, event.getTarget(), KeyEvent.KEY_PRESSED, " ", event.getCharacter(), KeyCode.getKeyCode(event.getCharacter()), event.isShiftDown(), event.isControlDown(), this.isMnemonicsDisplayEnabled(), event.isMetaDown());
        } else if (this.isMnemonicsDisplayEnabled()) {
            lookupEvent = new KeyEvent(null, event.getTarget(), KeyEvent.KEY_PRESSED, event.getCharacter(), event.getText(), event.getCode(), event.isShiftDown(), event.isControlDown(), this.isMnemonicsDisplayEnabled(), event.isMetaDown());
        }
        ObservableList mnemonicsList = null;
        for (Map.Entry mnemonic : this.mnemonics.entrySet()) {
            if (!((KeyCombination)mnemonic.getKey()).match(lookupEvent)) continue;
            mnemonicsList = (ObservableList)mnemonic.getValue();
            break;
        }
        if (mnemonicsList == null) {
            return;
        }
        boolean multipleNodes = false;
        Node firstNode = null;
        Mnemonic firstMnemonics = null;
        int focusedIndex = -1;
        int nextFocusable = -1;
        for (int i = 0; i < mnemonicsList.size(); ++i) {
            Mnemonic mnemonic = (Mnemonic)mnemonicsList.get(i);
            Node currentNode = mnemonic.getNode();
            if (firstMnemonics == null && NodeHelper.isTreeVisible(currentNode) && !currentNode.isDisabled()) {
                firstMnemonics = mnemonic;
            }
            if (NodeHelper.isTreeVisible(currentNode) && currentNode.isFocusTraversable() && !currentNode.isDisabled()) {
                if (firstNode == null) {
                    firstNode = currentNode;
                } else {
                    multipleNodes = true;
                    if (focusedIndex != -1 && nextFocusable == -1) {
                        nextFocusable = i;
                    }
                }
            }
            if (!currentNode.isFocused()) continue;
            focusedIndex = i;
        }
        if (firstNode != null) {
            if (!multipleNodes) {
                firstNode.requestFocus();
                event.consume();
            } else if (focusedIndex == -1) {
                firstNode.requestFocus();
                event.consume();
            } else if (focusedIndex >= mnemonicsList.size()) {
                firstNode.requestFocus();
                event.consume();
            } else {
                if (nextFocusable != -1) {
                    ((Mnemonic)mnemonicsList.get(nextFocusable)).getNode().requestFocus();
                } else {
                    firstNode.requestFocus();
                }
                event.consume();
            }
        }
        if (!multipleNodes && firstMnemonics != null) {
            if (event.getEventType() == KeyEvent.KEY_TYPED) {
                event.consume();
            } else {
                firstMnemonics.fire();
                event.consume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAccelerators(KeyEvent event) {
        if (this.acceleratorsBackingMap != null) {
            this.acceleratorsBackingMap.lock();
            try {
                for (Map.Entry accelerator : this.acceleratorsBackingMap.backingMap.entrySet()) {
                    Runnable acceleratorRunnable;
                    if (!((KeyCombination)accelerator.getKey()).match(event) || (acceleratorRunnable = (Runnable)accelerator.getValue()) == null) continue;
                    acceleratorRunnable.run();
                    event.consume();
                }
            }
            finally {
                this.acceleratorsBackingMap.unlock();
            }
        }
    }

    private void processMnemonicsKeyDisplay() {
        ObservableList mnemonicsList = null;
        if (this.mnemonics != null) {
            for (Map.Entry mnemonic : this.mnemonics.entrySet()) {
                mnemonicsList = (ObservableList)mnemonic.getValue();
                if (mnemonicsList == null) continue;
                for (int i = 0; i < mnemonicsList.size(); ++i) {
                    Node currentNode = ((Mnemonic)mnemonicsList.get(i)).getNode();
                    NodeHelper.setShowMnemonics(currentNode, this.mnemonicsDisplayEnabled);
                }
            }
        }
    }

    public boolean isMnemonicsDisplayEnabled() {
        return this.mnemonicsDisplayEnabled;
    }

    public void setMnemonicsDisplayEnabled(boolean b) {
        if (b != this.mnemonicsDisplayEnabled) {
            this.mnemonicsDisplayEnabled = b;
            this.processMnemonicsKeyDisplay();
        }
    }

    public void clearNodeMnemonics(Node node) {
        if (this.mnemonics != null) {
            for (ObservableList list : this.mnemonics.values()) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Mnemonic m = (Mnemonic)it.next();
                    if (m.getNode() != node) continue;
                    it.remove();
                }
            }
        }
    }

    private static class CopyOnWriteMap<K, V>
    extends AbstractMap<K, V> {
        private Map<K, V> backingMap = new HashMap();
        private boolean lock;

        private CopyOnWriteMap() {
        }

        public void lock() {
            this.lock = true;
        }

        public void unlock() {
            this.lock = false;
        }

        @Override
        public V put(K key, V value) {
            if (this.lock) {
                this.backingMap = new HashMap<K, V>(this.backingMap);
                this.lock = false;
            }
            return this.backingMap.put(key, value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private Iterator<Map.Entry<K, V>> backingIt;
                        private Map<K, V> backingMapAtCreation;
                        private Map.Entry<K, V> lastNext;
                        {
                            this.backingIt = backingMap.entrySet().iterator();
                            this.backingMapAtCreation = backingMap;
                            this.lastNext = null;
                        }

                        @Override
                        public boolean hasNext() {
                            this.checkCoMod();
                            return this.backingIt.hasNext();
                        }

                        private void checkCoMod() {
                            if (backingMap != this.backingMapAtCreation) {
                                throw new ConcurrentModificationException();
                            }
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            this.checkCoMod();
                            this.lastNext = this.backingIt.next();
                            return this.lastNext;
                        }

                        @Override
                        public void remove() {
                            this.checkCoMod();
                            if (this.lastNext == null) {
                                throw new IllegalStateException();
                            }
                            if (lock) {
                                backingMap = new HashMap(backingMap);
                                this.backingIt = backingMap.entrySet().iterator();
                                while (!this.lastNext.equals(this.backingIt.next())) {
                                }
                                lock = false;
                            }
                            this.backingIt.remove();
                            this.lastNext = null;
                        }
                    };
                }

                @Override
                public int size() {
                    return backingMap.size();
                }
            };
        }
    }
}

