/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.util.Utils;
import javafx.scene.LightBase;
import javafx.scene.Node;

public class LightBaseHelper
extends NodeHelper {
    private static final LightBaseHelper theInstance = new LightBaseHelper();
    private static LightBaseAccessor lightBaseAccessor;

    private static LightBaseHelper getInstance() {
        return theInstance;
    }

    public static void initHelper(LightBase lightBase) {
        LightBaseHelper.setHelper(lightBase, LightBaseHelper.getInstance());
    }

    @Override
    protected NGNode createPeerImpl(Node node) {
        throw new UnsupportedOperationException("Applications should not extend the LightBase class directly.");
    }

    @Override
    protected void updatePeerImpl(Node node) {
        super.updatePeerImpl(node);
        lightBaseAccessor.doUpdatePeer(node);
    }

    @Override
    protected void markDirtyImpl(Node node, DirtyBits dirtyBit) {
        super.markDirtyImpl(node, dirtyBit);
        lightBaseAccessor.doMarkDirty(node, dirtyBit);
    }

    @Override
    protected BaseBounds computeGeomBoundsImpl(Node node, BaseBounds bounds, BaseTransform tx) {
        return lightBaseAccessor.doComputeGeomBounds(node, bounds, tx);
    }

    @Override
    protected boolean computeContainsImpl(Node node, double localX, double localY) {
        return lightBaseAccessor.doComputeContains(node, localX, localY);
    }

    public static void setLightBaseAccessor(LightBaseAccessor newAccessor) {
        if (lightBaseAccessor != null) {
            throw new IllegalStateException();
        }
        lightBaseAccessor = newAccessor;
    }

    static {
        Utils.forceInit(LightBase.class);
    }

    public static interface LightBaseAccessor {
        public void doMarkDirty(Node var1, DirtyBits var2);

        public void doUpdatePeer(Node var1);

        public BaseBounds doComputeGeomBounds(Node var1, BaseBounds var2, BaseTransform var3);

        public boolean doComputeContains(Node var1, double var2, double var4);
    }
}

