/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.scene.traversal.TraversalMethod;
import javafx.scene.Node;
import javafx.scene.Parent;

public abstract class TopMostTraversalEngine
extends TraversalEngine {
    protected TopMostTraversalEngine() {
        super(DEFAULT_ALGORITHM);
    }

    TopMostTraversalEngine(Algorithm algorithm) {
        super(algorithm);
    }

    public final Node trav(Node node, Direction dir, TraversalMethod method) {
        Node newNode = null;
        Node traverseNode = node;
        for (Parent p = node.getParent(); p != null; p = p.getParent()) {
            ParentTraversalEngine engine = ParentHelper.getTraversalEngine(p);
            if (engine == null || !engine.canTraverse()) continue;
            newNode = engine.select(node, dir);
            if (newNode != null) break;
            traverseNode = p;
            if (dir != Direction.NEXT) continue;
            dir = Direction.NEXT_IN_LINE;
        }
        if (newNode == null) {
            newNode = this.select(traverseNode, dir);
        }
        if (newNode == null) {
            if (dir == Direction.NEXT || dir == Direction.NEXT_IN_LINE) {
                newNode = this.selectFirst();
            } else if (dir == Direction.PREVIOUS) {
                newNode = this.selectLast();
            }
        }
        if (newNode != null) {
            this.focusAndNotify(newNode, method);
        }
        return newNode;
    }

    private void focusAndNotify(Node newNode, TraversalMethod method) {
        if (method == TraversalMethod.KEY) {
            NodeHelper.requestFocusVisible(newNode);
        } else {
            newNode.requestFocus();
        }
        this.notifyTreeTraversedTo(newNode);
    }

    private void notifyTreeTraversedTo(Node newNode) {
        for (Parent p = newNode.getParent(); p != null; p = p.getParent()) {
            ParentTraversalEngine traversalEngine = ParentHelper.getTraversalEngine(p);
            if (traversalEngine == null) continue;
            traversalEngine.notifyTraversedTo(newNode);
        }
        this.notifyTraversedTo(newNode);
    }

    public final Node traverseToFirst() {
        Node n = this.selectFirst();
        if (n != null) {
            this.focusAndNotify(n, TraversalMethod.DEFAULT);
        }
        return n;
    }

    public final Node traverseToLast() {
        Node n = this.selectLast();
        if (n != null) {
            this.focusAndNotify(n, TraversalMethod.DEFAULT);
        }
        return n;
    }
}

