/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Pixels;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.embed.AbstractEvents;
import com.sun.javafx.embed.EmbeddedSceneDTInterface;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.HostDragStartListener;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.scene.input.KeyCodeMap;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.EmbeddedSceneDnD;
import com.sun.javafx.tk.quantum.EmbeddedState;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.UploadingPainter;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.AccessController;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventType;
import javafx.scene.image.PixelFormat;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

final class EmbeddedScene
extends GlassScene
implements EmbeddedSceneInterface {
    private HostInterface host;
    private UploadingPainter painter;
    private PaintRenderJob paintRenderJob;
    private float renderScaleX;
    private float renderScaleY;
    private final EmbeddedSceneDnD embeddedDnD;
    private volatile IntBuffer texBits;
    private volatile int texLineStride;
    private volatile float texScaleFactorX = 1.0f;
    private volatile float texScaleFactorY = 1.0f;
    private volatile PixelFormat<?> pixelFormat;

    public EmbeddedScene(HostInterface host, boolean depthBuffer, boolean msaa) {
        super(depthBuffer, msaa);
        this.sceneState = new EmbeddedState(this);
        this.host = host;
        this.embeddedDnD = new EmbeddedSceneDnD(this);
        PaintCollector collector = PaintCollector.getInstance();
        this.painter = new UploadingPainter(this);
        this.paintRenderJob = new PaintRenderJob(this, collector.getRendered(), this.painter);
        int nativeFormat = Pixels.getNativeFormat();
        ByteOrder byteorder = ByteOrder.nativeOrder();
        if (nativeFormat == 1 && byteorder == ByteOrder.LITTLE_ENDIAN) {
            this.pixelFormat = PixelFormat.getIntArgbPreInstance();
        } else if (nativeFormat == 2 && byteorder == ByteOrder.BIG_ENDIAN) {
            this.pixelFormat = PixelFormat.getIntArgbInstance();
        }
        assert (this.pixelFormat != null);
    }

    @Override
    public void dispose() {
        assert (this.host != null);
        QuantumToolkit.runWithRenderLock(() -> {
            this.host.setEmbeddedScene(null);
            this.host = null;
            this.updateSceneState();
            this.painter = null;
            this.paintRenderJob = null;
            this.texBits = null;
            return null;
        });
        super.dispose();
    }

    @Override
    void setStage(GlassStage stage) {
        super.setStage(stage);
        assert (this.host != null);
        this.host.setEmbeddedScene(stage != null ? this : null);
    }

    @Override
    protected boolean isSynchronous() {
        return false;
    }

    @Override
    public void setRoot(NGNode root) {
        super.setRoot(root);
        this.painter.setRoot(root);
    }

    @Override
    public TKClipboard createDragboard(boolean isDragSource) {
        return this.embeddedDnD.createDragboard(isDragSource);
    }

    @Override
    public void enableInputMethodEvents(boolean enable) {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedScene.enableInputMethodEvents " + enable);
        }
    }

    @Override
    public void finishInputMethodComposition() {
        if (QuantumToolkit.verbose) {
            System.err.println("EmbeddedScene.finishInputMethodComposition");
        }
    }

    @Override
    public void setPixelScaleFactors(float scalex, float scaley) {
        this.renderScaleX = scalex;
        this.renderScaleY = scaley;
        this.entireSceneNeedsRepaint();
    }

    public float getRenderScaleX() {
        return this.renderScaleX;
    }

    public float getRenderScaleY() {
        return this.renderScaleY;
    }

    @Override
    public PixelFormat<?> getPixelFormat() {
        return this.pixelFormat;
    }

    void uploadPixels(Pixels pixels) {
        this.texBits = (IntBuffer)pixels.getPixels();
        this.texLineStride = pixels.getWidthUnsafe();
        this.texScaleFactorX = pixels.getScaleXUnsafe();
        this.texScaleFactorY = pixels.getScaleYUnsafe();
        if (this.host != null) {
            this.host.repaint();
        }
    }

    @Override
    public void repaint() {
        Toolkit tk = Toolkit.getToolkit();
        tk.addRenderJob(this.paintRenderJob);
    }

    @Override
    public boolean traverseOut(Direction dir) {
        if (dir == Direction.NEXT) {
            return this.host.traverseFocusOut(true);
        }
        if (dir == Direction.PREVIOUS) {
            return this.host.traverseFocusOut(false);
        }
        return false;
    }

    @Override
    public void setSize(int width, int height) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener != null) {
                this.sceneListener.changedSize(width, height);
            }
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public boolean getPixels(IntBuffer dest, int width, int height) {
        return QuantumToolkit.runWithRenderLock(() -> {
            int scaledWidth = width;
            int scaledHeight = height;
            if (this.getRenderScaleX() != this.texScaleFactorX || this.getRenderScaleY() != this.texScaleFactorY || this.texBits == null) {
                return false;
            }
            scaledWidth = (int)Math.ceil((float)scaledWidth * this.texScaleFactorX);
            scaledHeight = (int)Math.ceil((float)scaledHeight * this.texScaleFactorY);
            dest.rewind();
            this.texBits.rewind();
            if (dest.capacity() != this.texBits.capacity()) {
                int w = Math.min(scaledWidth, this.texLineStride);
                int h = Math.min(scaledHeight, this.texBits.capacity() / this.texLineStride);
                int[] linebuf = new int[w];
                for (int i = 0; i < h; ++i) {
                    this.texBits.position(i * this.texLineStride);
                    this.texBits.get(linebuf, 0, w);
                    dest.position(i * scaledWidth);
                    dest.put(linebuf);
                }
                return true;
            }
            dest.put(this.texBits);
            return true;
        });
    }

    @Override
    protected Color getClearColor() {
        if (this.fillPaint != null && this.fillPaint.getType() == Paint.Type.COLOR && ((Color)this.fillPaint).getAlpha() == 0.0f) {
            return (Color)this.fillPaint;
        }
        return super.getClearColor();
    }

    @Override
    public void mouseEvent(int type, int button, boolean primaryBtnDown, boolean middleBtnDown, boolean secondaryBtnDown, boolean backBtnDown, boolean forwardBtnDown, int x, int y, int xAbs, int yAbs, boolean shift, boolean ctrl, boolean alt, boolean meta, boolean popupTrigger) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener == null) {
                return null;
            }
            assert (type != 2);
            EventType<MouseEvent> eventType = AbstractEvents.mouseIDToFXEventID(type);
            this.sceneListener.mouseEvent(eventType, x, y, xAbs, yAbs, AbstractEvents.mouseButtonToFXMouseButton(button), popupTrigger, false, shift, ctrl, alt, meta, primaryBtnDown, middleBtnDown, secondaryBtnDown, backBtnDown, forwardBtnDown);
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public void scrollEvent(int type, double scrollX, double scrollY, double totalScrollX, double totalScrollY, double xMultiplier, double yMultiplier, double x, double y, double xAbs, double yAbs, boolean shift, boolean ctrl, boolean alt, boolean meta, boolean inertia) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener == null) {
                return null;
            }
            this.sceneListener.scrollEvent(AbstractEvents.scrollIDToFXEventType(type), scrollX, scrollY, totalScrollX, totalScrollY, xMultiplier, yMultiplier, 0, 0, 0, 0, 0, x, y, xAbs, yAbs, shift, ctrl, alt, meta, false, inertia);
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public void inputMethodEvent(EventType<InputMethodEvent> type, ObservableList<InputMethodTextRun> composed, String committed, int caretPosition) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener != null) {
                this.sceneListener.inputMethodEvent(type, composed, committed, caretPosition);
            }
            return null;
        }));
    }

    @Override
    public void menuEvent(int x, int y, int xAbs, int yAbs, boolean isKeyboardTrigger) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener != null) {
                this.sceneListener.menuEvent(x, y, xAbs, yAbs, isKeyboardTrigger);
            }
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public void keyEvent(int type, int key, char[] ch, int modifiers) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener != null) {
                String str;
                boolean shiftDown = (modifiers & 1) != 0;
                boolean controlDown = (modifiers & 2) != 0;
                boolean altDown = (modifiers & 4) != 0;
                boolean metaDown = (modifiers & 8) != 0;
                String text = str = new String(ch);
                KeyEvent keyEvent = new KeyEvent(AbstractEvents.keyIDToFXEventType(type), str, text, KeyCodeMap.valueOf(key), shiftDown, controlDown, altDown, metaDown);
                this.sceneListener.keyEvent(keyEvent);
            }
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public void zoomEvent(int type, double zoomFactor, double totalZoomFactor, double x, double y, double screenX, double screenY, boolean shift, boolean ctrl, boolean alt, boolean meta, boolean inertia) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener == null) {
                return null;
            }
            this.sceneListener.zoomEvent(AbstractEvents.zoomIDToFXEventType(type), zoomFactor, totalZoomFactor, x, y, screenX, screenY, shift, ctrl, alt, meta, false, inertia);
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public void rotateEvent(int type, double angle, double totalAngle, double x, double y, double screenX, double screenY, boolean shift, boolean ctrl, boolean alt, boolean meta, boolean inertia) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener == null) {
                return null;
            }
            this.sceneListener.rotateEvent(AbstractEvents.rotateIDToFXEventType(type), angle, totalAngle, x, y, screenX, screenY, shift, ctrl, alt, meta, false, inertia);
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public void swipeEvent(int type, double x, double y, double screenX, double screenY, boolean shift, boolean ctrl, boolean alt, boolean meta) {
        Platform.runLater(() -> AccessController.doPrivileged(() -> {
            if (this.sceneListener == null) {
                return null;
            }
            this.sceneListener.swipeEvent(AbstractEvents.swipeIDToFXEventType(type), 0, x, y, screenX, screenY, shift, ctrl, alt, meta, false);
            return null;
        }, this.getAccessControlContext()));
    }

    @Override
    public void setCursor(Object cursor) {
        super.setCursor(cursor);
        this.host.setCursor((CursorFrame)cursor);
    }

    @Override
    public void setDragStartListener(HostDragStartListener l) {
        this.embeddedDnD.setDragStartListener(l);
    }

    @Override
    public EmbeddedSceneDTInterface createDropTarget() {
        return this.embeddedDnD.createDropTarget();
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.inputMethodRequests;
    }
}

