/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.util;

import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DataURI {
    private final String originalUri;
    private final String originalData;
    private final String mimeType;
    private final String mimeSubtype;
    private final Map<String, String> parameters;
    private final boolean base64;
    private final byte[] data;

    public static boolean matchScheme(String uri) {
        if (uri == null || uri.length() < 6) {
            return false;
        }
        return (uri = uri.stripLeading()).length() > 5 && "data:".equalsIgnoreCase(uri.substring(0, 5));
    }

    public static DataURI tryParse(String uri) {
        if (!DataURI.matchScheme(uri)) {
            return null;
        }
        int dataSeparator = (uri = uri.trim()).indexOf(44, 5);
        if (dataSeparator < 0) {
            throw new IllegalArgumentException("Invalid URI: " + uri);
        }
        String mimeType = "text";
        String mimeSubtype = "plain";
        boolean base64 = false;
        String[] headers = uri.substring(5, dataSeparator).split(";");
        Map<String, String> nameValuePairs = Collections.emptyMap();
        if (headers.length > 0) {
            int start = 0;
            int mimeSeparator = headers[0].indexOf(47);
            if (mimeSeparator > 0) {
                mimeType = headers[0].substring(0, mimeSeparator);
                mimeSubtype = headers[0].substring(mimeSeparator + 1);
                start = 1;
            }
            for (int i = start; i < headers.length; ++i) {
                String header = headers[i];
                int separator = header.indexOf(61);
                if (separator < 0) {
                    if (i < headers.length - 1) {
                        throw new IllegalArgumentException("Invalid URI: " + uri);
                    }
                    base64 = "base64".equalsIgnoreCase(headers[headers.length - 1]);
                    continue;
                }
                if (nameValuePairs.isEmpty()) {
                    nameValuePairs = new HashMap<String, String>();
                }
                nameValuePairs.put(header.substring(0, separator).toLowerCase(), header.substring(separator + 1));
            }
        }
        String data = uri.substring(dataSeparator + 1);
        Charset charset = Charset.defaultCharset();
        return new DataURI(uri, data, mimeType, mimeSubtype, nameValuePairs, base64, base64 ? Base64.getDecoder().decode(data) : URLDecoder.decode(data.replace("+", "%2B"), charset).getBytes(charset));
    }

    private DataURI(String originalUri, String originalData, String mimeType, String mimeSubtype, Map<String, String> parameters, boolean base64, byte[] decodedData) {
        this.originalUri = originalUri;
        this.originalData = originalData;
        this.mimeType = mimeType;
        this.mimeSubtype = mimeSubtype;
        this.parameters = parameters;
        this.base64 = base64;
        this.data = decodedData;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getMimeSubtype() {
        return this.mimeSubtype;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isBase64() {
        return this.base64;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        if (this.originalData.length() < 32) {
            return this.originalUri;
        }
        return this.originalUri.substring(0, this.originalUri.length() - this.originalData.length()) + this.originalData.substring(0, 14) + "..." + this.originalData.substring(this.originalData.length() - 14);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataURI)) {
            return false;
        }
        DataURI dataURI = (DataURI)o;
        return this.base64 == dataURI.base64 && Objects.equals(this.mimeType, dataURI.mimeType) && Objects.equals(this.mimeSubtype, dataURI.mimeSubtype) && Arrays.equals(this.data, dataURI.data);
    }

    public int hashCode() {
        int result = Objects.hash(this.mimeType, this.mimeSubtype, this.base64);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

