/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.Curve;
import com.sun.marlin.FloatMath;
import com.sun.marlin.IntArrayCache;
import com.sun.marlin.MarlinAlphaConsumer;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinProperties;
import com.sun.marlin.MarlinRenderer;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.MergeSort;
import com.sun.marlin.OffHeapArray;
import com.sun.marlin.RendererContext;
import sun.misc.Unsafe;

public final class RendererNoAA
implements MarlinRenderer,
MarlinConst {
    static final boolean DISABLE_RENDER = false;
    private static final int ALL_BUT_LSB = -2;
    private static final int ERR_STEP_MAX = Integer.MAX_VALUE;
    private static final double POWER_2_TO_32 = 4.294967296E9;
    private static final double RDR_OFFSET_X = 0.5;
    private static final double RDR_OFFSET_Y = 0.5;
    public static final long OFF_CURX_OR = 0L;
    public static final long OFF_ERROR = 0L + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_BUMP_X = OFF_ERROR + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_BUMP_ERR = OFF_BUMP_X + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_NEXT = OFF_BUMP_ERR + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_YMAX = OFF_NEXT + (long)OffHeapArray.SIZE_INT;
    public static final int SIZEOF_EDGE_BYTES = (int)(OFF_YMAX + (long)OffHeapArray.SIZE_INT);
    private static final double CUB_DEC_ERR_SUBPIX = (double)MarlinProperties.getCubicDecD2() * 0.125;
    private static final double CUB_INC_ERR_SUBPIX = (double)MarlinProperties.getCubicIncD1() * 0.125;
    public static final double CUB_DEC_BND = 8.0 * CUB_DEC_ERR_SUBPIX;
    public static final double CUB_INC_BND = 8.0 * CUB_INC_ERR_SUBPIX;
    public static final int CUB_COUNT_LG = 2;
    private static final int CUB_COUNT = 4;
    private static final int CUB_COUNT_2 = 16;
    private static final int CUB_COUNT_3 = 64;
    private static final double CUB_INV_COUNT = 0.25;
    private static final double CUB_INV_COUNT_2 = 0.0625;
    private static final double CUB_INV_COUNT_3 = 0.015625;
    private static final double QUAD_DEC_ERR_SUBPIX = (double)MarlinProperties.getQuadDecD2() * 0.125;
    public static final double QUAD_DEC_BND = 8.0 * QUAD_DEC_ERR_SUBPIX;
    private int[] crossings;
    private int[] aux_crossings;
    private int edgeCount;
    private int[] edgePtrs;
    private int[] aux_edgePtrs;
    private int activeEdgeMaxUsed;
    private final IntArrayCache.Reference crossings_ref;
    private final IntArrayCache.Reference edgePtrs_ref;
    private final IntArrayCache.Reference aux_crossings_ref;
    private final IntArrayCache.Reference aux_edgePtrs_ref;
    private int edgeMinY = Integer.MAX_VALUE;
    private int edgeMaxY = Integer.MIN_VALUE;
    private double edgeMinX = Double.POSITIVE_INFINITY;
    private double edgeMaxX = Double.NEGATIVE_INFINITY;
    private final OffHeapArray edges;
    private int[] edgeBuckets;
    private int[] edgeBucketCounts;
    private int buckets_minY;
    private int buckets_maxY;
    private final IntArrayCache.Reference edgeBuckets_ref;
    private final IntArrayCache.Reference edgeBucketCounts_ref;
    boolean useRLE = false;
    private int boundsMinX;
    private int boundsMinY;
    private int boundsMaxX;
    private int boundsMaxY;
    private int windingRule;
    private double x0;
    private double y0;
    private double sx0;
    private double sy0;
    final RendererContext rdrCtx;
    private final Curve curve;
    private int[] alphaLine;
    private final IntArrayCache.Reference alphaLine_ref;
    private boolean enableBlkFlags = false;
    private boolean prevUseBlkFlags = false;
    private int[] blkFlags;
    private final IntArrayCache.Reference blkFlags_ref;
    private int bbox_spminX;
    private int bbox_spmaxX;
    private int bbox_spminY;
    private int bbox_spmaxY;
    int bboxX0;
    int bboxX1;
    int bboxY0;
    int bboxY1;

    private void quadBreakIntoLinesAndAdd(double x0, double y0, Curve c, double x2, double y2) {
        int count = 1;
        double maxDD = Math.abs(c.dbx) + Math.abs(c.dby);
        double _DEC_BND = QUAD_DEC_BND;
        while (maxDD >= _DEC_BND) {
            maxDD /= 4.0;
            count <<= 1;
            if (!DO_STATS) continue;
            this.rdrCtx.stats.stat_rdr_quadBreak_dec.add(count);
        }
        int nL = count;
        if (count > 1) {
            double icount = 1.0 / (double)count;
            double icount2 = icount * icount;
            double ddx = c.dbx * icount2;
            double ddy = c.dby * icount2;
            double dx = c.bx * icount2 + c.cx * icount;
            double dy = c.by * icount2 + c.cy * icount;
            double x1 = x0;
            double y1 = y0;
            while (--count > 0) {
                this.addLine(x0, y0, x1 += dx, y1 += dy);
                x0 = x1;
                y0 = y1;
                dx += ddx;
                dy += ddy;
            }
        }
        this.addLine(x0, y0, x2, y2);
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_quadBreak.add(nL);
        }
    }

    private void curveBreakIntoLinesAndAdd(double x0, double y0, Curve c, double x3, double y3) {
        int count = 4;
        double icount = 0.25;
        double icount2 = 0.0625;
        double icount3 = 0.015625;
        double dddx = 2.0 * c.dax * 0.015625;
        double dddy = 2.0 * c.day * 0.015625;
        double ddx = dddx + c.dbx * 0.0625;
        double ddy = dddy + c.dby * 0.0625;
        double dx = c.ax * 0.015625 + c.bx * 0.0625 + c.cx * 0.25;
        double dy = c.ay * 0.015625 + c.by * 0.0625 + c.cy * 0.25;
        int nL = 0;
        double _DEC_BND = CUB_DEC_BND;
        double _INC_BND = CUB_INC_BND;
        double x1 = x0;
        double y1 = y0;
        while (count > 0) {
            while (count % 2 == 0 && Math.abs(ddx) + Math.abs(ddy) <= _INC_BND) {
                dx = 2.0 * dx + ddx;
                dy = 2.0 * dy + ddy;
                ddx = 4.0 * (ddx + dddx);
                ddy = 4.0 * (ddy + dddy);
                dddx *= 8.0;
                dddy *= 8.0;
                count >>= 1;
                if (!DO_STATS) continue;
                this.rdrCtx.stats.stat_rdr_curveBreak_inc.add(count);
            }
            while (Math.abs(ddx) + Math.abs(ddy) >= _DEC_BND) {
                ddx = ddx / 4.0 - (dddx /= 8.0);
                ddy = ddy / 4.0 - (dddy /= 8.0);
                dx = (dx - ddx) / 2.0;
                dy = (dy - ddy) / 2.0;
                count <<= 1;
                if (!DO_STATS) continue;
                this.rdrCtx.stats.stat_rdr_curveBreak_dec.add(count);
            }
            if (--count == 0) break;
            ddx += dddx;
            this.addLine(x0, y0, x1 += (dx += ddx), y1 += (dy += (ddy += dddy)));
            x0 = x1;
            y0 = y1;
        }
        this.addLine(x0, y0, x3, y3);
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_curveBreak.add(nL + 1);
        }
    }

    private void addLine(double x1, double y1, double x2, double y2) {
        double slope;
        int lastCrossing;
        int firstCrossing;
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_addLine.add(1);
        }
        int or = 1;
        if (y2 < y1) {
            or = 0;
            double tmp = y2;
            y2 = y1;
            y1 = tmp;
            tmp = x2;
            x2 = x1;
            x1 = tmp;
        }
        if ((firstCrossing = FloatMath.max(FloatMath.ceil_int(y1), this.boundsMinY)) >= (lastCrossing = FloatMath.min(FloatMath.ceil_int(y2), this.boundsMaxY))) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_rdr_addLine_skip.add(1);
            }
            return;
        }
        if (firstCrossing < this.edgeMinY) {
            this.edgeMinY = firstCrossing;
        }
        if (lastCrossing > this.edgeMaxY) {
            this.edgeMaxY = lastCrossing;
        }
        if ((slope = (x1 - x2) / (y1 - y2)) >= 0.0) {
            if (x1 < this.edgeMinX) {
                this.edgeMinX = x1;
            }
            if (x2 > this.edgeMaxX) {
                this.edgeMaxX = x2;
            }
        } else {
            if (x2 < this.edgeMinX) {
                this.edgeMinX = x2;
            }
            if (x1 > this.edgeMaxX) {
                this.edgeMaxX = x1;
            }
        }
        int _SIZEOF_EDGE_BYTES = SIZEOF_EDGE_BYTES;
        OffHeapArray _edges = this.edges;
        int edgePtr = _edges.used;
        if (_edges.length - (long)edgePtr < (long)_SIZEOF_EDGE_BYTES) {
            long edgeNewSize = ArrayCacheConst.getNewLargeSize(_edges.length, edgePtr + _SIZEOF_EDGE_BYTES);
            if (DO_STATS) {
                this.rdrCtx.stats.stat_rdr_edges_resizes.add(edgeNewSize);
            }
            _edges.resize(edgeNewSize);
        }
        Unsafe _unsafe = OffHeapArray.UNSAFE;
        long SIZE_INT = 4L;
        long addr = _edges.address + (long)edgePtr;
        double x1_intercept = x1 + ((double)firstCrossing - y1) * slope;
        long x1_fixed_biased = (long)(4.294967296E9 * x1_intercept) + Integer.MAX_VALUE;
        _unsafe.putInt(addr, (int)(x1_fixed_biased >> 31) & 0xFFFFFFFE | or);
        _unsafe.putInt(addr += 4L, (int)x1_fixed_biased >>> 1);
        long slope_fixed = (long)(4.294967296E9 * slope);
        _unsafe.putInt(addr += 4L, (int)(slope_fixed >> 31) & 0xFFFFFFFE);
        _unsafe.putInt(addr += 4L, (int)slope_fixed >>> 1);
        int[] _edgeBuckets = this.edgeBuckets;
        int[] _edgeBucketCounts = this.edgeBucketCounts;
        int _boundsMinY = this.boundsMinY;
        int bucketIdx = firstCrossing - _boundsMinY;
        _unsafe.putInt(addr += 4L, _edgeBuckets[bucketIdx]);
        _unsafe.putInt(addr += 4L, lastCrossing);
        _edgeBuckets[bucketIdx] = edgePtr;
        int n = bucketIdx;
        _edgeBucketCounts[n] = _edgeBucketCounts[n] + 2;
        int n2 = lastCrossing - _boundsMinY;
        _edgeBucketCounts[n2] = _edgeBucketCounts[n2] | 1;
        _edges.used += _SIZEOF_EDGE_BYTES;
    }

    RendererNoAA(RendererContext rdrCtx) {
        this.rdrCtx = rdrCtx;
        this.curve = rdrCtx.curve;
        this.edges = rdrCtx.rdrMem.edges;
        this.edgeBuckets_ref = rdrCtx.rdrMem.edgeBuckets_ref;
        this.edgeBucketCounts_ref = rdrCtx.rdrMem.edgeBucketCounts_ref;
        this.edgeBuckets = this.edgeBuckets_ref.initial;
        this.edgeBucketCounts = this.edgeBucketCounts_ref.initial;
        this.alphaLine_ref = rdrCtx.rdrMem.alphaLine_ref;
        this.alphaLine = this.alphaLine_ref.initial;
        this.crossings_ref = rdrCtx.rdrMem.crossings_ref;
        this.aux_crossings_ref = rdrCtx.rdrMem.aux_crossings_ref;
        this.edgePtrs_ref = rdrCtx.rdrMem.edgePtrs_ref;
        this.aux_edgePtrs_ref = rdrCtx.rdrMem.aux_edgePtrs_ref;
        this.crossings = this.crossings_ref.initial;
        this.aux_crossings = this.aux_crossings_ref.initial;
        this.edgePtrs = this.edgePtrs_ref.initial;
        this.aux_edgePtrs = this.aux_edgePtrs_ref.initial;
        this.blkFlags_ref = rdrCtx.rdrMem.blkFlags_ref;
        this.blkFlags = this.blkFlags_ref.initial;
    }

    @Override
    public RendererNoAA init(int pix_boundsX, int pix_boundsY, int pix_boundsWidth, int pix_boundsHeight, int windingRule) {
        int edgeBucketsLength;
        this.windingRule = windingRule;
        this.boundsMinX = pix_boundsX;
        this.boundsMaxX = pix_boundsX + pix_boundsWidth;
        this.boundsMinY = pix_boundsY;
        this.boundsMaxY = pix_boundsY + pix_boundsHeight;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("boundsXY = [" + this.boundsMinX + " ... " + this.boundsMaxX + "[ [" + this.boundsMinY + " ... " + this.boundsMaxY + "[");
        }
        if ((edgeBucketsLength = this.boundsMaxY - this.boundsMinY + 1) > INITIAL_BUCKET_ARRAY) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_renderer_edgeBuckets.add(edgeBucketsLength);
                this.rdrCtx.stats.stat_array_renderer_edgeBucketCounts.add(edgeBucketsLength);
            }
            this.edgeBuckets = this.edgeBuckets_ref.getArray(edgeBucketsLength);
            this.edgeBucketCounts = this.edgeBucketCounts_ref.getArray(edgeBucketsLength);
        }
        this.edgeMinY = Integer.MAX_VALUE;
        this.edgeMaxY = Integer.MIN_VALUE;
        this.edgeMinX = Double.POSITIVE_INFINITY;
        this.edgeMaxX = Double.NEGATIVE_INFINITY;
        this.edgeCount = 0;
        this.activeEdgeMaxUsed = 0;
        this.edges.used = 0;
        this.bboxX0 = 0;
        this.bboxX1 = 0;
        return this;
    }

    @Override
    public void dispose() {
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_activeEdges.add(this.activeEdgeMaxUsed);
            this.rdrCtx.stats.stat_rdr_edges.add(this.edges.used);
            this.rdrCtx.stats.stat_rdr_edges_count.add(this.edges.used / SIZEOF_EDGE_BYTES);
            this.rdrCtx.stats.hist_rdr_edges_count.add(this.edges.used / SIZEOF_EDGE_BYTES);
            this.rdrCtx.stats.totalOffHeap += this.edges.length;
        }
        this.crossings = this.crossings_ref.putArray(this.crossings);
        this.aux_crossings = this.aux_crossings_ref.putArray(this.aux_crossings);
        this.edgePtrs = this.edgePtrs_ref.putArray(this.edgePtrs);
        this.aux_edgePtrs = this.aux_edgePtrs_ref.putArray(this.aux_edgePtrs);
        this.alphaLine = this.alphaLine_ref.putArray(this.alphaLine, 0, 0);
        this.blkFlags = this.blkFlags_ref.putArray(this.blkFlags, 0, 0);
        if (this.edgeMinY != Integer.MAX_VALUE) {
            if (this.rdrCtx.dirty) {
                this.buckets_minY = 0;
                this.buckets_maxY = this.boundsMaxY - this.boundsMinY;
            }
            this.edgeBuckets = this.edgeBuckets_ref.putArray(this.edgeBuckets, this.buckets_minY, this.buckets_maxY);
            this.edgeBucketCounts = this.edgeBucketCounts_ref.putArray(this.edgeBucketCounts, this.buckets_minY, this.buckets_maxY + 1);
        } else {
            this.edgeBuckets = this.edgeBuckets_ref.putArray(this.edgeBuckets, 0, 0);
            this.edgeBucketCounts = this.edgeBucketCounts_ref.putArray(this.edgeBucketCounts, 0, 0);
        }
        if (this.edges.length != (long)INITIAL_EDGES_CAPACITY) {
            this.edges.resize(INITIAL_EDGES_CAPACITY);
        }
    }

    private static double tosubpixx(double pix_x) {
        return pix_x;
    }

    private static double tosubpixy(double pix_y) {
        return pix_y - 0.5;
    }

    @Override
    public void moveTo(double pix_x0, double pix_y0) {
        this.closePath();
        double sx = RendererNoAA.tosubpixx(pix_x0);
        double sy = RendererNoAA.tosubpixy(pix_y0);
        this.sx0 = sx;
        this.sy0 = sy;
        this.x0 = sx;
        this.y0 = sy;
    }

    @Override
    public void lineTo(double pix_x1, double pix_y1) {
        double x1 = RendererNoAA.tosubpixx(pix_x1);
        double y1 = RendererNoAA.tosubpixy(pix_y1);
        this.addLine(this.x0, this.y0, x1, y1);
        this.x0 = x1;
        this.y0 = y1;
    }

    @Override
    public void curveTo(double pix_x1, double pix_y1, double pix_x2, double pix_y2, double pix_x3, double pix_y3) {
        double xe = RendererNoAA.tosubpixx(pix_x3);
        double ye = RendererNoAA.tosubpixy(pix_y3);
        this.curve.set(this.x0, this.y0, RendererNoAA.tosubpixx(pix_x1), RendererNoAA.tosubpixy(pix_y1), RendererNoAA.tosubpixx(pix_x2), RendererNoAA.tosubpixy(pix_y2), xe, ye);
        this.curveBreakIntoLinesAndAdd(this.x0, this.y0, this.curve, xe, ye);
        this.x0 = xe;
        this.y0 = ye;
    }

    @Override
    public void quadTo(double pix_x1, double pix_y1, double pix_x2, double pix_y2) {
        double xe = RendererNoAA.tosubpixx(pix_x2);
        double ye = RendererNoAA.tosubpixy(pix_y2);
        this.curve.set(this.x0, this.y0, RendererNoAA.tosubpixx(pix_x1), RendererNoAA.tosubpixy(pix_y1), xe, ye);
        this.quadBreakIntoLinesAndAdd(this.x0, this.y0, this.curve, xe, ye);
        this.x0 = xe;
        this.y0 = ye;
    }

    @Override
    public void closePath() {
        if (this.x0 != this.sx0 || this.y0 != this.sy0) {
            this.addLine(this.x0, this.y0, this.sx0, this.sy0);
            this.x0 = this.sx0;
            this.y0 = this.sy0;
        }
    }

    @Override
    public void pathDone() {
        this.closePath();
        this.endRendering();
    }

    private void _endRendering(int ymin, int ymax, MarlinAlphaConsumer ac) {
        int bboxx0 = this.bbox_spminX;
        int bboxx1 = this.bbox_spmaxX;
        boolean windingRuleEvenOdd = this.windingRule == 0;
        int[] _alpha = this.alphaLine;
        OffHeapArray _edges = this.edges;
        int[] _edgeBuckets = this.edgeBuckets;
        int[] _edgeBucketCounts = this.edgeBucketCounts;
        int[] _crossings = this.crossings;
        int[] _edgePtrs = this.edgePtrs;
        int[] _aux_crossings = this.aux_crossings;
        int[] _aux_edgePtrs = this.aux_edgePtrs;
        long _OFF_ERROR = OFF_ERROR;
        long _OFF_BUMP_X = OFF_BUMP_X;
        long _OFF_BUMP_ERR = OFF_BUMP_ERR;
        long _OFF_NEXT = OFF_NEXT;
        long _OFF_YMAX = OFF_YMAX;
        int _ALL_BUT_LSB = -2;
        int _ERR_STEP_MAX = Integer.MAX_VALUE;
        Unsafe _unsafe = OffHeapArray.UNSAFE;
        long addr0 = _edges.address;
        int _MIN_VALUE = Integer.MIN_VALUE;
        int _MAX_VALUE = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int y = ymin;
        int bucket = y - this.boundsMinY;
        int numCrossings = this.edgeCount;
        int edgePtrsLen = _edgePtrs.length;
        int crossingsLen = _crossings.length;
        int _arrayMaxUsed = this.activeEdgeMaxUsed;
        int ptrLen = 0;
        int[] _blkFlags = this.blkFlags;
        int _BLK_SIZE_LG = BLOCK_SIZE_LG;
        int _BLK_SIZE = BLOCK_SIZE;
        boolean _enableBlkFlagsHeuristics = ENABLE_BLOCK_FLAGS_HEURISTICS && this.enableBlkFlags;
        boolean useBlkFlags = this.prevUseBlkFlags;
        int stroking = this.rdrCtx.stroking;
        int lastY = -1;
        while (y < ymax) {
            int ecur;
            int i;
            long addr;
            int bucketcount = _edgeBucketCounts[bucket];
            int prevNumCrossings = numCrossings;
            if (bucketcount != 0) {
                if (DO_STATS) {
                    this.rdrCtx.stats.stat_rdr_activeEdges_updates.add(numCrossings);
                }
                if ((bucketcount & 1) != 0) {
                    addr = addr0 + _OFF_YMAX;
                    int newCount = 0;
                    for (i = 0; i < numCrossings; ++i) {
                        ecur = _edgePtrs[i];
                        if (_unsafe.getInt(addr + (long)ecur) <= y) continue;
                        _edgePtrs[newCount++] = ecur;
                    }
                    prevNumCrossings = numCrossings = newCount;
                }
                if ((ptrLen = bucketcount >> 1) != 0) {
                    int ptrEnd;
                    if (DO_STATS) {
                        this.rdrCtx.stats.stat_rdr_activeEdges_adds.add(ptrLen);
                        if (ptrLen > 10) {
                            this.rdrCtx.stats.stat_rdr_activeEdges_adds_high.add(ptrLen);
                        }
                    }
                    if (edgePtrsLen < (ptrEnd = numCrossings + ptrLen)) {
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_edgePtrs.add(ptrEnd);
                        }
                        this.edgePtrs = _edgePtrs = this.edgePtrs_ref.widenArray(_edgePtrs, numCrossings, ptrEnd);
                        edgePtrsLen = _edgePtrs.length;
                        this.aux_edgePtrs_ref.putArray(_aux_edgePtrs);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_aux_edgePtrs.add(ptrEnd);
                        }
                        this.aux_edgePtrs = _aux_edgePtrs = this.aux_edgePtrs_ref.getArray(ArrayCacheConst.getNewSize(numCrossings, ptrEnd));
                    }
                    addr = addr0 + _OFF_NEXT;
                    ecur = _edgeBuckets[bucket];
                    while (numCrossings < ptrEnd) {
                        _edgePtrs[numCrossings] = ecur;
                        ecur = _unsafe.getInt(addr + (long)ecur);
                        ++numCrossings;
                    }
                    if (crossingsLen < numCrossings) {
                        this.crossings_ref.putArray(_crossings);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_crossings.add(numCrossings);
                        }
                        this.crossings = _crossings = this.crossings_ref.getArray(numCrossings);
                        this.aux_crossings_ref.putArray(_aux_crossings);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_aux_crossings.add(numCrossings);
                        }
                        this.aux_crossings = _aux_crossings = this.aux_crossings_ref.getArray(numCrossings);
                        crossingsLen = _crossings.length;
                    }
                    if (DO_STATS && numCrossings > _arrayMaxUsed) {
                        _arrayMaxUsed = numCrossings;
                    }
                }
            }
            if (numCrossings != 0) {
                int sum;
                int x1;
                int j;
                int err;
                int cross;
                int curx;
                int lastCross;
                if (ptrLen < 10 || numCrossings < 40) {
                    if (DO_STATS) {
                        this.rdrCtx.stats.hist_rdr_crossings.add(numCrossings);
                        this.rdrCtx.stats.hist_rdr_crossings_adds.add(ptrLen);
                    }
                    boolean useBinarySearch = numCrossings >= 20;
                    lastCross = Integer.MIN_VALUE;
                    for (i = 0; i < numCrossings; ++i) {
                        ecur = _edgePtrs[i];
                        addr = addr0 + (long)ecur;
                        cross = curx = _unsafe.getInt(addr);
                        err = _unsafe.getInt(addr + _OFF_ERROR) + _unsafe.getInt(addr + _OFF_BUMP_ERR);
                        _unsafe.putInt(addr, (curx += _unsafe.getInt(addr + _OFF_BUMP_X)) - (err >> 30 & 0xFFFFFFFE));
                        _unsafe.putInt(addr + _OFF_ERROR, err & Integer.MAX_VALUE);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_rdr_crossings_updates.add(numCrossings);
                        }
                        if (cross < lastCross) {
                            if (DO_STATS) {
                                this.rdrCtx.stats.stat_rdr_crossings_sorts.add(i);
                            }
                            if (useBinarySearch && i >= prevNumCrossings) {
                                if (DO_STATS) {
                                    this.rdrCtx.stats.stat_rdr_crossings_bsearch.add(i);
                                }
                                int low = 0;
                                int high = i - 1;
                                do {
                                    int mid;
                                    if (_crossings[mid = low + high >> 1] < cross) {
                                        low = mid + 1;
                                        continue;
                                    }
                                    high = mid - 1;
                                } while (low <= high);
                                for (j = i - 1; j >= low; --j) {
                                    _crossings[j + 1] = _crossings[j];
                                    _edgePtrs[j + 1] = _edgePtrs[j];
                                }
                                _crossings[low] = cross;
                                _edgePtrs[low] = ecur;
                                continue;
                            }
                            j = i - 1;
                            _crossings[i] = _crossings[j];
                            _edgePtrs[i] = _edgePtrs[j];
                            while (--j >= 0 && _crossings[j] > cross) {
                                _crossings[j + 1] = _crossings[j];
                                _edgePtrs[j + 1] = _edgePtrs[j];
                            }
                            _crossings[j + 1] = cross;
                            _edgePtrs[j + 1] = ecur;
                            continue;
                        }
                        _crossings[i] = lastCross = cross;
                    }
                } else {
                    if (DO_STATS) {
                        this.rdrCtx.stats.stat_rdr_crossings_msorts.add(numCrossings);
                        this.rdrCtx.stats.hist_rdr_crossings_ratio.add(1000 * ptrLen / numCrossings);
                        this.rdrCtx.stats.hist_rdr_crossings_msorts.add(numCrossings);
                        this.rdrCtx.stats.hist_rdr_crossings_msorts_adds.add(ptrLen);
                    }
                    lastCross = Integer.MIN_VALUE;
                    for (i = 0; i < numCrossings; ++i) {
                        ecur = _edgePtrs[i];
                        addr = addr0 + (long)ecur;
                        cross = curx = _unsafe.getInt(addr);
                        err = _unsafe.getInt(addr + _OFF_ERROR) + _unsafe.getInt(addr + _OFF_BUMP_ERR);
                        _unsafe.putInt(addr, (curx += _unsafe.getInt(addr + _OFF_BUMP_X)) - (err >> 30 & 0xFFFFFFFE));
                        _unsafe.putInt(addr + _OFF_ERROR, err & Integer.MAX_VALUE);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_rdr_crossings_updates.add(numCrossings);
                        }
                        if (i >= prevNumCrossings) {
                            _crossings[i] = cross;
                            continue;
                        }
                        if (cross < lastCross) {
                            if (DO_STATS) {
                                this.rdrCtx.stats.stat_rdr_crossings_sorts.add(i);
                            }
                            j = i - 1;
                            _aux_crossings[i] = _aux_crossings[j];
                            _aux_edgePtrs[i] = _aux_edgePtrs[j];
                            while (--j >= 0 && _aux_crossings[j] > cross) {
                                _aux_crossings[j + 1] = _aux_crossings[j];
                                _aux_edgePtrs[j + 1] = _aux_edgePtrs[j];
                            }
                            _aux_crossings[j + 1] = cross;
                            _aux_edgePtrs[j + 1] = ecur;
                            continue;
                        }
                        _aux_crossings[i] = lastCross = cross;
                        _aux_edgePtrs[i] = ecur;
                    }
                    MergeSort.mergeSortNoCopy(_crossings, _edgePtrs, _aux_crossings, _aux_edgePtrs, numCrossings, prevNumCrossings);
                }
                ptrLen = 0;
                int curxo = _crossings[0];
                int x0 = curxo >> 1;
                if (x0 < minX) {
                    minX = x0;
                }
                if ((x1 = _crossings[numCrossings - 1] >> 1) > maxX) {
                    maxX = x1;
                }
                int prev = curx = x0;
                int crorientation = ((curxo & 1) << 1) - 1;
                if (windingRuleEvenOdd) {
                    sum = crorientation;
                    for (i = 1; i < numCrossings; ++i) {
                        curxo = _crossings[i];
                        curx = curxo >> 1;
                        crorientation = ((curxo & 1) << 1) - 1;
                        if ((sum & 1) != 0) {
                            int n = x0 = prev > bboxx0 ? prev : bboxx0;
                            if (curx < bboxx1) {
                                x1 = curx;
                            } else {
                                x1 = bboxx1;
                                i = numCrossings;
                            }
                            if (x0 < x1) {
                                int n2 = x0 -= bboxx0;
                                _alpha[n2] = _alpha[n2] + 1;
                                int n3 = x1 -= bboxx0;
                                _alpha[n3] = _alpha[n3] - 1;
                                if (useBlkFlags) {
                                    _blkFlags[x0 >> _BLK_SIZE_LG] = 1;
                                    _blkFlags[x1 >> _BLK_SIZE_LG] = 1;
                                }
                            }
                        }
                        sum += crorientation;
                        prev = curx;
                    }
                } else {
                    i = 1;
                    sum = 0;
                    while (true) {
                        if ((sum += crorientation) != 0) {
                            if (prev > curx) {
                                prev = curx;
                            }
                        } else {
                            int n = x0 = prev > bboxx0 ? prev : bboxx0;
                            if (curx < bboxx1) {
                                x1 = curx;
                            } else {
                                x1 = bboxx1;
                                i = numCrossings;
                            }
                            if (x0 < x1) {
                                int n4 = x0 -= bboxx0;
                                _alpha[n4] = _alpha[n4] + 1;
                                int n5 = x1 -= bboxx0;
                                _alpha[n5] = _alpha[n5] - 1;
                                if (useBlkFlags) {
                                    _blkFlags[x0 >> _BLK_SIZE_LG] = 1;
                                    _blkFlags[x1 >> _BLK_SIZE_LG] = 1;
                                }
                            }
                            prev = Integer.MAX_VALUE;
                        }
                        if (i == numCrossings) break;
                        curxo = _crossings[i];
                        curx = curxo >> 1;
                        crorientation = ((curxo & 1) << 1) - 1;
                        ++i;
                    }
                }
            }
            lastY = y;
            minX = FloatMath.max(minX, bboxx0);
            if ((maxX = FloatMath.min(maxX, bboxx1)) >= minX) {
                this.copyAARow(_alpha, lastY, minX, maxX + 1, useBlkFlags, ac);
                if (_enableBlkFlagsHeuristics) {
                    boolean bl = useBlkFlags = (maxX -= minX) > _BLK_SIZE && maxX > (numCrossings >> stroking) - 1 << _BLK_SIZE_LG;
                    if (DO_STATS) {
                        int tmp = FloatMath.max(1, (numCrossings >> stroking) - 1);
                        this.rdrCtx.stats.hist_tile_generator_encoding_dist.add(maxX / tmp);
                    }
                }
            } else {
                ac.clearAlphas(lastY);
            }
            minX = Integer.MAX_VALUE;
            maxX = Integer.MIN_VALUE;
            ++y;
            ++bucket;
        }
        --y;
        minX = FloatMath.max(minX, bboxx0);
        if ((maxX = FloatMath.min(maxX, bboxx1)) >= minX) {
            this.copyAARow(_alpha, y, minX, maxX + 1, useBlkFlags, ac);
        } else if (y != lastY) {
            ac.clearAlphas(y);
        }
        this.edgeCount = numCrossings;
        this.prevUseBlkFlags = useBlkFlags;
        if (DO_STATS) {
            this.activeEdgeMaxUsed = _arrayMaxUsed;
        }
    }

    void endRendering() {
        int width;
        if (this.edgeMinY == Integer.MAX_VALUE) {
            return;
        }
        int spminX = FloatMath.max(FloatMath.ceil_int(this.edgeMinX - 0.5), this.boundsMinX);
        int spmaxX = FloatMath.min(FloatMath.ceil_int(this.edgeMaxX - 0.5), this.boundsMaxX);
        int spminY = this.edgeMinY;
        int spmaxY = this.edgeMaxY;
        this.buckets_minY = spminY - this.boundsMinY;
        this.buckets_maxY = spmaxY - this.boundsMinY;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("edgesXY = [" + this.edgeMinX + " ... " + this.edgeMaxX + "[ [" + this.edgeMinY + " ... " + this.edgeMaxY + "[");
            MarlinUtils.logInfo("spXY    = [" + spminX + " ... " + spmaxX + "[ [" + spminY + " ... " + spmaxY + "[");
        }
        if (spminX >= spmaxX || spminY >= spmaxY) {
            return;
        }
        int pminX = spminX;
        int pmaxX = spmaxX;
        int pminY = spminY;
        int pmaxY = spmaxY;
        this.initConsumer(pminX, pminY, pmaxX, pmaxY);
        if (ENABLE_BLOCK_FLAGS) {
            int blkLen;
            this.enableBlkFlags = this.useRLE;
            boolean bl = this.prevUseBlkFlags = this.enableBlkFlags && !ENABLE_BLOCK_FLAGS_HEURISTICS;
            if (this.enableBlkFlags && (blkLen = (pmaxX - pminX >> BLOCK_SIZE_LG) + 2) > 256) {
                this.blkFlags = this.blkFlags_ref.getArray(blkLen);
            }
        }
        this.bbox_spminX = pminX;
        this.bbox_spmaxX = pmaxX;
        this.bbox_spminY = spminY;
        this.bbox_spmaxY = spmaxY;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("pXY       = [" + pminX + " ... " + pmaxX + "[ [" + pminY + " ... " + pmaxY + "[");
            MarlinUtils.logInfo("bbox_spXY = [" + this.bbox_spminX + " ... " + this.bbox_spmaxX + "[ [" + this.bbox_spminY + " ... " + this.bbox_spmaxY + "[");
        }
        if ((width = pmaxX - pminX + 2) > INITIAL_AA_ARRAY) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_renderer_alphaline.add(width);
            }
            this.alphaLine = this.alphaLine_ref.getArray(width);
        }
    }

    void initConsumer(int minx, int miny, int maxx, int maxy) {
        this.bboxX0 = minx;
        this.bboxX1 = maxx;
        this.bboxY0 = miny;
        this.bboxY1 = maxy;
        int width = maxx - minx;
        this.useRLE = FORCE_NO_RLE ? false : (FORCE_RLE ? true : width > RLE_MIN_WIDTH);
    }

    @Override
    public void produceAlphas(MarlinAlphaConsumer ac) {
        ac.setMaxAlpha(1);
        if (this.enableBlkFlags && !ac.supportBlockFlags()) {
            this.enableBlkFlags = false;
            this.prevUseBlkFlags = false;
        }
        this._endRendering(this.bbox_spminY, this.bbox_spmaxY, ac);
    }

    void copyAARow(int[] alphaRow, int pix_y, int pix_from, int pix_to, boolean useBlockFlags, MarlinAlphaConsumer ac) {
        if (DO_STATS) {
            this.rdrCtx.stats.stat_cache_rowAA.add(pix_to - pix_from);
        }
        if (useBlockFlags) {
            if (DO_STATS) {
                this.rdrCtx.stats.hist_tile_generator_encoding.add(1);
            }
            ac.setAndClearRelativeAlphas(this.blkFlags, alphaRow, pix_y, pix_from, pix_to);
        } else {
            if (DO_STATS) {
                this.rdrCtx.stats.hist_tile_generator_encoding.add(0);
            }
            ac.setAndClearRelativeAlphas(alphaRow, pix_y, pix_from, pix_to);
        }
    }

    @Override
    public int getOutpixMinX() {
        return this.bboxX0;
    }

    @Override
    public int getOutpixMaxX() {
        return this.bboxX1;
    }

    @Override
    public int getOutpixMinY() {
        return this.bboxY0;
    }

    @Override
    public int getOutpixMaxY() {
        return this.bboxY1;
    }

    @Override
    public double getOffsetX() {
        return 0.5;
    }

    @Override
    public double getOffsetY() {
        return 0.5;
    }
}

