/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin.stats;

public class StatLong {
    public final String name;
    public long count = 0L;
    public long sum = 0L;
    public long min = Integer.MAX_VALUE;
    public long max = Integer.MIN_VALUE;

    public StatLong(String name) {
        this.name = name;
    }

    public void reset() {
        this.count = 0L;
        this.sum = 0L;
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
    }

    public void add(int val) {
        ++this.count;
        this.sum += (long)val;
        if ((long)val < this.min) {
            this.min = val;
        }
        if ((long)val > this.max) {
            this.max = val;
        }
    }

    public void add(long val) {
        ++this.count;
        this.sum += val;
        if (val < this.min) {
            this.min = val;
        }
        if (val > this.max) {
            this.max = val;
        }
    }

    public String toString() {
        return this.toString(new StringBuilder(128)).toString();
    }

    public final StringBuilder toString(StringBuilder sb) {
        sb.append(this.name).append('[').append(this.count);
        sb.append("] sum: ").append(this.sum).append(" avg: ");
        sb.append(StatLong.trimTo3Digits((double)this.sum / (double)this.count));
        sb.append(" [").append(this.min).append(" | ").append(this.max).append("]");
        return sb;
    }

    public static double trimTo3Digits(double value) {
        return (double)((long)(1000.0 * value)) / 1000.0;
    }
}

