/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGDefaultCamera;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.Material;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.es2.ES2Graphics;
import com.sun.prism.es2.ES2Mesh;
import com.sun.prism.es2.ES2MeshView;
import com.sun.prism.es2.ES2PhongMaterial;
import com.sun.prism.es2.ES2PhongShader;
import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.es2.ES2RTTexture;
import com.sun.prism.es2.ES2RenderTarget;
import com.sun.prism.es2.ES2Shader;
import com.sun.prism.es2.ES2SwapChain;
import com.sun.prism.es2.ES2Texture;
import com.sun.prism.es2.GLContext;
import com.sun.prism.es2.GLDrawable;
import com.sun.prism.es2.GLFactory;
import com.sun.prism.es2.GLPixelFormat;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;

class ES2Context
extends BaseShaderContext {
    private static GeneralTransform3D scratchTx = new GeneralTransform3D();
    private static final GeneralTransform3D flipTx = new GeneralTransform3D();
    private static final Affine3D scratchAffine3DTx = new Affine3D();
    private static float[] rawMatrix = new float[16];
    private GeneralTransform3D projViewTx = new GeneralTransform3D();
    private GeneralTransform3D worldTx = new GeneralTransform3D();
    private Vec3d cameraPos = new Vec3d();
    private RenderTarget currentTarget;
    private final GLContext glContext;
    private final GLDrawable dummyGLDrawable;
    private final GLPixelFormat pixelFormat;
    private BaseShaderContext.State state;
    private int quadIndices;
    private GLDrawable currentDrawable = null;
    private int indexBuffer = 0;
    private int shaderProgram;
    public static final int NUM_QUADS = PrismSettings.superShader ? 4096 : 256;

    ES2Context(Screen screen, ShaderFactory factory) {
        super(screen, factory, NUM_QUADS);
        GLFactory glF = ES2Pipeline.glFactory;
        this.pixelFormat = glF.createGLPixelFormat(screen.getNativeScreen(), ES2Pipeline.pixelFormatAttributes);
        this.dummyGLDrawable = glF.createDummyGLDrawable(this.pixelFormat);
        this.glContext = glF.createGLContext(this.dummyGLDrawable, this.pixelFormat, glF.getShareContext(), PrismSettings.isVsyncEnabled);
        this.makeCurrent(this.dummyGLDrawable);
        this.glContext.enableVertexAttributes();
        this.quadIndices = this.genQuadsIndexBuffer(NUM_QUADS);
        this.setIndexBuffer(this.quadIndices);
        this.state = new BaseShaderContext.State();
    }

    static short[] getQuadIndices16bit(int numQuads) {
        short[] data = new short[numQuads * 6];
        for (int i = 0; i != numQuads; ++i) {
            int vtx = i * 4;
            int idx = i * 6;
            data[idx + 0] = (short)(vtx + 0);
            data[idx + 1] = (short)(vtx + 1);
            data[idx + 2] = (short)(vtx + 2);
            data[idx + 3] = (short)(vtx + 2);
            data[idx + 4] = (short)(vtx + 1);
            data[idx + 5] = (short)(vtx + 3);
        }
        return data;
    }

    int genQuadsIndexBuffer(int numQuads) {
        if (numQuads * 6 > 65536) {
            throw new IllegalArgumentException("vertex indices overflow");
        }
        return this.glContext.createIndexBuffer16(ES2Context.getQuadIndices16bit(numQuads));
    }

    final void clearContext() {
        if (this.currentDrawable != null) {
            this.currentDrawable.swapBuffers(this.glContext);
        }
    }

    final void setIndexBuffer(int ib) {
        if (this.indexBuffer != ib) {
            this.indexBuffer = ib;
            this.glContext.setIndexBuffer(this.indexBuffer);
        }
    }

    GLContext getGLContext() {
        return this.glContext;
    }

    GLPixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    ES2Shader getPhongShader(ES2MeshView meshView) {
        return ES2PhongShader.getShader(meshView, this);
    }

    void makeCurrent(GLDrawable drawable) {
        if (drawable == null) {
            drawable = this.dummyGLDrawable;
        }
        if (drawable != this.currentDrawable) {
            this.glContext.makeCurrent(drawable);
            this.glContext.bindFBO(0);
            this.currentDrawable = drawable;
        }
    }

    void forceRenderTarget(ES2Graphics g) {
        this.updateRenderTarget(g.getRenderTarget(), g.getCameraNoClone(), g.isDepthTest() && g.isDepthBuffer());
    }

    int getShaderProgram() {
        return this.shaderProgram;
    }

    void setShaderProgram(int progid) {
        this.shaderProgram = progid;
        this.glContext.setShaderProgram(progid);
    }

    void updateShaderProgram(int progid) {
        if (progid != this.shaderProgram) {
            this.setShaderProgram(progid);
        }
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    protected void releaseRenderTarget() {
        this.currentTarget = null;
        super.releaseRenderTarget();
    }

    @Override
    protected BaseShaderContext.State updateRenderTarget(RenderTarget target, NGCamera camera, boolean depthTest) {
        int fboID = ((ES2RenderTarget)((Object)target)).getFboID();
        this.glContext.bindFBO(fboID);
        boolean msaa = false;
        if (target instanceof ES2RTTexture) {
            ES2RTTexture rtTarget = (ES2RTTexture)target;
            msaa = rtTarget.isMSAA();
            if (depthTest) {
                rtTarget.attachDepthBuffer(this);
            }
        }
        int x = target.getContentX();
        int y = target.getContentY();
        int w = target.getContentWidth();
        int h = target.getContentHeight();
        this.glContext.updateViewportAndDepthTest(x, y, w, h, depthTest);
        this.glContext.updateMSAAState(msaa);
        if (camera instanceof NGDefaultCamera) {
            ((NGDefaultCamera)camera).validate(w, h);
            scratchTx = camera.getProjViewTx(scratchTx);
        } else {
            scratchTx = camera.getProjViewTx(scratchTx);
            double vw = camera.getViewWidth();
            double vh = camera.getViewHeight();
            if ((double)w != vw || (double)h != vh) {
                scratchTx.scale(vw / (double)w, vh / (double)h, 1.0);
            }
        }
        if (target instanceof ES2RTTexture) {
            this.projViewTx.set(flipTx);
            this.projViewTx.mul(scratchTx);
        } else {
            this.projViewTx.set(scratchTx);
        }
        this.cameraPos = camera.getPositionInWorld(this.cameraPos);
        this.currentTarget = target;
        return this.state;
    }

    @Override
    protected void updateTexture(int texUnit, Texture tex) {
        this.glContext.updateActiveTextureUnit(texUnit);
        if (tex == null) {
            this.glContext.updateBoundTexture(0);
        } else {
            ES2Texture es2Tex = (ES2Texture)tex;
            this.glContext.updateBoundTexture(es2Tex.getNativeSourceHandle());
            es2Tex.updateWrapState();
            es2Tex.updateFilterState();
        }
    }

    @Override
    protected void updateShaderTransform(Shader shader, BaseTransform xform) {
        if (xform == null) {
            xform = BaseTransform.IDENTITY_TRANSFORM;
        }
        scratchTx.set(this.projViewTx);
        GeneralTransform3D perspectiveTransform = this.getPerspectiveTransformNoClone();
        if (perspectiveTransform.isIdentity()) {
            this.updateRawMatrix(scratchTx.mul(xform));
        } else {
            this.updateRawMatrix(scratchTx.mul(xform).mul(perspectiveTransform));
        }
        ES2Shader es2shader = (ES2Shader)shader;
        es2shader.setMatrix("mvpMatrix", rawMatrix);
        if (es2shader.isPixcoordUsed()) {
            float yflip;
            float yinv;
            float xoff = this.currentTarget.getContentX();
            float yoff = this.currentTarget.getContentY();
            if (this.currentTarget instanceof ES2SwapChain) {
                yinv = this.currentTarget.getPhysicalHeight();
                yflip = 1.0f;
            } else {
                yinv = 0.0f;
                yflip = -1.0f;
            }
            shader.setConstant("jsl_pixCoordOffset", xoff, yoff, yinv, yflip);
        }
    }

    @Override
    protected void updateWorldTransform(BaseTransform xform) {
        this.worldTx.setIdentity();
        if (xform != null && !xform.isIdentity()) {
            this.worldTx.mul(xform);
        }
    }

    @Override
    protected void updateClipRect(Rectangle clipRect) {
        if (clipRect == null || clipRect.isEmpty()) {
            this.glContext.scissorTest(false, 0, 0, 0, 0);
        } else {
            int w = clipRect.width;
            int h = clipRect.height;
            int x = this.currentTarget.getContentX();
            int y = this.currentTarget.getContentY();
            if (this.currentTarget instanceof ES2RTTexture) {
                x += clipRect.x;
                y += clipRect.y;
            } else {
                int dsth = this.currentTarget.getPhysicalHeight();
                x += clipRect.x;
                y += dsth - (clipRect.y + h);
            }
            this.glContext.scissorTest(true, x, y, w, h);
        }
    }

    @Override
    protected void updateCompositeMode(CompositeMode mode) {
        switch (mode) {
            case CLEAR: {
                this.glContext.blendFunc(0, 0);
                break;
            }
            case SRC: {
                this.glContext.blendFunc(1, 0);
                break;
            }
            case SRC_OVER: {
                this.glContext.blendFunc(1, 7);
                break;
            }
            case DST_OUT: {
                this.glContext.blendFunc(0, 7);
                break;
            }
            case ADD: {
                this.glContext.blendFunc(1, 1);
                break;
            }
            default: {
                throw new InternalError("Unrecognized composite mode: " + mode);
            }
        }
    }

    @Override
    public void setDeviceParametersFor2D() {
        this.indexBuffer = 0;
        this.shaderProgram = 0;
        this.glContext.setDeviceParametersFor2D();
        this.glContext.enableVertexAttributes();
        this.setIndexBuffer(this.quadIndices);
    }

    @Override
    public void setDeviceParametersFor3D() {
        this.glContext.disableVertexAttributes();
        this.glContext.setDeviceParametersFor3D();
    }

    long createES2Mesh() {
        return this.glContext.createES2Mesh();
    }

    void releaseES2Mesh(long nativeHandle) {
        this.glContext.releaseES2Mesh(nativeHandle);
    }

    boolean buildNativeGeometry(long nativeHandle, float[] vertexBuffer, int vertexBufferLength, short[] indexBuffer, int indexBufferLength) {
        return this.glContext.buildNativeGeometry(nativeHandle, vertexBuffer, vertexBufferLength, indexBuffer, indexBufferLength);
    }

    boolean buildNativeGeometry(long nativeHandle, float[] vertexBuffer, int vertexBufferLength, int[] indexBuffer, int indexBufferLength) {
        return this.glContext.buildNativeGeometry(nativeHandle, vertexBuffer, vertexBufferLength, indexBuffer, indexBufferLength);
    }

    long createES2PhongMaterial() {
        return this.glContext.createES2PhongMaterial();
    }

    void releaseES2PhongMaterial(long nativeHandle) {
        this.glContext.releaseES2PhongMaterial(nativeHandle);
    }

    void setSolidColor(long nativeHandle, float r, float g, float b, float a) {
        this.glContext.setSolidColor(nativeHandle, r, g, b, a);
    }

    void setMap(long nativeHandle, int mapType, int texID) {
        this.glContext.setMap(nativeHandle, mapType, texID);
    }

    long createES2MeshView(ES2Mesh mesh) {
        return this.glContext.createES2MeshView(mesh.getNativeHandle());
    }

    void releaseES2MeshView(long nativeHandle) {
        this.glContext.releaseES2MeshView(nativeHandle);
    }

    void setCullingMode(long nativeHandle, int cullingMode) {
        this.glContext.setCullingMode(nativeHandle, cullingMode);
    }

    void setMaterial(long nativeHandle, Material material) {
        ES2PhongMaterial es2Material = (ES2PhongMaterial)material;
        this.glContext.setMaterial(nativeHandle, es2Material.getNativeHandle());
    }

    void setWireframe(long nativeHandle, boolean wireframe) {
        this.glContext.setWireframe(nativeHandle, wireframe);
    }

    void setAmbientLight(long nativeHandle, float r, float g, float b) {
        this.glContext.setAmbientLight(nativeHandle, r, g, b);
    }

    void setLight(long nativeHandle, int index, float x, float y, float z, float r, float g, float b, float w, float ca, float la, float qa, float isAttenuated, float maxRange, float dirX, float dirY, float dirZ, float innerAngle, float outerAngle, float falloff) {
        this.glContext.setLight(nativeHandle, index, x, y, z, r, g, b, w, ca, la, qa, isAttenuated, maxRange, dirX, dirY, dirZ, innerAngle, outerAngle, falloff);
    }

    @Override
    public void blit(RTTexture srcRTT, RTTexture dstRTT, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1) {
        int dstFboID = dstRTT == null ? 0 : ((ES2RTTexture)dstRTT).getFboID();
        int srcFboID = ((ES2RTTexture)srcRTT).getFboID();
        this.glContext.blitFBO(srcFboID, dstFboID, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1);
    }

    void renderMeshView(long nativeHandle, Graphics g, ES2MeshView meshView) {
        ES2Shader shader = this.getPhongShader(meshView);
        this.setShaderProgram(shader.getProgramObject());
        float pixelScaleFactorX = g.getPixelScaleFactorX();
        float pixelScaleFactorY = g.getPixelScaleFactorY();
        if ((double)pixelScaleFactorX != 1.0 || (double)pixelScaleFactorY != 1.0) {
            scratchTx = scratchTx.set(this.projViewTx);
            scratchTx.scale(pixelScaleFactorX, pixelScaleFactorY, 1.0);
            this.updateRawMatrix(scratchTx);
        } else {
            this.updateRawMatrix(this.projViewTx);
        }
        shader.setMatrix("viewProjectionMatrix", rawMatrix);
        shader.setConstant("camPos", (float)this.cameraPos.x, (float)this.cameraPos.y, (float)this.cameraPos.z);
        BaseTransform xform = g.getTransformNoClone();
        if ((double)pixelScaleFactorX != 1.0 || (double)pixelScaleFactorY != 1.0) {
            scratchAffine3DTx.setToIdentity();
            scratchAffine3DTx.scale(1.0 / (double)pixelScaleFactorX, 1.0 / (double)pixelScaleFactorY);
            scratchAffine3DTx.concatenate(xform);
            this.updateWorldTransform(scratchAffine3DTx);
        } else {
            this.updateWorldTransform(xform);
        }
        this.updateRawMatrix(this.worldTx);
        shader.setMatrix("worldMatrix", rawMatrix);
        ES2PhongShader.setShaderParamaters(shader, meshView, this);
        this.glContext.renderMeshView(nativeHandle);
    }

    @Override
    protected void renderQuads(float[] coordArray, byte[] colorArray, int numVertices) {
        this.glContext.drawIndexedQuads(coordArray, colorArray, numVertices);
    }

    void printRawMatrix(String mesg) {
        System.err.println(mesg + " = ");
        for (int i = 0; i < 4; ++i) {
            System.err.println(rawMatrix[i] + ", " + rawMatrix[i + 4] + ", " + rawMatrix[i + 8] + ", " + rawMatrix[i + 12]);
        }
    }

    private void updateRawMatrix(GeneralTransform3D src) {
        ES2Context.rawMatrix[0] = (float)src.get(0);
        ES2Context.rawMatrix[1] = (float)src.get(4);
        ES2Context.rawMatrix[2] = (float)src.get(8);
        ES2Context.rawMatrix[3] = (float)src.get(12);
        ES2Context.rawMatrix[4] = (float)src.get(1);
        ES2Context.rawMatrix[5] = (float)src.get(5);
        ES2Context.rawMatrix[6] = (float)src.get(9);
        ES2Context.rawMatrix[7] = (float)src.get(13);
        ES2Context.rawMatrix[8] = (float)src.get(2);
        ES2Context.rawMatrix[9] = (float)src.get(6);
        ES2Context.rawMatrix[10] = (float)src.get(10);
        ES2Context.rawMatrix[11] = (float)src.get(14);
        ES2Context.rawMatrix[12] = (float)src.get(3);
        ES2Context.rawMatrix[13] = (float)src.get(7);
        ES2Context.rawMatrix[14] = (float)src.get(11);
        ES2Context.rawMatrix[15] = (float)src.get(15);
    }

    static {
        BaseTransform tx = Affine2D.getScaleInstance(1.0, -1.0);
        flipTx.setIdentity();
        flipTx.mul(tx);
    }
}

