/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.Graphics;
import com.sun.prism.Material;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Light;
import com.sun.prism.es2.ES2Mesh;
import com.sun.prism.es2.ES2PhongMaterial;
import com.sun.prism.impl.BaseMeshView;
import com.sun.prism.impl.Disposer;

class ES2MeshView
extends BaseMeshView {
    static int count = 0;
    private final ES2Context context;
    private final long nativeHandle;
    private float ambientLightRed = 0.0f;
    private float ambientLightBlue = 0.0f;
    private float ambientLightGreen = 0.0f;
    private ES2Light[] lights = new ES2Light[3];
    private final ES2Mesh mesh;
    private ES2PhongMaterial material;

    private ES2MeshView(ES2Context context, long nativeHandle, ES2Mesh mesh, Disposer.Record disposerRecord) {
        super(disposerRecord);
        this.context = context;
        this.mesh = mesh;
        this.nativeHandle = nativeHandle;
        ++count;
    }

    static ES2MeshView create(ES2Context context, ES2Mesh mesh) {
        long nativeHandle = context.createES2MeshView(mesh);
        return new ES2MeshView(context, nativeHandle, mesh, new ES2MeshViewDisposerRecord(context, nativeHandle));
    }

    @Override
    public void setCullingMode(int cullingMode) {
        this.context.setCullingMode(this.nativeHandle, cullingMode);
    }

    @Override
    public void setMaterial(Material material) {
        this.context.setMaterial(this.nativeHandle, material);
        this.material = (ES2PhongMaterial)material;
    }

    @Override
    public void setWireframe(boolean wireframe) {
        this.context.setWireframe(this.nativeHandle, wireframe);
    }

    @Override
    public void setAmbientLight(float r, float g, float b) {
        this.ambientLightRed = r;
        this.ambientLightGreen = g;
        this.ambientLightBlue = b;
        this.context.setAmbientLight(this.nativeHandle, r, g, b);
    }

    float getAmbientLightRed() {
        return this.ambientLightRed;
    }

    float getAmbientLightGreen() {
        return this.ambientLightGreen;
    }

    float getAmbientLightBlue() {
        return this.ambientLightBlue;
    }

    @Override
    public void setLight(int index, float x, float y, float z, float r, float g, float b, float w, float ca, float la, float qa, float isAttenuated, float maxRange, float dirX, float dirY, float dirZ, float innerAngle, float outerAngle, float falloff) {
        if (index >= 0 && index <= 2) {
            this.lights[index] = new ES2Light(x, y, z, r, g, b, w, ca, la, qa, isAttenuated, maxRange, dirX, dirY, dirZ, innerAngle, outerAngle, falloff);
            this.context.setLight(this.nativeHandle, index, x, y, z, r, g, b, w, ca, la, qa, isAttenuated, maxRange, dirX, dirY, dirZ, innerAngle, outerAngle, falloff);
        }
    }

    ES2Light[] getLights() {
        return this.lights;
    }

    @Override
    public void render(Graphics g) {
        this.material.lockTextureMaps();
        this.context.renderMeshView(this.nativeHandle, g, this);
        this.material.unlockTextureMaps();
    }

    ES2PhongMaterial getMaterial() {
        return this.material;
    }

    @Override
    public void dispose() {
        this.material = null;
        this.lights = null;
        this.disposerRecord.dispose();
        --count;
    }

    public int getCount() {
        return count;
    }

    static class ES2MeshViewDisposerRecord
    implements Disposer.Record {
        private final ES2Context context;
        private long nativeHandle;

        ES2MeshViewDisposerRecord(ES2Context context, long nativeHandle) {
            this.context = context;
            this.nativeHandle = nativeHandle;
        }

        void traceDispose() {
        }

        @Override
        public void dispose() {
            if (this.nativeHandle != 0L) {
                this.traceDispose();
                this.context.releaseES2MeshView(this.nativeHandle);
                this.nativeHandle = 0L;
            }
        }
    }
}

