/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.GLContext;
import com.sun.prism.impl.BaseGraphicsResource;
import com.sun.prism.impl.Disposer;
import com.sun.prism.ps.Shader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ES2Shader
extends BaseGraphicsResource
implements Shader {
    private int programID;
    private final ES2Context context;
    private final Map<String, Uniform> uniforms = new HashMap<String, Uniform>();
    private final int maxTexCoordIndex;
    private final boolean isPixcoordUsed;
    private boolean valid;
    private float[] currentMatrix;

    private ES2Shader(ES2Context context, int programID, int vertexShaderID, int[] fragmentShaderID, Map<String, Integer> samplers, int maxTexCoordIndex, boolean isPixcoordUsed) throws RuntimeException {
        super(new ES2ShaderDisposerRecord(context, vertexShaderID, fragmentShaderID, programID));
        this.context = context;
        this.programID = programID;
        this.maxTexCoordIndex = maxTexCoordIndex;
        this.isPixcoordUsed = isPixcoordUsed;
        boolean bl = this.valid = programID != 0;
        if (this.valid && samplers != null) {
            int currentProgram = context.getShaderProgram();
            context.setShaderProgram(programID);
            for (String key : samplers.keySet()) {
                this.setConstant(key, samplers.get(key));
            }
            context.setShaderProgram(currentProgram);
        }
    }

    static ES2Shader createFromSource(ES2Context context, String vert, String[] frag, Map<String, Integer> samplers, Map<String, Integer> attributes, int maxTexCoordIndex, boolean isPixcoordUsed) {
        GLContext glCtx = context.getGLContext();
        if (!glCtx.isShaderCompilerSupported()) {
            throw new RuntimeException("Shader compiler not available on this device");
        }
        if (vert == null || frag == null || frag.length == 0) {
            throw new RuntimeException("Both vertexShaderSource and fragmentShaderSource must be specified");
        }
        int vertexShaderID = glCtx.compileShader(vert, true);
        if (vertexShaderID == 0) {
            throw new RuntimeException("Error creating vertex shader");
        }
        int[] fragmentShaderID = new int[frag.length];
        for (int i = 0; i < frag.length; ++i) {
            fragmentShaderID[i] = glCtx.compileShader(frag[i], false);
            if (fragmentShaderID[i] != 0) continue;
            glCtx.deleteShader(vertexShaderID);
            throw new RuntimeException("Error creating fragment shader");
        }
        String[] attrs = new String[attributes.size()];
        int[] indexs = new int[attrs.length];
        int i = 0;
        Iterator<String> iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            String attr;
            attrs[i] = attr = iterator.next();
            indexs[i] = attributes.get(attr);
            ++i;
        }
        int programID = glCtx.createProgram(vertexShaderID, fragmentShaderID, attrs, indexs);
        if (programID == 0) {
            throw new RuntimeException("Error creating shader program");
        }
        return new ES2Shader(context, programID, vertexShaderID, fragmentShaderID, samplers, maxTexCoordIndex, isPixcoordUsed);
    }

    static ES2Shader createFromSource(ES2Context context, String vert, InputStream frag, Map<String, Integer> samplers, Map<String, Integer> attributes, int maxTexCoordIndex, boolean isPixcoordUsed) {
        String[] fragmentShaderSource = new String[]{ES2Shader.readStreamIntoString(frag)};
        return ES2Shader.createFromSource(context, vert, fragmentShaderSource, samplers, attributes, maxTexCoordIndex, isPixcoordUsed);
    }

    static String readStreamIntoString(InputStream in) {
        StringBuffer sb = new StringBuffer(1024);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            char[] chars = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(chars)) > -1) {
                sb.append(String.valueOf(chars, 0, numRead));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading shader stream");
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error closing reader");
            }
        }
        return sb.toString();
    }

    public int getProgramObject() {
        return this.programID;
    }

    public int getMaxTexCoordIndex() {
        return this.maxTexCoordIndex;
    }

    public boolean isPixcoordUsed() {
        return this.isPixcoordUsed;
    }

    private Uniform getUniform(String name) {
        Uniform uniform = this.uniforms.get(name);
        if (uniform == null) {
            int loc = this.context.getGLContext().getUniformLocation(this.programID, name);
            uniform = new Uniform();
            uniform.location = loc;
            this.uniforms.put(name, uniform);
        }
        return uniform;
    }

    @Override
    public void enable() throws RuntimeException {
        this.context.updateShaderProgram(this.programID);
    }

    @Override
    public void disable() throws RuntimeException {
        this.context.updateShaderProgram(0);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setConstant(String name, int i0) throws RuntimeException {
        int[] values;
        Uniform uniform = this.getUniform(name);
        if (uniform.location == -1) {
            return;
        }
        if (uniform.values == null) {
            uniform.values = new int[1];
        }
        if ((values = (int[])uniform.values)[0] != i0) {
            values[0] = i0;
            this.context.getGLContext().uniform1i(uniform.location, i0);
        }
    }

    @Override
    public void setConstant(String name, int i0, int i1) throws RuntimeException {
        int[] values;
        Uniform uniform = this.getUniform(name);
        if (uniform.location == -1) {
            return;
        }
        if (uniform.values == null) {
            uniform.values = new int[2];
        }
        if ((values = (int[])uniform.values)[0] != i0 || values[1] != i1) {
            values[0] = i0;
            values[1] = i1;
            this.context.getGLContext().uniform2i(uniform.location, i0, i1);
        }
    }

    @Override
    public void setConstant(String name, int i0, int i1, int i2) throws RuntimeException {
        int[] values;
        Uniform uniform = this.getUniform(name);
        if (uniform.location == -1) {
            return;
        }
        if (uniform.values == null) {
            uniform.values = new int[3];
        }
        if ((values = (int[])uniform.values)[0] != i0 || values[1] != i1 || values[2] != i2) {
            values[0] = i0;
            values[1] = i1;
            values[2] = i2;
            this.context.getGLContext().uniform3i(uniform.location, i0, i1, i2);
        }
    }

    @Override
    public void setConstant(String name, int i0, int i1, int i2, int i3) throws RuntimeException {
        int[] values;
        Uniform uniform = this.getUniform(name);
        if (uniform.location == -1) {
            return;
        }
        if (uniform.values == null) {
            uniform.values = new int[4];
        }
        if ((values = (int[])uniform.values)[0] != i0 || values[1] != i1 || values[2] != i2 || values[3] != i3) {
            values[0] = i0;
            values[1] = i1;
            values[2] = i2;
            values[3] = i3;
            this.context.getGLContext().uniform4i(uniform.location, i0, i1, i2, i3);
        }
    }

    @Override
    public void setConstant(String name, float f0) throws RuntimeException {
        float[] values;
        Uniform uniform = this.getUniform(name);
        if (uniform.location == -1) {
            return;
        }
        if (uniform.values == null) {
            uniform.values = new float[1];
        }
        if ((values = (float[])uniform.values)[0] != f0) {
            values[0] = f0;
            this.context.getGLContext().uniform1f(uniform.location, f0);
        }
    }

    @Override
    public void setConstant(String name, float f0, float f1) throws RuntimeException {
        float[] values;
        Uniform uniform = this.getUniform(name);
        if (uniform.location == -1) {
            return;
        }
        if (uniform.values == null) {
            uniform.values = new float[2];
        }
        if ((values = (float[])uniform.values)[0] != f0 || values[1] != f1) {
            values[0] = f0;
            values[1] = f1;
            this.context.getGLContext().uniform2f(uniform.location, f0, f1);
        }
    }

    @Override
    public void setConstant(String name, float f0, float f1, float f2) throws RuntimeException {
        float[] values;
        Uniform uniform = this.getUniform(name);
        if (uniform.location == -1) {
            return;
        }
        if (uniform.values == null) {
            uniform.values = new float[3];
        }
        if ((values = (float[])uniform.values)[0] != f0 || values[1] != f1 || values[2] != f2) {
            values[0] = f0;
            values[1] = f1;
            values[2] = f2;
            this.context.getGLContext().uniform3f(uniform.location, f0, f1, f2);
        }
    }

    @Override
    public void setConstant(String name, float f0, float f1, float f2, float f3) throws RuntimeException {
        float[] values;
        Uniform uniform = this.getUniform(name);
        if (uniform.location == -1) {
            return;
        }
        if (uniform.values == null) {
            uniform.values = new float[4];
        }
        if ((values = (float[])uniform.values)[0] != f0 || values[1] != f1 || values[2] != f2 || values[3] != f3) {
            values[0] = f0;
            values[1] = f1;
            values[2] = f2;
            values[3] = f3;
            this.context.getGLContext().uniform4f(uniform.location, f0, f1, f2, f3);
        }
    }

    @Override
    public void setConstants(String name, IntBuffer buf, int off, int count) throws RuntimeException {
        int loc = this.getUniform((String)name).location;
        if (loc == -1) {
            return;
        }
        this.context.getGLContext().uniform4iv(loc, count, buf);
    }

    @Override
    public void setConstants(String name, FloatBuffer buf, int off, int count) throws RuntimeException {
        int loc = this.getUniform((String)name).location;
        if (loc == -1) {
            return;
        }
        this.context.getGLContext().uniform4fv(loc, count, buf);
    }

    public void setMatrix(String name, float[] buf) throws RuntimeException {
        int loc = this.getUniform((String)name).location;
        if (loc == -1) {
            return;
        }
        if (this.currentMatrix == null) {
            this.currentMatrix = new float[16];
        }
        if (!Arrays.equals(this.currentMatrix, buf)) {
            this.context.getGLContext().uniformMatrix4fv(loc, false, buf);
            System.arraycopy(buf, 0, this.currentMatrix, 0, buf.length);
        }
    }

    @Override
    public void dispose() throws RuntimeException {
        if (this.programID != 0) {
            this.disposerRecord.dispose();
            this.programID = 0;
        }
        this.valid = false;
    }

    private static class ES2ShaderDisposerRecord
    implements Disposer.Record {
        private final ES2Context context;
        private int vertexShaderID;
        private int[] fragmentShaderID;
        private int programID;

        private ES2ShaderDisposerRecord(ES2Context context, int vertexShaderID, int[] fragmentShaderID, int programID) {
            this.context = context;
            this.vertexShaderID = vertexShaderID;
            this.fragmentShaderID = fragmentShaderID;
            this.programID = programID;
        }

        @Override
        public void dispose() {
            if (this.programID != 0) {
                this.context.getGLContext().disposeShaders(this.programID, this.vertexShaderID, this.fragmentShaderID);
                this.vertexShaderID = 0;
                this.programID = 0;
                this.fragmentShaderID = null;
            }
        }
    }

    private static class Uniform {
        private int location;
        private Object values;

        private Uniform() {
        }
    }
}

