/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.javafx.PlatformUtil;
import com.sun.prism.MeshView;
import com.sun.prism.PhongMaterial;
import com.sun.prism.Texture;
import com.sun.prism.es2.BufferFactory;
import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.es2.GLDrawable;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

abstract class GLContext {
    static final int GL_ZERO = 0;
    static final int GL_ONE = 1;
    static final int GL_SRC_COLOR = 2;
    static final int GL_ONE_MINUS_SRC_COLOR = 3;
    static final int GL_DST_COLOR = 4;
    static final int GL_ONE_MINUS_DST_COLOR = 5;
    static final int GL_SRC_ALPHA = 6;
    static final int GL_ONE_MINUS_SRC_ALPHA = 7;
    static final int GL_DST_ALPHA = 8;
    static final int GL_ONE_MINUS_DST_ALPHA = 9;
    static final int GL_CONSTANT_COLOR = 10;
    static final int GL_ONE_MINUS_CONSTANT_COLOR = 11;
    static final int GL_CONSTANT_ALPHA = 12;
    static final int GL_ONE_MINUS_CONSTANT_ALPHA = 13;
    static final int GL_SRC_ALPHA_SATURATE = 14;
    static final int GL_FLOAT = 20;
    static final int GL_UNSIGNED_BYTE = 21;
    static final int GL_UNSIGNED_INT_8_8_8_8_REV = 22;
    static final int GL_UNSIGNED_INT_8_8_8_8 = 23;
    static final int GL_UNSIGNED_SHORT_8_8_APPLE = 24;
    static final int GL_RGBA = 40;
    static final int GL_BGRA = 41;
    static final int GL_RGB = 42;
    static final int GL_LUMINANCE = 43;
    static final int GL_ALPHA = 44;
    static final int GL_RGBA32F = 45;
    static final int GL_YCBCR_422_APPLE = 46;
    static final int GL_TEXTURE_2D = 50;
    static final int GL_TEXTURE_BINDING_2D = 51;
    static final int GL_NEAREST = 52;
    static final int GL_LINEAR = 53;
    static final int GL_NEAREST_MIPMAP_NEAREST = 54;
    static final int GL_LINEAR_MIPMAP_LINEAR = 55;
    static final int GL_UNPACK_ALIGNMENT = 60;
    static final int GL_UNPACK_ROW_LENGTH = 61;
    static final int GL_UNPACK_SKIP_PIXELS = 62;
    static final int GL_UNPACK_SKIP_ROWS = 63;
    static final int WRAPMODE_REPEAT = 100;
    static final int WRAPMODE_CLAMP_TO_EDGE = 101;
    static final int WRAPMODE_CLAMP_TO_BORDER = 102;
    static final int GL_BACK = 110;
    static final int GL_FRONT = 111;
    static final int GL_NONE = 112;
    static final int GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 120;
    static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 121;
    static final int GL_MAX_TEXTURE_IMAGE_UNITS = 122;
    static final int GL_MAX_TEXTURE_SIZE = 123;
    static final int GL_MAX_VERTEX_ATTRIBS = 124;
    static final int GL_MAX_VARYING_COMPONENTS = 125;
    static final int GL_MAX_VARYING_VECTORS = 126;
    static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 127;
    static final int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 128;
    static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 129;
    static final int MAPTYPE_DIFFUSE = PhongMaterial.MapType.DIFFUSE.ordinal();
    static final int MAPTYPE_SPECULAR = PhongMaterial.MapType.SPECULAR.ordinal();
    static final int MAPTYPE_BUMP = PhongMaterial.MapType.BUMP.ordinal();
    static final int MAPTYPE_SELFILLUM = PhongMaterial.MapType.SELF_ILLUM.ordinal();
    static final int NUM_MATRIX_ELEMENTS = 16;
    long nativeCtxInfo;
    private int maxTextureSize = -1;
    private Boolean nonPowTwoExtAvailable;
    private Boolean clampToZeroAvailable;
    private int activeTexUnit;
    private int[] boundTextures = new int[4];
    private int viewportX;
    private int viewportY;
    private int viewportWidth;
    private int viewportHeight;
    private boolean depthTest = false;
    private boolean msaa = false;
    private int maxSampleSize = -1;
    private static final int FBO_ID_UNSET = -1;
    private static final int FBO_ID_NOCACHE = -2;
    private int nativeFBOID = PlatformUtil.isMac() || PlatformUtil.isIOS() ? -2 : -1;

    GLContext() {
    }

    private static native void nActiveTexture(long var0, int var2);

    private static native void nBindFBO(long var0, int var2);

    private static native void nBindTexture(long var0, int var2);

    private static native void nBlendFunc(int var0, int var1);

    private static native void nClearBuffers(long var0, float var2, float var3, float var4, float var5, boolean var6, boolean var7, boolean var8);

    private static native int nCompileShader(long var0, String var2, boolean var3);

    private static native int nCreateDepthBuffer(long var0, int var2, int var3, int var4);

    private static native int nCreateRenderBuffer(long var0, int var2, int var3, int var4);

    private static native int nCreateFBO(long var0, int var2);

    private static native int nCreateProgram(long var0, int var2, int[] var3, int var4, String[] var5, int[] var6);

    private static native int nCreateTexture(long var0, int var2, int var3);

    private static native void nDeleteRenderBuffer(long var0, int var2);

    private static native void nDeleteFBO(long var0, int var2);

    private static native void nDeleteShader(long var0, int var2);

    private static native void nDeleteTexture(long var0, int var2);

    private static native void nDisposeShaders(long var0, int var2, int var3, int[] var4);

    private static native void nFinish();

    private static native int nGenAndBindTexture();

    private static native int nGetFBO();

    private static native int nGetIntParam(int var0);

    private static native int nGetMaxSampleSize();

    private static native int nGetUniformLocation(long var0, int var2, String var3);

    private static native void nPixelStorei(int var0, int var1);

    private static native boolean nReadPixelsByte(long var0, int var2, Buffer var3, byte[] var4, int var5, int var6, int var7, int var8);

    private static native boolean nReadPixelsInt(long var0, int var2, Buffer var3, int[] var4, int var5, int var6, int var7, int var8);

    private static native void nScissorTest(long var0, boolean var2, int var3, int var4, int var5, int var6);

    private static native void nSetDepthTest(long var0, boolean var2);

    private static native void nSetMSAA(long var0, boolean var2);

    private static native void nTexParamsMinMax(int var0, int var1);

    private static native boolean nTexImage2D0(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Object var8, int var9, boolean var10);

    private static native boolean nTexImage2D1(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Object var8, int var9, boolean var10);

    private static native void nTexSubImage2D0(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Object var8, int var9);

    private static native void nTexSubImage2D1(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, Object var8, int var9);

    private static native void nUpdateViewport(long var0, int var2, int var3, int var4, int var5);

    private static native void nUniform1f(long var0, int var2, float var3);

    private static native void nUniform2f(long var0, int var2, float var3, float var4);

    private static native void nUniform3f(long var0, int var2, float var3, float var4, float var5);

    private static native void nUniform4f(long var0, int var2, float var3, float var4, float var5, float var6);

    private static native void nUniform4fv0(long var0, int var2, int var3, Object var4, int var5);

    private static native void nUniform4fv1(long var0, int var2, int var3, Object var4, int var5);

    private static native void nUniform1i(long var0, int var2, int var3);

    private static native void nUniform2i(long var0, int var2, int var3, int var4);

    private static native void nUniform3i(long var0, int var2, int var3, int var4, int var5);

    private static native void nUniform4i(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void nUniform4iv0(long var0, int var2, int var3, Object var4, int var5);

    private static native void nUniform4iv1(long var0, int var2, int var3, Object var4, int var5);

    private static native void nUniformMatrix4fv(long var0, int var2, boolean var3, float[] var4);

    private static native void nUpdateFilterState(long var0, int var2, boolean var3);

    private static native void nUpdateWrapState(long var0, int var2, int var3);

    private static native void nUseProgram(long var0, int var2);

    private static native void nEnableVertexAttributes(long var0);

    private static native void nDisableVertexAttributes(long var0);

    private static native void nDrawIndexedQuads(long var0, int var2, float[] var3, byte[] var4);

    private static native int nCreateIndexBuffer16(long var0, short[] var2, int var3);

    private static native void nSetIndexBuffer(long var0, int var2);

    private static native void nSetDeviceParametersFor2D(long var0);

    private static native void nSetDeviceParametersFor3D(long var0);

    private static native long nCreateES2Mesh(long var0);

    private static native void nReleaseES2Mesh(long var0, long var2);

    private static native boolean nBuildNativeGeometryShort(long var0, long var2, float[] var4, int var5, short[] var6, int var7);

    private static native boolean nBuildNativeGeometryInt(long var0, long var2, float[] var4, int var5, int[] var6, int var7);

    private static native long nCreateES2PhongMaterial(long var0);

    private static native void nReleaseES2PhongMaterial(long var0, long var2);

    private static native void nSetSolidColor(long var0, long var2, float var4, float var5, float var6, float var7);

    private static native void nSetMap(long var0, long var2, int var4, int var5);

    private static native long nCreateES2MeshView(long var0, long var2);

    private static native void nReleaseES2MeshView(long var0, long var2);

    private static native void nSetCullingMode(long var0, long var2, int var4);

    private static native void nSetMaterial(long var0, long var2, long var4);

    private static native void nSetWireframe(long var0, long var2, boolean var4);

    private static native void nSetAmbientLight(long var0, long var2, float var4, float var5, float var6);

    private static native void nSetLight(long var0, long var2, int var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22);

    private static native void nRenderMeshView(long var0, long var2);

    private static native void nBlit(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    void activeTexture(int texUnit) {
        GLContext.nActiveTexture(this.nativeCtxInfo, texUnit);
    }

    void bindFBO(int nativeFBOID) {
        switch (this.nativeFBOID) {
            case -1: {
                this.nativeFBOID = nativeFBOID;
                GLContext.nBindFBO(this.nativeCtxInfo, nativeFBOID);
                break;
            }
            case -2: {
                GLContext.nBindFBO(this.nativeCtxInfo, nativeFBOID);
                break;
            }
            default: {
                if (this.nativeFBOID == nativeFBOID) break;
                GLContext.nBindFBO(this.nativeCtxInfo, nativeFBOID);
                this.nativeFBOID = nativeFBOID;
            }
        }
    }

    void bindTexture(int texID) {
        GLContext.nBindTexture(this.nativeCtxInfo, texID);
    }

    void blendFunc(int sFactor, int dFactor) {
        GLContext.nBlendFunc(sFactor, dFactor);
    }

    boolean canCreateNonPowTwoTextures() {
        if (this.nonPowTwoExtAvailable == null) {
            this.nonPowTwoExtAvailable = PrismSettings.forcePow2 ? Boolean.FALSE.booleanValue() : ES2Pipeline.glFactory.isNPOTSupported();
        }
        return this.nonPowTwoExtAvailable;
    }

    boolean canClampToZero() {
        if (this.clampToZeroAvailable == null) {
            this.clampToZeroAvailable = PrismSettings.noClampToZero ? Boolean.FALSE.booleanValue() : ES2Pipeline.glFactory.isGL2();
        }
        return this.clampToZeroAvailable;
    }

    void clearBuffers(Color color, boolean clearColor, boolean clearDepth, boolean ignoreScissor) {
        float r = color.getRedPremult();
        float g = color.getGreenPremult();
        float b = color.getBluePremult();
        float a = color.getAlpha();
        GLContext.nClearBuffers(this.nativeCtxInfo, r, g, b, a, clearColor, clearDepth, ignoreScissor);
    }

    int compileShader(String shaderSource, boolean vertex) {
        return GLContext.nCompileShader(this.nativeCtxInfo, shaderSource, vertex);
    }

    int createDepthBuffer(int width, int height, int msaaSamples) {
        return GLContext.nCreateDepthBuffer(this.nativeCtxInfo, width, height, msaaSamples);
    }

    int createRenderBuffer(int width, int height, int msaaSamples) {
        return GLContext.nCreateRenderBuffer(this.nativeCtxInfo, width, height, msaaSamples);
    }

    int createFBO(int texID) {
        if (this.nativeFBOID != -2) {
            this.nativeFBOID = -1;
        }
        return GLContext.nCreateFBO(this.nativeCtxInfo, texID);
    }

    int createProgram(int vertexShaderID, int[] fragmentShaderIDArr, String[] attrs, int[] indexs) {
        if (fragmentShaderIDArr == null) {
            System.err.println("Error: fragmentShaderIDArr is null");
            return 0;
        }
        boolean shaderSpecified = true;
        for (int i = 0; i < fragmentShaderIDArr.length; ++i) {
            if (fragmentShaderIDArr[i] != 0) continue;
            shaderSpecified = false;
            break;
        }
        if (vertexShaderID == 0 || fragmentShaderIDArr.length == 0 || !shaderSpecified) {
            System.err.println("Both vertexShader and fragmentShader(s) must be specified");
        }
        if (attrs.length != indexs.length) {
            System.err.println("attrs.length must be equal to index.length");
        }
        return GLContext.nCreateProgram(this.nativeCtxInfo, vertexShaderID, fragmentShaderIDArr, attrs.length, attrs, indexs);
    }

    int createTexture(int width, int height) {
        return GLContext.nCreateTexture(this.nativeCtxInfo, width, height);
    }

    void deleteRenderBuffer(int dbID) {
        GLContext.nDeleteRenderBuffer(this.nativeCtxInfo, dbID);
    }

    void deleteFBO(int fboID) {
        GLContext.nDeleteFBO(this.nativeCtxInfo, fboID);
    }

    void deleteShader(int shadeID) {
        GLContext.nDeleteShader(this.nativeCtxInfo, shadeID);
    }

    void blitFBO(int msaaFboID, int dstFboID, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1) {
        GLContext.nBlit(this.nativeCtxInfo, msaaFboID, dstFboID, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1);
    }

    void deleteTexture(int tID) {
        GLContext.nDeleteTexture(this.nativeCtxInfo, tID);
    }

    void disposeShaders(int pID, int vID, int[] fID) {
        GLContext.nDisposeShaders(this.nativeCtxInfo, pID, vID, fID);
    }

    void finish() {
        GLContext.nFinish();
    }

    int genAndBindTexture() {
        int texID;
        this.boundTextures[this.activeTexUnit] = texID = GLContext.nGenAndBindTexture();
        return texID;
    }

    int getBoundFBO() {
        switch (this.nativeFBOID) {
            case -1: {
                this.nativeFBOID = GLContext.nGetFBO();
                return this.nativeFBOID;
            }
            case -2: {
                return GLContext.nGetFBO();
            }
        }
        return this.nativeFBOID;
    }

    long getNativeCtxInfo() {
        return this.nativeCtxInfo;
    }

    abstract long getNativeHandle();

    int getActiveTextureUnit() {
        return this.activeTexUnit;
    }

    void setActiveTextureUnit(int unit) {
        this.activeTexture(unit);
        this.activeTexUnit = unit;
    }

    void updateActiveTextureUnit(int unit) {
        if (unit != this.getActiveTextureUnit()) {
            this.setActiveTextureUnit(unit);
        }
    }

    int getBoundTexture() {
        return this.boundTextures[this.activeTexUnit];
    }

    int getBoundTexture(int unit) {
        return this.boundTextures[unit];
    }

    int getNumBoundTexture() {
        return this.boundTextures.length;
    }

    void setBoundTexture(int texid) {
        this.bindTexture(texid);
        this.boundTextures[this.activeTexUnit] = texid;
    }

    void updateBoundTexture(int texid) {
        if (texid != this.getBoundTexture()) {
            this.setBoundTexture(texid);
        }
    }

    int getIntParam(int param) {
        return GLContext.nGetIntParam(param);
    }

    int getSampleSize() {
        int maxSamples = this.getMaxSampleSize();
        return maxSamples < 2 ? 0 : (maxSamples < 4 ? 2 : 4);
    }

    int getMaxSampleSize() {
        if (this.maxSampleSize > -1) {
            return this.maxSampleSize;
        }
        this.maxSampleSize = ES2Pipeline.msaa ? GLContext.nGetMaxSampleSize() : 0;
        return this.maxSampleSize;
    }

    int getMaxTextureSize() {
        if (this.maxTextureSize > -1) {
            return this.maxTextureSize;
        }
        this.maxTextureSize = this.getIntParam(123);
        return this.maxTextureSize;
    }

    int getUniformLocation(int programID, String name) {
        return GLContext.nGetUniformLocation(this.nativeCtxInfo, programID, name);
    }

    boolean isShaderCompilerSupported() {
        return true;
    }

    abstract void makeCurrent(GLDrawable var1);

    void pixelStorei(int pname, int param) {
        GLContext.nPixelStorei(pname, param);
    }

    boolean readPixels(Buffer buffer, int x, int y, int w, int h) {
        boolean res = false;
        if (buffer instanceof ByteBuffer) {
            ByteBuffer buf = (ByteBuffer)buffer;
            byte[] arr = buf.hasArray() ? buf.array() : null;
            int length = buf.capacity();
            res = GLContext.nReadPixelsByte(this.nativeCtxInfo, length, buffer, arr, x, y, w, h);
        } else if (buffer instanceof IntBuffer) {
            IntBuffer buf = (IntBuffer)buffer;
            int[] arr = buf.hasArray() ? buf.array() : null;
            int length = buf.capacity() * 4;
            res = GLContext.nReadPixelsInt(this.nativeCtxInfo, length, buffer, arr, x, y, w, h);
        } else {
            throw new IllegalArgumentException("readPixel: pixel's buffer type is not supported: " + buffer);
        }
        return res;
    }

    void scissorTest(boolean enable, int x, int y, int w, int h) {
        GLContext.nScissorTest(this.nativeCtxInfo, enable, x, y, w, h);
    }

    void setShaderProgram(int progid) {
        GLContext.nUseProgram(this.nativeCtxInfo, progid);
    }

    void texParamsMinMax(int pname, boolean useMipmap) {
        int min = pname;
        int max = pname;
        if (useMipmap) {
            min = min == 53 ? 55 : 54;
        }
        GLContext.nTexParamsMinMax(min, max);
    }

    boolean texImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, Buffer pixels, boolean useMipmap) {
        boolean direct = BufferFactory.isDirect(pixels);
        boolean result = direct ? GLContext.nTexImage2D0(target, level, internalFormat, width, height, border, format, type, pixels, BufferFactory.getDirectBufferByteOffset(pixels), useMipmap) : GLContext.nTexImage2D1(target, level, internalFormat, width, height, border, format, type, BufferFactory.getArray(pixels), BufferFactory.getIndirectBufferByteOffset(pixels), useMipmap);
        return result;
    }

    void texSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        boolean direct = BufferFactory.isDirect(pixels);
        if (direct) {
            GLContext.nTexSubImage2D0(target, level, xoffset, yoffset, width, height, format, type, pixels, BufferFactory.getDirectBufferByteOffset(pixels));
        } else {
            GLContext.nTexSubImage2D1(target, level, xoffset, yoffset, width, height, format, type, BufferFactory.getArray(pixels), BufferFactory.getIndirectBufferByteOffset(pixels));
        }
    }

    void updateViewportAndDepthTest(int x, int y, int w, int h, boolean depthTest) {
        if (this.viewportX != x || this.viewportY != y || this.viewportWidth != w || this.viewportHeight != h) {
            this.viewportX = x;
            this.viewportY = y;
            this.viewportWidth = w;
            this.viewportHeight = h;
            GLContext.nUpdateViewport(this.nativeCtxInfo, x, y, w, h);
        }
        if (this.depthTest != depthTest) {
            GLContext.nSetDepthTest(this.nativeCtxInfo, depthTest);
            this.depthTest = depthTest;
        }
    }

    void updateMSAAState(boolean msaa) {
        if (this.msaa != msaa) {
            GLContext.nSetMSAA(this.nativeCtxInfo, msaa);
            this.msaa = msaa;
        }
    }

    void updateFilterState(int texID, boolean linearFilter) {
        GLContext.nUpdateFilterState(this.nativeCtxInfo, texID, linearFilter);
    }

    void updateWrapState(int texID, Texture.WrapMode wrapMode) {
        int wm;
        switch (wrapMode) {
            case REPEAT_SIMULATED: 
            case REPEAT: {
                wm = 100;
                break;
            }
            case CLAMP_TO_ZERO_SIMULATED: 
            case CLAMP_TO_EDGE_SIMULATED: 
            case CLAMP_TO_EDGE: {
                wm = 101;
                break;
            }
            case CLAMP_TO_ZERO: {
                wm = 102;
                break;
            }
            case CLAMP_NOT_NEEDED: {
                return;
            }
            default: {
                throw new InternalError("Unrecognized wrap mode: " + wrapMode);
            }
        }
        GLContext.nUpdateWrapState(this.nativeCtxInfo, texID, wm);
    }

    void uniform1f(int location, float v0) {
        GLContext.nUniform1f(this.nativeCtxInfo, location, v0);
    }

    void uniform2f(int location, float v0, float v1) {
        GLContext.nUniform2f(this.nativeCtxInfo, location, v0, v1);
    }

    void uniform3f(int location, float v0, float v1, float v2) {
        GLContext.nUniform3f(this.nativeCtxInfo, location, v0, v1, v2);
    }

    void uniform4f(int location, float v0, float v1, float v2, float v3) {
        GLContext.nUniform4f(this.nativeCtxInfo, location, v0, v1, v2, v3);
    }

    void uniform4fv(int location, int count, FloatBuffer value) {
        boolean direct = BufferFactory.isDirect(value);
        if (direct) {
            GLContext.nUniform4fv0(this.nativeCtxInfo, location, count, value, BufferFactory.getDirectBufferByteOffset(value));
        } else {
            GLContext.nUniform4fv1(this.nativeCtxInfo, location, count, BufferFactory.getArray(value), BufferFactory.getIndirectBufferByteOffset(value));
        }
    }

    void uniform1i(int location, int v0) {
        GLContext.nUniform1i(this.nativeCtxInfo, location, v0);
    }

    void uniform2i(int location, int v0, int v1) {
        GLContext.nUniform2i(this.nativeCtxInfo, location, v0, v1);
    }

    void uniform3i(int location, int v0, int v1, int v2) {
        GLContext.nUniform3i(this.nativeCtxInfo, location, v0, v1, v2);
    }

    void uniform4i(int location, int v0, int v1, int v2, int v3) {
        GLContext.nUniform4i(this.nativeCtxInfo, location, v0, v1, v2, v3);
    }

    void uniform4iv(int location, int count, IntBuffer value) {
        boolean direct = BufferFactory.isDirect(value);
        if (direct) {
            GLContext.nUniform4iv0(this.nativeCtxInfo, location, count, value, BufferFactory.getDirectBufferByteOffset(value));
        } else {
            GLContext.nUniform4iv1(this.nativeCtxInfo, location, count, BufferFactory.getArray(value), BufferFactory.getIndirectBufferByteOffset(value));
        }
    }

    void uniformMatrix4fv(int location, boolean transpose, float[] values) {
        GLContext.nUniformMatrix4fv(this.nativeCtxInfo, location, transpose, values);
    }

    void enableVertexAttributes() {
        GLContext.nEnableVertexAttributes(this.nativeCtxInfo);
    }

    void disableVertexAttributes() {
        GLContext.nDisableVertexAttributes(this.nativeCtxInfo);
    }

    void drawIndexedQuads(float[] coords, byte[] colors, int numVertices) {
        GLContext.nDrawIndexedQuads(this.nativeCtxInfo, numVertices, coords, colors);
    }

    int createIndexBuffer16(short[] data) {
        return GLContext.nCreateIndexBuffer16(this.nativeCtxInfo, data, data.length);
    }

    void setIndexBuffer(int ib) {
        GLContext.nSetIndexBuffer(this.nativeCtxInfo, ib);
    }

    void setDeviceParametersFor2D() {
        GLContext.nSetDeviceParametersFor2D(this.nativeCtxInfo);
    }

    void setDeviceParametersFor3D() {
        GLContext.nSetDeviceParametersFor3D(this.nativeCtxInfo);
    }

    long createES2Mesh() {
        return GLContext.nCreateES2Mesh(this.nativeCtxInfo);
    }

    void releaseES2Mesh(long nativeHandle) {
        GLContext.nReleaseES2Mesh(this.nativeCtxInfo, nativeHandle);
    }

    boolean buildNativeGeometry(long nativeHandle, float[] vertexBuffer, int vertexBufferLength, short[] indexBuffer, int indexBufferLength) {
        return GLContext.nBuildNativeGeometryShort(this.nativeCtxInfo, nativeHandle, vertexBuffer, vertexBufferLength, indexBuffer, indexBufferLength);
    }

    boolean buildNativeGeometry(long nativeHandle, float[] vertexBuffer, int vertexBufferLength, int[] indexBuffer, int indexBufferLength) {
        return GLContext.nBuildNativeGeometryInt(this.nativeCtxInfo, nativeHandle, vertexBuffer, vertexBufferLength, indexBuffer, indexBufferLength);
    }

    long createES2PhongMaterial() {
        return GLContext.nCreateES2PhongMaterial(this.nativeCtxInfo);
    }

    void releaseES2PhongMaterial(long nativeHandle) {
        GLContext.nReleaseES2PhongMaterial(this.nativeCtxInfo, nativeHandle);
    }

    void setSolidColor(long nativePhongMaterial, float r, float g, float b, float a) {
        GLContext.nSetSolidColor(this.nativeCtxInfo, nativePhongMaterial, r, g, b, a);
    }

    void setMap(long nativePhongMaterial, int mapType, int texID) {
        GLContext.nSetMap(this.nativeCtxInfo, nativePhongMaterial, mapType, texID);
    }

    long createES2MeshView(long nativeMeshInfo) {
        return GLContext.nCreateES2MeshView(this.nativeCtxInfo, nativeMeshInfo);
    }

    void releaseES2MeshView(long nativeHandle) {
        GLContext.nReleaseES2MeshView(this.nativeCtxInfo, nativeHandle);
    }

    void setCullingMode(long nativeMeshViewInfo, int cullMode) {
        int cm;
        if (cullMode == MeshView.CULL_NONE) {
            cm = 112;
        } else if (cullMode == MeshView.CULL_BACK) {
            cm = 110;
        } else if (cullMode == MeshView.CULL_FRONT) {
            cm = 111;
        } else {
            throw new IllegalArgumentException("illegal value for CullMode: " + cullMode);
        }
        GLContext.nSetCullingMode(this.nativeCtxInfo, nativeMeshViewInfo, cm);
    }

    void setMaterial(long nativeMeshViewInfo, long nativePhongMaterialInfo) {
        GLContext.nSetMaterial(this.nativeCtxInfo, nativeMeshViewInfo, nativePhongMaterialInfo);
    }

    void setWireframe(long nativeMeshViewInfo, boolean wireframe) {
        GLContext.nSetWireframe(this.nativeCtxInfo, nativeMeshViewInfo, wireframe);
    }

    void setAmbientLight(long nativeMeshViewInfo, float r, float g, float b) {
        GLContext.nSetAmbientLight(this.nativeCtxInfo, nativeMeshViewInfo, r, g, b);
    }

    void setLight(long nativeMeshViewInfo, int index, float x, float y, float z, float r, float g, float b, float w, float ca, float la, float qa, float isAttenuated, float maxRange, float dirX, float dirY, float dirZ, float innerAngle, float outerAngle, float falloff) {
        GLContext.nSetLight(this.nativeCtxInfo, nativeMeshViewInfo, index, x, y, z, r, g, b, w, ca, la, qa, isAttenuated, maxRange, dirX, dirY, dirZ, innerAngle, outerAngle, falloff);
    }

    void renderMeshView(long nativeMeshViewInfo) {
        GLContext.nRenderMeshView(this.nativeCtxInfo, nativeMeshViewInfo);
    }
}

