/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.marlin.DMarlinRenderingEngine;
import com.sun.marlin.IntArrayCache;
import com.sun.marlin.MarlinAlphaConsumer;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinRenderer;
import com.sun.marlin.RendererContext;
import com.sun.pisces.PiscesRenderer;
import com.sun.prism.BasicStroke;
import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.shape.DMarlinPrismUtils;
import com.sun.prism.sw.SWArgbPreTexture;
import com.sun.prism.sw.SWRTTexture;
import java.lang.ref.SoftReference;

final class SWContext {
    private final ResourceFactory factory;
    private final ShapeRenderer shapeRenderer;
    private SoftReference<SWRTTexture> readBackBufferRef;
    private SoftReference<SWArgbPreTexture> imagePaintTextureRef;

    SWContext(ResourceFactory factory) {
        this.factory = factory;
        switch (PrismSettings.rasterizerSpec) {
            default: 
        }
        this.shapeRenderer = new DMarlinShapeRenderer();
    }

    void renderShape(PiscesRenderer pr, Shape shape, BasicStroke stroke, BaseTransform tr, Rectangle clip, boolean antialiasedShape) {
        this.shapeRenderer.renderShape(pr, shape, stroke, tr, clip, antialiasedShape);
    }

    private SWRTTexture initRBBuffer(int width, int height) {
        SWRTTexture tex = (SWRTTexture)this.factory.createRTTexture(width, height, Texture.WrapMode.CLAMP_NOT_NEEDED);
        this.readBackBufferRef = new SoftReference<SWRTTexture>(tex);
        return tex;
    }

    private void disposeRBBuffer() {
        if (this.readBackBufferRef != null) {
            this.readBackBufferRef.clear();
            this.readBackBufferRef = null;
        }
    }

    SWRTTexture validateRBBuffer(int width, int height) {
        SWRTTexture tex;
        if (this.readBackBufferRef == null) {
            tex = this.initRBBuffer(width, height);
        } else {
            tex = this.readBackBufferRef.get();
            if (tex == null || tex.getPhysicalWidth() < width || tex.getPhysicalHeight() < height) {
                this.disposeRBBuffer();
                tex = this.initRBBuffer(width, height);
            }
            tex.setContentWidth(width);
            tex.setContentHeight(height);
        }
        return tex;
    }

    private SWArgbPreTexture initImagePaintTexture(int width, int height) {
        SWArgbPreTexture tex = (SWArgbPreTexture)this.factory.createTexture(PixelFormat.INT_ARGB_PRE, Texture.Usage.DEFAULT, Texture.WrapMode.REPEAT, width, height);
        this.imagePaintTextureRef = new SoftReference<SWArgbPreTexture>(tex);
        return tex;
    }

    private void disposeImagePaintTexture() {
        if (this.imagePaintTextureRef != null) {
            this.imagePaintTextureRef.clear();
            this.imagePaintTextureRef = null;
        }
    }

    SWArgbPreTexture validateImagePaintTexture(int width, int height) {
        SWArgbPreTexture tex;
        if (this.imagePaintTextureRef == null) {
            tex = this.initImagePaintTexture(width, height);
        } else {
            tex = this.imagePaintTextureRef.get();
            if (tex == null || tex.getPhysicalWidth() < width || tex.getPhysicalHeight() < height) {
                this.disposeImagePaintTexture();
                tex = this.initImagePaintTexture(width, height);
            }
            tex.setContentWidth(width);
            tex.setContentHeight(height);
        }
        return tex;
    }

    void dispose() {
        this.disposeRBBuffer();
        this.disposeImagePaintTexture();
        this.shapeRenderer.dispose();
    }

    static final class DMarlinShapeRenderer
    implements ShapeRenderer {
        private final DirectRTMarlinAlphaConsumer alphaConsumer = new DirectRTMarlinAlphaConsumer();

        DMarlinShapeRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void renderShape(PiscesRenderer pr, Shape shape, BasicStroke stroke, BaseTransform tr, Rectangle clip, boolean antialiasedShape) {
            if (stroke != null && stroke.getType() != 0) {
                shape = stroke.createStrokedShape(shape);
                stroke = null;
            }
            RendererContext rdrCtx = DMarlinRenderingEngine.getRendererContext();
            MarlinRenderer renderer = null;
            try {
                if (shape instanceof Path2D) {
                    renderer = DMarlinPrismUtils.setupRenderer(rdrCtx, (Path2D)shape, stroke, tr, clip, antialiasedShape);
                }
                if (renderer == null) {
                    renderer = DMarlinPrismUtils.setupRenderer(rdrCtx, shape, stroke, tr, clip, antialiasedShape);
                }
                int outpix_xmin = renderer.getOutpixMinX();
                int outpix_xmax = renderer.getOutpixMaxX();
                int outpix_ymin = renderer.getOutpixMinY();
                int outpix_ymax = renderer.getOutpixMaxY();
                int w = outpix_xmax - outpix_xmin;
                int h = outpix_ymax - outpix_ymin;
                if (w <= 0 || h <= 0) {
                    return;
                }
                this.alphaConsumer.initConsumer(outpix_xmin, outpix_ymin, w, h, pr);
                renderer.produceAlphas(this.alphaConsumer);
            }
            finally {
                if (renderer != null) {
                    renderer.dispose();
                }
                DMarlinRenderingEngine.returnRendererContext(rdrCtx);
            }
        }

        @Override
        public void dispose() {
        }
    }

    static interface ShapeRenderer {
        public void renderShape(PiscesRenderer var1, Shape var2, BasicStroke var3, BaseTransform var4, Rectangle var5, boolean var6);

        public void dispose();
    }

    static final class DirectRTMarlinAlphaConsumer
    implements MarlinAlphaConsumer {
        private byte[] alpha_map;
        private int x;
        private int y;
        private int w;
        private int h;
        private int rowNum;
        private PiscesRenderer pr;

        DirectRTMarlinAlphaConsumer() {
        }

        public void initConsumer(int x, int y, int w, int h, PiscesRenderer pr) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.rowNum = 0;
            this.pr = pr;
        }

        @Override
        public int getOriginX() {
            return this.x;
        }

        @Override
        public int getOriginY() {
            return this.y;
        }

        @Override
        public int getWidth() {
            return this.w;
        }

        @Override
        public int getHeight() {
            return this.h;
        }

        @Override
        public void setMaxAlpha(int maxalpha) {
            if (this.alpha_map == null || this.alpha_map.length != maxalpha + 1) {
                this.alpha_map = new byte[maxalpha + 1];
                for (int i = 0; i <= maxalpha; ++i) {
                    this.alpha_map[i] = (byte)((i * 255 + maxalpha / 2) / maxalpha);
                }
            }
        }

        @Override
        public boolean supportBlockFlags() {
            return false;
        }

        @Override
        public void clearAlphas(int pix_y) {
        }

        @Override
        public void setAndClearRelativeAlphas(int[] alphaDeltas, int pix_y, int pix_from, int pix_to) {
            this.pr.emitAndClearAlphaRow(this.alpha_map, alphaDeltas, pix_y, pix_from, pix_to, pix_from - this.x, this.rowNum);
            ++this.rowNum;
            int to = pix_to - this.x;
            if (to <= this.w) {
                alphaDeltas[to] = 0;
            } else {
                alphaDeltas[this.w] = 0;
            }
            if (MarlinConst.DO_CHECKS) {
                IntArrayCache.check(alphaDeltas, pix_from - this.x, to + 1, 0);
            }
        }

        @Override
        public void setAndClearRelativeAlphas(int[] blkFlags, int[] alphaDeltas, int pix_y, int pix_from, int pix_to) {
            throw new UnsupportedOperationException();
        }
    }
}

