/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.sw;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrImage;
import com.sun.scenario.effect.impl.prism.PrRenderer;
import com.sun.scenario.effect.impl.prism.sw.PSWDrawable;
import com.sun.scenario.effect.impl.sw.RendererDelegate;
import java.lang.reflect.Constructor;

public class PSWRenderer
extends PrRenderer {
    private final Screen screen;
    private final ResourceFactory resourceFactory;
    private final RendererDelegate delegate;
    private Renderer.RendererState state;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PSWRenderer(Screen screen, RendererDelegate delegate) {
        this.screen = screen;
        this.resourceFactory = null;
        this.delegate = delegate;
        PSWRenderer pSWRenderer = this;
        synchronized (pSWRenderer) {
            this.state = Renderer.RendererState.OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PSWRenderer(ResourceFactory factory, RendererDelegate delegate) {
        this.screen = null;
        this.resourceFactory = factory;
        this.delegate = delegate;
        PSWRenderer pSWRenderer = this;
        synchronized (pSWRenderer) {
            this.state = Renderer.RendererState.OK;
        }
    }

    @Override
    public PrDrawable createDrawable(RTTexture rtt) {
        return PSWDrawable.create(rtt);
    }

    public static synchronized PSWRenderer createJSWInstance(Screen screen) {
        PSWRenderer ret = null;
        try {
            Class<?> klass = Class.forName("com.sun.scenario.effect.impl.sw.java.JSWRendererDelegate");
            RendererDelegate delegate = (RendererDelegate)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ret = new PSWRenderer(screen, delegate);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static synchronized PSWRenderer createJSWInstance(ResourceFactory factory) {
        PSWRenderer ret = null;
        try {
            Class<?> klass = Class.forName("com.sun.scenario.effect.impl.sw.java.JSWRendererDelegate");
            RendererDelegate delegate = (RendererDelegate)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ret = new PSWRenderer(factory, delegate);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static synchronized PSWRenderer createJSWInstance(FilterContext fctx) {
        PSWRenderer ret = null;
        try {
            ResourceFactory factory = (ResourceFactory)fctx.getReferent();
            ret = PSWRenderer.createJSWInstance(factory);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    private static synchronized PSWRenderer createSSEInstance(Screen screen) {
        PSWRenderer ret = null;
        try {
            Class<?> klass = Class.forName("com.sun.scenario.effect.impl.sw.sse.SSERendererDelegate");
            RendererDelegate delegate = (RendererDelegate)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ret = new PSWRenderer(screen, delegate);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static Renderer createRenderer(FilterContext fctx) {
        Object ref = fctx.getReferent();
        GraphicsPipeline pipe = GraphicsPipeline.getPipeline();
        if (pipe == null || !(ref instanceof Screen)) {
            return null;
        }
        Screen screen = (Screen)ref;
        PSWRenderer renderer = PSWRenderer.createSSEInstance(screen);
        if (renderer == null) {
            renderer = PSWRenderer.createJSWInstance(screen);
        }
        return renderer;
    }

    @Override
    public Effect.AccelType getAccelType() {
        return this.delegate.getAccelType();
    }

    @Override
    public synchronized Renderer.RendererState getRendererState() {
        return this.state;
    }

    @Override
    protected Renderer getBackupRenderer() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        PSWRenderer pSWRenderer = this;
        synchronized (pSWRenderer) {
            this.state = Renderer.RendererState.DISPOSED;
        }
    }

    protected final synchronized void markLost() {
        if (this.state == Renderer.RendererState.OK) {
            this.state = Renderer.RendererState.LOST;
        }
    }

    @Override
    public int getCompatibleWidth(int w) {
        if (this.screen != null) {
            return PSWDrawable.getCompatibleWidth(this.screen, w);
        }
        return this.resourceFactory.getRTTWidth(w, Texture.WrapMode.CLAMP_TO_EDGE);
    }

    @Override
    public int getCompatibleHeight(int h) {
        if (this.screen != null) {
            return PSWDrawable.getCompatibleHeight(this.screen, h);
        }
        return this.resourceFactory.getRTTHeight(h, Texture.WrapMode.CLAMP_TO_EDGE);
    }

    @Override
    public final PSWDrawable createCompatibleImage(int w, int h) {
        if (this.screen != null) {
            return PSWDrawable.create(this.screen, w, h);
        }
        RTTexture rtt = this.resourceFactory.createRTTexture(w, h, Texture.WrapMode.CLAMP_TO_EDGE);
        return PSWDrawable.create(rtt);
    }

    @Override
    public PSWDrawable getCompatibleImage(int w, int h) {
        PSWDrawable im = (PSWDrawable)super.getCompatibleImage(w, h);
        if (im == null) {
            this.markLost();
        }
        return im;
    }

    private EffectPeer createIntrinsicPeer(FilterContext fctx, String name) {
        EffectPeer peer;
        Class<?> klass = null;
        try {
            klass = Class.forName("com.sun.scenario.effect.impl.prism.Pr" + name + "Peer");
            Constructor<?> ctor = klass.getConstructor(FilterContext.class, Renderer.class, String.class);
            peer = (EffectPeer)ctor.newInstance(fctx, this, name);
        }
        catch (Exception e) {
            return null;
        }
        return peer;
    }

    private EffectPeer createPlatformPeer(FilterContext fctx, String name, int unrollCount) {
        EffectPeer peer;
        String klassName = this.delegate.getPlatformPeerName(name, unrollCount);
        try {
            Class<?> klass = Class.forName(klassName);
            Constructor<?> ctor = klass.getConstructor(FilterContext.class, Renderer.class, String.class);
            peer = (EffectPeer)ctor.newInstance(fctx, this, name);
        }
        catch (Exception e) {
            System.err.println("Error: " + this.getAccelType() + " peer not found for: " + name + " due to error: " + e.getMessage());
            return null;
        }
        return peer;
    }

    @Override
    protected EffectPeer createPeer(FilterContext fctx, String name, int unrollCount) {
        if (PrRenderer.isIntrinsicPeer(name)) {
            return this.createIntrinsicPeer(fctx, name);
        }
        return this.createPlatformPeer(fctx, name, unrollCount);
    }

    @Override
    public boolean isImageDataCompatible(ImageData id) {
        return this.getRendererState() == Renderer.RendererState.OK && id.getUntransformedImage() instanceof PSWDrawable;
    }

    @Override
    public void clearImage(Filterable filterable) {
        PSWDrawable img = (PSWDrawable)filterable;
        img.clear();
    }

    @Override
    public ImageData createImageData(FilterContext fctx, Filterable src) {
        int h;
        if (!(src instanceof PrImage)) {
            throw new IllegalArgumentException("Identity source must be PrImage");
        }
        Image img = ((PrImage)src).getImage();
        int w = img.getWidth();
        PSWDrawable dst = this.createCompatibleImage(w, h = img.getHeight());
        if (dst == null) {
            return null;
        }
        Graphics g = dst.createGraphics();
        ResourceFactory factory = g.getResourceFactory();
        Texture tex = factory.createTexture(img, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_TO_EDGE);
        g.drawTexture(tex, 0.0f, 0.0f, w, h);
        g.sync();
        tex.dispose();
        return new ImageData(fctx, dst, new Rectangle(w, h));
    }

    @Override
    public Filterable transform(FilterContext fctx, Filterable original, BaseTransform transform, Rectangle origBounds, Rectangle xformBounds) {
        PSWDrawable dst = this.getCompatibleImage(xformBounds.width, xformBounds.height);
        if (dst != null) {
            Graphics g = dst.createGraphics();
            g.translate(-xformBounds.x, -xformBounds.y);
            g.transform(transform);
            g.drawTexture(((PSWDrawable)original).getTextureObject(), origBounds.x, origBounds.y, origBounds.width, origBounds.height);
        }
        return dst;
    }

    @Override
    public ImageData transform(FilterContext fctx, ImageData original, BaseTransform transform, Rectangle origBounds, Rectangle xformBounds) {
        PSWDrawable dst = this.getCompatibleImage(xformBounds.width, xformBounds.height);
        if (dst != null) {
            PSWDrawable orig = (PSWDrawable)original.getUntransformedImage();
            Graphics g = dst.createGraphics();
            g.translate(-xformBounds.x, -xformBounds.y);
            g.transform(transform);
            g.drawTexture(orig.getTextureObject(), origBounds.x, origBounds.y, origBounds.width, origBounds.height);
        }
        original.unref();
        return new ImageData(fctx, dst, xformBounds);
    }
}

