/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import javafx.animation.Transition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public final class FillTransition
extends Transition {
    private Color start;
    private Color end;
    private ObjectProperty<Shape> shape;
    private static final Shape DEFAULT_SHAPE = null;
    private Shape cachedShape;
    private ObjectProperty<Duration> duration;
    private static final Duration DEFAULT_DURATION = Duration.millis((double)400.0);
    private ObjectProperty<Color> fromValue;
    private static final Color DEFAULT_FROM_VALUE = null;
    private ObjectProperty<Color> toValue;
    private static final Color DEFAULT_TO_VALUE = null;

    public final void setShape(Shape value) {
        if (this.shape != null || value != null) {
            this.shapeProperty().set((Object)value);
        }
    }

    public final Shape getShape() {
        return this.shape == null ? DEFAULT_SHAPE : (Shape)this.shape.get();
    }

    public final ObjectProperty<Shape> shapeProperty() {
        if (this.shape == null) {
            this.shape = new SimpleObjectProperty((Object)this, "shape", (Object)DEFAULT_SHAPE);
        }
        return this.shape;
    }

    public final void setDuration(Duration value) {
        if (this.duration != null || !DEFAULT_DURATION.equals((Object)value)) {
            this.durationProperty().set((Object)value);
        }
    }

    public final Duration getDuration() {
        return this.duration == null ? DEFAULT_DURATION : (Duration)this.duration.get();
    }

    public final ObjectProperty<Duration> durationProperty() {
        if (this.duration == null) {
            this.duration = new ObjectPropertyBase<Duration>(DEFAULT_DURATION){

                public void invalidated() {
                    try {
                        FillTransition.this.setCycleDuration(FillTransition.this.getDuration());
                    }
                    catch (IllegalArgumentException e) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(FillTransition.this.getCycleDuration());
                        throw e;
                    }
                }

                public Object getBean() {
                    return FillTransition.this;
                }

                public String getName() {
                    return "duration";
                }
            };
        }
        return this.duration;
    }

    public final void setFromValue(Color value) {
        if (this.fromValue != null || value != null) {
            this.fromValueProperty().set((Object)value);
        }
    }

    public final Color getFromValue() {
        return this.fromValue == null ? DEFAULT_FROM_VALUE : (Color)this.fromValue.get();
    }

    public final ObjectProperty<Color> fromValueProperty() {
        if (this.fromValue == null) {
            this.fromValue = new SimpleObjectProperty((Object)this, "fromValue", (Object)DEFAULT_FROM_VALUE);
        }
        return this.fromValue;
    }

    public final void setToValue(Color value) {
        if (this.toValue != null || value != null) {
            this.toValueProperty().set((Object)value);
        }
    }

    public final Color getToValue() {
        return this.toValue == null ? DEFAULT_TO_VALUE : (Color)this.toValue.get();
    }

    public final ObjectProperty<Color> toValueProperty() {
        if (this.toValue == null) {
            this.toValue = new SimpleObjectProperty((Object)this, "toValue", (Object)DEFAULT_TO_VALUE);
        }
        return this.toValue;
    }

    public FillTransition(Duration duration, Shape shape, Color fromValue, Color toValue) {
        this.setDuration(duration);
        this.setShape(shape);
        this.setFromValue(fromValue);
        this.setToValue(toValue);
        this.setCycleDuration(duration);
    }

    public FillTransition(Duration duration, Color fromValue, Color toValue) {
        this(duration, null, fromValue, toValue);
    }

    public FillTransition(Duration duration, Shape shape) {
        this(duration, shape, null, null);
    }

    public FillTransition(Duration duration) {
        this(duration, null, null, null);
    }

    public FillTransition() {
        this(DEFAULT_DURATION, null);
    }

    @Override
    protected void interpolate(double frac) {
        Color newColor = this.start.interpolate(this.end, frac);
        this.cachedShape.setFill(newColor);
    }

    private Shape getTargetShape() {
        Node node;
        Shape shape = this.getShape();
        if (shape == null && (node = this.getParentTargetNode()) instanceof Shape) {
            shape = (Shape)node;
        }
        return shape;
    }

    @Override
    boolean startable(boolean forceSync) {
        if (!super.startable(forceSync)) {
            return false;
        }
        if (!forceSync && this.cachedShape != null) {
            return true;
        }
        Shape shape = this.getTargetShape();
        return shape != null && (this.getFromValue() != null || shape.getFill() instanceof Color) && this.getToValue() != null;
    }

    @Override
    void sync(boolean forceSync) {
        super.sync(forceSync);
        if (forceSync || this.cachedShape == null) {
            this.cachedShape = this.getTargetShape();
            Color _fromValue = this.getFromValue();
            this.start = _fromValue != null ? _fromValue : (Color)this.cachedShape.getFill();
            this.end = this.getToValue();
        }
    }
}

