/*
 * Decompiled with CFR 0.152.
 */
package javafx.print;

import com.sun.javafx.print.PrintHelper;
import com.sun.javafx.print.PrinterImpl;
import com.sun.javafx.print.Units;
import com.sun.javafx.tk.PrintPipeline;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableSet;
import javafx.geometry.Rectangle2D;
import javafx.print.JobSettings;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.print.Paper;
import javafx.print.PaperSource;
import javafx.print.PrintResolution;
import javafx.print.PrinterAttributes;

public final class Printer {
    private static ReadOnlyObjectWrapper<Printer> defaultPrinter;
    private PrinterImpl impl;
    private PrinterAttributes attributes;
    private PageLayout defPageLayout;

    public static ObservableSet<Printer> getAllPrinters() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        return PrintPipeline.getPrintPipeline().getAllPrinters();
    }

    private static ReadOnlyObjectWrapper<Printer> defaultPrinterImpl() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        Printer p = PrintPipeline.getPrintPipeline().getDefaultPrinter();
        if (defaultPrinter == null) {
            defaultPrinter = new ReadOnlyObjectWrapper(null, "defaultPrinter", (Object)p);
        } else {
            defaultPrinter.setValue((Object)p);
        }
        return defaultPrinter;
    }

    public static ReadOnlyObjectProperty<Printer> defaultPrinterProperty() {
        return Printer.defaultPrinterImpl().getReadOnlyProperty();
    }

    public static Printer getDefaultPrinter() {
        return (Printer)Printer.defaultPrinterProperty().get();
    }

    Printer(PrinterImpl impl) {
        this.impl = impl;
        impl.setPrinter(this);
    }

    PrinterImpl getPrinterImpl() {
        return this.impl;
    }

    public String getName() {
        return this.impl.getName();
    }

    public PrinterAttributes getPrinterAttributes() {
        if (this.attributes == null) {
            this.attributes = new PrinterAttributes(this.impl);
        }
        return this.attributes;
    }

    JobSettings getDefaultJobSettings() {
        return this.impl.getDefaultJobSettings();
    }

    public PageLayout getDefaultPageLayout() {
        if (this.defPageLayout == null) {
            PrinterAttributes printerCaps = this.getPrinterAttributes();
            this.defPageLayout = this.createPageLayout(printerCaps.getDefaultPaper(), printerCaps.getDefaultPageOrientation(), MarginType.DEFAULT);
        }
        return this.defPageLayout;
    }

    public PageLayout createPageLayout(Paper paper, PageOrientation orient, MarginType mType) {
        if (paper == null || orient == null || mType == null) {
            throw new NullPointerException("Parameters cannot be null");
        }
        Rectangle2D imgArea = this.impl.printableArea(paper);
        double width = paper.getWidth() / 72.0;
        double height = paper.getHeight() / 72.0;
        double plm = imgArea.getMinX();
        double ptm = imgArea.getMinY();
        double prm = width - imgArea.getMaxX();
        double pbm = height - imgArea.getMaxY();
        if (plm < 0.01) {
            plm = 0.0;
        }
        if (prm < 0.01) {
            prm = 0.0;
        }
        if (ptm < 0.01) {
            ptm = 0.0;
        }
        if (pbm < 0.01) {
            pbm = 0.0;
        }
        switch (mType) {
            case DEFAULT: {
                plm = plm <= 0.75 ? 0.75 : plm;
                prm = prm <= 0.75 ? 0.75 : prm;
                ptm = ptm <= 0.75 ? 0.75 : ptm;
                pbm = pbm <= 0.75 ? 0.75 : pbm;
                break;
            }
            case EQUAL: {
                double maxM;
                double maxH = Math.max(plm, prm);
                double maxV = Math.max(ptm, pbm);
                ptm = pbm = (maxM = Math.max(maxH, maxV));
                prm = pbm;
                plm = pbm;
                break;
            }
            case EQUAL_OPPOSITES: {
                double maxH = Math.max(plm, prm);
                double maxV = Math.max(ptm, pbm);
                plm = prm = maxH;
                ptm = pbm = maxV;
                break;
            }
        }
        while (plm + prm > width) {
            plm /= 2.0;
            prm /= 2.0;
        }
        while (ptm + pbm > height) {
            ptm /= 2.0;
            pbm /= 2.0;
        }
        switch (orient) {
            case LANDSCAPE: {
                double lm = pbm;
                double rm = ptm;
                double tm = plm;
                double bm = prm;
                break;
            }
            case REVERSE_LANDSCAPE: {
                double lm = ptm;
                double rm = pbm;
                double tm = prm;
                double bm = plm;
                break;
            }
            case REVERSE_PORTRAIT: {
                double lm = prm;
                double rm = plm;
                double tm = pbm;
                double bm = ptm;
                break;
            }
            default: {
                double lm = plm;
                double rm = prm;
                double tm = ptm;
                double bm = pbm;
            }
        }
        return new PageLayout(paper, orient, lm *= 72.0, rm *= 72.0, tm *= 72.0, bm *= 72.0);
    }

    public PageLayout createPageLayout(Paper paper, PageOrientation orient, double lMargin, double rMargin, double tMargin, double bMargin) {
        double bm;
        double tm;
        double rm;
        double lm;
        if (paper == null || orient == null) {
            throw new NullPointerException("Parameters cannot be null");
        }
        if (lMargin < 0.0 || rMargin < 0.0 || tMargin < 0.0 || bMargin < 0.0) {
            throw new IllegalArgumentException("Margins must be >= 0");
        }
        Rectangle2D imgArea = this.impl.printableArea(paper);
        double width = paper.getWidth() / 72.0;
        double height = paper.getHeight() / 72.0;
        double plm = imgArea.getMinX();
        double ptm = imgArea.getMinY();
        double prm = width - imgArea.getMaxX();
        double pbm = height - imgArea.getMaxY();
        lMargin /= 72.0;
        rMargin /= 72.0;
        tMargin /= 72.0;
        bMargin /= 72.0;
        boolean useDefault = false;
        if (orient == PageOrientation.PORTRAIT || orient == PageOrientation.REVERSE_PORTRAIT) {
            if (lMargin + rMargin > width || tMargin + bMargin > height) {
                useDefault = true;
            }
        } else if (lMargin + rMargin > height || tMargin + bMargin > width) {
            useDefault = true;
        }
        if (useDefault) {
            return this.createPageLayout(paper, orient, MarginType.DEFAULT);
        }
        switch (orient) {
            case LANDSCAPE: {
                lm = pbm;
                rm = ptm;
                tm = plm;
                bm = prm;
                break;
            }
            case REVERSE_LANDSCAPE: {
                lm = ptm;
                rm = pbm;
                tm = prm;
                bm = plm;
                break;
            }
            case REVERSE_PORTRAIT: {
                lm = prm;
                rm = plm;
                tm = pbm;
                bm = ptm;
                break;
            }
            default: {
                lm = plm;
                rm = prm;
                tm = ptm;
                bm = pbm;
            }
        }
        lm = lMargin >= lm ? lMargin : lm;
        rm = rMargin >= rm ? rMargin : rm;
        tm = tMargin >= tm ? tMargin : tm;
        bm = bMargin >= bm ? bMargin : bm;
        return new PageLayout(paper, orient, lm *= 72.0, rm *= 72.0, tm *= 72.0, bm *= 72.0);
    }

    public String toString() {
        return "Printer " + this.getName();
    }

    static {
        PrintHelper.setPrintAccessor(new PrintHelper.PrintAccessor(){

            @Override
            public PrintResolution createPrintResolution(int fr, int cfr) {
                return new PrintResolution(fr, cfr);
            }

            @Override
            public Paper createPaper(String paperName, double paperWidth, double paperHeight, Units units) {
                return new Paper(paperName, paperWidth, paperHeight, units);
            }

            @Override
            public PaperSource createPaperSource(String name) {
                return new PaperSource(name);
            }

            @Override
            public JobSettings createJobSettings(Printer printer) {
                return new JobSettings(printer);
            }

            @Override
            public Printer createPrinter(PrinterImpl impl) {
                return new Printer(impl);
            }

            @Override
            public PrinterImpl getPrinterImpl(Printer printer) {
                return printer.getPrinterImpl();
            }
        });
    }

    public static enum MarginType {
        DEFAULT,
        HARDWARE_MINIMUM,
        EQUAL,
        EQUAL_OPPOSITES;

    }
}

