/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.util.Utils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.Effect;

public class Bloom
extends Effect {
    private ObjectProperty<Effect> input;
    private DoubleProperty threshold;

    public Bloom() {
    }

    public Bloom(double threshold) {
        this.setThreshold(threshold);
    }

    @Override
    com.sun.scenario.effect.Bloom createPeer() {
        return new com.sun.scenario.effect.Bloom();
    }

    public final void setInput(Effect value) {
        this.inputProperty().set((Object)value);
    }

    public final Effect getInput() {
        return this.input == null ? null : (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect.EffectInputProperty("input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect e) {
        Effect localInput = this.getInput();
        if (localInput == null) {
            return false;
        }
        if (localInput == e) {
            return true;
        }
        return localInput.checkChainContains(e);
    }

    public final void setThreshold(double value) {
        this.thresholdProperty().set(value);
    }

    public final double getThreshold() {
        return this.threshold == null ? 0.3 : this.threshold.get();
    }

    public final DoubleProperty thresholdProperty() {
        if (this.threshold == null) {
            this.threshold = new DoublePropertyBase(0.3){

                public void invalidated() {
                    Bloom.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return Bloom.this;
                }

                public String getName() {
                    return "threshold";
                }
            };
        }
        return this.threshold;
    }

    @Override
    void update() {
        Effect localInput = this.getInput();
        if (localInput != null) {
            localInput.sync();
        }
        com.sun.scenario.effect.Bloom peer = (com.sun.scenario.effect.Bloom)this.getPeer();
        peer.setInput(localInput == null ? null : localInput.getPeer());
        peer.setThreshold((float)Utils.clamp(0.0, this.getThreshold(), 1.0));
    }

    @Override
    BaseBounds getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        return Bloom.getInputBounds(bounds, tx, node, boundsAccessor, this.getInput());
    }

    @Override
    Effect copy() {
        Bloom b = new Bloom(this.getThreshold());
        b.setInput(this.getInput());
        return b;
    }
}

