/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import javafx.scene.image.WritablePixelFormat;

public abstract class PixelFormat<T extends Buffer> {
    private Type type;

    PixelFormat(Type type) {
        this.type = type;
    }

    public static WritablePixelFormat<IntBuffer> getIntArgbInstance() {
        return WritablePixelFormat.IntArgb.INSTANCE;
    }

    public static WritablePixelFormat<IntBuffer> getIntArgbPreInstance() {
        return WritablePixelFormat.IntArgbPre.INSTANCE;
    }

    public static WritablePixelFormat<ByteBuffer> getByteBgraInstance() {
        return WritablePixelFormat.ByteBgra.INSTANCE;
    }

    public static WritablePixelFormat<ByteBuffer> getByteBgraPreInstance() {
        return WritablePixelFormat.ByteBgraPre.INSTANCE;
    }

    public static PixelFormat<ByteBuffer> getByteRgbInstance() {
        return ByteRgb.instance;
    }

    public static PixelFormat<ByteBuffer> createByteIndexedPremultipliedInstance(int[] colors) {
        return IndexedPixelFormat.createByte(colors, true);
    }

    public static PixelFormat<ByteBuffer> createByteIndexedInstance(int[] colors) {
        return IndexedPixelFormat.createByte(colors, false);
    }

    public Type getType() {
        return this.type;
    }

    public abstract boolean isWritable();

    public abstract boolean isPremultiplied();

    static int NonPretoPre(int nonpre) {
        int a = nonpre >>> 24;
        if (a == 255) {
            return nonpre;
        }
        if (a == 0) {
            return 0;
        }
        int r = nonpre >> 16 & 0xFF;
        int g = nonpre >> 8 & 0xFF;
        int b = nonpre & 0xFF;
        r = (r * a + 127) / 255;
        g = (g * a + 127) / 255;
        b = (b * a + 127) / 255;
        return a << 24 | r << 16 | g << 8 | b;
    }

    static int PretoNonPre(int pre) {
        int a = pre >>> 24;
        if (a == 255 || a == 0) {
            return pre;
        }
        int r = pre >> 16 & 0xFF;
        int g = pre >> 8 & 0xFF;
        int b = pre & 0xFF;
        int halfa = a >> 1;
        r = r >= a ? 255 : (r * 255 + halfa) / a;
        g = g >= a ? 255 : (g * 255 + halfa) / a;
        b = b >= a ? 255 : (b * 255 + halfa) / a;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public abstract int getArgb(T var1, int var2, int var3, int var4);

    public static enum Type {
        INT_ARGB_PRE,
        INT_ARGB,
        BYTE_BGRA_PRE,
        BYTE_BGRA,
        BYTE_RGB,
        BYTE_INDEXED;

    }

    static class ByteRgb
    extends PixelFormat<ByteBuffer> {
        static final ByteRgb instance = new ByteRgb();

        private ByteRgb() {
            super(Type.BYTE_RGB);
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isPremultiplied() {
            return false;
        }

        @Override
        public int getArgb(ByteBuffer buf, int x, int y, int scanlineStride) {
            int index = y * scanlineStride + x * 3;
            int r = buf.get(index) & 0xFF;
            int g = buf.get(index + 1) & 0xFF;
            int b = buf.get(index + 2) & 0xFF;
            return 0xFF000000 | r << 16 | g << 8 | b;
        }
    }

    static class IndexedPixelFormat
    extends PixelFormat<ByteBuffer> {
        int[] precolors;
        int[] nonprecolors;
        boolean premult;

        static PixelFormat createByte(int[] colors, boolean premult) {
            return new IndexedPixelFormat(Type.BYTE_INDEXED, premult, Arrays.copyOf(colors, 256));
        }

        private IndexedPixelFormat(Type type, boolean premult, int[] colors) {
            super(type);
            if (premult) {
                this.precolors = colors;
            } else {
                this.nonprecolors = colors;
            }
            this.premult = premult;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isPremultiplied() {
            return this.premult;
        }

        int[] getPreColors() {
            if (this.precolors == null) {
                int[] colors = new int[this.nonprecolors.length];
                for (int i = 0; i < colors.length; ++i) {
                    colors[i] = IndexedPixelFormat.NonPretoPre(this.nonprecolors[i]);
                }
                this.precolors = colors;
            }
            return this.precolors;
        }

        int[] getNonPreColors() {
            if (this.nonprecolors == null) {
                int[] colors = new int[this.precolors.length];
                for (int i = 0; i < colors.length; ++i) {
                    colors[i] = IndexedPixelFormat.PretoNonPre(this.precolors[i]);
                }
                this.nonprecolors = colors;
            }
            return this.nonprecolors;
        }

        @Override
        public int getArgb(ByteBuffer buf, int x, int y, int scanlineStride) {
            return this.getNonPreColors()[buf.get(y * scanlineStride + x) & 0xFF];
        }
    }
}

