/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.GestureEvent;
import javafx.scene.input.PickResult;

public final class ScrollEvent
extends GestureEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<ScrollEvent> ANY = new EventType(GestureEvent.ANY, "ANY_SCROLL");
    public static final EventType<ScrollEvent> SCROLL = new EventType(ANY, "SCROLL");
    public static final EventType<ScrollEvent> SCROLL_STARTED = new EventType(ANY, "SCROLL_STARTED");
    public static final EventType<ScrollEvent> SCROLL_FINISHED = new EventType(ANY, "SCROLL_FINISHED");
    private final double deltaX;
    private final double deltaY;
    private double totalDeltaX;
    private final double totalDeltaY;
    private final HorizontalTextScrollUnits textDeltaXUnits;
    private final VerticalTextScrollUnits textDeltaYUnits;
    private final double textDeltaX;
    private final double textDeltaY;
    private final int touchCount;
    private final double multiplierX;
    private final double multiplierY;

    private ScrollEvent(Object source, EventTarget target, EventType<ScrollEvent> eventType, double x, double y, double screenX, double screenY, boolean shiftDown, boolean controlDown, boolean altDown, boolean metaDown, boolean direct, boolean inertia, double deltaX, double deltaY, double totalDeltaX, double totalDeltaY, double multiplierX, double multiplierY, HorizontalTextScrollUnits textDeltaXUnits, double textDeltaX, VerticalTextScrollUnits textDeltaYUnits, double textDeltaY, int touchCount, PickResult pickResult) {
        super(source, target, eventType, x, y, screenX, screenY, shiftDown, controlDown, altDown, metaDown, direct, inertia, pickResult);
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.totalDeltaX = totalDeltaX;
        this.totalDeltaY = totalDeltaY;
        this.textDeltaXUnits = textDeltaXUnits;
        this.textDeltaX = textDeltaX;
        this.textDeltaYUnits = textDeltaYUnits;
        this.textDeltaY = textDeltaY;
        this.touchCount = touchCount;
        this.multiplierX = multiplierX;
        this.multiplierY = multiplierY;
    }

    public ScrollEvent(@NamedArg(value="source") Object source, @NamedArg(value="target") EventTarget target, @NamedArg(value="eventType") EventType<ScrollEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="direct") boolean direct, @NamedArg(value="inertia") boolean inertia, @NamedArg(value="deltaX") double deltaX, @NamedArg(value="deltaY") double deltaY, @NamedArg(value="totalDeltaX") double totalDeltaX, @NamedArg(value="totalDeltaY") double totalDeltaY, @NamedArg(value="textDeltaXUnits") HorizontalTextScrollUnits textDeltaXUnits, @NamedArg(value="textDeltaX") double textDeltaX, @NamedArg(value="textDeltaYUnits") VerticalTextScrollUnits textDeltaYUnits, @NamedArg(value="textDeltaY") double textDeltaY, @NamedArg(value="touchCount") int touchCount, @NamedArg(value="pickResult") PickResult pickResult) {
        this(source, target, eventType, x, y, screenX, screenY, shiftDown, controlDown, altDown, metaDown, direct, inertia, deltaX, deltaY, totalDeltaX, totalDeltaY, 1.0, 1.0, textDeltaXUnits, textDeltaX, textDeltaYUnits, textDeltaY, touchCount, pickResult);
    }

    public ScrollEvent(@NamedArg(value="eventType") EventType<ScrollEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="direct") boolean direct, @NamedArg(value="inertia") boolean inertia, @NamedArg(value="deltaX") double deltaX, @NamedArg(value="deltaY") double deltaY, @NamedArg(value="totalDeltaX") double totalDeltaX, @NamedArg(value="totalDeltaY") double totalDeltaY, @NamedArg(value="textDeltaXUnits") HorizontalTextScrollUnits textDeltaXUnits, @NamedArg(value="textDeltaX") double textDeltaX, @NamedArg(value="textDeltaYUnits") VerticalTextScrollUnits textDeltaYUnits, @NamedArg(value="textDeltaY") double textDeltaY, @NamedArg(value="touchCount") int touchCount, @NamedArg(value="pickResult") PickResult pickResult) {
        this(null, null, eventType, x, y, screenX, screenY, shiftDown, controlDown, altDown, metaDown, direct, inertia, deltaX, deltaY, totalDeltaX, totalDeltaY, 1.0, 1.0, textDeltaXUnits, textDeltaX, textDeltaYUnits, textDeltaY, touchCount, pickResult);
    }

    public ScrollEvent(@NamedArg(value="eventType") EventType<ScrollEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="direct") boolean direct, @NamedArg(value="inertia") boolean inertia, @NamedArg(value="deltaX") double deltaX, @NamedArg(value="deltaY") double deltaY, @NamedArg(value="totalDeltaX") double totalDeltaX, @NamedArg(value="totalDeltaY") double totalDeltaY, @NamedArg(value="multiplierX") double multiplierX, @NamedArg(value="multiplierY") double multiplierY, @NamedArg(value="textDeltaXUnits") HorizontalTextScrollUnits textDeltaXUnits, @NamedArg(value="textDeltaX") double textDeltaX, @NamedArg(value="textDeltaYUnits") VerticalTextScrollUnits textDeltaYUnits, @NamedArg(value="textDeltaY") double textDeltaY, @NamedArg(value="touchCount") int touchCount, @NamedArg(value="pickResult") PickResult pickResult) {
        this(null, null, eventType, x, y, screenX, screenY, shiftDown, controlDown, altDown, metaDown, direct, inertia, deltaX, deltaY, totalDeltaX, totalDeltaY, multiplierX, multiplierY, textDeltaXUnits, textDeltaX, textDeltaYUnits, textDeltaY, touchCount, pickResult);
    }

    public double getDeltaX() {
        return this.deltaX;
    }

    public double getDeltaY() {
        return this.deltaY;
    }

    public double getTotalDeltaX() {
        return this.totalDeltaX;
    }

    public double getTotalDeltaY() {
        return this.totalDeltaY;
    }

    public HorizontalTextScrollUnits getTextDeltaXUnits() {
        return this.textDeltaXUnits;
    }

    public VerticalTextScrollUnits getTextDeltaYUnits() {
        return this.textDeltaYUnits;
    }

    public double getTextDeltaX() {
        return this.textDeltaX;
    }

    public double getTextDeltaY() {
        return this.textDeltaY;
    }

    public int getTouchCount() {
        return this.touchCount;
    }

    public double getMultiplierX() {
        return this.multiplierX;
    }

    public double getMultiplierY() {
        return this.multiplierY;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ScrollEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        sb.append(", deltaX = ").append(this.getDeltaX()).append(", deltaY = ").append(this.getDeltaY());
        sb.append(", totalDeltaX = ").append(this.getTotalDeltaX()).append(", totalDeltaY = ").append(this.getTotalDeltaY());
        sb.append(", textDeltaXUnits = ").append((Object)this.getTextDeltaXUnits()).append(", textDeltaX = ").append(this.getTextDeltaX());
        sb.append(", textDeltaYUnits = ").append((Object)this.getTextDeltaYUnits()).append(", textDeltaY = ").append(this.getTextDeltaY());
        sb.append(", touchCount = ").append(this.getTouchCount());
        sb.append(", x = ").append(this.getX()).append(", y = ").append(this.getY()).append(", z = ").append(this.getZ());
        sb.append(this.isDirect() ? ", direct" : ", indirect");
        if (this.isInertia()) {
            sb.append(", inertia");
        }
        if (this.isShiftDown()) {
            sb.append(", shiftDown");
        }
        if (this.isControlDown()) {
            sb.append(", controlDown");
        }
        if (this.isAltDown()) {
            sb.append(", altDown");
        }
        if (this.isMetaDown()) {
            sb.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            sb.append(", shortcutDown");
        }
        sb.append(", pickResult = ").append(this.getPickResult());
        return sb.append("]").toString();
    }

    @Override
    public ScrollEvent copyFor(Object newSource, EventTarget newTarget) {
        return (ScrollEvent)super.copyFor(newSource, newTarget);
    }

    public ScrollEvent copyFor(Object newSource, EventTarget newTarget, EventType<ScrollEvent> type) {
        ScrollEvent e = this.copyFor(newSource, newTarget);
        e.eventType = type;
        return e;
    }

    public EventType<ScrollEvent> getEventType() {
        return super.getEventType();
    }

    public static enum HorizontalTextScrollUnits {
        NONE,
        CHARACTERS;

    }

    public static enum VerticalTextScrollUnits {
        NONE,
        LINES,
        PAGES;

    }
}

