/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.geom.Area;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public abstract class Shape
extends Node {
    private NGShape.Mode mode = NGShape.Mode.FILL;
    private ObjectProperty<Paint> fill;
    Paint old_fill;
    private ObjectProperty<Paint> stroke;
    private final AbstractNotifyListener platformImageChangeListener = new AbstractNotifyListener(){

        public void invalidated(Observable valueModel) {
            NodeHelper.markDirty(Shape.this, DirtyBits.SHAPE_FILL);
            NodeHelper.markDirty(Shape.this, DirtyBits.SHAPE_STROKE);
            NodeHelper.geomChanged(Shape.this);
            Shape.this.checkModeChanged();
        }
    };
    Paint old_stroke;
    private BooleanProperty smooth;
    private static final double MIN_STROKE_WIDTH = 0.0;
    private static final double MIN_STROKE_MITER_LIMIT = 1.0;
    private Reference<Runnable> shapeChangeListener;
    private boolean strokeAttributesDirty = true;
    private StrokeAttributes strokeAttributes;
    private static final StrokeType DEFAULT_STROKE_TYPE;
    private static final double DEFAULT_STROKE_WIDTH = 1.0;
    private static final StrokeLineJoin DEFAULT_STROKE_LINE_JOIN;
    private static final StrokeLineCap DEFAULT_STROKE_LINE_CAP;
    private static final double DEFAULT_STROKE_MITER_LIMIT = 10.0;
    private static final double DEFAULT_STROKE_DASH_OFFSET = 0.0;
    private static final float[] DEFAULT_PG_STROKE_DASH_ARRAY;

    StrokeLineJoin convertLineJoin(StrokeLineJoin t) {
        return t;
    }

    public final void setStrokeType(StrokeType value) {
        this.strokeTypeProperty().set((Object)value);
    }

    public final StrokeType getStrokeType() {
        return this.strokeAttributes == null ? DEFAULT_STROKE_TYPE : this.strokeAttributes.getType();
    }

    public final ObjectProperty<StrokeType> strokeTypeProperty() {
        return this.getStrokeAttributes().typeProperty();
    }

    public final void setStrokeWidth(double value) {
        this.strokeWidthProperty().set(value);
    }

    public final double getStrokeWidth() {
        return this.strokeAttributes == null ? 1.0 : this.strokeAttributes.getWidth();
    }

    public final DoubleProperty strokeWidthProperty() {
        return this.getStrokeAttributes().widthProperty();
    }

    public final void setStrokeLineJoin(StrokeLineJoin value) {
        this.strokeLineJoinProperty().set((Object)value);
    }

    public final StrokeLineJoin getStrokeLineJoin() {
        return this.strokeAttributes == null ? DEFAULT_STROKE_LINE_JOIN : this.strokeAttributes.getLineJoin();
    }

    public final ObjectProperty<StrokeLineJoin> strokeLineJoinProperty() {
        return this.getStrokeAttributes().lineJoinProperty();
    }

    public final void setStrokeLineCap(StrokeLineCap value) {
        this.strokeLineCapProperty().set((Object)value);
    }

    public final StrokeLineCap getStrokeLineCap() {
        return this.strokeAttributes == null ? DEFAULT_STROKE_LINE_CAP : this.strokeAttributes.getLineCap();
    }

    public final ObjectProperty<StrokeLineCap> strokeLineCapProperty() {
        return this.getStrokeAttributes().lineCapProperty();
    }

    public final void setStrokeMiterLimit(double value) {
        this.strokeMiterLimitProperty().set(value);
    }

    public final double getStrokeMiterLimit() {
        return this.strokeAttributes == null ? 10.0 : this.strokeAttributes.getMiterLimit();
    }

    public final DoubleProperty strokeMiterLimitProperty() {
        return this.getStrokeAttributes().miterLimitProperty();
    }

    public final void setStrokeDashOffset(double value) {
        this.strokeDashOffsetProperty().set(value);
    }

    public final double getStrokeDashOffset() {
        return this.strokeAttributes == null ? 0.0 : this.strokeAttributes.getDashOffset();
    }

    public final DoubleProperty strokeDashOffsetProperty() {
        return this.getStrokeAttributes().dashOffsetProperty();
    }

    public final ObservableList<Double> getStrokeDashArray() {
        return this.getStrokeAttributes().dashArrayProperty();
    }

    private NGShape.Mode computeMode() {
        if (this.getFill() != null && this.getStroke() != null) {
            return NGShape.Mode.STROKE_FILL;
        }
        if (this.getFill() != null) {
            return NGShape.Mode.FILL;
        }
        if (this.getStroke() != null) {
            return NGShape.Mode.STROKE;
        }
        return NGShape.Mode.EMPTY;
    }

    NGShape.Mode getMode() {
        return this.mode;
    }

    private void checkModeChanged() {
        NGShape.Mode newMode = this.computeMode();
        if (this.mode != newMode) {
            this.mode = newMode;
            NodeHelper.markDirty(this, DirtyBits.SHAPE_MODE);
            NodeHelper.geomChanged(this);
        }
    }

    public final void setFill(Paint value) {
        this.fillProperty().set((Object)value);
    }

    public final Paint getFill() {
        return this.fill == null ? Color.BLACK : (Paint)this.fill.get();
    }

    public final ObjectProperty<Paint> fillProperty() {
        if (this.fill == null) {
            this.fill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){
                boolean needsListener;
                {
                    this.needsListener = false;
                }

                public void invalidated() {
                    Paint _fill = (Paint)this.get();
                    if (this.needsListener) {
                        Toolkit.getPaintAccessor().removeListener(Shape.this.old_fill, Shape.this.platformImageChangeListener);
                    }
                    this.needsListener = _fill != null && Toolkit.getPaintAccessor().isMutable(_fill);
                    Shape.this.old_fill = _fill;
                    if (this.needsListener) {
                        Toolkit.getPaintAccessor().addListener(_fill, Shape.this.platformImageChangeListener);
                    }
                    NodeHelper.markDirty(Shape.this, DirtyBits.SHAPE_FILL);
                    Shape.this.checkModeChanged();
                }

                @Override
                public CssMetaData<Shape, Paint> getCssMetaData() {
                    return StyleableProperties.FILL;
                }

                public Object getBean() {
                    return Shape.this;
                }

                public String getName() {
                    return "fill";
                }
            };
        }
        return this.fill;
    }

    public final void setStroke(Paint value) {
        this.strokeProperty().set((Object)value);
    }

    public final Paint getStroke() {
        return this.stroke == null ? null : (Paint)this.stroke.get();
    }

    public final ObjectProperty<Paint> strokeProperty() {
        if (this.stroke == null) {
            this.stroke = new StyleableObjectProperty<Paint>(){
                boolean needsListener = false;

                public void invalidated() {
                    Paint _stroke = (Paint)this.get();
                    if (this.needsListener) {
                        Toolkit.getPaintAccessor().removeListener(Shape.this.old_stroke, Shape.this.platformImageChangeListener);
                    }
                    this.needsListener = _stroke != null && Toolkit.getPaintAccessor().isMutable(_stroke);
                    Shape.this.old_stroke = _stroke;
                    if (this.needsListener) {
                        Toolkit.getPaintAccessor().addListener(_stroke, Shape.this.platformImageChangeListener);
                    }
                    NodeHelper.markDirty(Shape.this, DirtyBits.SHAPE_STROKE);
                    Shape.this.checkModeChanged();
                }

                @Override
                public CssMetaData<Shape, Paint> getCssMetaData() {
                    return StyleableProperties.STROKE;
                }

                public Object getBean() {
                    return Shape.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
        }
        return this.stroke;
    }

    public final void setSmooth(boolean value) {
        this.smoothProperty().set(value);
    }

    public final boolean isSmooth() {
        return this.smooth == null ? true : this.smooth.get();
    }

    public final BooleanProperty smoothProperty() {
        if (this.smooth == null) {
            this.smooth = new StyleableBooleanProperty(true){

                public void invalidated() {
                    NodeHelper.markDirty(Shape.this, DirtyBits.NODE_SMOOTH);
                }

                @Override
                public CssMetaData<Shape, Boolean> getCssMetaData() {
                    return StyleableProperties.SMOOTH;
                }

                public Object getBean() {
                    return Shape.this;
                }

                public String getName() {
                    return "smooth";
                }
            };
        }
        return this.smooth;
    }

    private Paint doCssGetFillInitialValue() {
        return Color.BLACK;
    }

    private Paint doCssGetStrokeInitialValue() {
        return null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Shape.getClassCssMetaData();
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        return this.computeShapeBounds(bounds, tx, ShapeHelper.configShape(this));
    }

    private boolean doComputeContains(double localX, double localY) {
        return this.computeShapeContains(localX, localY, ShapeHelper.configShape(this));
    }

    private void updatePGShape() {
        NGShape peer = (NGShape)NodeHelper.getPeer(this);
        if (this.strokeAttributesDirty && this.getStroke() != null) {
            float[] pgDashArray = this.hasStrokeDashArray() ? Shape.toPGDashArray(this.getStrokeDashArray()) : DEFAULT_PG_STROKE_DASH_ARRAY;
            peer.setDrawStroke((float)Utils.clampMin(this.getStrokeWidth(), 0.0), this.getStrokeType(), this.getStrokeLineCap(), this.convertLineJoin(this.getStrokeLineJoin()), (float)Utils.clampMin(this.getStrokeMiterLimit(), 1.0), pgDashArray, (float)this.getStrokeDashOffset());
            this.strokeAttributesDirty = false;
        }
        if (NodeHelper.isDirty(this, DirtyBits.SHAPE_MODE)) {
            peer.setMode(this.mode);
        }
        if (NodeHelper.isDirty(this, DirtyBits.SHAPE_FILL)) {
            Paint localFill = this.getFill();
            peer.setFillPaint(localFill == null ? null : Toolkit.getPaintAccessor().getPlatformPaint(localFill));
        }
        if (NodeHelper.isDirty(this, DirtyBits.SHAPE_STROKE)) {
            Paint localStroke = this.getStroke();
            peer.setDrawPaint(localStroke == null ? null : Toolkit.getPaintAccessor().getPlatformPaint(localStroke));
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_SMOOTH)) {
            peer.setSmooth(this.isSmooth());
        }
    }

    private void doMarkDirty(DirtyBits dirtyBits) {
        Runnable listener;
        Runnable runnable = listener = this.shapeChangeListener != null ? this.shapeChangeListener.get() : null;
        if (listener != null && NodeHelper.isDirtyEmpty(this)) {
            listener.run();
        }
    }

    void setShapeChangeListener(Runnable listener) {
        if (this.shapeChangeListener != null) {
            this.shapeChangeListener.clear();
        }
        this.shapeChangeListener = listener != null ? new WeakReference<Runnable>(listener) : null;
    }

    private void doUpdatePeer() {
        this.updatePGShape();
    }

    BaseBounds computeBounds(BaseBounds bounds, BaseTransform tx, double upad, double dpad, double x, double y, double w, double h) {
        if (w < 0.0 || h < 0.0) {
            return bounds.makeEmpty();
        }
        double x0 = x;
        double y0 = y;
        double x1 = w;
        double y1 = h;
        double _dpad = dpad;
        if (tx.isTranslateOrIdentity()) {
            x1 += x0;
            y1 += y0;
            if (tx.getType() == 1) {
                double dx = tx.getMxt();
                double dy = tx.getMyt();
                x0 += dx;
                y0 += dy;
                x1 += dx;
                y1 += dy;
            }
            _dpad += upad;
        } else {
            x0 -= upad;
            y0 -= upad;
            x1 += upad * 2.0;
            y1 += upad * 2.0;
            double mxx = tx.getMxx();
            double mxy = tx.getMxy();
            double myx = tx.getMyx();
            double myy = tx.getMyy();
            double mxt = x0 * mxx + y0 * mxy + tx.getMxt();
            double myt = x0 * myx + y0 * myy + tx.getMyt();
            x0 = Math.min(Math.min(0.0, mxx *= x1), Math.min(mxy *= y1, mxx + mxy)) + mxt;
            y0 = Math.min(Math.min(0.0, myx *= x1), Math.min(myy *= y1, myx + myy)) + myt;
            x1 = Math.max(Math.max(0.0, mxx), Math.max(mxy, mxx + mxy)) + mxt;
            y1 = Math.max(Math.max(0.0, myx), Math.max(myy, myx + myy)) + myt;
        }
        bounds = bounds.deriveWithNewBounds((float)(x0 -= _dpad), (float)(y0 -= _dpad), 0.0f, (float)(x1 += _dpad), (float)(y1 += _dpad), 0.0f);
        return bounds;
    }

    BaseBounds computeShapeBounds(BaseBounds bounds, BaseTransform tx, com.sun.javafx.geom.Shape s) {
        boolean includeStroke;
        if (this.mode == NGShape.Mode.EMPTY) {
            return bounds.makeEmpty();
        }
        float[] bbox = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        boolean includeShape = this.mode != NGShape.Mode.STROKE;
        boolean bl = includeStroke = this.mode != NGShape.Mode.FILL;
        if (includeStroke && this.getStrokeType() == StrokeType.INSIDE) {
            includeShape = true;
            includeStroke = false;
        }
        if (includeStroke) {
            StrokeType type = this.getStrokeType();
            double sw = Utils.clampMin(this.getStrokeWidth(), 0.0);
            StrokeLineCap cap = this.getStrokeLineCap();
            StrokeLineJoin join = this.convertLineJoin(this.getStrokeLineJoin());
            float miterlimit = (float)Utils.clampMin(this.getStrokeMiterLimit(), 1.0);
            Toolkit.getToolkit().accumulateStrokeBounds(s, bbox, type, sw, cap, join, miterlimit, tx);
            bbox[0] = (float)((double)bbox[0] - 0.5);
            bbox[1] = (float)((double)bbox[1] - 0.5);
            bbox[2] = (float)((double)bbox[2] + 0.5);
            bbox[3] = (float)((double)bbox[3] + 0.5);
        } else if (includeShape) {
            com.sun.javafx.geom.Shape.accumulate(bbox, s, tx);
        }
        if (bbox[2] < bbox[0] || bbox[3] < bbox[1]) {
            return bounds.makeEmpty();
        }
        bounds = bounds.deriveWithNewBounds(bbox[0], bbox[1], 0.0f, bbox[2], bbox[3], 0.0f);
        return bounds;
    }

    boolean computeShapeContains(double localX, double localY, com.sun.javafx.geom.Shape s) {
        boolean includeStroke;
        if (this.mode == NGShape.Mode.EMPTY) {
            return false;
        }
        boolean includeShape = this.mode != NGShape.Mode.STROKE;
        boolean bl = includeStroke = this.mode != NGShape.Mode.FILL;
        if (includeStroke && includeShape && this.getStrokeType() == StrokeType.INSIDE) {
            includeStroke = false;
        }
        if (includeShape && s.contains((float)localX, (float)localY)) {
            return true;
        }
        if (includeStroke) {
            StrokeType type = this.getStrokeType();
            double sw = Utils.clampMin(this.getStrokeWidth(), 0.0);
            StrokeLineCap cap = this.getStrokeLineCap();
            StrokeLineJoin join = this.convertLineJoin(this.getStrokeLineJoin());
            float miterlimit = (float)Utils.clampMin(this.getStrokeMiterLimit(), 1.0);
            return Toolkit.getToolkit().strokeContains(s, localX, localY, type, sw, cap, join, miterlimit);
        }
        return false;
    }

    private StrokeAttributes getStrokeAttributes() {
        if (this.strokeAttributes == null) {
            this.strokeAttributes = new StrokeAttributes();
        }
        return this.strokeAttributes;
    }

    private boolean hasStrokeDashArray() {
        return this.strokeAttributes != null && this.strokeAttributes.hasDashArray();
    }

    private static float[] toPGDashArray(List<Double> dashArray) {
        int size = dashArray.size();
        float[] pgDashArray = new float[size];
        for (int i = 0; i < size; ++i) {
            pgDashArray[i] = dashArray.get(i).floatValue();
        }
        return pgDashArray;
    }

    public static Shape union(Shape shape1, Shape shape2) {
        Area result = shape1.getTransformedArea();
        result.add(shape2.getTransformedArea());
        return Shape.createFromGeomShape(result);
    }

    public static Shape subtract(Shape shape1, Shape shape2) {
        Area result = shape1.getTransformedArea();
        result.subtract(shape2.getTransformedArea());
        return Shape.createFromGeomShape(result);
    }

    public static Shape intersect(Shape shape1, Shape shape2) {
        Area result = shape1.getTransformedArea();
        result.intersect(shape2.getTransformedArea());
        return Shape.createFromGeomShape(result);
    }

    private Area getTransformedArea() {
        return this.getTransformedArea(Shape.calculateNodeToSceneTransform(this));
    }

    private Area getTransformedArea(BaseTransform transform) {
        if (this.mode == NGShape.Mode.EMPTY) {
            return new Area();
        }
        com.sun.javafx.geom.Shape fillShape = ShapeHelper.configShape(this);
        if (this.mode == NGShape.Mode.FILL || this.mode == NGShape.Mode.STROKE_FILL && this.getStrokeType() == StrokeType.INSIDE) {
            return Shape.createTransformedArea(fillShape, transform);
        }
        StrokeType strokeType = this.getStrokeType();
        double strokeWidth = Utils.clampMin(this.getStrokeWidth(), 0.0);
        StrokeLineCap strokeLineCap = this.getStrokeLineCap();
        StrokeLineJoin strokeLineJoin = this.convertLineJoin(this.getStrokeLineJoin());
        float strokeMiterLimit = (float)Utils.clampMin(this.getStrokeMiterLimit(), 1.0);
        float[] dashArray = this.hasStrokeDashArray() ? Shape.toPGDashArray(this.getStrokeDashArray()) : DEFAULT_PG_STROKE_DASH_ARRAY;
        com.sun.javafx.geom.Shape strokeShape = Toolkit.getToolkit().createStrokedShape(fillShape, strokeType, strokeWidth, strokeLineCap, strokeLineJoin, strokeMiterLimit, dashArray, (float)this.getStrokeDashOffset());
        if (this.mode == NGShape.Mode.STROKE) {
            return Shape.createTransformedArea(strokeShape, transform);
        }
        Area combinedArea = new Area(fillShape);
        combinedArea.add(new Area(strokeShape));
        return Shape.createTransformedArea(combinedArea, transform);
    }

    private static BaseTransform calculateNodeToSceneTransform(Node node) {
        Affine3D cumulativeTransformation = new Affine3D();
        do {
            cumulativeTransformation.preConcatenate(NodeHelper.getLeafTransform(node));
        } while ((node = node.getParent()) != null);
        return cumulativeTransformation;
    }

    private static Area createTransformedArea(com.sun.javafx.geom.Shape geomShape, BaseTransform transform) {
        return transform.isIdentity() ? new Area(geomShape) : new Area(geomShape.getPathIterator(transform));
    }

    private static Path createFromGeomShape(com.sun.javafx.geom.Shape geomShape) {
        Path path = new Path();
        ObservableList<PathElement> elements = path.getElements();
        PathIterator iterator = geomShape.getPathIterator(null);
        float[] coords = new float[6];
        while (!iterator.isDone()) {
            int segmentType = iterator.currentSegment(coords);
            switch (segmentType) {
                case 0: {
                    elements.add((Object)new MoveTo(coords[0], coords[1]));
                    break;
                }
                case 1: {
                    elements.add((Object)new LineTo(coords[0], coords[1]));
                    break;
                }
                case 2: {
                    elements.add((Object)new QuadCurveTo(coords[0], coords[1], coords[2], coords[3]));
                    break;
                }
                case 3: {
                    elements.add((Object)new CubicCurveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]));
                    break;
                }
                case 4: {
                    elements.add((Object)new ClosePath());
                }
            }
            iterator.next();
        }
        path.setFillRule(iterator.getWindingRule() == 0 ? FillRule.EVEN_ODD : FillRule.NON_ZERO);
        path.setFill(Color.BLACK);
        path.setStroke(null);
        return path;
    }

    static {
        ShapeHelper.setShapeAccessor(new ShapeHelper.ShapeAccessor(){

            @Override
            public void doUpdatePeer(Node node) {
                ((Shape)node).doUpdatePeer();
            }

            @Override
            public void doMarkDirty(Node node, DirtyBits dirtyBit) {
                ((Shape)node).doMarkDirty(dirtyBit);
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((Shape)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((Shape)node).doComputeContains(localX, localY);
            }

            @Override
            public Paint doCssGetFillInitialValue(Shape shape) {
                return shape.doCssGetFillInitialValue();
            }

            @Override
            public Paint doCssGetStrokeInitialValue(Shape shape) {
                return shape.doCssGetStrokeInitialValue();
            }

            @Override
            public NGShape.Mode getMode(Shape shape) {
                return shape.getMode();
            }

            @Override
            public void setShapeChangeListener(Shape shape, Runnable listener) {
                shape.setShapeChangeListener(listener);
            }
        });
        DEFAULT_STROKE_TYPE = StrokeType.CENTERED;
        DEFAULT_STROKE_LINE_JOIN = StrokeLineJoin.MITER;
        DEFAULT_STROKE_LINE_CAP = StrokeLineCap.SQUARE;
        DEFAULT_PG_STROKE_DASH_ARRAY = new float[0];
    }

    private final class StrokeAttributes {
        private ObjectProperty<StrokeType> type;
        private DoubleProperty width;
        private ObjectProperty<StrokeLineJoin> lineJoin;
        private ObjectProperty<StrokeLineCap> lineCap;
        private DoubleProperty miterLimit;
        private DoubleProperty dashOffset;
        private ObservableList<Double> dashArray;
        private ObjectProperty<Number[]> cssDashArray = null;

        private StrokeAttributes() {
        }

        public final StrokeType getType() {
            return this.type == null ? DEFAULT_STROKE_TYPE : (StrokeType)((Object)this.type.get());
        }

        public final ObjectProperty<StrokeType> typeProperty() {
            if (this.type == null) {
                this.type = new StyleableObjectProperty<StrokeType>(DEFAULT_STROKE_TYPE){

                    public void invalidated() {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_TYPE);
                    }

                    @Override
                    public CssMetaData<Shape, StrokeType> getCssMetaData() {
                        return StyleableProperties.STROKE_TYPE;
                    }

                    public Object getBean() {
                        return Shape.this;
                    }

                    public String getName() {
                        return "strokeType";
                    }
                };
            }
            return this.type;
        }

        public double getWidth() {
            return this.width == null ? 1.0 : this.width.get();
        }

        public final DoubleProperty widthProperty() {
            if (this.width == null) {
                this.width = new StyleableDoubleProperty(1.0){

                    public void invalidated() {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_WIDTH);
                    }

                    @Override
                    public CssMetaData<Shape, Number> getCssMetaData() {
                        return StyleableProperties.STROKE_WIDTH;
                    }

                    public Object getBean() {
                        return Shape.this;
                    }

                    public String getName() {
                        return "strokeWidth";
                    }
                };
            }
            return this.width;
        }

        public StrokeLineJoin getLineJoin() {
            return this.lineJoin == null ? DEFAULT_STROKE_LINE_JOIN : (StrokeLineJoin)((Object)this.lineJoin.get());
        }

        public final ObjectProperty<StrokeLineJoin> lineJoinProperty() {
            if (this.lineJoin == null) {
                this.lineJoin = new StyleableObjectProperty<StrokeLineJoin>(DEFAULT_STROKE_LINE_JOIN){

                    public void invalidated() {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_LINE_JOIN);
                    }

                    @Override
                    public CssMetaData<Shape, StrokeLineJoin> getCssMetaData() {
                        return StyleableProperties.STROKE_LINE_JOIN;
                    }

                    public Object getBean() {
                        return Shape.this;
                    }

                    public String getName() {
                        return "strokeLineJoin";
                    }
                };
            }
            return this.lineJoin;
        }

        public StrokeLineCap getLineCap() {
            return this.lineCap == null ? DEFAULT_STROKE_LINE_CAP : (StrokeLineCap)((Object)this.lineCap.get());
        }

        public final ObjectProperty<StrokeLineCap> lineCapProperty() {
            if (this.lineCap == null) {
                this.lineCap = new StyleableObjectProperty<StrokeLineCap>(DEFAULT_STROKE_LINE_CAP){

                    public void invalidated() {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_LINE_CAP);
                    }

                    @Override
                    public CssMetaData<Shape, StrokeLineCap> getCssMetaData() {
                        return StyleableProperties.STROKE_LINE_CAP;
                    }

                    public Object getBean() {
                        return Shape.this;
                    }

                    public String getName() {
                        return "strokeLineCap";
                    }
                };
            }
            return this.lineCap;
        }

        public double getMiterLimit() {
            return this.miterLimit == null ? 10.0 : this.miterLimit.get();
        }

        public final DoubleProperty miterLimitProperty() {
            if (this.miterLimit == null) {
                this.miterLimit = new StyleableDoubleProperty(10.0){

                    public void invalidated() {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_MITER_LIMIT);
                    }

                    @Override
                    public CssMetaData<Shape, Number> getCssMetaData() {
                        return StyleableProperties.STROKE_MITER_LIMIT;
                    }

                    public Object getBean() {
                        return Shape.this;
                    }

                    public String getName() {
                        return "strokeMiterLimit";
                    }
                };
            }
            return this.miterLimit;
        }

        public double getDashOffset() {
            return this.dashOffset == null ? 0.0 : this.dashOffset.get();
        }

        public final DoubleProperty dashOffsetProperty() {
            if (this.dashOffset == null) {
                this.dashOffset = new StyleableDoubleProperty(0.0){

                    public void invalidated() {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_DASH_OFFSET);
                    }

                    @Override
                    public CssMetaData<Shape, Number> getCssMetaData() {
                        return StyleableProperties.STROKE_DASH_OFFSET;
                    }

                    public Object getBean() {
                        return Shape.this;
                    }

                    public String getName() {
                        return "strokeDashOffset";
                    }
                };
            }
            return this.dashOffset;
        }

        public ObservableList<Double> dashArrayProperty() {
            if (this.dashArray == null) {
                this.dashArray = new TrackableObservableList<Double>(){

                    protected void onChanged(ListChangeListener.Change<Double> c) {
                        StrokeAttributes.this.invalidated(StyleableProperties.STROKE_DASH_ARRAY);
                    }
                };
            }
            return this.dashArray;
        }

        private ObjectProperty<Number[]> cssDashArrayProperty() {
            if (this.cssDashArray == null) {
                this.cssDashArray = new StyleableObjectProperty<Number[]>(){

                    @Override
                    public void set(Number[] v) {
                        ObservableList<Double> list = StrokeAttributes.this.dashArrayProperty();
                        list.clear();
                        if (v != null && v.length > 0) {
                            for (int n = 0; n < v.length; ++n) {
                                list.add((Object)v[n].doubleValue());
                            }
                        }
                    }

                    public Double[] get() {
                        ObservableList<Double> list = StrokeAttributes.this.dashArrayProperty();
                        return list.toArray((Double[])new Double[list.size()]);
                    }

                    public Object getBean() {
                        return Shape.this;
                    }

                    public String getName() {
                        return "cssDashArray";
                    }

                    @Override
                    public CssMetaData<Shape, Number[]> getCssMetaData() {
                        return StyleableProperties.STROKE_DASH_ARRAY;
                    }
                };
            }
            return this.cssDashArray;
        }

        public boolean canSetType() {
            return this.type == null || !this.type.isBound();
        }

        public boolean canSetWidth() {
            return this.width == null || !this.width.isBound();
        }

        public boolean canSetLineJoin() {
            return this.lineJoin == null || !this.lineJoin.isBound();
        }

        public boolean canSetLineCap() {
            return this.lineCap == null || !this.lineCap.isBound();
        }

        public boolean canSetMiterLimit() {
            return this.miterLimit == null || !this.miterLimit.isBound();
        }

        public boolean canSetDashOffset() {
            return this.dashOffset == null || !this.dashOffset.isBound();
        }

        public boolean hasDashArray() {
            return this.dashArray != null;
        }

        private void invalidated(CssMetaData<Shape, ?> propertyCssKey) {
            NodeHelper.markDirty(Shape.this, DirtyBits.SHAPE_STROKEATTRS);
            Shape.this.strokeAttributesDirty = true;
            if (propertyCssKey != StyleableProperties.STROKE_DASH_OFFSET) {
                NodeHelper.geomChanged(Shape.this);
            }
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<Shape, Paint> FILL = new CssMetaData<Shape, Paint>("-fx-fill", PaintConverter.getInstance(), (Paint)Color.BLACK){

            @Override
            public boolean isSettable(Shape node) {
                return node.fill == null || !node.fill.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(Shape node) {
                return (StyleableProperty)node.fillProperty();
            }

            @Override
            public Paint getInitialValue(Shape node) {
                return ShapeHelper.cssGetFillInitialValue(node);
            }
        };
        private static final CssMetaData<Shape, Boolean> SMOOTH = new CssMetaData<Shape, Boolean>("-fx-smooth", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Shape node) {
                return node.smooth == null || !node.smooth.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Shape node) {
                return (StyleableProperty)node.smoothProperty();
            }
        };
        private static final CssMetaData<Shape, Paint> STROKE = new CssMetaData<Shape, Paint>("-fx-stroke", PaintConverter.getInstance()){

            @Override
            public boolean isSettable(Shape node) {
                return node.stroke == null || !node.stroke.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(Shape node) {
                return (StyleableProperty)node.strokeProperty();
            }

            @Override
            public Paint getInitialValue(Shape node) {
                return ShapeHelper.cssGetStrokeInitialValue(node);
            }
        };
        private static final CssMetaData<Shape, Number[]> STROKE_DASH_ARRAY = new CssMetaData<Shape, Number[]>("-fx-stroke-dash-array", (StyleConverter)SizeConverter.SequenceConverter.getInstance(), (Number[])new Double[0]){

            @Override
            public boolean isSettable(Shape node) {
                return true;
            }

            @Override
            public StyleableProperty<Number[]> getStyleableProperty(Shape node) {
                return (StyleableProperty)node.getStrokeAttributes().cssDashArrayProperty();
            }
        };
        private static final CssMetaData<Shape, Number> STROKE_DASH_OFFSET = new CssMetaData<Shape, Number>("-fx-stroke-dash-offset", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(Shape node) {
                return node.strokeAttributes == null || node.strokeAttributes.canSetDashOffset();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Shape node) {
                return (StyleableProperty)node.strokeDashOffsetProperty();
            }
        };
        private static final CssMetaData<Shape, StrokeLineCap> STROKE_LINE_CAP = new CssMetaData<Shape, StrokeLineCap>("-fx-stroke-line-cap", new EnumConverter<StrokeLineCap>(StrokeLineCap.class), StrokeLineCap.SQUARE){

            @Override
            public boolean isSettable(Shape node) {
                return node.strokeAttributes == null || node.strokeAttributes.canSetLineCap();
            }

            @Override
            public StyleableProperty<StrokeLineCap> getStyleableProperty(Shape node) {
                return (StyleableProperty)node.strokeLineCapProperty();
            }
        };
        private static final CssMetaData<Shape, StrokeLineJoin> STROKE_LINE_JOIN = new CssMetaData<Shape, StrokeLineJoin>("-fx-stroke-line-join", new EnumConverter<StrokeLineJoin>(StrokeLineJoin.class), StrokeLineJoin.MITER){

            @Override
            public boolean isSettable(Shape node) {
                return node.strokeAttributes == null || node.strokeAttributes.canSetLineJoin();
            }

            @Override
            public StyleableProperty<StrokeLineJoin> getStyleableProperty(Shape node) {
                return (StyleableProperty)node.strokeLineJoinProperty();
            }
        };
        private static final CssMetaData<Shape, StrokeType> STROKE_TYPE = new CssMetaData<Shape, StrokeType>("-fx-stroke-type", new EnumConverter<StrokeType>(StrokeType.class), StrokeType.CENTERED){

            @Override
            public boolean isSettable(Shape node) {
                return node.strokeAttributes == null || node.strokeAttributes.canSetType();
            }

            @Override
            public StyleableProperty<StrokeType> getStyleableProperty(Shape node) {
                return (StyleableProperty)node.strokeTypeProperty();
            }
        };
        private static final CssMetaData<Shape, Number> STROKE_MITER_LIMIT = new CssMetaData<Shape, Number>("-fx-stroke-miter-limit", SizeConverter.getInstance(), (Number)10.0){

            @Override
            public boolean isSettable(Shape node) {
                return node.strokeAttributes == null || node.strokeAttributes.canSetMiterLimit();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Shape node) {
                return (StyleableProperty)node.strokeMiterLimitProperty();
            }
        };
        private static final CssMetaData<Shape, Number> STROKE_WIDTH = new CssMetaData<Shape, Number>("-fx-stroke-width", SizeConverter.getInstance(), (Number)1.0){

            @Override
            public boolean isSettable(Shape node) {
                return node.strokeAttributes == null || node.strokeAttributes.canSetWidth();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Shape node) {
                return (StyleableProperty)node.strokeWidthProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Node.getClassCssMetaData());
            styleables.add(FILL);
            styleables.add(SMOOTH);
            styleables.add(STROKE);
            styleables.add(STROKE_DASH_ARRAY);
            styleables.add(STROKE_DASH_OFFSET);
            styleables.add(STROKE_LINE_CAP);
            styleables.add(STROKE_LINE_JOIN);
            styleables.add(STROKE_TYPE);
            styleables.add(STROKE_MITER_LIMIT);
            styleables.add(STROKE_WIDTH);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

