/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.text;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.TransformedShape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.shape.ShapeHelper;
import com.sun.javafx.scene.shape.TextHelper;
import com.sun.javafx.scene.text.FontHelper;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLayoutFactory;
import com.sun.javafx.scene.text.TextLine;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.sg.prism.NGText;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.HitInfo;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextBoundsType;
import javafx.scene.text.TextFlow;

@DefaultProperty(value="text")
public class Text
extends javafx.scene.shape.Shape {
    private TextLayout layout;
    private static final PathElement[] EMPTY_PATH_ELEMENT_ARRAY;
    private boolean isSpan;
    private TextSpan textSpan;
    private GlyphList[] textRuns;
    private BaseBounds spanBounds;
    private boolean spanBoundsInvalid;
    private StringProperty text;
    private DoubleProperty x;
    private DoubleProperty y;
    private ObjectProperty<Font> font;
    private ObjectProperty<TextBoundsType> boundsType;
    private DoubleProperty wrappingWidth;
    private ObjectProperty<FontSmoothingType> fontSmoothingType;
    private TextAttribute attributes;
    private static final VPos DEFAULT_TEXT_ORIGIN;
    private static final TextBoundsType DEFAULT_BOUNDS_TYPE;
    private static final boolean DEFAULT_UNDERLINE = false;
    private static final boolean DEFAULT_STRIKETHROUGH = false;
    private static final TextAlignment DEFAULT_TEXT_ALIGNMENT;
    private static final double DEFAULT_LINE_SPACING = 0.0;
    private static final int DEFAULT_CARET_POSITION = -1;
    private static final int DEFAULT_SELECTION_START = -1;
    private static final int DEFAULT_SELECTION_END = -1;
    private static final Color DEFAULT_SELECTION_FILL;
    private static final boolean DEFAULT_CARET_BIAS = true;

    public Text() {
        TextHelper.initHelper(this);
        this.textRuns = null;
        this.spanBounds = new RectBounds();
        this.spanBoundsInvalid = true;
        this.setAccessibleRole(AccessibleRole.TEXT);
        InvalidationListener listener = observable -> this.checkSpan();
        this.parentProperty().addListener(listener);
        this.managedProperty().addListener(listener);
        this.effectiveNodeOrientationProperty().addListener(observable -> this.checkOrientation());
        this.setPickOnBounds(true);
    }

    public Text(String text) {
        this();
        this.setText(text);
    }

    public Text(double x, double y, String text) {
        this(text);
        this.setX(x);
        this.setY(y);
    }

    private NGNode doCreatePeer() {
        return new NGText();
    }

    private boolean isSpan() {
        return this.isSpan;
    }

    private void checkSpan() {
        boolean bl = this.isSpan = this.isManaged() && this.getParent() instanceof TextFlow;
        if (this.isSpan() && !this.pickOnBoundsProperty().isBound()) {
            this.setPickOnBounds(false);
        }
    }

    private void checkOrientation() {
        if (!this.isSpan()) {
            NodeOrientation orientation = this.getEffectiveNodeOrientation();
            boolean rtl = orientation == NodeOrientation.RIGHT_TO_LEFT;
            int dir = rtl ? 2048 : 1024;
            TextLayout layout = this.getTextLayout();
            if (layout.setDirection(dir)) {
                this.needsTextLayout();
            }
        }
    }

    @Override
    public boolean usesMirroring() {
        return false;
    }

    private void needsFullTextLayout() {
        if (this.isSpan()) {
            this.textSpan = null;
        } else {
            TextLayout layout = this.getTextLayout();
            String string = this.getTextInternal();
            Object font = this.getFontInternal();
            layout.setContent(string, font);
        }
        this.needsTextLayout();
    }

    private void needsTextLayout() {
        this.textRuns = null;
        NodeHelper.geomChanged(this);
        NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
    }

    TextSpan getTextSpan() {
        if (this.textSpan == null) {
            this.textSpan = new TextSpan(){

                @Override
                public String getText() {
                    return Text.this.getTextInternal();
                }

                @Override
                public Object getFont() {
                    return Text.this.getFontInternal();
                }

                @Override
                public RectBounds getBounds() {
                    return null;
                }
            };
        }
        return this.textSpan;
    }

    private TextLayout getTextLayout() {
        if (this.isSpan()) {
            this.layout = null;
            TextFlow parent = (TextFlow)this.getParent();
            return parent.getTextLayout();
        }
        if (this.layout == null) {
            TextLayoutFactory factory = Toolkit.getToolkit().getTextLayoutFactory();
            this.layout = factory.createLayout();
            String string = this.getTextInternal();
            Object font = this.getFontInternal();
            TextAlignment alignment = this.getTextAlignment();
            if (alignment == null) {
                alignment = DEFAULT_TEXT_ALIGNMENT;
            }
            this.layout.setContent(string, font);
            this.layout.setAlignment(alignment.ordinal());
            this.layout.setLineSpacing((float)this.getLineSpacing());
            this.layout.setWrapWidth((float)this.getWrappingWidth());
            if (this.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                this.layout.setDirection(2048);
            } else {
                this.layout.setDirection(1024);
            }
            this.layout.setTabSize(this.getTabSize());
        }
        return this.layout;
    }

    void layoutSpan(GlyphList[] runs) {
        GlyphList run;
        int i;
        TextSpan span = this.getTextSpan();
        int count = 0;
        for (i = 0; i < runs.length; ++i) {
            run = runs[i];
            if (run.getTextSpan() != span) continue;
            ++count;
        }
        this.textRuns = new GlyphList[count];
        count = 0;
        for (i = 0; i < runs.length; ++i) {
            run = runs[i];
            if (run.getTextSpan() != span) continue;
            this.textRuns[count++] = run;
        }
        this.spanBoundsInvalid = true;
        NodeHelper.geomChanged(this);
        NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
    }

    BaseBounds getSpanBounds() {
        if (this.spanBoundsInvalid) {
            GlyphList[] runs = this.getRuns();
            if (runs.length != 0) {
                float left = Float.POSITIVE_INFINITY;
                float top = Float.POSITIVE_INFINITY;
                float right = 0.0f;
                float bottom = 0.0f;
                for (int i = 0; i < runs.length; ++i) {
                    GlyphList run = runs[i];
                    com.sun.javafx.geom.Point2D location = run.getLocation();
                    float width = run.getWidth();
                    float height = run.getLineBounds().getHeight();
                    left = Math.min(location.x, left);
                    top = Math.min(location.y, top);
                    right = Math.max(location.x + width, right);
                    bottom = Math.max(location.y + height, bottom);
                }
                this.spanBounds = this.spanBounds.deriveWithNewBounds(left, top, 0.0f, right, bottom, 0.0f);
            } else {
                this.spanBounds = this.spanBounds.makeEmpty();
            }
            this.spanBoundsInvalid = false;
        }
        return this.spanBounds;
    }

    private GlyphList[] getRuns() {
        if (this.textRuns != null) {
            return this.textRuns;
        }
        if (this.isSpan()) {
            this.getParent().layout();
        } else {
            TextLayout layout = this.getTextLayout();
            this.textRuns = layout.getRuns();
        }
        return this.textRuns;
    }

    private Shape getShape() {
        TextLayout layout = this.getTextLayout();
        int type = 1;
        if (this.isStrikethrough()) {
            type |= 4;
        }
        if (this.isUnderline()) {
            type |= 2;
        }
        TextSpan filter = null;
        if (this.isSpan()) {
            type |= 0x10;
            filter = this.getTextSpan();
        } else {
            type |= 8;
        }
        return layout.getShape(type, filter);
    }

    private BaseBounds getVisualBounds() {
        if (ShapeHelper.getMode(this) == NGShape.Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
            int type = 1;
            if (this.isStrikethrough()) {
                type |= 4;
            }
            if (this.isUnderline()) {
                type |= 2;
            }
            return this.getTextLayout().getVisualBounds(type);
        }
        return this.getShape().getBounds();
    }

    private BaseBounds getLogicalBounds() {
        TextLayout layout = this.getTextLayout();
        return layout.getBounds();
    }

    public final void setText(String value) {
        if (value == null) {
            value = "";
        }
        this.textProperty().set((Object)value);
    }

    public final String getText() {
        return this.text == null ? "" : (String)this.text.get();
    }

    private String getTextInternal() {
        String localText = this.getText();
        return localText == null ? "" : localText;
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new StringPropertyBase(""){

                public Object getBean() {
                    return Text.this;
                }

                public String getName() {
                    return "text";
                }

                public void invalidated() {
                    Text.this.needsFullTextLayout();
                    Text.this.setSelectionStart(-1);
                    Text.this.setSelectionEnd(-1);
                    Text.this.setCaretPosition(-1);
                    Text.this.setCaretBias(true);
                    String value = this.get();
                    if (value == null && !this.isBound()) {
                        this.set("");
                    }
                    Text.this.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT);
                }
            };
        }
        return this.text;
    }

    public final void setX(double value) {
        this.xProperty().set(value);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                public Object getBean() {
                    return Text.this;
                }

                public String getName() {
                    return "x";
                }

                public void invalidated() {
                    NodeHelper.geomChanged(Text.this);
                }
            };
        }
        return this.x;
    }

    public final void setY(double value) {
        this.yProperty().set(value);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                public Object getBean() {
                    return Text.this;
                }

                public String getName() {
                    return "y";
                }

                public void invalidated() {
                    NodeHelper.geomChanged(Text.this);
                }
            };
        }
        return this.y;
    }

    public final void setFont(Font value) {
        this.fontProperty().set((Object)value);
    }

    public final Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    private Object getFontInternal() {
        Font font = this.getFont();
        if (font == null) {
            font = Font.getDefault();
        }
        return FontHelper.getNativeFont(font);
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new StyleableObjectProperty<Font>(Font.getDefault()){

                public Object getBean() {
                    return Text.this;
                }

                public String getName() {
                    return "font";
                }

                @Override
                public CssMetaData<Text, Font> getCssMetaData() {
                    return StyleableProperties.FONT;
                }

                public void invalidated() {
                    Text.this.needsFullTextLayout();
                    NodeHelper.markDirty(Text.this, DirtyBits.TEXT_FONT);
                }
            };
        }
        return this.font;
    }

    public final void setTextOrigin(VPos value) {
        this.textOriginProperty().set((Object)value);
    }

    public final VPos getTextOrigin() {
        if (this.attributes == null || this.attributes.textOrigin == null) {
            return DEFAULT_TEXT_ORIGIN;
        }
        return this.attributes.getTextOrigin();
    }

    public final ObjectProperty<VPos> textOriginProperty() {
        return this.getTextAttribute().textOriginProperty();
    }

    public final void setBoundsType(TextBoundsType value) {
        this.boundsTypeProperty().set((Object)value);
    }

    public final TextBoundsType getBoundsType() {
        return this.boundsType == null ? DEFAULT_BOUNDS_TYPE : (TextBoundsType)((Object)this.boundsTypeProperty().get());
    }

    public final ObjectProperty<TextBoundsType> boundsTypeProperty() {
        if (this.boundsType == null) {
            this.boundsType = new StyleableObjectProperty<TextBoundsType>(DEFAULT_BOUNDS_TYPE){

                public Object getBean() {
                    return Text.this;
                }

                public String getName() {
                    return "boundsType";
                }

                @Override
                public CssMetaData<Text, TextBoundsType> getCssMetaData() {
                    return StyleableProperties.BOUNDS_TYPE;
                }

                public void invalidated() {
                    TextLayout layout = Text.this.getTextLayout();
                    int type = 0;
                    if (Text.this.boundsType.get() == TextBoundsType.LOGICAL_VERTICAL_CENTER) {
                        type |= 0x4000;
                    }
                    if (layout.setBoundsType(type)) {
                        Text.this.needsTextLayout();
                    } else {
                        NodeHelper.geomChanged(Text.this);
                    }
                }
            };
        }
        return this.boundsType;
    }

    public final void setWrappingWidth(double value) {
        this.wrappingWidthProperty().set(value);
    }

    public final double getWrappingWidth() {
        return this.wrappingWidth == null ? 0.0 : this.wrappingWidth.get();
    }

    public final DoubleProperty wrappingWidthProperty() {
        if (this.wrappingWidth == null) {
            this.wrappingWidth = new DoublePropertyBase(){

                public Object getBean() {
                    return Text.this;
                }

                public String getName() {
                    return "wrappingWidth";
                }

                public void invalidated() {
                    if (!Text.this.isSpan()) {
                        TextLayout layout = Text.this.getTextLayout();
                        if (layout.setWrapWidth((float)this.get())) {
                            Text.this.needsTextLayout();
                        } else {
                            NodeHelper.geomChanged(Text.this);
                        }
                    }
                }
            };
        }
        return this.wrappingWidth;
    }

    public final void setUnderline(boolean value) {
        this.underlineProperty().set(value);
    }

    public final boolean isUnderline() {
        if (this.attributes == null || this.attributes.underline == null) {
            return false;
        }
        return this.attributes.isUnderline();
    }

    public final BooleanProperty underlineProperty() {
        return this.getTextAttribute().underlineProperty();
    }

    public final void setStrikethrough(boolean value) {
        this.strikethroughProperty().set(value);
    }

    public final boolean isStrikethrough() {
        if (this.attributes == null || this.attributes.strikethrough == null) {
            return false;
        }
        return this.attributes.isStrikethrough();
    }

    public final BooleanProperty strikethroughProperty() {
        return this.getTextAttribute().strikethroughProperty();
    }

    public final void setTextAlignment(TextAlignment value) {
        this.textAlignmentProperty().set((Object)value);
    }

    public final TextAlignment getTextAlignment() {
        if (this.attributes == null || this.attributes.textAlignment == null) {
            return DEFAULT_TEXT_ALIGNMENT;
        }
        return this.attributes.getTextAlignment();
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        return this.getTextAttribute().textAlignmentProperty();
    }

    public final void setLineSpacing(double spacing) {
        this.lineSpacingProperty().set(spacing);
    }

    public final double getLineSpacing() {
        if (this.attributes == null || this.attributes.lineSpacing == null) {
            return 0.0;
        }
        return this.attributes.getLineSpacing();
    }

    public final DoubleProperty lineSpacingProperty() {
        return this.getTextAttribute().lineSpacingProperty();
    }

    @Override
    public final double getBaselineOffset() {
        return this.baselineOffsetProperty().get();
    }

    public final ReadOnlyDoubleProperty baselineOffsetProperty() {
        return this.getTextAttribute().baselineOffsetProperty();
    }

    public final void setFontSmoothingType(FontSmoothingType value) {
        this.fontSmoothingTypeProperty().set((Object)value);
    }

    public final FontSmoothingType getFontSmoothingType() {
        return this.fontSmoothingType == null ? FontSmoothingType.GRAY : (FontSmoothingType)((Object)this.fontSmoothingType.get());
    }

    public final ObjectProperty<FontSmoothingType> fontSmoothingTypeProperty() {
        if (this.fontSmoothingType == null) {
            this.fontSmoothingType = new StyleableObjectProperty<FontSmoothingType>(FontSmoothingType.GRAY){

                public Object getBean() {
                    return Text.this;
                }

                public String getName() {
                    return "fontSmoothingType";
                }

                @Override
                public CssMetaData<Text, FontSmoothingType> getCssMetaData() {
                    return StyleableProperties.FONT_SMOOTHING_TYPE;
                }

                public void invalidated() {
                    NodeHelper.markDirty(Text.this, DirtyBits.TEXT_ATTRS);
                    NodeHelper.geomChanged(Text.this);
                }
            };
        }
        return this.fontSmoothingType;
    }

    private void doGeomChanged() {
        if (this.attributes != null) {
            if (this.attributes.caretBinding != null) {
                this.attributes.caretBinding.invalidate();
            }
            if (this.attributes.selectionBinding != null) {
                this.attributes.selectionBinding.invalidate();
            }
        }
        NodeHelper.markDirty(this, DirtyBits.NODE_GEOMETRY);
    }

    public final PathElement[] getSelectionShape() {
        return (PathElement[])this.selectionShapeProperty().get();
    }

    public final ReadOnlyObjectProperty<PathElement[]> selectionShapeProperty() {
        return this.getTextAttribute().selectionShapeProperty();
    }

    public final void setSelectionStart(int value) {
        if (value == -1 && (this.attributes == null || this.attributes.selectionStart == null)) {
            return;
        }
        this.selectionStartProperty().set(value);
    }

    public final int getSelectionStart() {
        if (this.attributes == null || this.attributes.selectionStart == null) {
            return -1;
        }
        return this.attributes.getSelectionStart();
    }

    public final IntegerProperty selectionStartProperty() {
        return this.getTextAttribute().selectionStartProperty();
    }

    public final void setSelectionEnd(int value) {
        if (value == -1 && (this.attributes == null || this.attributes.selectionEnd == null)) {
            return;
        }
        this.selectionEndProperty().set(value);
    }

    public final int getSelectionEnd() {
        if (this.attributes == null || this.attributes.selectionEnd == null) {
            return -1;
        }
        return this.attributes.getSelectionEnd();
    }

    public final IntegerProperty selectionEndProperty() {
        return this.getTextAttribute().selectionEndProperty();
    }

    public final ObjectProperty<Paint> selectionFillProperty() {
        return this.getTextAttribute().selectionFillProperty();
    }

    public final void setSelectionFill(Paint paint) {
        this.selectionFillProperty().set((Object)paint);
    }

    public final Paint getSelectionFill() {
        return (Paint)this.selectionFillProperty().get();
    }

    public final PathElement[] getCaretShape() {
        return (PathElement[])this.caretShapeProperty().get();
    }

    public final ReadOnlyObjectProperty<PathElement[]> caretShapeProperty() {
        return this.getTextAttribute().caretShapeProperty();
    }

    public final void setCaretPosition(int value) {
        if (value == -1 && (this.attributes == null || this.attributes.caretPosition == null)) {
            return;
        }
        this.caretPositionProperty().set(value);
    }

    public final int getCaretPosition() {
        if (this.attributes == null || this.attributes.caretPosition == null) {
            return -1;
        }
        return this.attributes.getCaretPosition();
    }

    public final IntegerProperty caretPositionProperty() {
        return this.getTextAttribute().caretPositionProperty();
    }

    public final void setCaretBias(boolean value) {
        if (value && (this.attributes == null || this.attributes.caretBias == null)) {
            return;
        }
        this.caretBiasProperty().set(value);
    }

    public final boolean isCaretBias() {
        if (this.attributes == null || this.attributes.caretBias == null) {
            return true;
        }
        return this.getTextAttribute().isCaretBias();
    }

    public final BooleanProperty caretBiasProperty() {
        return this.getTextAttribute().caretBiasProperty();
    }

    public final HitInfo hitTest(Point2D point) {
        if (point == null) {
            return null;
        }
        TextLayout layout = this.getTextLayout();
        double x = point.getX() - this.getX();
        double y = point.getY() - this.getY() + (double)this.getYRendering();
        TextLayout.Hit layoutHit = layout.getHitInfo((float)x, (float)y);
        return new HitInfo(layoutHit.getCharIndex(), layoutHit.getInsertionIndex(), layoutHit.isLeading(), this.getText());
    }

    private PathElement[] getRange(int start, int end, int type) {
        int length = this.getTextInternal().length();
        if (0 <= start && start < end && end <= length) {
            TextLayout layout = this.getTextLayout();
            float x = (float)this.getX();
            float y = (float)this.getY() - this.getYRendering();
            return layout.getRange(start, end, type, x, y);
        }
        return EMPTY_PATH_ELEMENT_ARRAY;
    }

    public final PathElement[] caretShape(int charIndex, boolean caretBias) {
        if (0 <= charIndex && charIndex <= this.getTextInternal().length()) {
            float x = (float)this.getX();
            float y = (float)this.getY() - this.getYRendering();
            return this.getTextLayout().getCaretShape(charIndex, caretBias, x, y);
        }
        return null;
    }

    public final PathElement[] rangeShape(int start, int end) {
        return this.getRange(start, end, 1);
    }

    public final PathElement[] underlineShape(int start, int end) {
        return this.getRange(start, end, 2);
    }

    private float getYAdjustment(BaseBounds bounds) {
        VPos origin = this.getTextOrigin();
        if (origin == null) {
            origin = DEFAULT_TEXT_ORIGIN;
        }
        switch (origin) {
            case TOP: {
                return -bounds.getMinY();
            }
            case BASELINE: {
                return 0.0f;
            }
            case CENTER: {
                return -bounds.getMinY() - bounds.getHeight() / 2.0f;
            }
            case BOTTOM: {
                return -bounds.getMinY() - bounds.getHeight();
            }
        }
        return 0.0f;
    }

    private float getYRendering() {
        if (this.isSpan()) {
            return 0.0f;
        }
        BaseBounds bounds = this.getLogicalBounds();
        VPos origin = this.getTextOrigin();
        if (origin == null) {
            origin = DEFAULT_TEXT_ORIGIN;
        }
        if (this.getBoundsType() == TextBoundsType.VISUAL) {
            BaseBounds vBounds = this.getVisualBounds();
            float delta = vBounds.getMinY() - bounds.getMinY();
            switch (origin) {
                case TOP: {
                    return delta;
                }
                case BASELINE: {
                    return -vBounds.getMinY() + delta;
                }
                case CENTER: {
                    return vBounds.getHeight() / 2.0f + delta;
                }
                case BOTTOM: {
                    return vBounds.getHeight() + delta;
                }
            }
            return 0.0f;
        }
        switch (origin) {
            case TOP: {
                return 0.0f;
            }
            case BASELINE: {
                return -bounds.getMinY();
            }
            case CENTER: {
                return bounds.getHeight() / 2.0f;
            }
            case BOTTOM: {
                return bounds.getHeight();
            }
        }
        return 0.0f;
    }

    private Bounds doComputeLayoutBounds() {
        if (this.isSpan()) {
            BaseBounds bounds = this.getSpanBounds();
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            return new BoundingBox(0.0, 0.0, width, height);
        }
        if (this.getBoundsType() == TextBoundsType.VISUAL) {
            return TextHelper.superComputeLayoutBounds(this);
        }
        BaseBounds bounds = this.getLogicalBounds();
        double x = (double)bounds.getMinX() + this.getX();
        double y = (double)bounds.getMinY() + this.getY() + (double)this.getYAdjustment(bounds);
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double wrappingWidth = this.getWrappingWidth();
        if (wrappingWidth != 0.0) {
            width = wrappingWidth;
        }
        return new BoundingBox(x, y, width, height);
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        NodeOrientation orientation;
        if (this.isSpan()) {
            if (ShapeHelper.getMode(this) != NGShape.Mode.FILL && this.getStrokeType() != StrokeType.INSIDE) {
                return TextHelper.superComputeGeomBounds(this, bounds, tx);
            }
            TextLayout layout = this.getTextLayout();
            bounds = layout.getBounds(this.getTextSpan(), bounds);
            BaseBounds spanBounds = this.getSpanBounds();
            float minX = bounds.getMinX() - spanBounds.getMinX();
            float minY = bounds.getMinY() - spanBounds.getMinY();
            float maxX = minX + bounds.getWidth();
            float maxY = minY + bounds.getHeight();
            bounds = bounds.deriveWithNewBounds(minX, minY, 0.0f, maxX, maxY, 0.0f);
            return tx.transform(bounds, bounds);
        }
        if (this.getBoundsType() == TextBoundsType.VISUAL) {
            if (this.getTextInternal().length() == 0 || ShapeHelper.getMode(this) == NGShape.Mode.EMPTY) {
                return bounds.makeEmpty();
            }
            if (ShapeHelper.getMode(this) == NGShape.Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
                BaseBounds visualBounds = this.getVisualBounds();
                float x = visualBounds.getMinX() + (float)this.getX();
                float yadj = this.getYAdjustment(visualBounds);
                float y = visualBounds.getMinY() + yadj + (float)this.getY();
                bounds.deriveWithNewBounds(x, y, 0.0f, x + visualBounds.getWidth(), y + visualBounds.getHeight(), 0.0f);
                return tx.transform(bounds, bounds);
            }
            return TextHelper.superComputeGeomBounds(this, bounds, tx);
        }
        BaseBounds textBounds = this.getLogicalBounds();
        float x = textBounds.getMinX() + (float)this.getX();
        float yadj = this.getYAdjustment(textBounds);
        float y = textBounds.getMinY() + yadj + (float)this.getY();
        float width = textBounds.getWidth();
        float height = textBounds.getHeight();
        float wrappingWidth = (float)this.getWrappingWidth();
        if (wrappingWidth > width) {
            width = wrappingWidth;
        } else if (wrappingWidth > 0.0f && (orientation = this.getEffectiveNodeOrientation()) == NodeOrientation.RIGHT_TO_LEFT) {
            x -= width - wrappingWidth;
        }
        textBounds = new RectBounds(x, y, x + width, y + height);
        if (ShapeHelper.getMode(this) != NGShape.Mode.FILL && this.getStrokeType() != StrokeType.INSIDE) {
            bounds = TextHelper.superComputeGeomBounds(this, bounds, BaseTransform.IDENTITY_TRANSFORM);
        } else {
            TextLayout layout = this.getTextLayout();
            bounds = layout.getBounds(null, bounds);
            x = bounds.getMinX() + (float)this.getX();
            width = bounds.getWidth();
            bounds = bounds.deriveWithNewBounds(x, y, 0.0f, x + width, y + height, 0.0f);
        }
        bounds = bounds.deriveWithUnion(textBounds);
        return tx.transform(bounds, bounds);
    }

    private boolean doComputeContains(double localX, double localY) {
        double x = localX + (double)this.getSpanBounds().getMinX();
        double y = localY + (double)this.getSpanBounds().getMinY();
        GlyphList[] runs = this.getRuns();
        if (runs.length != 0) {
            for (int i = 0; i < runs.length; ++i) {
                GlyphList run = runs[i];
                com.sun.javafx.geom.Point2D location = run.getLocation();
                float width = run.getWidth();
                RectBounds lineBounds = run.getLineBounds();
                float height = lineBounds.getHeight();
                if (!((double)location.x <= x) || !(x < (double)(location.x + width)) || !((double)location.y <= y) || !(y < (double)(location.y + height))) continue;
                return true;
            }
        }
        return false;
    }

    private Shape doConfigShape() {
        float y;
        float x;
        if (ShapeHelper.getMode(this) == NGShape.Mode.EMPTY || this.getTextInternal().length() == 0) {
            return new Path2D();
        }
        Shape shape = this.getShape();
        if (this.isSpan()) {
            BaseBounds bounds = this.getSpanBounds();
            x = -bounds.getMinX();
            y = -bounds.getMinY();
        } else {
            x = (float)this.getX();
            y = this.getYAdjustment(this.getVisualBounds()) + (float)this.getY();
        }
        return TransformedShape.translatedShape(shape, x, y);
    }

    public final IntegerProperty tabSizeProperty() {
        return this.getTextAttribute().tabSizeProperty();
    }

    public final int getTabSize() {
        if (this.attributes == null || this.attributes.tabSize == null) {
            return 8;
        }
        return this.getTextAttribute().getTabSize();
    }

    public final void setTabSize(int spaces) {
        this.tabSizeProperty().set(spaces);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Text.getClassCssMetaData();
    }

    private void updatePGText() {
        NGText peer = (NGText)NodeHelper.getPeer(this);
        if (NodeHelper.isDirty(this, DirtyBits.TEXT_ATTRS)) {
            peer.setUnderline(this.isUnderline());
            peer.setStrikethrough(this.isStrikethrough());
            FontSmoothingType smoothing = this.getFontSmoothingType();
            if (smoothing == null) {
                smoothing = FontSmoothingType.GRAY;
            }
            peer.setFontSmoothingType(smoothing.ordinal());
        }
        if (NodeHelper.isDirty(this, DirtyBits.TEXT_FONT)) {
            peer.setFont(this.getFontInternal());
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_CONTENTS)) {
            peer.setGlyphs(this.getRuns());
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_GEOMETRY)) {
            if (this.isSpan()) {
                BaseBounds spanBounds = this.getSpanBounds();
                peer.setLayoutLocation(spanBounds.getMinX(), spanBounds.getMinY());
            } else {
                float x = (float)this.getX();
                float y = (float)this.getY();
                float yadj = this.getYRendering();
                peer.setLayoutLocation(-x, yadj - y);
            }
        }
        if (NodeHelper.isDirty(this, DirtyBits.TEXT_SELECTION)) {
            Object fillObj = null;
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            int length = this.getTextInternal().length();
            if (0 <= start && start < end && end <= length) {
                Paint fill = (Paint)this.selectionFillProperty().get();
                fillObj = fill != null ? Toolkit.getPaintAccessor().getPlatformPaint(fill) : null;
            }
            peer.setSelection(start, end, fillObj);
        }
    }

    private void doUpdatePeer() {
        this.updatePGText();
    }

    private TextAttribute getTextAttribute() {
        if (this.attributes == null) {
            this.attributes = new TextAttribute();
        }
        return this.attributes;
    }

    @Override
    public String toString() {
        int tab;
        double wrap;
        StringBuilder sb = new StringBuilder("Text[");
        String id = this.getId();
        if (id != null) {
            sb.append("id=").append(id).append(", ");
        }
        sb.append("text=\"").append(this.getText()).append("\"");
        sb.append(", x=").append(this.getX());
        sb.append(", y=").append(this.getY());
        sb.append(", alignment=").append((Object)this.getTextAlignment());
        sb.append(", origin=").append((Object)this.getTextOrigin());
        sb.append(", boundsType=").append((Object)this.getBoundsType());
        double spacing = this.getLineSpacing();
        if (spacing != 0.0) {
            sb.append(", lineSpacing=").append(spacing);
        }
        if ((wrap = this.getWrappingWidth()) != 0.0) {
            sb.append(", wrappingWidth=").append(wrap);
        }
        if ((tab = this.getTabSize()) != 8) {
            sb.append(", tabSize=").append(tab);
        }
        sb.append(", font=").append(this.getFont());
        sb.append(", fontSmoothingType=").append((Object)this.getFontSmoothingType());
        if (this.isStrikethrough()) {
            sb.append(", strikethrough");
        }
        if (this.isUnderline()) {
            sb.append(", underline");
        }
        sb.append(", fill=").append(this.getFill());
        Paint stroke = this.getStroke();
        if (stroke != null) {
            sb.append(", stroke=").append(stroke);
            sb.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return sb.append("]").toString();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case TEXT: {
                String accText = this.getAccessibleText();
                if (accText != null && !accText.isEmpty()) {
                    return accText;
                }
                return this.getText();
            }
            case FONT: {
                return this.getFont();
            }
            case CARET_OFFSET: {
                int sel = this.getCaretPosition();
                if (sel >= 0) {
                    return sel;
                }
                return this.getText().length();
            }
            case SELECTION_START: {
                int sel = this.getSelectionStart();
                if (sel >= 0) {
                    return sel;
                }
                sel = this.getCaretPosition();
                if (sel >= 0) {
                    return sel;
                }
                return this.getText().length();
            }
            case SELECTION_END: {
                int sel = this.getSelectionEnd();
                if (sel >= 0) {
                    return sel;
                }
                sel = this.getCaretPosition();
                if (sel >= 0) {
                    return sel;
                }
                return this.getText().length();
            }
            case LINE_FOR_OFFSET: {
                TextLine line;
                int offset = (Integer)parameters[0];
                if (offset > this.getTextInternal().length()) {
                    return null;
                }
                TextLine[] lines = this.getTextLayout().getLines();
                int lineIndex = 0;
                for (int i = 1; i < lines.length && (line = lines[i]).getStart() <= offset; ++i) {
                    ++lineIndex;
                }
                return lineIndex;
            }
            case LINE_START: {
                int lineIndex = (Integer)parameters[0];
                TextLine[] lines = this.getTextLayout().getLines();
                if (0 <= lineIndex && lineIndex < lines.length) {
                    TextLine line = lines[lineIndex];
                    return line.getStart();
                }
                return null;
            }
            case LINE_END: {
                int lineIndex = (Integer)parameters[0];
                TextLine[] lines = this.getTextLayout().getLines();
                if (0 <= lineIndex && lineIndex < lines.length) {
                    TextLine line = lines[lineIndex];
                    return line.getStart() + line.getLength();
                }
                return null;
            }
            case OFFSET_AT_POINT: {
                Point2D point = (Point2D)parameters[0];
                point = this.screenToLocal(point);
                return this.hitTest(point).getCharIndex();
            }
            case BOUNDS_FOR_RANGE: {
                int start = (Integer)parameters[0];
                int end = (Integer)parameters[1];
                PathElement[] elements = this.rangeShape(start, end + 1);
                Bounds[] bounds = new Bounds[elements.length / 5];
                int index = 0;
                for (int i = 0; i < bounds.length; ++i) {
                    MoveTo topLeft = (MoveTo)elements[index];
                    LineTo topRight = (LineTo)elements[index + 1];
                    LineTo bottomRight = (LineTo)elements[index + 2];
                    BoundingBox b = new BoundingBox(topLeft.getX(), topLeft.getY(), topRight.getX() - topLeft.getX(), bottomRight.getY() - topRight.getY());
                    bounds[i] = this.localToScreen(b);
                    index += 5;
                }
                return bounds;
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    static {
        TextHelper.setTextAccessor(new TextHelper.TextAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((Text)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((Text)node).doUpdatePeer();
            }

            @Override
            public Bounds doComputeLayoutBounds(Node node) {
                return ((Text)node).doComputeLayoutBounds();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((Text)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((Text)node).doComputeContains(localX, localY);
            }

            @Override
            public void doGeomChanged(Node node) {
                ((Text)node).doGeomChanged();
            }

            @Override
            public Shape doConfigShape(javafx.scene.shape.Shape shape) {
                return ((Text)shape).doConfigShape();
            }
        });
        EMPTY_PATH_ELEMENT_ARRAY = new PathElement[0];
        DEFAULT_TEXT_ORIGIN = VPos.BASELINE;
        DEFAULT_BOUNDS_TYPE = TextBoundsType.LOGICAL;
        DEFAULT_TEXT_ALIGNMENT = TextAlignment.LEFT;
        DEFAULT_SELECTION_FILL = Color.WHITE;
    }

    private final class TextAttribute {
        private ObjectProperty<VPos> textOrigin;
        private BooleanProperty underline;
        private BooleanProperty strikethrough;
        private ObjectProperty<TextAlignment> textAlignment;
        private DoubleProperty lineSpacing;
        private ReadOnlyDoubleWrapper baselineOffset;
        private ObjectProperty<PathElement[]> selectionShape;
        private ObjectBinding<PathElement[]> selectionBinding;
        private ObjectProperty<Paint> selectionFill;
        private IntegerProperty selectionStart;
        private IntegerProperty selectionEnd;
        private ObjectProperty<PathElement[]> caretShape;
        private ObjectBinding<PathElement[]> caretBinding;
        private IntegerProperty caretPosition;
        private BooleanProperty caretBias;
        private IntegerProperty tabSize;

        private TextAttribute() {
        }

        final VPos getTextOrigin() {
            return this.textOrigin == null ? DEFAULT_TEXT_ORIGIN : (VPos)((Object)this.textOrigin.get());
        }

        public final ObjectProperty<VPos> textOriginProperty() {
            if (this.textOrigin == null) {
                this.textOrigin = new StyleableObjectProperty<VPos>(DEFAULT_TEXT_ORIGIN){

                    public Object getBean() {
                        return Text.this;
                    }

                    public String getName() {
                        return "textOrigin";
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.TEXT_ORIGIN;
                    }

                    public void invalidated() {
                        NodeHelper.geomChanged(Text.this);
                    }
                };
            }
            return this.textOrigin;
        }

        final boolean isUnderline() {
            return this.underline == null ? false : this.underline.get();
        }

        final BooleanProperty underlineProperty() {
            if (this.underline == null) {
                this.underline = new StyleableBooleanProperty(){

                    public Object getBean() {
                        return Text.this;
                    }

                    public String getName() {
                        return "underline";
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.UNDERLINE;
                    }

                    public void invalidated() {
                        NodeHelper.markDirty(Text.this, DirtyBits.TEXT_ATTRS);
                        if (Text.this.getBoundsType() == TextBoundsType.VISUAL) {
                            NodeHelper.geomChanged(Text.this);
                        }
                    }
                };
            }
            return this.underline;
        }

        final boolean isStrikethrough() {
            return this.strikethrough == null ? false : this.strikethrough.get();
        }

        final BooleanProperty strikethroughProperty() {
            if (this.strikethrough == null) {
                this.strikethrough = new StyleableBooleanProperty(){

                    public Object getBean() {
                        return Text.this;
                    }

                    public String getName() {
                        return "strikethrough";
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.STRIKETHROUGH;
                    }

                    public void invalidated() {
                        NodeHelper.markDirty(Text.this, DirtyBits.TEXT_ATTRS);
                        if (Text.this.getBoundsType() == TextBoundsType.VISUAL) {
                            NodeHelper.geomChanged(Text.this);
                        }
                    }
                };
            }
            return this.strikethrough;
        }

        final TextAlignment getTextAlignment() {
            return this.textAlignment == null ? DEFAULT_TEXT_ALIGNMENT : (TextAlignment)((Object)this.textAlignment.get());
        }

        final ObjectProperty<TextAlignment> textAlignmentProperty() {
            if (this.textAlignment == null) {
                this.textAlignment = new StyleableObjectProperty<TextAlignment>(DEFAULT_TEXT_ALIGNMENT){

                    public Object getBean() {
                        return Text.this;
                    }

                    public String getName() {
                        return "textAlignment";
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.TEXT_ALIGNMENT;
                    }

                    public void invalidated() {
                        if (!Text.this.isSpan()) {
                            TextLayout layout;
                            TextAlignment alignment = (TextAlignment)((Object)this.get());
                            if (alignment == null) {
                                alignment = DEFAULT_TEXT_ALIGNMENT;
                            }
                            if ((layout = Text.this.getTextLayout()).setAlignment(alignment.ordinal())) {
                                Text.this.needsTextLayout();
                            }
                        }
                    }
                };
            }
            return this.textAlignment;
        }

        final double getLineSpacing() {
            return this.lineSpacing == null ? 0.0 : this.lineSpacing.get();
        }

        final DoubleProperty lineSpacingProperty() {
            if (this.lineSpacing == null) {
                this.lineSpacing = new StyleableDoubleProperty(0.0){

                    public Object getBean() {
                        return Text.this;
                    }

                    public String getName() {
                        return "lineSpacing";
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.LINE_SPACING;
                    }

                    public void invalidated() {
                        TextLayout layout;
                        if (!Text.this.isSpan() && (layout = Text.this.getTextLayout()).setLineSpacing((float)this.get())) {
                            Text.this.needsTextLayout();
                        }
                    }
                };
            }
            return this.lineSpacing;
        }

        final ReadOnlyDoubleProperty baselineOffsetProperty() {
            if (this.baselineOffset == null) {
                this.baselineOffset = new ReadOnlyDoubleWrapper(Text.this, "baselineOffset"){
                    {
                        this.bind((ObservableValue)new DoubleBinding(){
                            {
                                this.bind(new Observable[]{Text.this.fontProperty()});
                            }

                            protected double computeValue() {
                                BaseBounds bounds = Text.this.getLogicalBounds();
                                return -bounds.getMinY();
                            }
                        });
                    }
                };
            }
            return this.baselineOffset.getReadOnlyProperty();
        }

        final ReadOnlyObjectProperty<PathElement[]> selectionShapeProperty() {
            if (this.selectionShape == null) {
                this.selectionBinding = new ObjectBinding<PathElement[]>(){
                    {
                        this.bind(new Observable[]{TextAttribute.this.selectionStartProperty(), TextAttribute.this.selectionEndProperty()});
                    }

                    protected PathElement[] computeValue() {
                        int start = TextAttribute.this.getSelectionStart();
                        int end = TextAttribute.this.getSelectionEnd();
                        return Text.this.getRange(start, end, 1);
                    }
                };
                this.selectionShape = new SimpleObjectProperty((Object)Text.this, "selectionShape");
                this.selectionShape.bind(this.selectionBinding);
            }
            return this.selectionShape;
        }

        final ObjectProperty<Paint> selectionFillProperty() {
            if (this.selectionFill == null) {
                this.selectionFill = new ObjectPropertyBase<Paint>((Paint)DEFAULT_SELECTION_FILL){

                    public Object getBean() {
                        return Text.this;
                    }

                    public String getName() {
                        return "selectionFill";
                    }

                    protected void invalidated() {
                        NodeHelper.markDirty(Text.this, DirtyBits.TEXT_SELECTION);
                    }
                };
            }
            return this.selectionFill;
        }

        final int getSelectionStart() {
            return this.selectionStart == null ? -1 : this.selectionStart.get();
        }

        final IntegerProperty selectionStartProperty() {
            if (this.selectionStart == null) {
                this.selectionStart = new IntegerPropertyBase(-1){

                    public Object getBean() {
                        return Text.this;
                    }

                    public String getName() {
                        return "selectionStart";
                    }

                    protected void invalidated() {
                        NodeHelper.markDirty(Text.this, DirtyBits.TEXT_SELECTION);
                        Text.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_START);
                    }
                };
            }
            return this.selectionStart;
        }

        final int getSelectionEnd() {
            return this.selectionEnd == null ? -1 : this.selectionEnd.get();
        }

        final IntegerProperty selectionEndProperty() {
            if (this.selectionEnd == null) {
                this.selectionEnd = new IntegerPropertyBase(-1){

                    public Object getBean() {
                        return Text.this;
                    }

                    public String getName() {
                        return "selectionEnd";
                    }

                    protected void invalidated() {
                        NodeHelper.markDirty(Text.this, DirtyBits.TEXT_SELECTION);
                        Text.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_END);
                    }
                };
            }
            return this.selectionEnd;
        }

        final ReadOnlyObjectProperty<PathElement[]> caretShapeProperty() {
            if (this.caretShape == null) {
                this.caretBinding = new ObjectBinding<PathElement[]>(){
                    {
                        this.bind(new Observable[]{TextAttribute.this.caretPositionProperty(), TextAttribute.this.caretBiasProperty()});
                    }

                    protected PathElement[] computeValue() {
                        int pos = TextAttribute.this.getCaretPosition();
                        int length = Text.this.getTextInternal().length();
                        if (0 <= pos && pos <= length) {
                            boolean bias = TextAttribute.this.isCaretBias();
                            float x = (float)Text.this.getX();
                            float y = (float)Text.this.getY() - Text.this.getYRendering();
                            TextLayout layout = Text.this.getTextLayout();
                            return layout.getCaretShape(pos, bias, x, y);
                        }
                        return EMPTY_PATH_ELEMENT_ARRAY;
                    }
                };
                this.caretShape = new SimpleObjectProperty((Object)Text.this, "caretShape");
                this.caretShape.bind(this.caretBinding);
            }
            return this.caretShape;
        }

        final int getCaretPosition() {
            return this.caretPosition == null ? -1 : this.caretPosition.get();
        }

        final IntegerProperty caretPositionProperty() {
            if (this.caretPosition == null) {
                this.caretPosition = new IntegerPropertyBase(-1){

                    public Object getBean() {
                        return Text.this;
                    }

                    public String getName() {
                        return "caretPosition";
                    }

                    protected void invalidated() {
                        Text.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_END);
                    }
                };
            }
            return this.caretPosition;
        }

        final boolean isCaretBias() {
            return this.caretBias == null ? true : this.caretBias.get();
        }

        final BooleanProperty caretBiasProperty() {
            if (this.caretBias == null) {
                this.caretBias = new SimpleBooleanProperty((Object)Text.this, "caretBias", true);
            }
            return this.caretBias;
        }

        final int getTabSize() {
            return this.tabSize == null ? 8 : this.tabSize.get();
        }

        final IntegerProperty tabSizeProperty() {
            if (this.tabSize == null) {
                this.tabSize = new StyleableIntegerProperty(8){

                    public Object getBean() {
                        return Text.this;
                    }

                    public String getName() {
                        return "tabSize";
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.TAB_SIZE;
                    }

                    protected void invalidated() {
                        if (!Text.this.isSpan()) {
                            TextLayout layout = Text.this.getTextLayout();
                            if (layout.setTabSize(this.get())) {
                                Text.this.needsTextLayout();
                            }
                            NodeHelper.markDirty(Text.this, DirtyBits.TEXT_ATTRS);
                            if (Text.this.getBoundsType() == TextBoundsType.VISUAL) {
                                NodeHelper.geomChanged(Text.this);
                            }
                        }
                    }
                };
            }
            return this.tabSize;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<Text, Font> FONT = new FontCssMetaData<Text>("-fx-font", Font.getDefault()){

            @Override
            public boolean isSettable(Text node) {
                return node.font == null || !node.font.isBound();
            }

            @Override
            public StyleableProperty<Font> getStyleableProperty(Text node) {
                return (StyleableProperty)node.fontProperty();
            }
        };
        private static final CssMetaData<Text, Boolean> UNDERLINE = new CssMetaData<Text, Boolean>("-fx-underline", BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(Text node) {
                return node.attributes == null || node.attributes.underline == null || !node.attributes.underline.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Text node) {
                return (StyleableProperty)node.underlineProperty();
            }
        };
        private static final CssMetaData<Text, Boolean> STRIKETHROUGH = new CssMetaData<Text, Boolean>("-fx-strikethrough", BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(Text node) {
                return node.attributes == null || node.attributes.strikethrough == null || !node.attributes.strikethrough.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Text node) {
                return (StyleableProperty)node.strikethroughProperty();
            }
        };
        private static final CssMetaData<Text, TextAlignment> TEXT_ALIGNMENT = new CssMetaData<Text, TextAlignment>("-fx-text-alignment", new EnumConverter<TextAlignment>(TextAlignment.class), TextAlignment.LEFT){

            @Override
            public boolean isSettable(Text node) {
                return node.attributes == null || node.attributes.textAlignment == null || !node.attributes.textAlignment.isBound();
            }

            @Override
            public StyleableProperty<TextAlignment> getStyleableProperty(Text node) {
                return (StyleableProperty)node.textAlignmentProperty();
            }
        };
        private static final CssMetaData<Text, VPos> TEXT_ORIGIN = new CssMetaData<Text, VPos>("-fx-text-origin", new EnumConverter<VPos>(VPos.class), VPos.BASELINE){

            @Override
            public boolean isSettable(Text node) {
                return node.attributes == null || node.attributes.textOrigin == null || !node.attributes.textOrigin.isBound();
            }

            @Override
            public StyleableProperty<VPos> getStyleableProperty(Text node) {
                return (StyleableProperty)node.textOriginProperty();
            }
        };
        private static final CssMetaData<Text, FontSmoothingType> FONT_SMOOTHING_TYPE = new CssMetaData<Text, FontSmoothingType>("-fx-font-smoothing-type", new EnumConverter<FontSmoothingType>(FontSmoothingType.class), FontSmoothingType.GRAY){

            @Override
            public boolean isSettable(Text node) {
                return node.fontSmoothingType == null || !node.fontSmoothingType.isBound();
            }

            @Override
            public StyleableProperty<FontSmoothingType> getStyleableProperty(Text node) {
                return (StyleableProperty)node.fontSmoothingTypeProperty();
            }
        };
        private static final CssMetaData<Text, Number> LINE_SPACING = new CssMetaData<Text, Number>("-fx-line-spacing", SizeConverter.getInstance(), (Number)0){

            @Override
            public boolean isSettable(Text node) {
                return node.attributes == null || node.attributes.lineSpacing == null || !node.attributes.lineSpacing.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Text node) {
                return (StyleableProperty)node.lineSpacingProperty();
            }
        };
        private static final CssMetaData<Text, TextBoundsType> BOUNDS_TYPE = new CssMetaData<Text, TextBoundsType>("-fx-bounds-type", new EnumConverter<TextBoundsType>(TextBoundsType.class), DEFAULT_BOUNDS_TYPE){

            @Override
            public boolean isSettable(Text node) {
                return node.boundsType == null || !node.boundsType.isBound();
            }

            @Override
            public StyleableProperty<TextBoundsType> getStyleableProperty(Text node) {
                return (StyleableProperty)node.boundsTypeProperty();
            }
        };
        private static final CssMetaData<Text, Number> TAB_SIZE = new CssMetaData<Text, Number>("-fx-tab-size", SizeConverter.getInstance(), (Number)8){

            @Override
            public boolean isSettable(Text node) {
                return node.attributes == null || node.attributes.tabSize == null || !node.attributes.tabSize.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Text node) {
                return (StyleableProperty)node.tabSizeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(javafx.scene.shape.Shape.getClassCssMetaData());
            styleables.add(FONT);
            styleables.add(UNDERLINE);
            styleables.add(STRIKETHROUGH);
            styleables.add(TEXT_ALIGNMENT);
            styleables.add(TEXT_ORIGIN);
            styleables.add(FONT_SMOOTHING_TYPE);
            styleables.add(LINE_SPACING);
            styleables.add(BOUNDS_TYPE);
            styleables.add(TAB_SIZE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

