/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.text;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLayoutFactory;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.shape.PathElement;
import javafx.scene.text.HitInfo;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class TextFlow
extends Pane {
    private TextLayout layout;
    private boolean needsContent;
    private boolean inLayout;
    private ObjectProperty<TextAlignment> textAlignment;
    private DoubleProperty lineSpacing;
    private IntegerProperty tabSize;

    public TextFlow() {
        this.effectiveNodeOrientationProperty().addListener(observable -> this.checkOrientation());
        this.setAccessibleRole(AccessibleRole.TEXT);
    }

    public TextFlow(Node ... children) {
        this();
        this.getChildren().addAll((Object[])children);
    }

    private void checkOrientation() {
        NodeOrientation orientation = this.getEffectiveNodeOrientation();
        boolean rtl = orientation == NodeOrientation.RIGHT_TO_LEFT;
        int dir = rtl ? 2048 : 1024;
        TextLayout layout = this.getTextLayout();
        if (layout.setDirection(dir)) {
            this.requestLayout();
        }
    }

    public final HitInfo hitTest(Point2D point) {
        if (point != null) {
            TextLayout layout = this.getTextLayout();
            double x = point.getX();
            double y = point.getY();
            TextLayout.Hit layoutHit = layout.getHitInfo((float)x, (float)y);
            return new HitInfo(layoutHit.getCharIndex(), layoutHit.getInsertionIndex(), layoutHit.isLeading(), null);
        }
        return null;
    }

    public PathElement[] caretShape(int charIndex, boolean leading) {
        return this.getTextLayout().getCaretShape(charIndex, leading, 0.0f, 0.0f);
    }

    public final PathElement[] rangeShape(int start, int end) {
        return this.getRange(start, end, 1);
    }

    @Override
    public boolean usesMirroring() {
        return false;
    }

    @Override
    protected void setWidth(double value) {
        if (value != this.getWidth()) {
            TextLayout layout = this.getTextLayout();
            Insets insets = this.getInsets();
            double left = this.snapSpaceX(insets.getLeft());
            double right = this.snapSpaceX(insets.getRight());
            double width = Math.max(1.0, value - left - right);
            layout.setWrapWidth((float)width);
            super.setWidth(value);
        }
    }

    @Override
    protected double computePrefWidth(double height) {
        TextLayout layout = this.getTextLayout();
        layout.setWrapWidth(0.0f);
        double width = layout.getBounds().getWidth();
        Insets insets = this.getInsets();
        double left = this.snapSpaceX(insets.getLeft());
        double right = this.snapSpaceX(insets.getRight());
        double wrappingWidth = Math.max(1.0, this.getWidth() - left - right);
        layout.setWrapWidth((float)wrappingWidth);
        return left + width + right;
    }

    @Override
    protected double computePrefHeight(double width) {
        TextLayout layout = this.getTextLayout();
        Insets insets = this.getInsets();
        double left = this.snapSpaceX(insets.getLeft());
        double right = this.snapSpaceX(insets.getRight());
        if (width == -1.0) {
            layout.setWrapWidth(0.0f);
        } else {
            double wrappingWidth = Math.max(1.0, width - left - right);
            layout.setWrapWidth((float)wrappingWidth);
        }
        double height = layout.getBounds().getHeight();
        double wrappingWidth = Math.max(1.0, this.getWidth() - left - right);
        layout.setWrapWidth((float)wrappingWidth);
        double top = this.snapSpaceY(insets.getTop());
        double bottom = this.snapSpaceY(insets.getBottom());
        return top + height + bottom;
    }

    @Override
    protected double computeMinHeight(double width) {
        return this.computePrefHeight(width);
    }

    @Override
    public void requestLayout() {
        if (this.inLayout) {
            return;
        }
        this.needsContent = true;
        super.requestLayout();
    }

    @Override
    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    @Override
    protected void layoutChildren() {
        this.inLayout = true;
        Insets insets = this.getInsets();
        double top = this.snapSpaceY(insets.getTop());
        double left = this.snapSpaceX(insets.getLeft());
        GlyphList[] runs = this.getTextLayout().getRuns();
        for (int j = 0; j < runs.length; ++j) {
            GlyphList run = runs[j];
            TextSpan span = run.getTextSpan();
            if (!(span instanceof EmbeddedSpan)) continue;
            Node child = ((EmbeddedSpan)span).getNode();
            com.sun.javafx.geom.Point2D location = run.getLocation();
            double baselineOffset = -run.getLineBounds().getMinY();
            this.layoutInArea(child, left + (double)location.x, top + (double)location.y, run.getWidth(), run.getHeight(), baselineOffset, null, true, true, HPos.CENTER, VPos.BASELINE);
        }
        List managed = this.getManagedChildren();
        for (Node node : managed) {
            if (!(node instanceof Text)) continue;
            Text text = (Text)node;
            text.layoutSpan(runs);
            BaseBounds spanBounds = text.getSpanBounds();
            text.relocate(left + (double)spanBounds.getMinX(), top + (double)spanBounds.getMinY());
        }
        this.inLayout = false;
    }

    private PathElement[] getRange(int start, int end, int type) {
        TextLayout layout = this.getTextLayout();
        return layout.getRange(start, end, type, 0.0f, 0.0f);
    }

    TextLayout getTextLayout() {
        if (this.layout == null) {
            TextLayoutFactory factory = Toolkit.getToolkit().getTextLayoutFactory();
            this.layout = factory.createLayout();
            this.layout.setTabSize(this.getTabSize());
            this.needsContent = true;
        }
        if (this.needsContent) {
            List children = this.getManagedChildren();
            TextSpan[] spans = new TextSpan[children.size()];
            for (int i = 0; i < spans.length; ++i) {
                Node node = (Node)children.get(i);
                if (node instanceof Text) {
                    spans[i] = ((Text)node).getTextSpan();
                    continue;
                }
                double baseline = node.getBaselineOffset();
                if (baseline == Double.NEGATIVE_INFINITY) {
                    baseline = node.getLayoutBounds().getHeight();
                }
                double width = this.computeChildPrefAreaWidth(node, null);
                double height = this.computeChildPrefAreaHeight(node, null);
                spans[i] = new EmbeddedSpan(node, baseline, width, height);
            }
            this.layout.setContent(spans);
            this.needsContent = false;
        }
        return this.layout;
    }

    public final void setTextAlignment(TextAlignment value) {
        this.textAlignmentProperty().set((Object)value);
    }

    public final TextAlignment getTextAlignment() {
        return this.textAlignment == null ? TextAlignment.LEFT : (TextAlignment)((Object)this.textAlignment.get());
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        if (this.textAlignment == null) {
            this.textAlignment = new StyleableObjectProperty<TextAlignment>(TextAlignment.LEFT){

                public Object getBean() {
                    return TextFlow.this;
                }

                public String getName() {
                    return "textAlignment";
                }

                @Override
                public CssMetaData<TextFlow, TextAlignment> getCssMetaData() {
                    return StyleableProperties.TEXT_ALIGNMENT;
                }

                public void invalidated() {
                    TextAlignment align = (TextAlignment)((Object)this.get());
                    if (align == null) {
                        align = TextAlignment.LEFT;
                    }
                    TextLayout layout = TextFlow.this.getTextLayout();
                    layout.setAlignment(align.ordinal());
                    TextFlow.this.requestLayout();
                }
            };
        }
        return this.textAlignment;
    }

    public final void setLineSpacing(double spacing) {
        this.lineSpacingProperty().set(spacing);
    }

    public final double getLineSpacing() {
        return this.lineSpacing == null ? 0.0 : this.lineSpacing.get();
    }

    public final DoubleProperty lineSpacingProperty() {
        if (this.lineSpacing == null) {
            this.lineSpacing = new StyleableDoubleProperty(0.0){

                public Object getBean() {
                    return TextFlow.this;
                }

                public String getName() {
                    return "lineSpacing";
                }

                @Override
                public CssMetaData<TextFlow, Number> getCssMetaData() {
                    return StyleableProperties.LINE_SPACING;
                }

                public void invalidated() {
                    TextLayout layout = TextFlow.this.getTextLayout();
                    if (layout.setLineSpacing((float)this.get())) {
                        TextFlow.this.requestLayout();
                    }
                }
            };
        }
        return this.lineSpacing;
    }

    public final IntegerProperty tabSizeProperty() {
        if (this.tabSize == null) {
            this.tabSize = new StyleableIntegerProperty(8){

                public Object getBean() {
                    return TextFlow.this;
                }

                public String getName() {
                    return "tabSize";
                }

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TAB_SIZE;
                }

                protected void invalidated() {
                    TextLayout layout = TextFlow.this.getTextLayout();
                    if (layout.setTabSize(this.get())) {
                        TextFlow.this.requestLayout();
                    }
                }
            };
        }
        return this.tabSize;
    }

    public final int getTabSize() {
        return this.tabSize == null ? 8 : this.tabSize.get();
    }

    public final void setTabSize(int spaces) {
        this.tabSizeProperty().set(spaces);
    }

    @Override
    public final double getBaselineOffset() {
        Insets insets = this.getInsets();
        double top = this.snapSpaceY(insets.getTop());
        return top - (double)this.getTextLayout().getBounds().getMinY();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TextFlow.getClassCssMetaData();
    }

    static double boundedSize(double min, double pref, double max) {
        double a = pref >= min ? pref : min;
        double b = min >= max ? min : max;
        return a <= b ? a : b;
    }

    double computeChildPrefAreaWidth(Node child, Insets margin) {
        return this.computeChildPrefAreaWidth(child, margin, -1.0);
    }

    double computeChildPrefAreaWidth(Node child, Insets margin, double height) {
        double top = margin != null ? this.snapSpaceY(margin.getTop()) : 0.0;
        double bottom = margin != null ? this.snapSpaceY(margin.getBottom()) : 0.0;
        double left = margin != null ? this.snapSpaceX(margin.getLeft()) : 0.0;
        double right = margin != null ? this.snapSpaceX(margin.getRight()) : 0.0;
        double alt = -1.0;
        if (child.getContentBias() == Orientation.VERTICAL) {
            alt = this.snapSizeY(TextFlow.boundedSize(child.minHeight(-1.0), height != -1.0 ? height - top - bottom : child.prefHeight(-1.0), child.maxHeight(-1.0)));
        }
        return left + this.snapSizeX(TextFlow.boundedSize(child.minWidth(alt), child.prefWidth(alt), child.maxWidth(alt))) + right;
    }

    double computeChildPrefAreaHeight(Node child, Insets margin) {
        return this.computeChildPrefAreaHeight(child, margin, -1.0);
    }

    double computeChildPrefAreaHeight(Node child, Insets margin, double width) {
        double top = margin != null ? this.snapSpaceY(margin.getTop()) : 0.0;
        double bottom = margin != null ? this.snapSpaceY(margin.getBottom()) : 0.0;
        double left = margin != null ? this.snapSpaceX(margin.getLeft()) : 0.0;
        double right = margin != null ? this.snapSpaceX(margin.getRight()) : 0.0;
        double alt = -1.0;
        if (child.getContentBias() == Orientation.HORIZONTAL) {
            alt = this.snapSizeX(TextFlow.boundedSize(child.minWidth(-1.0), width != -1.0 ? width - left - right : child.prefWidth(-1.0), child.maxWidth(-1.0)));
        }
        return top + this.snapSizeY(TextFlow.boundedSize(child.minHeight(alt), child.prefHeight(alt), child.maxHeight(alt))) + bottom;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case TEXT: {
                String accText = this.getAccessibleText();
                if (accText != null && !accText.isEmpty()) {
                    return accText;
                }
                StringBuilder title = new StringBuilder();
                for (Node node : this.getChildren()) {
                    Object text = node.queryAccessibleAttribute(AccessibleAttribute.TEXT, parameters);
                    if (text == null) continue;
                    title.append(text.toString());
                }
                return title.toString();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    private static class EmbeddedSpan
    implements TextSpan {
        RectBounds bounds;
        Node node;

        public EmbeddedSpan(Node node, double baseline, double width, double height) {
            this.node = node;
            this.bounds = new RectBounds(0.0f, (float)(-baseline), (float)width, (float)(height - baseline));
        }

        @Override
        public String getText() {
            return "\ufffc";
        }

        @Override
        public Object getFont() {
            return null;
        }

        @Override
        public RectBounds getBounds() {
            return this.bounds;
        }

        public Node getNode() {
            return this.node;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<TextFlow, TextAlignment> TEXT_ALIGNMENT = new CssMetaData<TextFlow, TextAlignment>("-fx-text-alignment", new EnumConverter<TextAlignment>(TextAlignment.class), TextAlignment.LEFT){

            @Override
            public boolean isSettable(TextFlow node) {
                return node.textAlignment == null || !node.textAlignment.isBound();
            }

            @Override
            public StyleableProperty<TextAlignment> getStyleableProperty(TextFlow node) {
                return (StyleableProperty)node.textAlignmentProperty();
            }
        };
        private static final CssMetaData<TextFlow, Number> LINE_SPACING = new CssMetaData<TextFlow, Number>("-fx-line-spacing", SizeConverter.getInstance(), (Number)0){

            @Override
            public boolean isSettable(TextFlow node) {
                return node.lineSpacing == null || !node.lineSpacing.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TextFlow node) {
                return (StyleableProperty)node.lineSpacingProperty();
            }
        };
        private static final CssMetaData<TextFlow, Number> TAB_SIZE = new CssMetaData<TextFlow, Number>("-fx-tab-size", SizeConverter.getInstance(), (Number)8){

            @Override
            public boolean isSettable(TextFlow node) {
                return node.tabSize == null || !node.tabSize.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TextFlow node) {
                return (StyleableProperty)node.tabSizeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Pane.getClassCssMetaData());
            styleables.add(TEXT_ALIGNMENT);
            styleables.add(LINE_SPACING);
            styleables.add(TAB_SIZE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

