/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.media;

import com.sun.javafx.tk.Toolkit;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javafx.scene.media.MediaPlayer;

class MediaPlayerShutdownHook
implements Runnable {
    private static final List<WeakReference<MediaPlayer>> playerRefs = new ArrayList<WeakReference<MediaPlayer>>();
    private static boolean isShutdown = false;

    MediaPlayerShutdownHook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMediaPlayer(MediaPlayer player) {
        List<WeakReference<MediaPlayer>> list = playerRefs;
        synchronized (list) {
            if (isShutdown) {
                com.sun.media.jfxmedia.MediaPlayer jfxPlayer = player.retrieveJfxPlayer();
                if (jfxPlayer != null) {
                    jfxPlayer.dispose();
                }
            } else {
                ListIterator<WeakReference<MediaPlayer>> it = playerRefs.listIterator();
                while (it.hasNext()) {
                    MediaPlayer l = (MediaPlayer)it.next().get();
                    if (l != null) continue;
                    it.remove();
                }
                playerRefs.add(new WeakReference<MediaPlayer>(player));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<WeakReference<MediaPlayer>> list = playerRefs;
        synchronized (list) {
            ListIterator<WeakReference<MediaPlayer>> it = playerRefs.listIterator();
            while (it.hasNext()) {
                MediaPlayer player = (MediaPlayer)it.next().get();
                if (player != null) {
                    player.destroyMediaTimer();
                    com.sun.media.jfxmedia.MediaPlayer jfxPlayer = player.retrieveJfxPlayer();
                    if (jfxPlayer == null) continue;
                    jfxPlayer.dispose();
                    continue;
                }
                it.remove();
            }
            isShutdown = true;
        }
    }

    static {
        Toolkit.getToolkit().addShutdownHook((Runnable)new MediaPlayerShutdownHook());
    }
}

