/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.locator.ConnectionHolder;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmediaimpl.MediaUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

final class HLSConnectionHolder
extends ConnectionHolder {
    private URLConnection urlConnection = null;
    private URLConnection headerConnection = null;
    private ReadableByteChannel headerChannel = null;
    private PlaylistThread playlistThread = new PlaylistThread();
    private VariantPlaylist variantPlaylist = null;
    private Playlist currentPlaylist = null;
    private int mediaFileIndex = -1;
    private CountDownLatch readySignal = new CountDownLatch(1);
    private Semaphore liveSemaphore = new Semaphore(0);
    private boolean isPlaylistClosed = false;
    private boolean isBitrateAdjustable = false;
    private long startTime = -1L;
    private boolean sendHeader = false;
    private static final long HLS_VALUE_FLOAT_MULTIPLIER = 1000L;
    private static final int HLS_PROP_GET_DURATION = 1;
    private static final int HLS_PROP_GET_HLS_MODE = 2;
    private static final int HLS_PROP_GET_MIMETYPE = 3;
    private static final int HLS_PROP_LOAD_SEGMENT = 4;
    private static final int HLS_PROP_SEGMENT_START_TIME = 5;
    private static final int HLS_VALUE_MIMETYPE_UNKNOWN = -1;
    private static final int HLS_VALUE_MIMETYPE_MP2T = 1;
    private static final int HLS_VALUE_MIMETYPE_MP3 = 2;
    private static final int HLS_VALUE_MIMETYPE_FMP4 = 3;
    private static final int HLS_VALUE_MIMETYPE_AAC = 4;
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final String CHARSET_US_ASCII = "US-ASCII";

    HLSConnectionHolder(URI uri) throws IOException {
        this.playlistThread.setPlaylistURI(uri);
        this.init();
    }

    private void init() {
        this.playlistThread.putState(0);
        this.playlistThread.start();
    }

    @Override
    public int readNextBlock() throws IOException {
        int read;
        if (this.isBitrateAdjustable && this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.headerChannel != null) {
            this.buffer.rewind();
            if (this.buffer.limit() < this.buffer.capacity()) {
                this.buffer.limit(this.buffer.capacity());
            }
            if ((read = this.headerChannel.read(this.buffer)) == -1) {
                this.resetHeaderConnection();
            } else {
                return read;
            }
        }
        read = super.readNextBlock();
        if (this.isBitrateAdjustable && read == -1) {
            long readTime = System.currentTimeMillis() - this.startTime;
            this.startTime = -1L;
            this.adjustBitrate(readTime);
        }
        return read;
    }

    @Override
    int readBlock(long position, int size) throws IOException {
        throw new IOException();
    }

    @Override
    boolean needBuffer() {
        return true;
    }

    @Override
    boolean isSeekable() {
        return true;
    }

    @Override
    boolean isRandomAccess() {
        return false;
    }

    @Override
    public long seek(long position) {
        try {
            this.readySignal.await();
        }
        catch (InterruptedException e) {
            return -1L;
        }
        return (long)(this.currentPlaylist.seek(position) * 1000.0);
    }

    @Override
    public void closeConnection() {
        this.currentPlaylist.close();
        super.closeConnection();
        this.resetConnection();
        this.playlistThread.putState(1);
    }

    @Override
    int property(int prop, int value) {
        try {
            this.readySignal.await();
        }
        catch (InterruptedException e) {
            return -1;
        }
        switch (prop) {
            case 1: {
                return (int)(this.currentPlaylist.getDuration() * 1000.0);
            }
            case 2: {
                return 1;
            }
            case 3: {
                return this.currentPlaylist.getMimeType();
            }
            case 4: {
                return this.loadNextSegment();
            }
            case 5: {
                return (int)(this.currentPlaylist.getMediaFileStartTime() * 1000.0);
            }
        }
        return -1;
    }

    private void resetConnection() {
        super.closeConnection();
        this.resetHeaderConnection();
        Locator.closeConnection(this.urlConnection);
        this.urlConnection = null;
    }

    private void resetHeaderConnection() {
        try {
            if (this.headerChannel != null) {
                this.headerChannel.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.headerChannel = null;
        }
        Locator.closeConnection(this.headerConnection);
        this.headerConnection = null;
    }

    private int loadNextSegment() {
        URI uri;
        String mediaFile;
        this.resetConnection();
        int headerLength = 0;
        if (this.sendHeader) {
            mediaFile = this.currentPlaylist.getHeaderFile();
            if (mediaFile == null) {
                return -1;
            }
            try {
                uri = new URI(mediaFile);
                this.headerConnection = uri.toURL().openConnection();
                this.headerChannel = this.openHeaderChannel();
                headerLength = this.headerConnection.getContentLength();
            }
            catch (IOException | URISyntaxException e) {
                return -1;
            }
            this.sendHeader = false;
        }
        if ((mediaFile = this.currentPlaylist.getNextMediaFile()) == null) {
            if (this.currentPlaylist.isFragmentedMP4()) {
                this.sendHeader = true;
            }
            return -1;
        }
        try {
            uri = new URI(mediaFile);
            this.urlConnection = uri.toURL().openConnection();
            this.channel = this.openChannel();
        }
        catch (IOException | URISyntaxException e) {
            return -1;
        }
        if (this.currentPlaylist.isCurrentMediaFileDiscontinuity()) {
            return -1 * (this.urlConnection.getContentLength() + headerLength);
        }
        return this.urlConnection.getContentLength() + headerLength;
    }

    private ReadableByteChannel openChannel() throws IOException {
        return Channels.newChannel(this.urlConnection.getInputStream());
    }

    private ReadableByteChannel openHeaderChannel() throws IOException {
        return Channels.newChannel(this.headerConnection.getInputStream());
    }

    private void adjustBitrate(long readTime) {
        int avgBitrate = (int)((long)this.urlConnection.getContentLength() * 8L * 1000L / readTime);
        Playlist playlist = this.variantPlaylist.getPlaylistBasedOnBitrate(avgBitrate);
        if (playlist != null && playlist != this.currentPlaylist) {
            if (this.currentPlaylist.isLive()) {
                playlist.update(this.currentPlaylist.getNextMediaFile());
                this.playlistThread.setReloadPlaylist(playlist);
            }
            playlist.setForceDiscontinuity(true);
            this.currentPlaylist = playlist;
            if (this.currentPlaylist.isFragmentedMP4()) {
                this.sendHeader = true;
            }
        }
    }

    private static String stripParameters(String mediaFile) {
        int qp = mediaFile.indexOf(63);
        if (qp > 0) {
            mediaFile = mediaFile.substring(0, qp);
        }
        return mediaFile;
    }

    private class PlaylistThread
    extends Thread {
        public static final int STATE_INIT = 0;
        public static final int STATE_EXIT = 1;
        public static final int STATE_RELOAD_PLAYLIST = 2;
        private final BlockingQueue<Integer> stateQueue = new LinkedBlockingQueue<Integer>();
        private URI playlistURI = null;
        private Playlist reloadPlaylist = null;
        private final Object reloadLock = new Object();
        private volatile boolean stopped = false;

        private PlaylistThread() {
            this.setName("JFXMedia HLS Playlist Thread");
            this.setDaemon(true);
        }

        private void setPlaylistURI(URI playlistURI) {
            this.playlistURI = playlistURI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setReloadPlaylist(Playlist playlist) {
            Object object = this.reloadLock;
            synchronized (object) {
                this.reloadPlaylist = playlist;
            }
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    int state = this.stateQueue.take();
                    switch (state) {
                        case 0: {
                            this.stateInit();
                            break;
                        }
                        case 1: {
                            this.stopped = true;
                            break;
                        }
                        case 2: {
                            this.stateReloadPlaylist();
                            break;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void putState(int state) {
            if (this.stateQueue != null) {
                try {
                    this.stateQueue.put(state);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private void stateInit() {
            if (this.playlistURI == null) {
                return;
            }
            try {
                PlaylistParser parser = new PlaylistParser();
                parser.load(this.playlistURI);
                if (parser.isVariantPlaylist()) {
                    HLSConnectionHolder.this.variantPlaylist = new VariantPlaylist(this.playlistURI);
                    while (parser.hasNext()) {
                        HLSConnectionHolder.this.variantPlaylist.addPlaylistInfo(parser.getString(), parser.getInteger());
                    }
                } else {
                    if (HLSConnectionHolder.this.currentPlaylist == null) {
                        HLSConnectionHolder.this.currentPlaylist = new Playlist(parser.isLivePlaylist(), parser.getTargetDuration());
                        HLSConnectionHolder.this.currentPlaylist.setPlaylistURI(this.playlistURI);
                    }
                    if (HLSConnectionHolder.this.currentPlaylist.setSequenceNumber(parser.getSequenceNumber())) {
                        while (parser.hasNext()) {
                            HLSConnectionHolder.this.currentPlaylist.addMediaFile(parser.getString(), parser.getDouble(), parser.getBoolean());
                        }
                    }
                    if (HLSConnectionHolder.this.variantPlaylist != null) {
                        HLSConnectionHolder.this.variantPlaylist.addPlaylist(HLSConnectionHolder.this.currentPlaylist);
                    }
                }
                if (HLSConnectionHolder.this.variantPlaylist != null) {
                    while (HLSConnectionHolder.this.variantPlaylist.hasNext()) {
                        try {
                            HLSConnectionHolder.this.currentPlaylist = new Playlist(HLSConnectionHolder.this.variantPlaylist.getPlaylistURI());
                            HLSConnectionHolder.this.currentPlaylist.update(null);
                            HLSConnectionHolder.this.variantPlaylist.addPlaylist(HLSConnectionHolder.this.currentPlaylist);
                        }
                        catch (MalformedURLException | URISyntaxException exception) {}
                    }
                }
                if (HLSConnectionHolder.this.variantPlaylist != null) {
                    HLSConnectionHolder.this.currentPlaylist = HLSConnectionHolder.this.variantPlaylist.getPlaylist(0);
                    HLSConnectionHolder.this.isBitrateAdjustable = true;
                }
                if (HLSConnectionHolder.this.currentPlaylist.isLive()) {
                    this.setReloadPlaylist(HLSConnectionHolder.this.currentPlaylist);
                    this.putState(2);
                }
                if (HLSConnectionHolder.this.currentPlaylist.isFragmentedMP4()) {
                    HLSConnectionHolder.this.sendHeader = true;
                    HLSConnectionHolder.this.mediaFileIndex = 0;
                }
            }
            finally {
                HLSConnectionHolder.this.readySignal.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stateReloadPlaylist() {
            try {
                long timeout;
                Object object = this.reloadLock;
                synchronized (object) {
                    timeout = this.reloadPlaylist.getTargetDuration() / 2L;
                }
                Thread.sleep(timeout);
            }
            catch (InterruptedException ex) {
                return;
            }
            Object object = this.reloadLock;
            synchronized (object) {
                this.reloadPlaylist.update(null);
            }
            this.putState(2);
        }
    }

    private static class VariantPlaylist {
        private URI playlistURI = null;
        private int infoIndex = -1;
        private List<String> playlistsLocations = new ArrayList<String>();
        private List<Integer> playlistsBitrates = new ArrayList<Integer>();
        private List<Playlist> playlists = new ArrayList<Playlist>();
        private String mediaFileExtension = null;

        private VariantPlaylist(URI uri) {
            this.playlistURI = uri;
        }

        private void addPlaylistInfo(String location, int bitrate) {
            this.playlistsLocations.add(location);
            this.playlistsBitrates.add(bitrate);
        }

        private void addPlaylist(Playlist playlist) {
            if (this.mediaFileExtension == null) {
                this.mediaFileExtension = playlist.getMediaFileExtension();
            } else if (!this.mediaFileExtension.equals(playlist.getMediaFileExtension())) {
                this.playlistsLocations.remove(this.infoIndex);
                this.playlistsBitrates.remove(this.infoIndex);
                --this.infoIndex;
                return;
            }
            this.playlists.add(playlist);
        }

        private Playlist getPlaylist(int index) {
            if (this.playlists.size() > index) {
                return this.playlists.get(index);
            }
            return null;
        }

        private boolean hasNext() {
            ++this.infoIndex;
            return this.playlistsLocations.size() > this.infoIndex && this.playlistsBitrates.size() > this.infoIndex;
        }

        private URI getPlaylistURI() throws URISyntaxException, MalformedURLException {
            String location = this.playlistsLocations.get(this.infoIndex);
            if (location.startsWith("http://") || location.startsWith("https://")) {
                return new URI(location);
            }
            return new URI(this.playlistURI.toURL().toString().substring(0, this.playlistURI.toURL().toString().lastIndexOf("/") + 1) + location);
        }

        private Playlist getPlaylistBasedOnBitrate(int bitrate) {
            int b;
            int i;
            int playlistIndex = -1;
            int playlistBitrate = 0;
            for (i = 0; i < this.playlistsBitrates.size(); ++i) {
                b = this.playlistsBitrates.get(i);
                if (b >= bitrate) continue;
                if (playlistIndex != -1) {
                    if (b <= playlistBitrate) continue;
                    playlistBitrate = b;
                    playlistIndex = i;
                    continue;
                }
                playlistIndex = i;
            }
            if (playlistIndex == -1) {
                for (i = 0; i < this.playlistsBitrates.size(); ++i) {
                    b = this.playlistsBitrates.get(i);
                    if (b >= playlistBitrate && playlistIndex != -1) continue;
                    playlistBitrate = b;
                    playlistIndex = i;
                }
            }
            if (playlistIndex < 0 || playlistIndex >= this.playlists.size()) {
                return null;
            }
            return this.playlists.get(playlistIndex);
        }
    }

    private class Playlist {
        private boolean isLive = false;
        private volatile boolean isLiveWaiting = false;
        private volatile boolean isLiveStop = false;
        private long targetDuration = 0L;
        private URI playlistURI = null;
        private final Object lock = new Object();
        private final List<String> mediaFiles = new ArrayList<String>();
        private final List<Double> mediaFilesStartTimes = new ArrayList<Double>();
        private final List<Boolean> mediaFilesDiscontinuities = new ArrayList<Boolean>();
        private boolean needBaseURI = true;
        private String baseURI = null;
        private double startTime = 0.0;
        private double duration = 0.0;
        private int sequenceNumber = -1;
        private int sequenceNumberStart = -1;
        private boolean sequenceNumberUpdated = false;
        private boolean forceDiscontinuity = false;
        private int mimeType = -1;

        private Playlist(boolean isLive, int targetDuration) {
            this.isLive = isLive;
            this.targetDuration = targetDuration * 1000;
            if (isLive) {
                this.duration = -1.0;
            }
        }

        private Playlist(URI uri) {
            this.playlistURI = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(String nextMediaFile) {
            PlaylistParser parser = new PlaylistParser();
            parser.load(this.playlistURI);
            this.isLive = parser.isLivePlaylist();
            this.targetDuration = parser.getTargetDuration() * 1000;
            if (this.isLive) {
                this.duration = -1.0;
            }
            if (this.setSequenceNumber(parser.getSequenceNumber())) {
                while (parser.hasNext()) {
                    this.addMediaFile(parser.getString(), parser.getDouble(), parser.getBoolean());
                }
            }
            if (nextMediaFile != null) {
                Object object = this.lock;
                synchronized (object) {
                    for (int i = 0; i < this.mediaFiles.size(); ++i) {
                        String mediaFile = this.mediaFiles.get(i);
                        if (!nextMediaFile.endsWith(mediaFile)) continue;
                        HLSConnectionHolder.this.mediaFileIndex = i - 1;
                        break;
                    }
                }
            }
        }

        private boolean isLive() {
            return this.isLive;
        }

        private boolean isFragmentedMP4() {
            return this.getMimeType() == 3;
        }

        private long getTargetDuration() {
            return this.targetDuration;
        }

        private void setPlaylistURI(URI uri) {
            this.playlistURI = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addMediaFile(String URI2, double duration, boolean isDiscontinuity) {
            Object object = this.lock;
            synchronized (object) {
                if (this.needBaseURI) {
                    this.setBaseURI(this.playlistURI.toString(), URI2);
                }
                if (this.isLive) {
                    if (this.sequenceNumberUpdated) {
                        int index = this.mediaFiles.indexOf(URI2);
                        if (index != -1) {
                            for (int i = 0; i < index; ++i) {
                                this.mediaFiles.remove(0);
                                this.mediaFilesDiscontinuities.remove(0);
                                if (HLSConnectionHolder.this.mediaFileIndex == -1) {
                                    this.forceDiscontinuity = true;
                                }
                                if (HLSConnectionHolder.this.mediaFileIndex < 0) continue;
                                --HLSConnectionHolder.this.mediaFileIndex;
                            }
                        }
                        this.sequenceNumberUpdated = false;
                    }
                    if (this.mediaFiles.contains(URI2)) {
                        return;
                    }
                }
                this.mediaFiles.add(URI2);
                this.mediaFilesDiscontinuities.add(isDiscontinuity);
                if (this.isLive) {
                    if (this.isLiveWaiting) {
                        HLSConnectionHolder.this.liveSemaphore.release();
                    }
                } else {
                    this.mediaFilesStartTimes.add(this.startTime);
                    this.startTime += duration;
                    if (this.mediaFiles.size() == 1) {
                        if (!this.isFragmentedMP4()) {
                            this.duration += duration;
                        }
                    } else {
                        this.duration += duration;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getNextMediaFile() {
            Object object;
            if (this.isLive) {
                object = this.lock;
                synchronized (object) {
                    this.isLiveWaiting = HLSConnectionHolder.this.mediaFileIndex + 1 >= this.mediaFiles.size();
                }
                if (this.isLiveWaiting) {
                    try {
                        HLSConnectionHolder.this.liveSemaphore.acquire();
                        this.isLiveWaiting = false;
                        if (this.isLiveStop) {
                            this.isLiveStop = false;
                            return null;
                        }
                    }
                    catch (InterruptedException e) {
                        this.isLiveWaiting = false;
                        return null;
                    }
                }
                if (HLSConnectionHolder.this.isPlaylistClosed) {
                    return null;
                }
            }
            object = this.lock;
            synchronized (object) {
                ++HLSConnectionHolder.this.mediaFileIndex;
                if (HLSConnectionHolder.this.mediaFileIndex < this.mediaFiles.size()) {
                    if (this.baseURI != null) {
                        return this.baseURI + this.mediaFiles.get(HLSConnectionHolder.this.mediaFileIndex);
                    }
                    return this.mediaFiles.get(HLSConnectionHolder.this.mediaFileIndex);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderFile() {
            Object object = this.lock;
            synchronized (object) {
                if (this.mediaFiles.size() > 0) {
                    if (this.baseURI != null) {
                        return this.baseURI + this.mediaFiles.get(0);
                    }
                    return this.mediaFiles.get(0);
                }
                return null;
            }
        }

        private double getMediaFileStartTime() {
            if (HLSConnectionHolder.this.mediaFileIndex < this.mediaFiles.size()) {
                return this.mediaFilesStartTimes.get(HLSConnectionHolder.this.mediaFileIndex);
            }
            return 0.0;
        }

        private double getDuration() {
            return this.duration;
        }

        private void setForceDiscontinuity(boolean value) {
            this.forceDiscontinuity = value;
        }

        private boolean isCurrentMediaFileDiscontinuity() {
            if (this.forceDiscontinuity) {
                this.forceDiscontinuity = false;
                return true;
            }
            return this.mediaFilesDiscontinuities.get(HLSConnectionHolder.this.mediaFileIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double seek(long time) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isLive) {
                    if (time == 0L) {
                        HLSConnectionHolder.this.mediaFileIndex = this.isFragmentedMP4() ? 0 : -1;
                        if (this.isLiveWaiting) {
                            this.isLiveStop = true;
                            HLSConnectionHolder.this.liveSemaphore.release();
                        }
                        return 0.0;
                    }
                } else {
                    time += this.targetDuration / 2000L;
                    int mediaFileStartTimeSize = this.mediaFilesStartTimes.size();
                    for (int index = 0; index < mediaFileStartTimeSize; ++index) {
                        if (!((double)time >= this.mediaFilesStartTimes.get(index))) continue;
                        if (index + 1 < mediaFileStartTimeSize) {
                            if (!((double)time < this.mediaFilesStartTimes.get(index + 1))) continue;
                            HLSConnectionHolder.this.mediaFileIndex = this.isFragmentedMP4() ? index : index - 1;
                            return this.mediaFilesStartTimes.get(index);
                        }
                        if ((double)(time - this.targetDuration / 2000L) < this.duration) {
                            HLSConnectionHolder.this.mediaFileIndex = this.isFragmentedMP4() ? index : index - 1;
                            return this.mediaFilesStartTimes.get(index);
                        }
                        if (Double.compare(time - this.targetDuration / 2000L, this.duration) != 0) continue;
                        return this.duration;
                    }
                }
            }
            return -1.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getMimeType() {
            Object object = this.lock;
            synchronized (object) {
                if (this.mimeType == -1 && this.mediaFiles.size() > 0) {
                    if (HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".ts")) {
                        this.mimeType = 1;
                    } else if (HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".mp3")) {
                        this.mimeType = 2;
                    } else if (HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".mp4") || HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".m4s")) {
                        this.mimeType = 3;
                    } else if (HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".aac")) {
                        this.mimeType = 4;
                    }
                }
            }
            return this.mimeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getMediaFileExtension() {
            Object object = this.lock;
            synchronized (object) {
                String mediaFile;
                int index;
                if (this.mediaFiles.size() > 0 && (index = (mediaFile = HLSConnectionHolder.stripParameters(this.mediaFiles.get(0))).lastIndexOf(".")) != -1) {
                    return mediaFile.substring(index);
                }
            }
            return null;
        }

        private boolean setSequenceNumber(int value) {
            if (this.sequenceNumberStart == -1) {
                this.sequenceNumberStart = value;
            } else if (this.sequenceNumber != value) {
                this.sequenceNumberUpdated = true;
                this.sequenceNumber = value;
            } else {
                return false;
            }
            return true;
        }

        private void close() {
            if (this.isLive) {
                HLSConnectionHolder.this.isPlaylistClosed = true;
                HLSConnectionHolder.this.liveSemaphore.release();
            }
        }

        private void setBaseURI(String playlistURI, String URI2) {
            if (!URI2.startsWith("http://") && !URI2.startsWith("https://")) {
                this.baseURI = playlistURI.substring(0, playlistURI.lastIndexOf("/") + 1);
            }
            this.needBaseURI = false;
        }
    }

    private static class PlaylistParser {
        private boolean isFirstLine = true;
        private boolean isLineMediaFileURI = false;
        private boolean isEndList = false;
        private boolean isLinePlaylistURI = false;
        private boolean isVariantPlaylist = false;
        private boolean isDiscontinuity = false;
        private int targetDuration = 0;
        private int sequenceNumber = 0;
        private int dataListIndex = -1;
        private List<String> dataListString = new ArrayList<String>();
        private List<Integer> dataListInteger = new ArrayList<Integer>();
        private List<Double> dataListDouble = new ArrayList<Double>();
        private List<Boolean> dataListBoolean = new ArrayList<Boolean>();

        private PlaylistParser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load(URI uri) {
            HttpURLConnection connection = null;
            BufferedReader reader = null;
            try {
                Charset charset;
                connection = (HttpURLConnection)uri.toURL().openConnection();
                connection.setRequestMethod("GET");
                if (connection.getResponseCode() != 200) {
                    MediaUtils.error(this, MediaError.ERROR_LOCATOR_CONNECTION_LOST.code(), "HTTP responce code: " + connection.getResponseCode(), null);
                }
                if ((charset = this.getCharset(uri.toURL().toExternalForm(), connection.getContentType())) != null) {
                    reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), charset));
                }
                if (reader != null) {
                    boolean result;
                    while (result = this.parseLine(reader.readLine())) {
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    Locator.closeConnection(connection);
                }
            }
        }

        private boolean isVariantPlaylist() {
            return this.isVariantPlaylist;
        }

        private boolean isLivePlaylist() {
            return !this.isEndList;
        }

        private int getTargetDuration() {
            return this.targetDuration;
        }

        private int getSequenceNumber() {
            return this.sequenceNumber;
        }

        private boolean hasNext() {
            ++this.dataListIndex;
            return this.dataListString.size() > this.dataListIndex || this.dataListInteger.size() > this.dataListIndex || this.dataListDouble.size() > this.dataListIndex || this.dataListBoolean.size() > this.dataListIndex;
        }

        private String getString() {
            return this.dataListString.get(this.dataListIndex);
        }

        private Integer getInteger() {
            return this.dataListInteger.get(this.dataListIndex);
        }

        private Double getDouble() {
            return this.dataListDouble.get(this.dataListIndex);
        }

        private Boolean getBoolean() {
            return this.dataListBoolean.get(this.dataListIndex);
        }

        private boolean parseLine(String line) {
            if (line == null) {
                return false;
            }
            if (this.isFirstLine) {
                if (line.compareTo("#EXTM3U") != 0) {
                    return false;
                }
                this.isFirstLine = false;
                return true;
            }
            if (line.isEmpty() || line.startsWith("#") && !line.startsWith("#EXT")) {
                return true;
            }
            if (line.startsWith("#EXTINF")) {
                String[] s2;
                String[] s1 = line.split(":");
                if (s1.length == 2 && s1[1].length() > 0 && (s2 = s1[1].split(",")).length >= 1) {
                    this.dataListDouble.add(Double.parseDouble(s2[0]));
                }
                this.isLineMediaFileURI = true;
            } else if (line.startsWith("#EXT-X-TARGETDURATION")) {
                String[] s1 = line.split(":");
                if (s1.length == 2 && s1[1].length() > 0) {
                    this.targetDuration = Integer.parseInt(s1[1]);
                }
            } else if (line.startsWith("#EXT-X-MEDIA-SEQUENCE")) {
                String[] s1 = line.split(":");
                if (s1.length == 2 && s1[1].length() > 0) {
                    this.sequenceNumber = Integer.parseInt(s1[1]);
                }
            } else if (line.startsWith("#EXT-X-STREAM-INF")) {
                String[] s2;
                this.isVariantPlaylist = true;
                int bitrate = 0;
                String[] s1 = line.split(":");
                if (s1.length == 2 && s1[1].length() > 0 && (s2 = s1[1].split(",")).length > 0) {
                    for (int i = 0; i < s2.length; ++i) {
                        String[] s3;
                        s2[i] = s2[i].trim();
                        if (!s2[i].startsWith("BANDWIDTH") || (s3 = s2[i].split("=")).length != 2 || s3[1].length() <= 0) continue;
                        bitrate = Integer.parseInt(s3[1]);
                    }
                }
                if (bitrate < 1) {
                    return false;
                }
                this.dataListInteger.add(bitrate);
                this.isLinePlaylistURI = true;
            } else if (line.startsWith("#EXT-X-ENDLIST")) {
                this.isEndList = true;
            } else if (line.startsWith("#EXT-X-DISCONTINUITY")) {
                this.isDiscontinuity = true;
            } else if (line.startsWith("#EXT-X-MAP")) {
                String[] s2;
                String[] s1 = line.split(":");
                if (s1.length == 2 && s1[1].length() > 0 && (s2 = s1[1].split(",")).length > 0) {
                    for (int i = 0; i < s2.length; ++i) {
                        String[] s3;
                        s2[i] = s2[i].trim();
                        if (!s2[i].startsWith("URI") || (s3 = s2[i].split("=")).length != 2 || s3[1].length() <= 0) continue;
                        String dataFile = s3[1].replaceAll("^\"+|\"+$", "");
                        this.dataListString.add(dataFile);
                        this.dataListBoolean.add(true);
                        this.dataListDouble.add(Double.valueOf(this.targetDuration));
                    }
                }
            } else if (this.isLinePlaylistURI) {
                this.isLinePlaylistURI = false;
                this.dataListString.add(line);
            } else if (this.isLineMediaFileURI && !line.startsWith("#")) {
                this.isLineMediaFileURI = false;
                this.dataListString.add(line);
                this.dataListBoolean.add(this.isDiscontinuity);
                this.isDiscontinuity = false;
            }
            return true;
        }

        private Charset getCharset(String url, String mimeType) {
            if (url != null && HLSConnectionHolder.stripParameters(url).endsWith(".m3u8") || mimeType != null && mimeType.equals("application/vnd.apple.mpegurl")) {
                if (Charset.isSupported(HLSConnectionHolder.CHARSET_UTF_8)) {
                    return Charset.forName(HLSConnectionHolder.CHARSET_UTF_8);
                }
            } else if ((url != null && HLSConnectionHolder.stripParameters(url).endsWith(".m3u") || mimeType != null && mimeType.equals("audio/mpegurl")) && Charset.isSupported(HLSConnectionHolder.CHARSET_US_ASCII)) {
                return Charset.forName(HLSConnectionHolder.CHARSET_US_ASCII);
            }
            return null;
        }
    }
}

