/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.logging.Logger;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;

public class MediaDisposer {
    private final ReferenceQueue<Object> purgatory = new ReferenceQueue();
    private final Map<Reference, Disposable> disposers = new HashMap<Reference, Disposable>();
    private static MediaDisposer theDisposinator;

    public static void addResourceDisposer(Object referent, Object resource, ResourceDisposer disposer) {
        MediaDisposer.disposinator().implAddResourceDisposer(referent, resource, disposer);
    }

    public static void removeResourceDisposer(Object resource) {
        MediaDisposer.disposinator().implRemoveResourceDisposer(resource);
    }

    public static void addDisposable(Object referent, Disposable disposable) {
        MediaDisposer.disposinator().implAddDisposable(referent, disposable);
    }

    private static synchronized MediaDisposer disposinator() {
        if (null == theDisposinator) {
            theDisposinator = new MediaDisposer();
            Thread disposerThread = new Thread(() -> theDisposinator.disposerLoop(), "Media Resource Disposer");
            disposerThread.setDaemon(true);
            disposerThread.start();
        }
        return theDisposinator;
    }

    private MediaDisposer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposerLoop() {
        while (true) {
            try {
                while (true) {
                    Disposable disposer;
                    Reference<Object> denizen = this.purgatory.remove();
                    Map<Reference, Disposable> map = this.disposers;
                    synchronized (map) {
                        disposer = this.disposers.remove(denizen);
                    }
                    denizen.clear();
                    if (null != disposer) {
                        disposer.dispose();
                    }
                    denizen = null;
                    Object var2_3 = null;
                }
            }
            catch (InterruptedException ex) {
                if (!Logger.canLog(1)) continue;
                Logger.logMsg(1, MediaDisposer.class.getName(), "disposerLoop", "Disposer loop interrupted, terminating");
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implAddResourceDisposer(Object referent, Object resource, ResourceDisposer disposer) {
        PhantomReference<Object> denizen = new PhantomReference<Object>(referent, this.purgatory);
        Map<Reference, Disposable> map = this.disposers;
        synchronized (map) {
            this.disposers.put(denizen, new ResourceDisposerRecord(resource, disposer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implRemoveResourceDisposer(Object resource) {
        Reference resourceKey = null;
        Map<Reference, Disposable> map = this.disposers;
        synchronized (map) {
            for (Map.Entry<Reference, Disposable> entry : this.disposers.entrySet()) {
                Disposable disposer = entry.getValue();
                if (!(disposer instanceof ResourceDisposerRecord)) continue;
                ResourceDisposerRecord rd = (ResourceDisposerRecord)disposer;
                if (!rd.resource.equals(resource)) continue;
                resourceKey = entry.getKey();
                break;
            }
            if (null != resourceKey) {
                this.disposers.remove(resourceKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implAddDisposable(Object referent, Disposable disposer) {
        PhantomReference<Object> denizen = new PhantomReference<Object>(referent, this.purgatory);
        Map<Reference, Disposable> map = this.disposers;
        synchronized (map) {
            this.disposers.put(denizen, disposer);
        }
    }

    public static interface ResourceDisposer {
        public void disposeResource(Object var1);
    }

    public static interface Disposable {
        public void dispose();
    }

    private static class ResourceDisposerRecord
    implements Disposable {
        Object resource;
        ResourceDisposer disposer;

        public ResourceDisposerRecord(Object resource, ResourceDisposer disposer) {
            this.resource = resource;
            this.disposer = disposer;
        }

        @Override
        public void dispose() {
            this.disposer.disposeResource(this.resource);
        }
    }
}

