/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.media;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.media.MediaViewHelper;
import com.sun.javafx.sg.prism.MediaFrameTracker;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.media.jfxmedia.control.MediaPlayerOverlay;
import com.sun.media.jfxmedia.events.VideoFrameRateListener;
import com.sun.media.jfxmediaimpl.HostUtils;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.media.Media;
import javafx.scene.media.MediaErrorEvent;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.NGMediaView;

public class MediaView
extends Node {
    private static final String VIDEO_FRAME_RATE_PROPERTY_NAME = "jfxmedia.decodedVideoFPS";
    private static final String DEFAULT_STYLE_CLASS = "media-view";
    private InvalidationListener errorListener = new MediaErrorInvalidationListener();
    private InvalidationListener mediaDimensionListener = value -> {
        NodeHelper.markDirty((Node)this, (DirtyBits)DirtyBits.NODE_VIEWPORT);
        NodeHelper.geomChanged((Node)this);
    };
    private VideoFrameRateListener decodedFrameRateListener;
    private boolean registerVideoFrameRateListener = false;
    private MediaPlayerOverlay mediaPlayerOverlay = null;
    private ChangeListener<Parent> parentListener;
    private ChangeListener<Boolean> treeVisibleListener;
    private ChangeListener<Number> opacityListener;
    private ObjectProperty<MediaPlayer> mediaPlayer;
    private ObjectProperty<EventHandler<MediaErrorEvent>> onError;
    private BooleanProperty preserveRatio;
    private BooleanProperty smooth;
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty fitWidth;
    private DoubleProperty fitHeight;
    private ObjectProperty<Rectangle2D> viewport;
    private int decodedFrameCount;
    private int renderedFrameCount;

    private VideoFrameRateListener createVideoFrameRateListener() {
        String listenerProp = null;
        try {
            listenerProp = System.getProperty(VIDEO_FRAME_RATE_PROPERTY_NAME);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listenerProp == null || !Boolean.getBoolean(VIDEO_FRAME_RATE_PROPERTY_NAME)) {
            return null;
        }
        return videoFrameRate -> Platform.runLater(() -> {
            ObservableMap props = this.getProperties();
            props.put((Object)VIDEO_FRAME_RATE_PROPERTY_NAME, (Object)videoFrameRate);
        });
    }

    private void createListeners() {
        this.parentListener = (ov2, oldParent, newParent) -> this.updateOverlayVisibility();
        this.treeVisibleListener = (ov1, oldVisible, newVisible) -> this.updateOverlayVisibility();
        this.opacityListener = (ov, oldOpacity, newOpacity) -> this.updateOverlayOpacity();
    }

    private boolean determineVisibility() {
        return this.getParent() != null && this.isVisible();
    }

    private synchronized void updateOverlayVisibility() {
        if (this.mediaPlayerOverlay != null) {
            this.mediaPlayerOverlay.setOverlayVisible(this.determineVisibility());
        }
    }

    private synchronized void updateOverlayOpacity() {
        if (this.mediaPlayerOverlay != null) {
            this.mediaPlayerOverlay.setOverlayOpacity(this.getOpacity());
        }
    }

    private synchronized void updateOverlayX() {
        if (this.mediaPlayerOverlay != null) {
            this.mediaPlayerOverlay.setOverlayX(this.getX());
        }
    }

    private synchronized void updateOverlayY() {
        if (this.mediaPlayerOverlay != null) {
            this.mediaPlayerOverlay.setOverlayY(this.getY());
        }
    }

    private synchronized void updateOverlayWidth() {
        if (this.mediaPlayerOverlay != null) {
            this.mediaPlayerOverlay.setOverlayWidth(this.getFitWidth());
        }
    }

    private synchronized void updateOverlayHeight() {
        if (this.mediaPlayerOverlay != null) {
            this.mediaPlayerOverlay.setOverlayHeight(this.getFitHeight());
        }
    }

    private synchronized void updateOverlayPreserveRatio() {
        if (this.mediaPlayerOverlay != null) {
            this.mediaPlayerOverlay.setOverlayPreserveRatio(this.isPreserveRatio());
        }
    }

    private static Affine3D calculateNodeToSceneTransform(Node node) {
        Affine3D transform = new Affine3D();
        do {
            transform.preConcatenate(NodeHelper.getLeafTransform((Node)node));
        } while ((node = node.getParent()) != null);
        return transform;
    }

    private void updateOverlayTransform() {
        if (this.mediaPlayerOverlay != null) {
            Affine3D trans = MediaView.calculateNodeToSceneTransform(this);
            this.mediaPlayerOverlay.setOverlayTransform(trans.getMxx(), trans.getMxy(), trans.getMxz(), trans.getMxt(), trans.getMyx(), trans.getMyy(), trans.getMyz(), trans.getMyt(), trans.getMzx(), trans.getMzy(), trans.getMzz(), trans.getMzt());
        }
    }

    private void updateMediaPlayerOverlay() {
        this.mediaPlayerOverlay.setOverlayX(this.getX());
        this.mediaPlayerOverlay.setOverlayY(this.getY());
        this.mediaPlayerOverlay.setOverlayPreserveRatio(this.isPreserveRatio());
        this.mediaPlayerOverlay.setOverlayWidth(this.getFitWidth());
        this.mediaPlayerOverlay.setOverlayHeight(this.getFitHeight());
        this.mediaPlayerOverlay.setOverlayOpacity(this.getOpacity());
        this.mediaPlayerOverlay.setOverlayVisible(this.determineVisibility());
        this.updateOverlayTransform();
    }

    private void doTransformsChanged() {
        if (this.mediaPlayerOverlay != null) {
            this.updateOverlayTransform();
        }
    }

    private MediaView getMediaView() {
        return this;
    }

    public MediaView() {
        MediaViewHelper.initHelper(this);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setSmooth(Toolkit.getToolkit().getDefaultImageSmooth());
        this.decodedFrameRateListener = this.createVideoFrameRateListener();
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
    }

    public MediaView(MediaPlayer mediaPlayer) {
        this();
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.setMediaPlayer(mediaPlayer);
    }

    public final void setMediaPlayer(MediaPlayer value) {
        this.mediaPlayerProperty().set((Object)value);
    }

    public final MediaPlayer getMediaPlayer() {
        return this.mediaPlayer == null ? null : (MediaPlayer)this.mediaPlayer.get();
    }

    public final ObjectProperty<MediaPlayer> mediaPlayerProperty() {
        if (this.mediaPlayer == null) {
            this.mediaPlayer = new ObjectPropertyBase<MediaPlayer>(){
                MediaPlayer oldValue = null;

                protected void invalidated() {
                    MediaPlayer newValue;
                    if (this.oldValue != null) {
                        Media media = this.oldValue.getMedia();
                        if (media != null) {
                            media.widthProperty().removeListener(MediaView.this.mediaDimensionListener);
                            media.heightProperty().removeListener(MediaView.this.mediaDimensionListener);
                        }
                        if (MediaView.this.decodedFrameRateListener != null && MediaView.this.getMediaPlayer().retrieveJfxPlayer() != null) {
                            MediaView.this.getMediaPlayer().retrieveJfxPlayer().getVideoRenderControl().removeVideoFrameRateListener(MediaView.this.decodedFrameRateListener);
                        }
                        this.oldValue.errorProperty().removeListener(MediaView.this.errorListener);
                        this.oldValue.removeView(MediaView.this.getMediaView());
                    }
                    if ((newValue = (MediaPlayer)this.get()) != null) {
                        newValue.addView(MediaView.this.getMediaView());
                        newValue.errorProperty().addListener(MediaView.this.errorListener);
                        if (MediaView.this.decodedFrameRateListener != null && MediaView.this.getMediaPlayer().retrieveJfxPlayer() != null) {
                            MediaView.this.getMediaPlayer().retrieveJfxPlayer().getVideoRenderControl().addVideoFrameRateListener(MediaView.this.decodedFrameRateListener);
                        } else if (MediaView.this.decodedFrameRateListener != null) {
                            MediaView.this.registerVideoFrameRateListener = true;
                        }
                        Media media = newValue.getMedia();
                        if (media != null) {
                            media.widthProperty().addListener(MediaView.this.mediaDimensionListener);
                            media.heightProperty().addListener(MediaView.this.mediaDimensionListener);
                        }
                    }
                    NodeHelper.markDirty((Node)MediaView.this, (DirtyBits)DirtyBits.MEDIAVIEW_MEDIA);
                    NodeHelper.geomChanged((Node)MediaView.this);
                    this.oldValue = newValue;
                }

                public Object getBean() {
                    return MediaView.this;
                }

                public String getName() {
                    return "mediaPlayer";
                }
            };
        }
        return this.mediaPlayer;
    }

    public final void setOnError(EventHandler<MediaErrorEvent> value) {
        this.onErrorProperty().set(value);
    }

    public final EventHandler<MediaErrorEvent> getOnError() {
        return this.onError == null ? null : (EventHandler)this.onError.get();
    }

    public final ObjectProperty<EventHandler<MediaErrorEvent>> onErrorProperty() {
        if (this.onError == null) {
            this.onError = new ObjectPropertyBase<EventHandler<MediaErrorEvent>>(){

                protected void invalidated() {
                    MediaView.this.setEventHandler(MediaErrorEvent.MEDIA_ERROR, (EventHandler)this.get());
                }

                public Object getBean() {
                    return MediaView.this;
                }

                public String getName() {
                    return "onError";
                }
            };
        }
        return this.onError;
    }

    public final void setPreserveRatio(boolean value) {
        this.preserveRatioProperty().set(value);
    }

    public final boolean isPreserveRatio() {
        return this.preserveRatio == null ? true : this.preserveRatio.get();
    }

    public final BooleanProperty preserveRatioProperty() {
        if (this.preserveRatio == null) {
            this.preserveRatio = new BooleanPropertyBase(true){

                protected void invalidated() {
                    if (HostUtils.isIOS()) {
                        MediaView.this.updateOverlayPreserveRatio();
                    } else {
                        NodeHelper.markDirty((Node)MediaView.this, (DirtyBits)DirtyBits.NODE_VIEWPORT);
                        NodeHelper.geomChanged((Node)MediaView.this);
                    }
                }

                public Object getBean() {
                    return MediaView.this;
                }

                public String getName() {
                    return "preserveRatio";
                }
            };
        }
        return this.preserveRatio;
    }

    public final void setSmooth(boolean value) {
        this.smoothProperty().set(value);
    }

    public final boolean isSmooth() {
        return this.smooth == null ? false : this.smooth.get();
    }

    public final BooleanProperty smoothProperty() {
        if (this.smooth == null) {
            this.smooth = new BooleanPropertyBase(){

                protected void invalidated() {
                    NodeHelper.markDirty((Node)MediaView.this, (DirtyBits)DirtyBits.NODE_SMOOTH);
                }

                public Object getBean() {
                    return MediaView.this;
                }

                public String getName() {
                    return "smooth";
                }
            };
        }
        return this.smooth;
    }

    public final void setX(double value) {
        this.xProperty().set(value);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                protected void invalidated() {
                    if (HostUtils.isIOS()) {
                        MediaView.this.updateOverlayX();
                    } else {
                        NodeHelper.markDirty((Node)MediaView.this, (DirtyBits)DirtyBits.NODE_GEOMETRY);
                        NodeHelper.geomChanged((Node)MediaView.this);
                    }
                }

                public Object getBean() {
                    return MediaView.this;
                }

                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double value) {
        this.yProperty().set(value);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                protected void invalidated() {
                    if (HostUtils.isIOS()) {
                        MediaView.this.updateOverlayY();
                    } else {
                        NodeHelper.markDirty((Node)MediaView.this, (DirtyBits)DirtyBits.NODE_GEOMETRY);
                        NodeHelper.geomChanged((Node)MediaView.this);
                    }
                }

                public Object getBean() {
                    return MediaView.this;
                }

                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setFitWidth(double value) {
        this.fitWidthProperty().set(value);
    }

    public final double getFitWidth() {
        return this.fitWidth == null ? 0.0 : this.fitWidth.get();
    }

    public final DoubleProperty fitWidthProperty() {
        if (this.fitWidth == null) {
            this.fitWidth = new DoublePropertyBase(){

                protected void invalidated() {
                    if (HostUtils.isIOS()) {
                        MediaView.this.updateOverlayWidth();
                    } else {
                        NodeHelper.markDirty((Node)MediaView.this, (DirtyBits)DirtyBits.NODE_VIEWPORT);
                        NodeHelper.geomChanged((Node)MediaView.this);
                    }
                }

                public Object getBean() {
                    return MediaView.this;
                }

                public String getName() {
                    return "fitWidth";
                }
            };
        }
        return this.fitWidth;
    }

    public final void setFitHeight(double value) {
        this.fitHeightProperty().set(value);
    }

    public final double getFitHeight() {
        return this.fitHeight == null ? 0.0 : this.fitHeight.get();
    }

    public final DoubleProperty fitHeightProperty() {
        if (this.fitHeight == null) {
            this.fitHeight = new DoublePropertyBase(){

                protected void invalidated() {
                    if (HostUtils.isIOS()) {
                        MediaView.this.updateOverlayHeight();
                    } else {
                        NodeHelper.markDirty((Node)MediaView.this, (DirtyBits)DirtyBits.NODE_VIEWPORT);
                        NodeHelper.geomChanged((Node)MediaView.this);
                    }
                }

                public Object getBean() {
                    return MediaView.this;
                }

                public String getName() {
                    return "fitHeight";
                }
            };
        }
        return this.fitHeight;
    }

    public final void setViewport(Rectangle2D value) {
        this.viewportProperty().set((Object)value);
    }

    public final Rectangle2D getViewport() {
        return this.viewport == null ? null : (Rectangle2D)this.viewport.get();
    }

    public final ObjectProperty<Rectangle2D> viewportProperty() {
        if (this.viewport == null) {
            this.viewport = new ObjectPropertyBase<Rectangle2D>(){

                protected void invalidated() {
                    NodeHelper.markDirty((Node)MediaView.this, (DirtyBits)DirtyBits.NODE_VIEWPORT);
                    NodeHelper.geomChanged((Node)MediaView.this);
                }

                public Object getBean() {
                    return MediaView.this;
                }

                public String getName() {
                    return "viewport";
                }
            };
        }
        return this.viewport;
    }

    void notifyMediaChange() {
        MediaPlayer player = this.getMediaPlayer();
        if (player != null) {
            NGMediaView peer = (NGMediaView)NodeHelper.getPeer((Node)this);
            peer.setMediaProvider(player);
        }
        NodeHelper.markDirty((Node)this, (DirtyBits)DirtyBits.MEDIAVIEW_MEDIA);
        NodeHelper.geomChanged((Node)this);
    }

    void notifyMediaSizeChange() {
        NodeHelper.markDirty((Node)this, (DirtyBits)DirtyBits.NODE_VIEWPORT);
        NodeHelper.geomChanged((Node)this);
    }

    void notifyMediaFrameUpdated() {
        ++this.decodedFrameCount;
        NodeHelper.markDirty((Node)this, (DirtyBits)DirtyBits.NODE_CONTENTS);
    }

    private NGNode doCreatePeer() {
        NGMediaView peer = new NGMediaView();
        peer.setFrameTracker(new MediaViewFrameTracker());
        return peer;
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        double vh;
        Media media = this.getMediaPlayer() == null ? null : this.getMediaPlayer().getMedia();
        double w = media != null ? (double)media.getWidth() : 0.0;
        double h = media != null ? (double)media.getHeight() : 0.0;
        double newW = this.getFitWidth();
        double newH = this.getFitHeight();
        double vw = this.getViewport() != null ? this.getViewport().getWidth() : 0.0;
        double d = vh = this.getViewport() != null ? this.getViewport().getHeight() : 0.0;
        if (vw > 0.0 && vh > 0.0) {
            w = vw;
            h = vh;
        }
        if (this.getFitWidth() <= 0.0 && this.getFitHeight() <= 0.0) {
            newW = w;
            newH = h;
        } else if (this.isPreserveRatio()) {
            if (this.getFitWidth() <= 0.0) {
                newW = h > 0.0 ? w * (this.getFitHeight() / h) : 0.0;
                newH = this.getFitHeight();
            } else if (this.getFitHeight() <= 0.0) {
                newW = this.getFitWidth();
                newH = w > 0.0 ? h * (this.getFitWidth() / w) : 0.0;
            } else {
                if (w == 0.0) {
                    w = this.getFitWidth();
                }
                if (h == 0.0) {
                    h = this.getFitHeight();
                }
                double scale = Math.min(this.getFitWidth() / w, this.getFitHeight() / h);
                newW = w * scale;
                newH = h * scale;
            }
        } else if (this.getFitHeight() <= 0.0) {
            newH = h;
        } else if (this.getFitWidth() <= 0.0) {
            newW = w;
        }
        if (newH < 1.0) {
            newH = 1.0;
        }
        if (newW < 1.0) {
            newW = 1.0;
        }
        w = newW;
        h = newH;
        if (w <= 0.0 || h <= 0.0) {
            return bounds.makeEmpty();
        }
        bounds = bounds.deriveWithNewBounds((float)this.getX(), (float)this.getY(), 0.0f, (float)(this.getX() + w), (float)(this.getY() + h), 0.0f);
        bounds = tx.transform(bounds, bounds);
        return bounds;
    }

    private boolean doComputeContains(double localX, double localY) {
        return true;
    }

    void updateViewport() {
        if (this.getMediaPlayer() == null) {
            return;
        }
        NGMediaView peer = (NGMediaView)NodeHelper.getPeer((Node)this);
        if (this.getViewport() != null) {
            peer.setViewport((float)this.getFitWidth(), (float)this.getFitHeight(), (float)this.getViewport().getMinX(), (float)this.getViewport().getMinY(), (float)this.getViewport().getWidth(), (float)this.getViewport().getHeight(), this.isPreserveRatio());
        } else {
            peer.setViewport((float)this.getFitWidth(), (float)this.getFitHeight(), 0.0f, 0.0f, 0.0f, 0.0f, this.isPreserveRatio());
        }
    }

    private void doUpdatePeer() {
        NGMediaView peer = (NGMediaView)NodeHelper.getPeer((Node)this);
        if (NodeHelper.isDirty((Node)this, (DirtyBits)DirtyBits.NODE_GEOMETRY)) {
            peer.setX((float)this.getX());
            peer.setY((float)this.getY());
        }
        if (NodeHelper.isDirty((Node)this, (DirtyBits)DirtyBits.NODE_SMOOTH)) {
            peer.setSmooth(this.isSmooth());
        }
        if (NodeHelper.isDirty((Node)this, (DirtyBits)DirtyBits.NODE_VIEWPORT)) {
            this.updateViewport();
        }
        if (NodeHelper.isDirty((Node)this, (DirtyBits)DirtyBits.NODE_CONTENTS)) {
            peer.renderNextFrame();
        }
        if (NodeHelper.isDirty((Node)this, (DirtyBits)DirtyBits.MEDIAVIEW_MEDIA)) {
            MediaPlayer player = this.getMediaPlayer();
            if (player != null) {
                peer.setMediaProvider(player);
                this.updateViewport();
            } else {
                peer.setMediaProvider(null);
            }
        }
    }

    void perfReset() {
        this.decodedFrameCount = 0;
        this.renderedFrameCount = 0;
    }

    int perfGetDecodedFrameCount() {
        return this.decodedFrameCount;
    }

    int perfGetRenderedFrameCount() {
        return this.renderedFrameCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _mediaPlayerOnReady() {
        com.sun.media.jfxmedia.MediaPlayer jfxPlayer = this.getMediaPlayer().retrieveJfxPlayer();
        if (jfxPlayer != null) {
            if (this.decodedFrameRateListener != null && this.registerVideoFrameRateListener) {
                jfxPlayer.getVideoRenderControl().addVideoFrameRateListener(this.decodedFrameRateListener);
                this.registerVideoFrameRateListener = false;
            }
            this.mediaPlayerOverlay = jfxPlayer.getMediaPlayerOverlay();
            if (this.mediaPlayerOverlay != null) {
                this.createListeners();
                this.parentProperty().addListener(this.parentListener);
                NodeHelper.treeVisibleProperty((Node)this).addListener(this.treeVisibleListener);
                this.opacityProperty().addListener(this.opacityListener);
                MediaView mediaView = this;
                synchronized (mediaView) {
                    this.updateMediaPlayerOverlay();
                }
            }
        }
    }

    static {
        MediaViewHelper.setMediaViewAccessor(new MediaViewHelper.MediaViewAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((MediaView)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((MediaView)node).doUpdatePeer();
            }

            @Override
            public void doTransformsChanged(Node node) {
                ((MediaView)node).doTransformsChanged();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((MediaView)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((MediaView)node).doComputeContains(localX, localY);
            }
        });
    }

    private class MediaErrorInvalidationListener
    implements InvalidationListener {
        private MediaErrorInvalidationListener() {
        }

        public void invalidated(Observable value) {
            ObservableObjectValue errorProperty = (ObservableObjectValue)value;
            MediaView.this.fireEvent(new MediaErrorEvent(MediaView.this.getMediaPlayer(), (EventTarget)MediaView.this.getMediaView(), (MediaException)errorProperty.get()));
        }
    }

    private class MediaViewFrameTracker
    implements MediaFrameTracker {
        private MediaViewFrameTracker() {
        }

        public void incrementDecodedFrameCount(int count) {
            MediaView.this.decodedFrameCount += count;
        }

        public void incrementRenderedFrameCount(int count) {
            MediaView.this.renderedFrameCount += count;
        }
    }
}

