/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.media;

import com.sun.glass.ui.Screen;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.Toolkit;
import com.sun.media.jfxmedia.control.VideoDataBuffer;
import com.sun.media.jfxmedia.control.VideoFormat;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.WeakHashMap;

public class PrismMediaFrameHandler
implements ResourceFactoryListener {
    private final Map<Screen, TextureMapEntry> textures = new WeakHashMap<Screen, TextureMapEntry>(1);
    private static Map<Object, PrismMediaFrameHandler> handlers;
    private WeakReference<ResourceFactory> registeredWithFactory = null;
    private final RenderJob releaseRenderJob = new RenderJob(() -> this.releaseData());

    public static synchronized PrismMediaFrameHandler getHandler(Object provider) {
        PrismMediaFrameHandler ret;
        if (provider == null) {
            throw new IllegalArgumentException("provider must be non-null");
        }
        if (handlers == null) {
            handlers = new WeakHashMap<Object, PrismMediaFrameHandler>(1);
        }
        if ((ret = handlers.get(provider)) == null) {
            ret = new PrismMediaFrameHandler(provider);
            handlers.put(provider, ret);
        }
        return ret;
    }

    private PrismMediaFrameHandler(Object provider) {
    }

    public Texture getTexture(Graphics g, VideoDataBuffer currentFrame) {
        Screen screen = g.getAssociatedScreen();
        TextureMapEntry tme = this.textures.get(screen);
        if (null == currentFrame) {
            if (this.textures.containsKey(screen)) {
                this.textures.remove(screen);
            }
            return null;
        }
        if (null == tme) {
            tme = new TextureMapEntry();
            this.textures.put(screen, tme);
        }
        if (tme.texture != null) {
            tme.texture.lock();
            if (tme.texture.isSurfaceLost()) {
                tme.texture = null;
            }
        }
        if (null == tme.texture || tme.lastFrameTime != currentFrame.getTimestamp()) {
            this.updateTexture(g, currentFrame, tme);
        }
        return tme.texture;
    }

    private void updateTexture(Graphics g, VideoDataBuffer vdb, TextureMapEntry tme) {
        Screen screen = g.getAssociatedScreen();
        if (tme.texture != null && (tme.encodedWidth != vdb.getEncodedWidth() || tme.encodedHeight != vdb.getEncodedHeight())) {
            tme.texture.dispose();
            tme.texture = null;
        }
        PrismFrameBuffer prismBuffer = new PrismFrameBuffer(vdb);
        if (tme.texture == null) {
            ResourceFactory factory = GraphicsPipeline.getDefaultResourceFactory();
            if (this.registeredWithFactory == null || this.registeredWithFactory.get() != factory) {
                factory.addFactoryListener((ResourceFactoryListener)this);
                this.registeredWithFactory = new WeakReference<ResourceFactory>(factory);
            }
            tme.texture = GraphicsPipeline.getPipeline().getResourceFactory(screen).createTexture((MediaFrame)prismBuffer);
            tme.encodedWidth = vdb.getEncodedWidth();
            tme.encodedHeight = vdb.getEncodedHeight();
        }
        if (tme.texture != null) {
            tme.texture.update((MediaFrame)prismBuffer, false);
        }
        tme.lastFrameTime = vdb.getTimestamp();
    }

    private void releaseData() {
        for (TextureMapEntry tme : this.textures.values()) {
            if (tme == null || tme.texture == null) continue;
            tme.texture.dispose();
        }
        this.textures.clear();
    }

    public void releaseTextures() {
        Toolkit tk = Toolkit.getToolkit();
        tk.addRenderJob(this.releaseRenderJob);
    }

    public void factoryReset() {
        this.releaseData();
    }

    public void factoryReleased() {
        this.releaseData();
    }

    private static class TextureMapEntry {
        public double lastFrameTime = -1.0;
        public Texture texture;
        public int encodedWidth;
        public int encodedHeight;

        private TextureMapEntry() {
        }
    }

    private class PrismFrameBuffer
    implements MediaFrame {
        private final PixelFormat videoFormat;
        private final VideoDataBuffer primary;

        public PrismFrameBuffer(VideoDataBuffer sourceBuffer) {
            if (null == sourceBuffer) {
                throw new NullPointerException();
            }
            this.primary = sourceBuffer;
            switch (this.primary.getFormat()) {
                case BGRA_PRE: {
                    this.videoFormat = PixelFormat.INT_ARGB_PRE;
                    break;
                }
                case YCbCr_420p: {
                    this.videoFormat = PixelFormat.MULTI_YCbCr_420;
                    break;
                }
                case YCbCr_422: {
                    this.videoFormat = PixelFormat.BYTE_APPLE_422;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported video format " + this.primary.getFormat());
                }
            }
        }

        public ByteBuffer getBufferForPlane(int plane) {
            return this.primary.getBufferForPlane(plane);
        }

        public void holdFrame() {
            this.primary.holdFrame();
        }

        public void releaseFrame() {
            this.primary.releaseFrame();
        }

        public PixelFormat getPixelFormat() {
            return this.videoFormat;
        }

        public int getWidth() {
            return this.primary.getWidth();
        }

        public int getHeight() {
            return this.primary.getHeight();
        }

        public int getEncodedWidth() {
            return this.primary.getEncodedWidth();
        }

        public int getEncodedHeight() {
            return this.primary.getEncodedHeight();
        }

        public int planeCount() {
            return this.primary.getPlaneCount();
        }

        public int[] planeStrides() {
            return this.primary.getPlaneStrides();
        }

        public int strideForPlane(int planeIndex) {
            return this.primary.getStrideForPlane(planeIndex);
        }

        public MediaFrame convertToFormat(PixelFormat fmt) {
            if (fmt == this.getPixelFormat()) {
                return this;
            }
            if (fmt != PixelFormat.INT_ARGB_PRE) {
                return null;
            }
            VideoDataBuffer newVDB = this.primary.convertToFormat(VideoFormat.BGRA_PRE);
            if (null == newVDB) {
                return null;
            }
            return new PrismFrameBuffer(newVDB);
        }
    }
}

