/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum MediaError {
    ERROR_BASE_MEDIA(256),
    ERROR_BASE_MANAGER(512),
    ERROR_BASE_PIPELINE(768),
    ERROR_BASE_FACTORY(1024),
    ERROR_BASE_LOCATOR(1280),
    ERROR_BASE_REGISTRY(1536),
    ERROR_BASE_GSTREAMER(2048),
    ERROR_BASE_SYSTEM(2560),
    ERROR_BASE_FUNCTION(2816),
    ERROR_BASE_JNI(3072),
    ERROR_BASE_OSX(3328),
    WARNING_BASE_JFXMEDIA(0x100000),
    WARNING_BASE_GSTREAMER(0x800000),
    WARNING_BASE_GLIB(0x900000),
    ERROR_MASK_BASE(3840),
    WARNING_MASK_BASE(0xF00000),
    ERROR_NONE(0),
    ERROR_MANAGER_NULL(ERROR_BASE_MANAGER.code() + 1),
    ERROR_MANAGER_CREATION(ERROR_BASE_MANAGER.code() + 2),
    ERROR_MANAGER_ENGINEINIT_FAIL(ERROR_BASE_MANAGER.code() + 3),
    ERROR_MANAGER_RUNLOOP_FAIL(ERROR_BASE_MANAGER.code() + 4),
    ERROR_MANAGER_LOGGER_INIT(ERROR_BASE_MANAGER.code() + 5),
    ERROR_MEDIA_NULL(ERROR_BASE_MEDIA.code() + 1),
    ERROR_MEDIA_CREATION(ERROR_BASE_MEDIA.code() + 2),
    ERROR_MEDIA_UNKNOWN_PIXEL_FORMAT(ERROR_BASE_MEDIA.code() + 3),
    ERROR_MEDIA_INVALID(ERROR_BASE_MEDIA.code() + 4),
    ERROR_MEDIA_MARKER_NAME_NULL(ERROR_BASE_MEDIA.code() + 5),
    ERROR_MEDIA_MARKER_TIME_NEGATIVE(ERROR_BASE_MEDIA.code() + 6),
    ERROR_MEDIA_MARKER_MAP_NULL(ERROR_BASE_MEDIA.code() + 7),
    ERROR_MEDIA_VIDEO_FORMAT_UNSUPPORTED(ERROR_BASE_MEDIA.code() + 8),
    ERROR_MEDIA_AUDIO_FORMAT_UNSUPPORTED(ERROR_BASE_MEDIA.code() + 9),
    ERROR_MEDIA_MP3_FORMAT_UNSUPPORTED(ERROR_BASE_MEDIA.code() + 10),
    ERROR_MEDIA_AAC_FORMAT_UNSUPPORTED(ERROR_BASE_MEDIA.code() + 11),
    ERROR_MEDIA_H264_FORMAT_UNSUPPORTED(ERROR_BASE_MEDIA.code() + 12),
    ERROR_MEDIA_H265_FORMAT_UNSUPPORTED(ERROR_BASE_MEDIA.code() + 13),
    ERROR_MEDIA_HLS_FORMAT_UNSUPPORTED(ERROR_BASE_MEDIA.code() + 14),
    ERROR_MEDIA_CORRUPTED(ERROR_BASE_MEDIA.code() + 15),
    ERROR_PIPELINE_NULL(ERROR_BASE_PIPELINE.code() + 1),
    ERROR_PIPELINE_CREATION(ERROR_BASE_PIPELINE.code() + 2),
    ERROR_PIPELINE_NO_FRAME_QUEUE(ERROR_BASE_PIPELINE.code() + 3),
    ERROR_FACTORY_NULL(ERROR_BASE_FACTORY.code() + 1),
    ERROR_FACTORY_CONTAINER_CREATION(ERROR_BASE_FACTORY.code() + 2),
    ERROR_FACTORY_INVALID_URI(ERROR_BASE_FACTORY.code() + 3),
    ERROR_LOCATOR_NULL(ERROR_BASE_LOCATOR.code() + 1),
    ERROR_LOCATOR_UNSUPPORTED_TYPE(ERROR_BASE_LOCATOR.code() + 2),
    ERROR_LOCATOR_UNSUPPORTED_MEDIA_FORMAT(ERROR_BASE_LOCATOR.code() + 3),
    ERROR_LOCATOR_CONNECTION_LOST(ERROR_BASE_LOCATOR.code() + 4),
    ERROR_LOCATOR_CONTENT_TYPE_NULL(ERROR_BASE_LOCATOR.code() + 5),
    ERROR_REGISTRY_NULL(ERROR_BASE_REGISTRY.code() + 1),
    ERROR_REGISTRY_PLUGIN_ALREADY_EXIST(ERROR_BASE_REGISTRY.code() + 2),
    ERROR_REGISTRY_PLUGIN_PATH(ERROR_BASE_REGISTRY.code() + 3),
    ERROR_REGISTRY_NO_MATCHING_RECIPE(ERROR_BASE_REGISTRY.code() + 4),
    ERROR_GSTREAMER_ERROR(ERROR_BASE_GSTREAMER.code() + 1),
    ERROR_GSTREAMER_PIPELINE_CREATION(ERROR_BASE_GSTREAMER.code() + 2),
    ERROR_GSTREAMER_AUDIO_DECODER_SINK_PAD(ERROR_BASE_GSTREAMER.code() + 3),
    ERROR_GSTREAMER_AUDIO_DECODER_SRC_PAD(ERROR_BASE_GSTREAMER.code() + 4),
    ERROR_GSTREAMER_AUDIO_SINK_SINK_PAD(ERROR_BASE_GSTREAMER.code() + 5),
    ERROR_GSTREAMER_VIDEO_DECODER_SINK_PAD(ERROR_BASE_GSTREAMER.code() + 6),
    ERROR_GSTREAMER_PIPELINE_STATE_CHANGE(ERROR_BASE_GSTREAMER.code() + 7),
    ERROR_GSTREAMER_PIPELINE_SEEK(ERROR_BASE_GSTREAMER.code() + 8),
    ERROR_GSTREAMER_PIPELINE_QUERY_LENGTH(ERROR_BASE_GSTREAMER.code() + 9),
    ERROR_GSTREAMER_PIPELINE_QUERY_POS(ERROR_BASE_GSTREAMER.code() + 10),
    ERROR_GSTREAMER_PIPELINE_METADATA_TYPE(ERROR_BASE_GSTREAMER.code() + 11),
    ERROR_GSTREAMER_AUDIO_SINK_CREATE(ERROR_BASE_GSTREAMER.code() + 12),
    ERROR_GSTREAMER_GET_BUFFER_SRC_PAD(ERROR_BASE_GSTREAMER.code() + 13),
    ERROR_GSTREAMER_CREATE_GHOST_PAD(ERROR_BASE_GSTREAMER.code() + 14),
    ERROR_GSTREAMER_ELEMENT_ADD_PAD(ERROR_BASE_GSTREAMER.code() + 15),
    ERROR_GSTREAMER_UNSUPPORTED_PROTOCOL(ERROR_BASE_GSTREAMER.code() + 16),
    ERROR_GSTREAMER_SOURCEFILE_NONEXISTENT(ERROR_BASE_GSTREAMER.code() + 32),
    ERROR_GSTREAMER_SOURCEFILE_NONREGULAR(ERROR_BASE_GSTREAMER.code() + 48),
    ERROR_GSTREAMER_ELEMENT_LINK(ERROR_BASE_GSTREAMER.code() + 64),
    ERROR_GSTREAMER_ELEMENT_LINK_AUDIO_BIN(ERROR_BASE_GSTREAMER.code() + 80),
    ERROR_GSTREAMER_ELEMENT_LINK_VIDEO_BIN(ERROR_BASE_GSTREAMER.code() + 96),
    ERROR_GSTREAMER_ELEMENT_CREATE(ERROR_BASE_GSTREAMER.code() + 112),
    ERROR_GSTREAMER_VIDEO_SINK_CREATE(ERROR_BASE_GSTREAMER.code() + 128),
    ERROR_GSTREAMER_BIN_CREATE(ERROR_BASE_GSTREAMER.code() + 144),
    ERROR_GSTREAMER_BIN_ADD_ELEMENT(ERROR_BASE_GSTREAMER.code() + 160),
    ERROR_GSTREAMER_ELEMENT_GET_PAD(ERROR_BASE_GSTREAMER.code() + 176),
    ERROR_GSTREAMER_MAIN_LOOP_CREATE(ERROR_BASE_GSTREAMER.code() + 192),
    ERROR_GSTREAMER_BUS_SOURCE_ATTACH(ERROR_BASE_GSTREAMER.code() + 193),
    ERROR_GSTREAMER_PIPELINE_SET_RATE_ZERO(ERROR_BASE_GSTREAMER.code() + 208),
    ERROR_GSTREAMER_VIDEO_SINK_SINK_PAD(ERROR_BASE_GSTREAMER.code() + 224),
    ERROR_NOT_IMPLEMENTED(ERROR_BASE_SYSTEM.code() + 1),
    ERROR_MEMORY_ALLOCATION(ERROR_BASE_SYSTEM.code() + 2),
    ERROR_OS_UNSUPPORTED(ERROR_BASE_SYSTEM.code() + 3),
    ERROR_PLATFORM_UNSUPPORTED(ERROR_BASE_SYSTEM.code() + 4),
    ERROR_MISSING_LIBSWSCALE(ERROR_BASE_SYSTEM.code() + 5),
    ERROR_INVALID_LIBSWSCALE(ERROR_BASE_SYSTEM.code() + 6),
    ERROR_FUNCTION_PARAM(ERROR_BASE_FUNCTION.code() + 1),
    ERROR_FUNCTION_PARAM_NULL(ERROR_BASE_FUNCTION.code() + 2),
    ERROR_JNI_SEND_PLAYER_MEDIA_ERROR_EVENT(ERROR_BASE_JNI.code() + 1),
    ERROR_JNI_SEND_PLAYER_HALT_EVENT(ERROR_BASE_JNI.code() + 2),
    ERROR_JNI_SEND_PLAYER_STATE_EVENT(ERROR_BASE_JNI.code() + 3),
    ERROR_JNI_SEND_NEW_FRAME_EVENT(ERROR_BASE_JNI.code() + 4),
    ERROR_JNI_SEND_FRAME_SIZE_CHANGED_EVENT(ERROR_BASE_JNI.code() + 5),
    ERROR_JNI_SEND_END_OF_MEDIA_EVENT(ERROR_BASE_JNI.code() + 6),
    ERROR_JNI_SEND_AUDIO_TRACK_EVENT(ERROR_BASE_JNI.code() + 7),
    ERROR_JNI_SEND_VIDEO_TRACK_EVENT(ERROR_BASE_JNI.code() + 8),
    ERROR_JNI_SEND_METADATA_EVENT(ERROR_BASE_JNI.code() + 9),
    ERROR_JNI_SEND_MARKER_EVENT(ERROR_BASE_JNI.code() + 10),
    ERROR_JNI_SEND_BUFFER_PROGRESS_EVENT(ERROR_BASE_JNI.code() + 11),
    ERROR_JNI_SEND_STOP_REACHED_EVENT(ERROR_BASE_JNI.code() + 12),
    ERROR_JNI_SEND_DURATION_UPDATE_EVENT(ERROR_BASE_JNI.code() + 13),
    ERROR_JNI_SEND_AUDIO_SPECTRUM_EVENT(ERROR_BASE_JNI.code() + 14),
    ERROR_OSX_INIT(ERROR_BASE_OSX.code() + 1),
    WARNING_JFXMEDIA_BALANCE(WARNING_BASE_JFXMEDIA.code() + 1),
    WARNING_GSTREAMER_WARNING(WARNING_BASE_GSTREAMER.code() + 1),
    WARNING_GSTREAMER_PIPELINE_ERROR(WARNING_BASE_GSTREAMER.code() + 2),
    WARNING_GSTREAMER_PIPELINE_WARNING(WARNING_BASE_GSTREAMER.code() + 3),
    WARNING_GSTREAMER_PIPELINE_STATE_EVENT(WARNING_BASE_GSTREAMER.code() + 4),
    WARNING_GSTREAMER_PIPELINE_FRAME_SIZE(WARNING_BASE_GSTREAMER.code() + 5),
    WARNING_GSTREAMER_INVALID_FRAME(WARNING_BASE_GSTREAMER.code() + 6),
    WARNING_GSTREAMER_PIPELINE_INFO_ERROR(WARNING_BASE_GSTREAMER.code() + 7),
    WARNING_GSTREAMER_AUDIO_BUFFER_FIELD(WARNING_BASE_GSTREAMER.code() + 8);

    private static ResourceBundle bundle;
    private static final Map<Integer, MediaError> map;
    private int code;
    private String description;

    private MediaError(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public String description() {
        if (this.description == null) {
            String errorName = this.name();
            if (bundle != null) {
                try {
                    this.description = bundle.getString(errorName);
                }
                catch (MissingResourceException e) {
                    this.description = errorName;
                }
            } else {
                this.description = errorName;
            }
        }
        return this.description;
    }

    public static MediaError getFromCode(int code) {
        return map.get(code);
    }

    static {
        map = new HashMap<Integer, MediaError>();
        try {
            bundle = ResourceBundle.getBundle("MediaErrors", Locale.getDefault());
        }
        catch (MissingResourceException e) {
            bundle = null;
        }
        for (MediaError error : MediaError.values()) {
            map.put(error.code(), error);
        }
    }
}

