/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.control;

import java.util.HashMap;
import java.util.Map;

public enum VideoFormat {
    ARGB(1),
    BGRA_PRE(2),
    YCbCr_420p(100),
    YCbCr_422(101);

    private int nativeType;
    private static final Map<Integer, VideoFormat> lookupMap;

    private VideoFormat(int ntype) {
        this.nativeType = ntype;
    }

    public int getNativeType() {
        return this.nativeType;
    }

    public boolean isRGB() {
        return this == ARGB || this == BGRA_PRE;
    }

    public boolean isEqualTo(int ntype) {
        return this.nativeType == ntype;
    }

    public static VideoFormat formatForType(int ntype) {
        return lookupMap.get(ntype);
    }

    static {
        lookupMap = new HashMap<Integer, VideoFormat>();
        for (VideoFormat fmt : VideoFormat.values()) {
            lookupMap.put(fmt.getNativeType(), fmt);
        }
    }

    public static class FormatTypes {
        public static final int FORMAT_TYPE_ARGB = 1;
        public static final int FORMAT_TYPE_BGRA_PRE = 2;
        public static final int FORMAT_TYPE_YCBCR_420P = 100;
        public static final int FORMAT_TYPE_YCBCR_422 = 101;
    }
}

