/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.media;

import com.sun.javafx.collections.VetoableListDecorator;
import com.sun.media.jfxmedia.logging.Logger;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.media.EqualizerBand;

public final class AudioEqualizer {
    public static final int MAX_NUM_BANDS = 64;
    private com.sun.media.jfxmedia.effects.AudioEqualizer jfxEqualizer = null;
    private final ObservableList<EqualizerBand> bands;
    private final Object disposeLock = new Object();
    private BooleanProperty enabled;

    public final ObservableList<EqualizerBand> getBands() {
        return this.bands;
    }

    AudioEqualizer() {
        this.bands = new Bands();
        this.bands.addAll((Object[])new EqualizerBand[]{new EqualizerBand(32.0, 19.0, 0.0), new EqualizerBand(64.0, 39.0, 0.0), new EqualizerBand(125.0, 78.0, 0.0), new EqualizerBand(250.0, 156.0, 0.0), new EqualizerBand(500.0, 312.0, 0.0), new EqualizerBand(1000.0, 625.0, 0.0), new EqualizerBand(2000.0, 1250.0, 0.0), new EqualizerBand(4000.0, 2500.0, 0.0), new EqualizerBand(8000.0, 5000.0, 0.0), new EqualizerBand(16000.0, 10000.0, 0.0)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAudioEqualizer(com.sun.media.jfxmedia.effects.AudioEqualizer jfxEqualizer) {
        Object object = this.disposeLock;
        synchronized (object) {
            if (this.jfxEqualizer == jfxEqualizer) {
                return;
            }
            if (this.jfxEqualizer != null && jfxEqualizer == null) {
                this.jfxEqualizer.setEnabled(false);
                for (EqualizerBand band : this.bands) {
                    band.setJfxBand(null);
                }
                this.jfxEqualizer = null;
                return;
            }
            this.jfxEqualizer = jfxEqualizer;
            jfxEqualizer.setEnabled(this.isEnabled());
            for (EqualizerBand band : this.bands) {
                if (band.getCenterFrequency() > 0.0 && band.getBandwidth() > 0.0) {
                    com.sun.media.jfxmedia.effects.EqualizerBand jfxBand = jfxEqualizer.addBand(band.getCenterFrequency(), band.getBandwidth(), band.getGain());
                    band.setJfxBand(jfxBand);
                    continue;
                }
                Logger.logMsg(4, "Center frequency [" + band.getCenterFrequency() + "] and bandwidth [" + band.getBandwidth() + "] must be greater than 0.");
            }
        }
    }

    public final void setEnabled(boolean value) {
        this.enabledProperty().set(value);
    }

    public final boolean isEnabled() {
        return this.enabled == null ? false : this.enabled.get();
    }

    public BooleanProperty enabledProperty() {
        if (this.enabled == null) {
            this.enabled = new BooleanPropertyBase(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void invalidated() {
                    Object object = AudioEqualizer.this.disposeLock;
                    synchronized (object) {
                        if (AudioEqualizer.this.jfxEqualizer != null) {
                            AudioEqualizer.this.jfxEqualizer.setEnabled(AudioEqualizer.this.enabled.get());
                        }
                    }
                }

                public Object getBean() {
                    return AudioEqualizer.this;
                }

                public String getName() {
                    return "enabled";
                }
            };
        }
        return this.enabled;
    }

    private class Bands
    extends VetoableListDecorator<EqualizerBand> {
        public Bands() {
            super(FXCollections.observableArrayList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onProposedChange(List<EqualizerBand> toBeAdded, int ... toBeRemoved) {
            Object object = AudioEqualizer.this.disposeLock;
            synchronized (object) {
                if (AudioEqualizer.this.jfxEqualizer != null) {
                    for (int i = 0; i < toBeRemoved.length; i += 2) {
                        for (EqualizerBand band : this.subList(toBeRemoved[i], toBeRemoved[i + 1])) {
                            AudioEqualizer.this.jfxEqualizer.removeBand(band.getCenterFrequency());
                        }
                    }
                    for (EqualizerBand band : toBeAdded) {
                        if (band.getCenterFrequency() > 0.0 && band.getBandwidth() > 0.0) {
                            com.sun.media.jfxmedia.effects.EqualizerBand jfxBand = AudioEqualizer.this.jfxEqualizer.addBand(band.getCenterFrequency(), band.getBandwidth(), band.getGain());
                            band.setJfxBand(jfxBand);
                            continue;
                        }
                        Logger.logMsg(4, "Center frequency [" + band.getCenterFrequency() + "] and bandwidth [" + band.getBandwidth() + "] must be greater than 0.");
                    }
                }
            }
        }
    }
}

