/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.media;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.media.PrismMediaFrameHandler;
import com.sun.javafx.sg.prism.MediaFrameTracker;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.media.jfxmedia.control.VideoDataBuffer;
import com.sun.prism.Graphics;
import com.sun.prism.Texture;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;

class NGMediaView
extends NGNode {
    private boolean smooth = true;
    private final RectBounds dimension = new RectBounds();
    private final RectBounds viewport = new RectBounds();
    private PrismMediaFrameHandler handler;
    private MediaPlayer player;
    private MediaFrameTracker frameTracker;

    NGMediaView() {
    }

    public void renderNextFrame() {
        this.visualsChanged();
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    public void setSmooth(boolean smooth) {
        if (smooth != this.smooth) {
            this.smooth = smooth;
            this.visualsChanged();
        }
    }

    public void setX(float x) {
        if (x != this.dimension.getMinX()) {
            float width = this.dimension.getWidth();
            this.dimension.setMinX(x);
            this.dimension.setMaxX(x + width);
            this.geometryChanged();
        }
    }

    public void setY(float y) {
        if (y != this.dimension.getMinY()) {
            float height = this.dimension.getHeight();
            this.dimension.setMinY(y);
            this.dimension.setMaxY(y + height);
            this.geometryChanged();
        }
    }

    public void setMediaProvider(Object provider) {
        if (provider == null) {
            this.player = null;
            this.handler = null;
            this.geometryChanged();
        } else if (provider instanceof MediaPlayer) {
            this.player = (MediaPlayer)provider;
            this.handler = PrismMediaFrameHandler.getHandler(this.player);
            this.geometryChanged();
        }
    }

    public void setViewport(float fitWidth, float fitHeight, float vx, float vy, float vw, float vh, boolean preserveRatio) {
        float w = 0.0f;
        float h = 0.0f;
        float newW = fitWidth;
        float newH = fitHeight;
        if (null != this.player) {
            Media m = this.player.getMedia();
            w = m.getWidth();
            h = m.getHeight();
        }
        if (vw > 0.0f && vh > 0.0f) {
            this.viewport.setBounds(vx, vy, vx + vw, vy + vh);
            w = vw;
            h = vh;
        } else {
            this.viewport.setBounds(0.0f, 0.0f, w, h);
        }
        if (fitWidth <= 0.0f && fitHeight <= 0.0f) {
            newW = w;
            newH = h;
        } else if (preserveRatio) {
            if ((double)fitWidth <= 0.0) {
                newW = h > 0.0f ? w * (fitHeight / h) : 0.0f;
                newH = fitHeight;
            } else if ((double)fitHeight <= 0.0) {
                newW = fitWidth;
                newH = w > 0.0f ? h * (fitWidth / w) : 0.0f;
            } else {
                if (w == 0.0f) {
                    w = fitWidth;
                }
                if (h == 0.0f) {
                    h = fitHeight;
                }
                float scale = Math.min(fitWidth / w, fitHeight / h);
                newW = w * scale;
                newH = h * scale;
            }
        } else if ((double)fitHeight <= 0.0) {
            newH = h;
        } else if ((double)fitWidth <= 0.0) {
            newW = w;
        }
        if (newH < 1.0f) {
            newH = 1.0f;
        }
        if (newW < 1.0f) {
            newW = 1.0f;
        }
        this.dimension.setMaxX(this.dimension.getMinX() + newW);
        this.dimension.setMaxY(this.dimension.getMinY() + newH);
        this.geometryChanged();
    }

    protected void renderContent(Graphics g) {
        if (null == this.handler || null == this.player) {
            return;
        }
        VideoDataBuffer frame = this.player.getLatestFrame();
        if (null == frame) {
            return;
        }
        Texture texture = this.handler.getTexture(g, frame);
        if (texture != null) {
            float iw = this.viewport.getWidth();
            float ih = this.viewport.getHeight();
            boolean dimensionsSet = !this.dimension.isEmpty();
            boolean doScale = dimensionsSet && (iw != this.dimension.getWidth() || ih != this.dimension.getHeight());
            g.translate(this.dimension.getMinX(), this.dimension.getMinY());
            if (doScale && iw != 0.0f && ih != 0.0f) {
                float scaleW = this.dimension.getWidth() / iw;
                float scaleH = this.dimension.getHeight() / ih;
                g.scale(scaleW, scaleH);
            }
            float sx1 = this.viewport.getMinX();
            float sy1 = this.viewport.getMinY();
            float sx2 = sx1 + iw;
            float sy2 = sy1 + ih;
            g.drawTexture(texture, 0.0f, 0.0f, iw, ih, sx1, sy1, sx2, sy2);
            texture.unlock();
            if (null != this.frameTracker) {
                this.frameTracker.incrementRenderedFrameCount(1);
            }
        }
        frame.releaseFrame();
    }

    protected boolean hasOverlappingContents() {
        return false;
    }

    public void setFrameTracker(MediaFrameTracker t) {
        this.frameTracker = t;
    }
}

