/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.embed.swing;

import java.awt.event.MouseWheelEvent;
import javafx.event.EventType;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class SwingEvents {
    public static int mouseIDToEmbedMouseType(int id) {
        switch (id) {
            case 501: {
                return 0;
            }
            case 502: {
                return 1;
            }
            case 500: {
                return 2;
            }
            case 503: {
                return 5;
            }
            case 506: {
                return 6;
            }
            case 504: {
                return 3;
            }
            case 505: {
                return 4;
            }
        }
        return 0;
    }

    public static int mouseButtonToEmbedMouseButton(int button, int extModifiers) {
        int abstractButton = 0;
        switch (button) {
            case 1: {
                abstractButton = 1;
                break;
            }
            case 2: {
                abstractButton = 4;
                break;
            }
            case 3: {
                abstractButton = 2;
                break;
            }
            case 4: {
                abstractButton = 8;
                break;
            }
            case 5: {
                abstractButton = 16;
                break;
            }
        }
        if ((extModifiers & 0x400) != 0) {
            abstractButton = 1;
        } else if ((extModifiers & 0x800) != 0) {
            abstractButton = 4;
        } else if ((extModifiers & 0x1000) != 0) {
            abstractButton = 2;
        } else if ((extModifiers & java.awt.event.MouseEvent.getMaskForButton(4)) != 0) {
            abstractButton = 8;
        } else if ((extModifiers & java.awt.event.MouseEvent.getMaskForButton(5)) != 0) {
            abstractButton = 16;
        }
        return abstractButton;
    }

    public static int getWheelRotation(java.awt.event.MouseEvent e) {
        if (e instanceof MouseWheelEvent) {
            return ((MouseWheelEvent)e).getWheelRotation();
        }
        return 0;
    }

    public static int keyIDToEmbedKeyType(int id) {
        switch (id) {
            case 401: {
                return 0;
            }
            case 402: {
                return 1;
            }
            case 400: {
                return 2;
            }
        }
        return 0;
    }

    public static int keyModifiersToEmbedKeyModifiers(int extModifiers) {
        int embedModifiers = 0;
        if ((extModifiers & 0x40) != 0) {
            embedModifiers |= 1;
        }
        if ((extModifiers & 0x80) != 0) {
            embedModifiers |= 2;
        }
        if ((extModifiers & 0x200) != 0) {
            embedModifiers |= 4;
        }
        if ((extModifiers & 0x100) != 0) {
            embedModifiers |= 8;
        }
        return embedModifiers;
    }

    public static char keyCharToEmbedKeyChar(char ch) {
        return ch == '\n' ? (char)'\r' : (char)ch;
    }

    public static int fxMouseEventTypeToMouseID(MouseEvent event) {
        EventType type = event.getEventType();
        if (type == MouseEvent.MOUSE_MOVED) {
            return 503;
        }
        if (type == MouseEvent.MOUSE_PRESSED) {
            return 501;
        }
        if (type == MouseEvent.MOUSE_RELEASED) {
            return 502;
        }
        if (type == MouseEvent.MOUSE_CLICKED) {
            return 500;
        }
        if (type == MouseEvent.MOUSE_ENTERED) {
            return 504;
        }
        if (type == MouseEvent.MOUSE_EXITED) {
            return 505;
        }
        if (type == MouseEvent.MOUSE_DRAGGED) {
            return 506;
        }
        if (type == MouseEvent.DRAG_DETECTED) {
            return -1;
        }
        throw new RuntimeException("Unknown MouseEvent type: " + type);
    }

    public static int fxMouseModsToMouseMods(MouseEvent event) {
        int mods = 0;
        if (event.isAltDown()) {
            mods |= 0x200;
        }
        if (event.isControlDown()) {
            mods |= 0x80;
        }
        if (event.isMetaDown()) {
            mods |= 0x100;
        }
        if (event.isShiftDown()) {
            mods |= 0x40;
        }
        if (event.isPrimaryButtonDown()) {
            mods |= 0x400;
        }
        if (event.isSecondaryButtonDown()) {
            mods |= 0x1000;
        }
        if (event.isMiddleButtonDown()) {
            mods |= 0x800;
        }
        if (event.isBackButtonDown()) {
            mods |= java.awt.event.MouseEvent.getMaskForButton(4);
        }
        if (event.isForwardButtonDown()) {
            mods |= java.awt.event.MouseEvent.getMaskForButton(5);
        }
        return mods;
    }

    public static int fxMouseButtonToMouseButton(MouseEvent event) {
        switch (event.getButton()) {
            case PRIMARY: {
                return 1;
            }
            case SECONDARY: {
                return 3;
            }
            case MIDDLE: {
                return 2;
            }
            case BACK: {
                return 4;
            }
            case FORWARD: {
                return 5;
            }
        }
        return 0;
    }

    public static int fxKeyEventTypeToKeyID(KeyEvent event) {
        EventType eventType = event.getEventType();
        if (eventType == KeyEvent.KEY_PRESSED) {
            return 401;
        }
        if (eventType == KeyEvent.KEY_RELEASED) {
            return 402;
        }
        if (eventType == KeyEvent.KEY_TYPED) {
            return 400;
        }
        throw new RuntimeException("Unknown KeyEvent type: " + eventType);
    }

    public static int fxKeyModsToKeyMods(KeyEvent event) {
        int mods = 0;
        if (event.isAltDown()) {
            mods |= 0x200;
        }
        if (event.isControlDown()) {
            mods |= 0x80;
        }
        if (event.isMetaDown()) {
            mods |= 0x100;
        }
        if (event.isShiftDown()) {
            mods |= 0x40;
        }
        return mods;
    }

    public static int fxScrollModsToMouseWheelMods(ScrollEvent event) {
        int mods = 0;
        if (event.isAltDown()) {
            mods |= 0x200;
        }
        if (event.isControlDown()) {
            mods |= 0x80;
        }
        if (event.isMetaDown()) {
            mods |= 0x100;
        }
        if (event.isShiftDown()) {
            mods |= 0x40;
        }
        return mods;
    }
}

