/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.embed.swing.Disposer;
import com.sun.javafx.embed.swing.SwingEvents;
import com.sun.javafx.embed.swing.SwingNodeHelper;
import com.sun.javafx.embed.swing.newimpl.SwingNodeInteropN;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.sg.prism.NGExternalNode;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.stage.FocusUngrabEvent;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.tk.TKStage;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowFocusListener;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ScrollEvent;
import javafx.scene.text.Font;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.swing.JComponent;
import javax.swing.Timer;
import jdk.swing.interop.LightweightFrameWrapper;

public class SwingNode
extends Node {
    private static boolean isThreadMerged;
    private double fxWidth;
    private double fxHeight;
    private int swingPrefWidth;
    private int swingPrefHeight;
    private int swingMaxWidth;
    private int swingMaxHeight;
    private int swingMinWidth;
    private int swingMinHeight;
    private volatile JComponent content;
    private volatile Object lwFrame;
    private NGExternalNode peer;
    private final ReentrantLock paintLock = new ReentrantLock();
    private boolean skipBackwardUnrgabNotification;
    private boolean grabbed;
    private Timer deactivate;
    private SwingNodeInteropN swNodeIOP;
    private EventHandler windowHiddenHandler;
    private Window hWindow;
    private List<Runnable> peerRequests;
    private final InvalidationListener locationListener;
    private final EventHandler<FocusUngrabEvent> ungrabHandler;
    private final ChangeListener<Boolean> windowVisibleListener;
    private final ChangeListener<Window> sceneWindowListener;

    private final Object getLightweightFrame() {
        return this.lwFrame;
    }

    private ReentrantLock getPaintLock() {
        return this.paintLock;
    }

    public SwingNode() {
        SwingNodeHelper.initHelper(this);
        this.windowHiddenHandler = event -> {
            Window w;
            TKStage tk;
            if (this.lwFrame != null && event.getTarget() instanceof Window && (tk = WindowHelper.getPeer((Window)(w = (Window)event.getTarget()))) != null) {
                if (isThreadMerged) {
                    this.swNodeIOP.overrideNativeWindowHandle(this.lwFrame, 0L, null);
                } else {
                    tk.postponeClose();
                    SwingNodeHelper.runOnEDT(() -> this.swNodeIOP.overrideNativeWindowHandle(this.lwFrame, 0L, () -> SwingNodeHelper.runOnFxThread(() -> tk.closePostponed())));
                }
            }
        };
        this.hWindow = null;
        this.peerRequests = new ArrayList<Runnable>();
        this.locationListener = observable -> this.locateLwFrame();
        this.ungrabHandler = event -> {
            if (!this.skipBackwardUnrgabNotification && this.lwFrame != null) {
                AccessController.doPrivileged(new PostEventAction(this.swNodeIOP.createUngrabEvent(this.lwFrame)));
            }
        };
        this.windowVisibleListener = (observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.disposeLwFrame();
            } else {
                this.setContent(this.content);
            }
        };
        this.sceneWindowListener = (observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.removeWindowListeners((Window)oldValue);
            }
            this.notifyNativeHandle((Window)newValue);
            if (newValue != null) {
                this.addWindowListeners((Window)newValue);
            }
        };
        this.swNodeIOP = new SwingNodeInteropN();
        this.setFocusTraversable(true);
        this.setEventHandler(javafx.scene.input.MouseEvent.ANY, new SwingMouseEventHandler());
        this.setEventHandler(KeyEvent.ANY, new SwingKeyEventHandler());
        this.setEventHandler(ScrollEvent.SCROLL, new SwingScrollEventHandler());
        this.focusedProperty().addListener((observable, oldValue, newValue) -> this.activateLwFrame((boolean)newValue));
        Font.getFamilies();
    }

    private void notifyNativeHandle(Window window) {
        if (this.hWindow != window) {
            if (this.hWindow != null) {
                this.hWindow.removeEventHandler(WindowEvent.WINDOW_HIDDEN, this.windowHiddenHandler);
            }
            if (window != null) {
                window.addEventHandler(WindowEvent.WINDOW_HIDDEN, this.windowHiddenHandler);
            }
            this.hWindow = window;
        }
        if (this.lwFrame != null) {
            TKStage tkStage;
            long rawHandle = 0L;
            if (window != null && (tkStage = WindowHelper.getPeer((Window)window)) != null) {
                rawHandle = tkStage.getRawHandle();
            }
            this.swNodeIOP.overrideNativeWindowHandle(this.lwFrame, rawHandle, null);
        }
    }

    public void setContent(JComponent content) {
        this.content = content;
        SwingNodeHelper.runOnEDT(() -> this.setContentImpl(content));
    }

    public JComponent getContent() {
        return this.content;
    }

    private void setContentImpl(JComponent content) {
        if (this.lwFrame != null) {
            this.swNodeIOP.disposeFrame(this.lwFrame);
            this.lwFrame = null;
        }
        if (content != null) {
            Window window;
            this.lwFrame = this.swNodeIOP.createLightweightFrame();
            SwingNodeWindowFocusListener snfListener = new SwingNodeWindowFocusListener(this);
            this.swNodeIOP.addWindowFocusListener(this.lwFrame, snfListener);
            if (this.getScene() != null && (window = this.getScene().getWindow()) != null) {
                this.swNodeIOP.notifyDisplayChanged(this.lwFrame, window.getRenderScaleX(), window.getRenderScaleY());
            }
            this.swNodeIOP.setContent(this.lwFrame, this.swNodeIOP.createSwingNodeContent(content, this));
            this.swNodeIOP.setVisible(this.lwFrame, true);
            Disposer.addRecord((Object)this, this.swNodeIOP.createSwingNodeDisposer(this.lwFrame));
            if (this.getScene() != null) {
                this.notifyNativeHandle(this.getScene().getWindow());
            }
            SwingNodeHelper.runOnFxThread(() -> {
                this.locateLwFrame();
                if (this.focusedProperty().get()) {
                    this.activateLwFrame(true);
                }
            });
        }
    }

    void setImageBuffer(int[] data, int x, int y, int w, int h, int linestride, double scaleX, double scaleY) {
        Runnable r = () -> this.peer.setImageBuffer((Buffer)IntBuffer.wrap(data), x, y, w, h, (float)w, (float)h, linestride, scaleX, scaleY);
        SwingNodeHelper.runOnFxThread(() -> {
            if (this.peer != null) {
                r.run();
            } else {
                this.peerRequests.clear();
                this.peerRequests.add(r);
            }
        });
    }

    void setImageBounds(int x, int y, int w, int h) {
        Runnable r = () -> this.peer.setImageBounds(x, y, w, h, (float)w, (float)h);
        SwingNodeHelper.runOnFxThread(() -> {
            if (this.peer != null) {
                r.run();
            } else {
                this.peerRequests.add(r);
            }
        });
    }

    void repaintDirtyRegion(int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight) {
        Runnable r = () -> {
            this.peer.repaintDirtyRegion(dirtyX, dirtyY, dirtyWidth, dirtyHeight);
            NodeHelper.markDirty((Node)this, (DirtyBits)DirtyBits.NODE_CONTENTS);
        };
        SwingNodeHelper.runOnFxThread(() -> {
            if (this.peer != null) {
                r.run();
            } else {
                this.peerRequests.add(r);
            }
        });
    }

    public boolean isResizable() {
        return true;
    }

    public void resize(double width, double height) {
        super.resize(width, height);
        if (width != this.fxWidth || height != this.fxHeight) {
            this.fxWidth = width;
            this.fxHeight = height;
            NodeHelper.geomChanged((Node)this);
            NodeHelper.markDirty((Node)this, (DirtyBits)DirtyBits.NODE_GEOMETRY);
            SwingNodeHelper.runOnEDT(() -> {
                if (this.lwFrame != null) {
                    this.locateLwFrame();
                }
            });
        }
    }

    public double prefWidth(double height) {
        return this.swingPrefWidth;
    }

    public double prefHeight(double width) {
        return this.swingPrefHeight;
    }

    public double maxWidth(double height) {
        return this.swingMaxWidth;
    }

    public double maxHeight(double width) {
        return this.swingMaxHeight;
    }

    public double minWidth(double height) {
        return this.swingMinWidth;
    }

    public double minHeight(double width) {
        return this.swingMinHeight;
    }

    private boolean doComputeContains(double localX, double localY) {
        return true;
    }

    private void removeSceneListeners(Scene scene) {
        Window window = scene.getWindow();
        if (window != null) {
            this.removeWindowListeners(window);
        }
        scene.windowProperty().removeListener(this.sceneWindowListener);
    }

    private void addSceneListeners(Scene scene) {
        Window window = scene.getWindow();
        if (window != null) {
            this.addWindowListeners(window);
            this.notifyNativeHandle(window);
        }
        scene.windowProperty().addListener(this.sceneWindowListener);
    }

    private void addWindowListeners(Window window) {
        window.xProperty().addListener(this.locationListener);
        window.yProperty().addListener(this.locationListener);
        window.widthProperty().addListener(this.locationListener);
        window.heightProperty().addListener(this.locationListener);
        window.renderScaleXProperty().addListener(this.locationListener);
        window.addEventHandler(FocusUngrabEvent.FOCUS_UNGRAB, this.ungrabHandler);
        window.showingProperty().addListener(this.windowVisibleListener);
        this.setLwFrameScale(window.getRenderScaleX(), window.getRenderScaleY());
    }

    private void removeWindowListeners(Window window) {
        window.xProperty().removeListener(this.locationListener);
        window.yProperty().removeListener(this.locationListener);
        window.widthProperty().removeListener(this.locationListener);
        window.heightProperty().removeListener(this.locationListener);
        window.renderScaleXProperty().removeListener(this.locationListener);
        window.removeEventHandler(FocusUngrabEvent.FOCUS_UNGRAB, this.ungrabHandler);
        window.showingProperty().removeListener(this.windowVisibleListener);
    }

    private NGNode doCreatePeer() {
        this.peer = new NGExternalNode();
        this.peer.setLock(this.paintLock);
        for (Runnable request : this.peerRequests) {
            request.run();
        }
        this.peerRequests = null;
        if (this.getScene() != null) {
            this.addSceneListeners(this.getScene());
        }
        this.sceneProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.removeSceneListeners((Scene)oldValue);
                this.disposeLwFrame();
            }
            if (newValue != null) {
                if (this.content != null && this.lwFrame == null) {
                    this.setContent(this.content);
                }
                this.addSceneListeners((Scene)newValue);
            }
        });
        NodeHelper.treeVisibleProperty((Node)this).addListener((observable, oldValue, newValue) -> this.setLwFrameVisible((boolean)newValue));
        return this.peer;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty((Node)this, (DirtyBits)DirtyBits.NODE_VISIBLE) || NodeHelper.isDirty((Node)this, (DirtyBits)DirtyBits.NODE_BOUNDS)) {
            this.locateLwFrame();
        }
        if (NodeHelper.isDirty((Node)this, (DirtyBits)DirtyBits.NODE_CONTENTS)) {
            this.peer.markContentDirty();
        }
    }

    private void locateLwFrame() {
        if (this.getScene() == null || this.lwFrame == null || this.getScene().getWindow() == null || !this.getScene().getWindow().isShowing()) {
            return;
        }
        Window w = this.getScene().getWindow();
        double renderScaleX = w.getRenderScaleX();
        double renderScaleY = w.getRenderScaleY();
        Point2D loc = this.localToScene(0.0, 0.0);
        int windowX = (int)w.getX();
        int windowY = (int)w.getY();
        int windowW = (int)w.getWidth();
        int windowH = (int)w.getHeight();
        int frameX = (int)Math.round(w.getX() + this.getScene().getX() + loc.getX());
        int frameY = (int)Math.round(w.getY() + this.getScene().getY() + loc.getY());
        int frameW = (int)this.fxWidth;
        int frameH = (int)this.fxHeight;
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.notifyDisplayChanged(this.lwFrame, renderScaleX, renderScaleY);
                this.swNodeIOP.setBounds(this.lwFrame, frameX, frameY, frameW, frameH);
                this.swNodeIOP.setHostBounds(this.lwFrame, windowX, windowY, windowW, windowH);
            }
        });
    }

    private void activateLwFrame(boolean activate) {
        if (this.lwFrame == null) {
            return;
        }
        if (PlatformUtil.isLinux()) {
            if (this.deactivate == null || !this.deactivate.isRunning()) {
                if (!activate) {
                    this.deactivate = new Timer(50, e -> {
                        if (this.lwFrame != null) {
                            this.swNodeIOP.emulateActivation(this.lwFrame, false);
                        }
                    });
                    this.deactivate.start();
                    return;
                }
            } else {
                this.deactivate.stop();
            }
        }
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.emulateActivation(this.lwFrame, activate);
            }
        });
    }

    private void disposeLwFrame() {
        if (this.lwFrame == null) {
            return;
        }
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.disposeFrame(this.lwFrame);
                this.lwFrame = null;
            }
        });
    }

    private void setLwFrameVisible(boolean visible) {
        if (this.lwFrame == null) {
            return;
        }
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.setVisible(this.lwFrame, visible);
            }
        });
    }

    private void setLwFrameScale(double scaleX, double scaleY) {
        if (this.lwFrame == null) {
            return;
        }
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.notifyDisplayChanged(this.lwFrame, scaleX, scaleY);
            }
        });
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        bounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, (float)this.fxWidth, (float)this.fxHeight, 0.0f);
        tx.transform(bounds, bounds);
        return bounds;
    }

    private void ungrabFocus(boolean postUngrabEvent) {
        if (PlatformUtil.isLinux()) {
            return;
        }
        if (this.grabbed && this.getScene() != null && this.getScene().getWindow() != null && WindowHelper.getPeer((Window)this.getScene().getWindow()) != null) {
            this.skipBackwardUnrgabNotification = !postUngrabEvent;
            WindowHelper.getPeer((Window)this.getScene().getWindow()).ungrabFocus();
            this.skipBackwardUnrgabNotification = false;
            this.grabbed = false;
        }
    }

    static {
        Object dummy = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                isThreadMerged = Boolean.valueOf(System.getProperty("javafx.embed.singleThread"));
                return null;
            }
        });
        SwingNodeHelper.setSwingNodeAccessor(new SwingNodeHelper.SwingNodeAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((SwingNode)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((SwingNode)node).doUpdatePeer();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((SwingNode)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((SwingNode)node).doComputeContains(localX, localY);
            }

            @Override
            public Object getLightweightFrame(SwingNode node) {
                return node.getLightweightFrame();
            }

            @Override
            public ReentrantLock getPaintLock(SwingNode node) {
                return node.getPaintLock();
            }

            @Override
            public void setImageBuffer(SwingNode node, int[] data, int x, int y, int w, int h, int linestride, double scaleX, double scaleY) {
                node.setImageBuffer(data, x, y, w, h, linestride, scaleX, scaleY);
            }

            @Override
            public void setImageBounds(SwingNode node, int x, int y, int w, int h) {
                node.setImageBounds(x, y, w, h);
            }

            @Override
            public void repaintDirtyRegion(SwingNode node, int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight) {
                node.repaintDirtyRegion(dirtyX, dirtyY, dirtyWidth, dirtyHeight);
            }

            @Override
            public void ungrabFocus(SwingNode node, boolean postUngrabEvent) {
                node.ungrabFocus(postUngrabEvent);
            }

            @Override
            public void setSwingPrefWidth(SwingNode node, int swingPrefWidth) {
                node.swingPrefWidth = swingPrefWidth;
            }

            @Override
            public void setSwingPrefHeight(SwingNode node, int swingPrefHeight) {
                node.swingPrefHeight = swingPrefHeight;
            }

            @Override
            public void setSwingMaxWidth(SwingNode node, int swingMaxWidth) {
                node.swingMaxWidth = swingMaxWidth;
            }

            @Override
            public void setSwingMaxHeight(SwingNode node, int swingMaxHeight) {
                node.swingMaxHeight = swingMaxHeight;
            }

            @Override
            public void setSwingMinWidth(SwingNode node, int swingMinWidth) {
                node.swingMinWidth = swingMinWidth;
            }

            @Override
            public void setSwingMinHeight(SwingNode node, int swingMinHeight) {
                node.swingMinHeight = swingMinHeight;
            }

            @Override
            public void setGrabbed(SwingNode node, boolean grab) {
                node.grabbed = grab;
            }
        });
    }

    private class SwingMouseEventHandler
    implements EventHandler<javafx.scene.input.MouseEvent> {
        private final Set<MouseButton> mouseClickedAllowed = new HashSet<MouseButton>();

        private SwingMouseEventHandler() {
        }

        public void handle(javafx.scene.input.MouseEvent event) {
            LightweightFrameWrapper frame = SwingNode.this.swNodeIOP.getLightweightFrame();
            if (frame == null) {
                return;
            }
            int swingID = SwingEvents.fxMouseEventTypeToMouseID(event);
            if (swingID < 0) {
                return;
            }
            event.consume();
            EventType type = event.getEventType();
            if (type == javafx.scene.input.MouseEvent.MOUSE_PRESSED) {
                this.mouseClickedAllowed.add(event.getButton());
            } else if (type != javafx.scene.input.MouseEvent.MOUSE_RELEASED) {
                if (type == javafx.scene.input.MouseEvent.MOUSE_DRAGGED) {
                    this.mouseClickedAllowed.clear();
                } else if (type == javafx.scene.input.MouseEvent.MOUSE_CLICKED) {
                    if (event.getClickCount() == 1 && !this.mouseClickedAllowed.contains(event.getButton())) {
                        return;
                    }
                    this.mouseClickedAllowed.remove(event.getButton());
                }
            }
            int swingModifiers = SwingEvents.fxMouseModsToMouseMods(event);
            boolean swingPopupTrigger = event.isPopupTrigger();
            int swingButton = SwingEvents.fxMouseButtonToMouseButton(event);
            long swingWhen = System.currentTimeMillis();
            int relX = (int)Math.round(event.getX());
            int relY = (int)Math.round(event.getY());
            int absX = (int)Math.round(event.getScreenX());
            int absY = (int)Math.round(event.getScreenY());
            MouseEvent mouseEvent = SwingNode.this.swNodeIOP.createMouseEvent(frame, swingID, swingWhen, swingModifiers, relX, relY, absX, absY, event.getClickCount(), swingPopupTrigger, swingButton);
            Void dummy = AccessController.doPrivileged(new PostEventAction(mouseEvent));
        }
    }

    private class SwingKeyEventHandler
    implements EventHandler<KeyEvent> {
        private SwingKeyEventHandler() {
        }

        public void handle(KeyEvent event) {
            String text;
            int swingID;
            LightweightFrameWrapper frame = SwingNode.this.swNodeIOP.getLightweightFrame();
            if (frame == null) {
                return;
            }
            if (event.getCharacter().isEmpty()) {
                return;
            }
            if (event.getCode() == KeyCode.LEFT || event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.UP || event.getCode() == KeyCode.DOWN || event.getCode() == KeyCode.TAB) {
                event.consume();
            }
            if ((swingID = SwingEvents.fxKeyEventTypeToKeyID(event)) < 0) {
                return;
            }
            int swingModifiers = SwingEvents.fxKeyModsToKeyMods(event);
            int swingKeyCode = event.getCode().getCode();
            char swingChar = event.getCharacter().charAt(0);
            if (event.getEventType() == KeyEvent.KEY_PRESSED && (text = event.getText()).length() == 1) {
                swingChar = text.charAt(0);
            }
            long swingWhen = System.currentTimeMillis();
            java.awt.event.KeyEvent keyEvent = SwingNode.this.swNodeIOP.createKeyEvent(frame, swingID, swingWhen, swingModifiers, swingKeyCode, swingChar);
            Void dummy = AccessController.doPrivileged(new PostEventAction(keyEvent));
        }
    }

    private class SwingScrollEventHandler
    implements EventHandler<ScrollEvent> {
        private SwingScrollEventHandler() {
        }

        public void handle(ScrollEvent event) {
            double delta;
            boolean isShift;
            LightweightFrameWrapper frame = SwingNode.this.swNodeIOP.getLightweightFrame();
            if (frame == null) {
                return;
            }
            int swingModifiers = SwingEvents.fxScrollModsToMouseWheelMods(event);
            boolean bl = isShift = (swingModifiers & 0x40) != 0;
            if (!isShift && event.getDeltaY() != 0.0) {
                this.sendMouseWheelEvent(frame, event.getX(), event.getY(), swingModifiers, event.getDeltaY() / event.getMultiplierY());
            }
            double d = delta = isShift && event.getDeltaY() != 0.0 ? event.getDeltaY() / event.getMultiplierY() : event.getDeltaX() / event.getMultiplierX();
            if (delta != 0.0) {
                this.sendMouseWheelEvent(frame, event.getX(), event.getY(), swingModifiers |= 0x40, delta);
            }
        }

        private void sendMouseWheelEvent(Object source, double fxX, double fxY, int swingModifiers, double delta) {
            int wheelRotation = (int)delta;
            int signum = (int)Math.signum(delta);
            if ((double)signum * delta < 1.0) {
                wheelRotation = signum;
            }
            int x = (int)Math.round(fxX);
            int y = (int)Math.round(fxY);
            MouseWheelEvent mouseWheelEvent = SwingNode.this.swNodeIOP.createMouseWheelEvent(source, swingModifiers, x, y, -wheelRotation);
            Void dummy = AccessController.doPrivileged(new PostEventAction(mouseWheelEvent));
        }
    }

    private static class SwingNodeWindowFocusListener
    implements WindowFocusListener {
        private WeakReference<SwingNode> swingNodeRef;

        SwingNodeWindowFocusListener(SwingNode swingNode) {
            this.swingNodeRef = new WeakReference<SwingNode>(swingNode);
        }

        @Override
        public void windowGainedFocus(java.awt.event.WindowEvent e) {
            SwingNodeHelper.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)((Object)((Object)this.swingNodeRef.get()));
                if (swingNode != null) {
                    swingNode.requestFocus();
                }
            });
        }

        @Override
        public void windowLostFocus(java.awt.event.WindowEvent e) {
            SwingNodeHelper.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)((Object)((Object)this.swingNodeRef.get()));
                if (swingNode != null) {
                    swingNode.ungrabFocus(true);
                }
            });
        }
    }

    private class PostEventAction
    implements PrivilegedAction<Void> {
        private AWTEvent event;

        PostEventAction(AWTEvent event) {
            this.event = event;
        }

        @Override
        public Void run() {
            EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eq.postEvent(this.event);
            return null;
        }
    }
}

