/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.embed.swing.newimpl;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.embed.swing.DisposerRecord;
import com.sun.javafx.embed.swing.FXDnD;
import com.sun.javafx.embed.swing.SwingCursors;
import com.sun.javafx.embed.swing.SwingNodeHelper;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.util.Utils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowFocusListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javafx.embed.swing.SwingNode;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;
import javax.swing.JComponent;
import jdk.swing.interop.DragSourceContextWrapper;
import jdk.swing.interop.LightweightContentWrapper;
import jdk.swing.interop.LightweightFrameWrapper;

public class SwingNodeInteropN {
    private volatile LightweightFrameWrapper lwFrame;
    private static OptionalMethod<LightweightFrameWrapper> jlfNotifyDisplayChanged;
    private static Class lwFrameWrapperClass;
    private static final OptionalMethod<LightweightFrameWrapper> jlfSetHostBounds;

    private static native void overrideNativeWindowHandle(Class var0, LightweightFrameWrapper var1, long var2, Runnable var4);

    public LightweightFrameWrapper createLightweightFrame() {
        this.lwFrame = new LightweightFrameWrapper();
        return this.lwFrame;
    }

    public LightweightFrameWrapper getLightweightFrame() {
        return this.lwFrame;
    }

    public MouseEvent createMouseEvent(Object frame, int swingID, long swingWhen, int swingModifiers, int relX, int relY, int absX, int absY, int clickCount, boolean swingPopupTrigger, int swingButton) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        return lwFrame.createMouseEvent(lwFrame, swingID, swingWhen, swingModifiers, relX, relY, absX, absY, clickCount, swingPopupTrigger, swingButton);
    }

    public MouseWheelEvent createMouseWheelEvent(Object frame, int swingModifiers, int x, int y, int wheelRotation) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        return lwFrame.createMouseWheelEvent(lwFrame, swingModifiers, x, y, wheelRotation);
    }

    public KeyEvent createKeyEvent(Object frame, int swingID, long swingWhen, int swingModifiers, int swingKeyCode, char swingChar) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        return lwFrame.createKeyEvent(lwFrame, swingID, swingWhen, swingModifiers, swingKeyCode, swingChar);
    }

    public AWTEvent createUngrabEvent(Object frame) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        return lwFrame.createUngrabEvent(lwFrame);
    }

    public void overrideNativeWindowHandle(Object frame, long handle, Runnable closeWindow) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        SwingNodeInteropN.overrideNativeWindowHandle(lwFrameWrapperClass, lwFrame, handle, closeWindow);
    }

    public void notifyDisplayChanged(Object frame, double scaleX, double scaleY) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        if (jlfNotifyDisplayChanged.isIntegerApi()) {
            jlfNotifyDisplayChanged.invoke(lwFrame, (int)Math.round(scaleX));
        } else {
            jlfNotifyDisplayChanged.invoke(lwFrame, scaleX, scaleY);
        }
    }

    public void setHostBounds(Object frame, int windowX, int windowY, int windowW, int windowH) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        jlfSetHostBounds.invoke(lwFrame, windowX, windowY, windowW, windowH);
    }

    public void setContent(Object frame, Object cnt) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        LightweightContentWrapper content = (LightweightContentWrapper)cnt;
        lwFrame.setContent(content);
    }

    public void setVisible(Object frame, boolean visible) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        lwFrame.setVisible(visible);
    }

    public void setBounds(Object frame, int frameX, int frameY, int frameW, int frameH) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        lwFrame.setBounds(frameX, frameY, frameW, frameH);
    }

    public LightweightContentWrapper createSwingNodeContent(JComponent content, SwingNode node) {
        return new SwingNodeContent(content, node);
    }

    public DisposerRecord createSwingNodeDisposer(Object frame) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        return new SwingNodeDisposer(lwFrame);
    }

    public void emulateActivation(Object frame, boolean activate) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        lwFrame.emulateActivation(activate);
    }

    public void disposeFrame(Object frame) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        lwFrame.dispose();
    }

    public void addWindowFocusListener(Object frame, WindowFocusListener l) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        lwFrame.addWindowFocusListener(l);
    }

    static {
        lwFrameWrapperClass = null;
        jlfNotifyDisplayChanged = new OptionalMethod<LightweightFrameWrapper>(LightweightFrameWrapper.class, "notifyDisplayChanged", Double.TYPE, Double.TYPE);
        if (!jlfNotifyDisplayChanged.isSupported()) {
            jlfNotifyDisplayChanged = new OptionalMethod<LightweightFrameWrapper>(LightweightFrameWrapper.class, "notifyDisplayChanged", Integer.TYPE);
        }
        try {
            lwFrameWrapperClass = Class.forName("jdk.swing.interop.LightweightFrameWrapper");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Utils.loadNativeSwingLibrary();
        jlfSetHostBounds = new OptionalMethod<LightweightFrameWrapper>(LightweightFrameWrapper.class, "setHostBounds", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    }

    private static class SwingNodeContent
    extends LightweightContentWrapper {
        private JComponent comp;
        private volatile FXDnD dnd;
        private WeakReference<SwingNode> swingNodeRef;

        SwingNodeContent(JComponent comp, SwingNode swingNode) {
            this.comp = comp;
            this.swingNodeRef = new WeakReference<SwingNode>(swingNode);
        }

        @Override
        public JComponent getComponent() {
            return this.comp;
        }

        @Override
        public void paintLock() {
            SwingNode swingNode = (SwingNode)((Object)this.swingNodeRef.get());
            if (swingNode != null) {
                SwingNodeHelper.getPaintLock(swingNode).lock();
            }
        }

        @Override
        public void paintUnlock() {
            SwingNode swingNode = (SwingNode)((Object)this.swingNodeRef.get());
            if (swingNode != null) {
                SwingNodeHelper.getPaintLock(swingNode).unlock();
            }
        }

        @Override
        public void imageBufferReset(int[] data, int x, int y, int width, int height, int linestride) {
            this.imageBufferReset(data, x, y, width, height, linestride, 1);
        }

        public void imageBufferReset(int[] data, int x, int y, int width, int height, int linestride, int scale) {
            SwingNode swingNode = (SwingNode)((Object)this.swingNodeRef.get());
            if (swingNode != null) {
                SwingNodeHelper.setImageBuffer(swingNode, data, x, y, width, height, linestride, scale, scale);
            }
        }

        @Override
        public void imageBufferReset(int[] data, int x, int y, int width, int height, int linestride, double scaleX, double scaleY) {
            SwingNode swingNode = (SwingNode)((Object)this.swingNodeRef.get());
            if (swingNode != null) {
                SwingNodeHelper.setImageBuffer(swingNode, data, x, y, width, height, linestride, scaleX, scaleY);
            }
        }

        @Override
        public void imageReshaped(int x, int y, int width, int height) {
            SwingNode swingNode = (SwingNode)((Object)this.swingNodeRef.get());
            if (swingNode != null) {
                SwingNodeHelper.setImageBounds(swingNode, x, y, width, height);
            }
        }

        @Override
        public void imageUpdated(int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight) {
            SwingNode swingNode = (SwingNode)((Object)this.swingNodeRef.get());
            if (swingNode != null) {
                SwingNodeHelper.repaintDirtyRegion(swingNode, dirtyX, dirtyY, dirtyWidth, dirtyHeight);
            }
        }

        @Override
        public void focusGrabbed() {
            SwingNodeHelper.runOnFxThread(() -> {
                Scene scene;
                if (PlatformUtil.isLinux()) {
                    return;
                }
                SwingNode swingNode = (SwingNode)((Object)((Object)this.swingNodeRef.get()));
                if (swingNode != null && (scene = swingNode.getScene()) != null && scene.getWindow() != null && WindowHelper.getPeer((Window)scene.getWindow()) != null) {
                    WindowHelper.getPeer((Window)scene.getWindow()).grabFocus();
                    SwingNodeHelper.setGrabbed(swingNode, true);
                }
            });
        }

        @Override
        public void focusUngrabbed() {
            SwingNodeHelper.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)((Object)((Object)this.swingNodeRef.get()));
                if (swingNode != null) {
                    Scene scene = swingNode.getScene();
                    SwingNodeHelper.ungrabFocus(swingNode, false);
                }
            });
        }

        @Override
        public void preferredSizeChanged(int width, int height) {
            SwingNodeHelper.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)((Object)((Object)this.swingNodeRef.get()));
                if (swingNode != null) {
                    SwingNodeHelper.setSwingPrefWidth(swingNode, width);
                    SwingNodeHelper.setSwingPrefHeight(swingNode, height);
                    NodeHelper.notifyLayoutBoundsChanged((Node)swingNode);
                }
            });
        }

        @Override
        public void maximumSizeChanged(int width, int height) {
            SwingNodeHelper.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)((Object)((Object)this.swingNodeRef.get()));
                if (swingNode != null) {
                    SwingNodeHelper.setSwingMaxWidth(swingNode, width);
                    SwingNodeHelper.setSwingMaxHeight(swingNode, height);
                    NodeHelper.notifyLayoutBoundsChanged((Node)swingNode);
                }
            });
        }

        @Override
        public void minimumSizeChanged(int width, int height) {
            SwingNodeHelper.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)((Object)((Object)this.swingNodeRef.get()));
                if (swingNode != null) {
                    SwingNodeHelper.setSwingMinWidth(swingNode, width);
                    SwingNodeHelper.setSwingMinHeight(swingNode, height);
                    NodeHelper.notifyLayoutBoundsChanged((Node)swingNode);
                }
            });
        }

        public void setCursor(Cursor cursor) {
            SwingNodeHelper.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)((Object)((Object)this.swingNodeRef.get()));
                if (swingNode != null) {
                    swingNode.setCursor(SwingCursors.embedCursorToCursor(cursor));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initDnD() {
            SwingNodeContent swingNodeContent = this;
            synchronized (swingNodeContent) {
                SwingNode swingNode;
                if (this.dnd == null && (swingNode = (SwingNode)((Object)this.swingNodeRef.get())) != null) {
                    this.dnd = new FXDnD(swingNode);
                }
            }
        }

        @Override
        public synchronized <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> abstractRecognizerClass, DragSource ds, Component c, int srcActions, DragGestureListener dgl) {
            this.initDnD();
            return this.dnd.createDragGestureRecognizer(abstractRecognizerClass, ds, c, srcActions, dgl);
        }

        @Override
        public DragSourceContextWrapper createDragSourceContext(DragGestureEvent dge) throws InvalidDnDOperationException {
            this.initDnD();
            return (DragSourceContextWrapper)this.dnd.createDragSourceContext(dge);
        }

        @Override
        public void addDropTarget(DropTarget dt) {
            this.initDnD();
            this.dnd.addDropTarget(dt);
        }

        @Override
        public void removeDropTarget(DropTarget dt) {
            this.initDnD();
            this.dnd.removeDropTarget(dt);
        }
    }

    private static class SwingNodeDisposer
    implements DisposerRecord {
        LightweightFrameWrapper lwFrame;

        SwingNodeDisposer(LightweightFrameWrapper ref) {
            this.lwFrame = ref;
        }

        @Override
        public void dispose() {
            if (this.lwFrame != null) {
                this.lwFrame.dispose();
                this.lwFrame = null;
            }
        }
    }

    private static final class OptionalMethod<T> {
        private final Method method;
        private final boolean isIntegerAPI;

        OptionalMethod(Class<T> cls, String name, Class<?> ... args) {
            Method m;
            try {
                m = cls.getMethod(name, args);
            }
            catch (NoSuchMethodException ignored) {
                m = null;
            }
            catch (Throwable ex) {
                throw new RuntimeException("Error when calling " + cls.getName() + ".getMethod('" + name + "').", ex);
            }
            this.method = m;
            this.isIntegerAPI = args != null && args.length > 0 && args[0] == Integer.TYPE;
        }

        public boolean isSupported() {
            return this.method != null;
        }

        public boolean isIntegerApi() {
            return this.isIntegerAPI;
        }

        public Object invoke(T object, Object ... args) {
            if (this.method != null) {
                try {
                    return this.method.invoke(object, args);
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Error when calling " + object.getClass().getName() + "." + this.method.getName() + "().", ex);
                }
            }
            return null;
        }
    }
}

