/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.collections.ObservableListWrapper;
import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextHitInfo;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;

class InputMethodSupport {
    InputMethodSupport() {
    }

    public static ObservableList<InputMethodTextRun> inputMethodEventComposed(String text, int commitCount) {
        ArrayList<InputMethodTextRun> composed = new ArrayList<InputMethodTextRun>();
        if (commitCount < text.length()) {
            composed.add(new InputMethodTextRun(text.substring(commitCount), InputMethodHighlight.UNSELECTED_RAW));
        }
        return new ObservableListWrapper(composed);
    }

    public static String getTextForEvent(InputMethodEvent e) {
        AttributedCharacterIterator text = e.getText();
        if (e.getText() != null) {
            char c = text.first();
            StringBuilder result = new StringBuilder();
            while (c != '\uffff') {
                result.append(c);
                c = text.next();
            }
            return result.toString();
        }
        return "";
    }

    public static class InputMethodRequestsAdapter
    implements java.awt.im.InputMethodRequests {
        private final InputMethodRequests fxRequests;

        public InputMethodRequestsAdapter(InputMethodRequests fxRequests) {
            this.fxRequests = fxRequests;
        }

        @Override
        public Rectangle getTextLocation(TextHitInfo offset) {
            Point2D result = this.fxRequests.getTextLocation(offset.getInsertionIndex());
            return new Rectangle((int)result.getX(), (int)result.getY(), 0, 0);
        }

        @Override
        public TextHitInfo getLocationOffset(int x, int y) {
            int result = this.fxRequests.getLocationOffset(x, y);
            return TextHitInfo.afterOffset(result);
        }

        @Override
        public int getInsertPositionOffset() {
            if (this.fxRequests instanceof ExtendedInputMethodRequests) {
                return ((ExtendedInputMethodRequests)this.fxRequests).getInsertPositionOffset();
            }
            return 0;
        }

        @Override
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            String result = null;
            if (this.fxRequests instanceof ExtendedInputMethodRequests) {
                result = ((ExtendedInputMethodRequests)this.fxRequests).getCommittedText(beginIndex, endIndex);
            }
            if (result == null) {
                result = "";
            }
            return new AttributedString(result).getIterator();
        }

        @Override
        public int getCommittedTextLength() {
            if (this.fxRequests instanceof ExtendedInputMethodRequests) {
                return ((ExtendedInputMethodRequests)this.fxRequests).getCommittedTextLength();
            }
            return 0;
        }

        @Override
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            String text = this.fxRequests.getSelectedText();
            if (text == null) {
                text = "";
            }
            return new AttributedString(text).getIterator();
        }
    }
}

