/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.embed.swing;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.embed.swing.SwingNode;
import javafx.scene.Node;
import javax.swing.SwingUtilities;

public class SwingNodeHelper
extends NodeHelper {
    private static final SwingNodeHelper theInstance = new SwingNodeHelper();
    private static SwingNodeAccessor swingNodeAccessor;
    private static final Set<Object> eventLoopKeys;

    private static SwingNodeHelper getInstance() {
        return theInstance;
    }

    public static void initHelper(SwingNode swingNode) {
        SwingNodeHelper.setHelper((Node)swingNode, (NodeHelper)SwingNodeHelper.getInstance());
    }

    protected NGNode createPeerImpl(Node node) {
        return swingNodeAccessor.doCreatePeer(node);
    }

    protected void updatePeerImpl(Node node) {
        super.updatePeerImpl(node);
        swingNodeAccessor.doUpdatePeer(node);
    }

    protected BaseBounds computeGeomBoundsImpl(Node node, BaseBounds bounds, BaseTransform tx) {
        return swingNodeAccessor.doComputeGeomBounds(node, bounds, tx);
    }

    protected boolean computeContainsImpl(Node node, double localX, double localY) {
        return swingNodeAccessor.doComputeContains(node, localX, localY);
    }

    public static Object getLightweightFrame(SwingNode node) {
        return swingNodeAccessor.getLightweightFrame(node);
    }

    public static ReentrantLock getPaintLock(SwingNode node) {
        return swingNodeAccessor.getPaintLock(node);
    }

    public static void setImageBuffer(SwingNode node, int[] data, int x, int y, int w, int h, int linestride, double scaleX, double scaleY) {
        swingNodeAccessor.setImageBuffer(node, data, x, y, w, h, linestride, scaleX, scaleY);
    }

    public static void setImageBounds(SwingNode node, int x, int y, int w, int h) {
        swingNodeAccessor.setImageBounds(node, x, y, w, h);
    }

    public static void repaintDirtyRegion(SwingNode node, int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight) {
        swingNodeAccessor.repaintDirtyRegion(node, dirtyX, dirtyY, dirtyWidth, dirtyHeight);
    }

    public static void ungrabFocus(SwingNode node, boolean postUngrabEvent) {
        swingNodeAccessor.ungrabFocus(node, postUngrabEvent);
    }

    public static void setSwingPrefWidth(SwingNode node, int swingPrefWidth) {
        swingNodeAccessor.setSwingPrefWidth(node, swingPrefWidth);
    }

    public static void setSwingPrefHeight(SwingNode node, int swingPrefHeight) {
        swingNodeAccessor.setSwingPrefHeight(node, swingPrefHeight);
    }

    public static void setSwingMaxWidth(SwingNode node, int swingMaxWidth) {
        swingNodeAccessor.setSwingMaxWidth(node, swingMaxWidth);
    }

    public static void setSwingMaxHeight(SwingNode node, int swingMaxHeight) {
        swingNodeAccessor.setSwingMaxHeight(node, swingMaxHeight);
    }

    public static void setSwingMinWidth(SwingNode node, int swingMinWidth) {
        swingNodeAccessor.setSwingMinWidth(node, swingMinWidth);
    }

    public static void setSwingMinHeight(SwingNode node, int swingMinHeight) {
        swingNodeAccessor.setSwingMinHeight(node, swingMinHeight);
    }

    public static void setGrabbed(SwingNode node, boolean grab) {
        swingNodeAccessor.setGrabbed(node, grab);
    }

    public static void runOnFxThread(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static void runOnEDT(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void runOnEDTAndWait(Object nestedLoopKey, Runnable r) {
        Toolkit.getToolkit().checkFxUserThread();
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            eventLoopKeys.add(nestedLoopKey);
            SwingUtilities.invokeLater(r);
            Toolkit.getToolkit().enterNestedEventLoop(nestedLoopKey);
        }
    }

    public static void leaveFXNestedLoop(Object nestedLoopKey) {
        if (!eventLoopKeys.contains(nestedLoopKey)) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            Toolkit.getToolkit().exitNestedEventLoop(nestedLoopKey, null);
        } else {
            Platform.runLater(() -> Toolkit.getToolkit().exitNestedEventLoop(nestedLoopKey, null));
        }
        eventLoopKeys.remove(nestedLoopKey);
    }

    public static void setSwingNodeAccessor(SwingNodeAccessor newAccessor) {
        if (swingNodeAccessor != null) {
            throw new IllegalStateException();
        }
        swingNodeAccessor = newAccessor;
    }

    static {
        Utils.forceInit(SwingNode.class);
        eventLoopKeys = new HashSet<Object>();
    }

    public static interface SwingNodeAccessor {
        public NGNode doCreatePeer(Node var1);

        public void doUpdatePeer(Node var1);

        public BaseBounds doComputeGeomBounds(Node var1, BaseBounds var2, BaseTransform var3);

        public boolean doComputeContains(Node var1, double var2, double var4);

        public Object getLightweightFrame(SwingNode var1);

        public ReentrantLock getPaintLock(SwingNode var1);

        public void setImageBuffer(SwingNode var1, int[] var2, int var3, int var4, int var5, int var6, int var7, double var8, double var10);

        public void setImageBounds(SwingNode var1, int var2, int var3, int var4, int var5);

        public void repaintDirtyRegion(SwingNode var1, int var2, int var3, int var4, int var5);

        public void ungrabFocus(SwingNode var1, boolean var2);

        public void setSwingPrefWidth(SwingNode var1, int var2);

        public void setSwingPrefHeight(SwingNode var1, int var2);

        public void setSwingMaxWidth(SwingNode var1, int var2);

        public void setSwingMaxHeight(SwingNode var1, int var2);

        public void setSwingMinWidth(SwingNode var1, int var2);

        public void setSwingMinHeight(SwingNode var1, int var2);

        public void setGrabbed(SwingNode var1, boolean var2);
    }
}

