/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.embed.swing.newimpl;

import com.sun.javafx.embed.swing.CachingTransferable;
import com.sun.javafx.embed.swing.FXDnD;
import com.sun.javafx.embed.swing.SwingDnD;
import com.sun.javafx.embed.swing.SwingEvents;
import com.sun.javafx.embed.swing.SwingNodeHelper;
import com.sun.javafx.tk.Toolkit;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.SecondaryLoop;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.embed.swing.SwingNode;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import jdk.swing.interop.DragSourceContextWrapper;
import jdk.swing.interop.DropTargetContextWrapper;
import jdk.swing.interop.LightweightFrameWrapper;

public class FXDnDInteropN {
    private WeakReference<SwingNode> nodeRef = null;
    private boolean isDragSourceListenerInstalled = false;
    private javafx.scene.input.MouseEvent pressEvent = null;
    private long pressTime = 0L;
    private volatile SecondaryLoop loop;
    private final Map<Component, FXDragGestureRecognizer> recognizers = new HashMap<Component, FXDragGestureRecognizer>();
    private final EventHandler<javafx.scene.input.MouseEvent> onMousePressHandler = event -> {
        this.pressEvent = event;
        this.pressTime = System.currentTimeMillis();
    };
    private volatile FXDragSourceContextPeer activeDSContextPeer;
    private final EventHandler<javafx.scene.input.MouseEvent> onDragStartHandler = event -> {
        this.activeDSContextPeer = null;
        javafx.scene.input.MouseEvent firstEv = this.getInitialGestureEvent();
        SwingNodeHelper.runOnEDTAndWait(this, () -> this.fireEvent((int)firstEv.getX(), (int)firstEv.getY(), this.pressTime, SwingEvents.fxMouseModsToMouseMods(firstEv)));
        if (this.activeDSContextPeer == null) {
            return;
        }
        event.consume();
        SwingNode node = this.getNode();
        if (node != null) {
            Dragboard db = node.startDragAndDrop(SwingDnD.dropActionsToTransferModes(this.activeDSContextPeer.sourceActions).toArray(new TransferMode[1]));
            HashMap<DataFormat, Object> fxData = new HashMap<DataFormat, Object>();
            for (String mt : this.activeDSContextPeer.transferable.getMimeTypes()) {
                DataFormat f = DataFormat.lookupMimeType((String)mt);
                if (f == null) continue;
                fxData.put(f, this.activeDSContextPeer.transferable.getData(mt));
            }
            boolean hasContent = db.setContent(fxData);
            if (!hasContent && !FXDnD.fxAppThreadIsDispatchThread) {
                this.loop.exit();
            }
        }
    };
    private final EventHandler<DragEvent> onDragDoneHandler = event -> {
        event.consume();
        if (!FXDnD.fxAppThreadIsDispatchThread) {
            this.loop.exit();
        }
        if (this.activeDSContextPeer != null) {
            TransferMode mode = event.getTransferMode();
            this.activeDSContextPeer.dragDone(mode == null ? 0 : SwingDnD.transferModeToDropAction(mode), (int)event.getX(), (int)event.getY());
        }
    };
    private boolean isDropTargetListenerInstalled = false;
    private volatile FXDropTargetContextPeer activeDTContextPeer = null;
    private final Map<Component, DropTarget> dropTargets = new HashMap<Component, DropTarget>();
    private final EventHandler<DragEvent> onDragEnteredHandler = event -> {
        int action;
        if (this.activeDTContextPeer == null) {
            this.activeDTContextPeer = new FXDropTargetContextPeer();
        }
        if ((action = this.activeDTContextPeer.postDropTargetEvent((DragEvent)event)) != 0) {
            event.consume();
        }
    };
    private final EventHandler<DragEvent> onDragExitedHandler = event -> {
        if (this.activeDTContextPeer == null) {
            this.activeDTContextPeer = new FXDropTargetContextPeer();
        }
        this.activeDTContextPeer.postDropTargetEvent((DragEvent)event);
        this.activeDTContextPeer = null;
    };
    private final EventHandler<DragEvent> onDragOverHandler = event -> {
        int action;
        if (this.activeDTContextPeer == null) {
            this.activeDTContextPeer = new FXDropTargetContextPeer();
        }
        if ((action = this.activeDTContextPeer.postDropTargetEvent((DragEvent)event)) != 0) {
            event.acceptTransferModes(SwingDnD.dropActionsToTransferModes(action).toArray(new TransferMode[1]));
            event.consume();
        }
    };
    private final EventHandler<DragEvent> onDragDroppedHandler = event -> {
        int action;
        if (this.activeDTContextPeer == null) {
            this.activeDTContextPeer = new FXDropTargetContextPeer();
        }
        if ((action = this.activeDTContextPeer.postDropTargetEvent((DragEvent)event)) != 0) {
            event.setDropCompleted(this.activeDTContextPeer.success);
            event.consume();
        }
        this.activeDTContextPeer = null;
    };

    public Component findComponentAt(Object frame, int x, int y, boolean ignoreEnabled) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        return lwFrame.findComponentAt(lwFrame, x, y, false);
    }

    public boolean isCompEqual(Component c, Object frame) {
        LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)frame;
        return lwFrame.isCompEqual(c, lwFrame);
    }

    public int convertModifiersToDropAction(int modifiers, int supportedActions) {
        return DragSourceContextWrapper.convertModifiersToDropAction(modifiers, supportedActions);
    }

    public Object createDragSourceContext(DragGestureEvent dge) throws InvalidDnDOperationException {
        return new FXDragSourceContextPeer(dge);
    }

    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(DragSource ds, Component c, int srcActions, DragGestureListener dgl) {
        return (T)new FXDragGestureRecognizer(ds, c, srcActions, dgl);
    }

    private void runOnFxThread(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public SwingNode getNode() {
        return (SwingNode)((Object)this.nodeRef.get());
    }

    public void setNode(SwingNode swnode) {
        this.nodeRef = new WeakReference<SwingNode>(swnode);
    }

    public <T> ComponentMapper<T> mapComponent(Map<Component, T> map, int x, int y) {
        return new ComponentMapper<T>(map, x, y);
    }

    private void fireEvent(int x, int y, long evTime, int modifiers) {
        ComponentMapper<FXDragGestureRecognizer> mapper = this.mapComponent(this.recognizers, x, y);
        FXDragGestureRecognizer r = (FXDragGestureRecognizer)mapper.object;
        if (r != null) {
            r.fireEvent(mapper.x, mapper.y, evTime, modifiers);
        } else {
            SwingNodeHelper.leaveFXNestedLoop(this);
        }
    }

    private javafx.scene.input.MouseEvent getInitialGestureEvent() {
        return this.pressEvent;
    }

    public void addDropTarget(DropTarget dt, SwingNode node) {
        this.dropTargets.put(dt.getComponent(), dt);
        Platform.runLater(() -> {
            if (!this.isDropTargetListenerInstalled) {
                node.addEventHandler(DragEvent.DRAG_ENTERED, this.onDragEnteredHandler);
                node.addEventHandler(DragEvent.DRAG_EXITED, this.onDragExitedHandler);
                node.addEventHandler(DragEvent.DRAG_OVER, this.onDragOverHandler);
                node.addEventHandler(DragEvent.DRAG_DROPPED, this.onDragDroppedHandler);
                this.isDropTargetListenerInstalled = true;
            }
        });
    }

    public void removeDropTarget(DropTarget dt, SwingNode node) {
        this.dropTargets.remove(dt.getComponent());
        Platform.runLater(() -> {
            if (this.isDropTargetListenerInstalled && this.dropTargets.isEmpty()) {
                node.removeEventHandler(DragEvent.DRAG_ENTERED, this.onDragEnteredHandler);
                node.removeEventHandler(DragEvent.DRAG_EXITED, this.onDragExitedHandler);
                node.removeEventHandler(DragEvent.DRAG_OVER, this.onDragOverHandler);
                node.removeEventHandler(DragEvent.DRAG_DROPPED, this.onDragDroppedHandler);
                this.isDropTargetListenerInstalled = false;
            }
        });
    }

    private final class FXDropTargetContextPeer
    extends DropTargetContextWrapper {
        private int targetActions = 0;
        private int currentAction = 0;
        private DropTarget dt = null;
        private DropTargetContext ctx = null;
        private final CachingTransferable transferable = new CachingTransferable();
        private boolean success = false;
        private int dropAction = 0;

        private FXDropTargetContextPeer() {
        }

        @Override
        public synchronized void setTargetActions(int actions) {
            this.targetActions = actions;
        }

        @Override
        public synchronized int getTargetActions() {
            return this.targetActions;
        }

        @Override
        public synchronized DropTarget getDropTarget() {
            return this.dt;
        }

        @Override
        public synchronized boolean isTransferableJVMLocal() {
            return false;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.transferable.getTransferDataFlavors();
        }

        @Override
        public synchronized Transferable getTransferable() {
            return this.transferable;
        }

        @Override
        public synchronized void acceptDrag(int dragAction) {
            this.currentAction = dragAction;
        }

        @Override
        public synchronized void rejectDrag() {
            this.currentAction = 0;
        }

        @Override
        public synchronized void acceptDrop(int dropAction) {
            this.dropAction = dropAction;
        }

        @Override
        public synchronized void rejectDrop() {
            this.dropAction = 0;
        }

        @Override
        public synchronized void dropComplete(boolean success) {
            this.success = success;
        }

        private int postDropTargetEvent(DragEvent event) {
            ComponentMapper<DropTarget> mapper = FXDnDInteropN.this.mapComponent(FXDnDInteropN.this.dropTargets, (int)event.getX(), (int)event.getY());
            EventType fxEvType = event.getEventType();
            Dragboard db = event.getDragboard();
            this.transferable.updateData((Clipboard)db, DragEvent.DRAG_DROPPED.equals(fxEvType));
            int sourceActions = SwingDnD.transferModesToDropActions(db.getTransferModes());
            int userAction = event.getTransferMode() == null ? 0 : SwingDnD.transferModeToDropAction(event.getTransferMode());
            DropTarget target = mapper.object != null ? (DropTarget)mapper.object : this.dt;
            SwingNodeHelper.runOnEDTAndWait(FXDnDInteropN.this, () -> {
                if (target != this.dt) {
                    if (this.ctx != null) {
                        this.reset(this.ctx);
                    }
                    this.ctx = null;
                    this.dropAction = 0;
                    this.currentAction = 0;
                }
                if (target != null) {
                    if (this.ctx == null) {
                        this.ctx = target.getDropTargetContext();
                        this.setDropTargetContext(this.ctx, this);
                    }
                    DropTarget dtl = target;
                    if (DragEvent.DRAG_DROPPED.equals(fxEvType)) {
                        DropTargetDropEvent awtEvent = new DropTargetDropEvent(this.ctx, new Point(mapper.x, mapper.y), userAction, sourceActions);
                        dtl.drop(awtEvent);
                    } else {
                        DropTargetDragEvent awtEvent = new DropTargetDragEvent(this.ctx, new Point(mapper.x, mapper.y), userAction, sourceActions);
                        if (DragEvent.DRAG_OVER.equals(fxEvType)) {
                            dtl.dragOver(awtEvent);
                        } else if (DragEvent.DRAG_ENTERED.equals(fxEvType)) {
                            dtl.dragEnter(awtEvent);
                        } else if (DragEvent.DRAG_EXITED.equals(fxEvType)) {
                            dtl.dragExit(awtEvent);
                        }
                    }
                }
                this.dt = (DropTarget)mapper.object;
                if (this.dt == null) {
                    this.ctx = null;
                    this.dropAction = 0;
                    this.currentAction = 0;
                }
                if (DragEvent.DRAG_DROPPED.equals(fxEvType) || DragEvent.DRAG_EXITED.equals(fxEvType)) {
                    this.ctx = null;
                }
                SwingNodeHelper.leaveFXNestedLoop(FXDnDInteropN.this);
            });
            if (DragEvent.DRAG_DROPPED.equals(fxEvType)) {
                return this.dropAction;
            }
            return this.currentAction;
        }
    }

    private final class FXDragSourceContextPeer
    extends DragSourceContextWrapper {
        private volatile int sourceActions;
        private final CachingTransferable transferable;

        @Override
        public void startSecondaryEventLoop() {
            Toolkit.getToolkit().enterNestedEventLoop((Object)this);
        }

        @Override
        public void quitSecondaryEventLoop() {
            assert (!Platform.isFxApplicationThread());
            Platform.runLater(() -> Toolkit.getToolkit().exitNestedEventLoop((Object)this, null));
        }

        @Override
        protected void setNativeCursor(Cursor c, int cType) {
        }

        private void dragDone(int operation, int x, int y) {
            this.dragDropFinished(operation != 0, operation, x, y);
        }

        FXDragSourceContextPeer(DragGestureEvent dge) {
            super(dge);
            this.sourceActions = 0;
            this.transferable = new CachingTransferable();
        }

        protected void startDrag(Transferable trans, long[] formats, Map formatMap) {
            FXDnDInteropN.this.activeDSContextPeer = this;
            this.transferable.updateData(trans, true);
            this.sourceActions = this.getDragSourceContext().getSourceActions();
            if (!FXDnD.fxAppThreadIsDispatchThread) {
                FXDnDInteropN.this.loop = java.awt.Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
                SwingNodeHelper.leaveFXNestedLoop(FXDnDInteropN.this);
                if (!FXDnDInteropN.this.loop.enter()) {
                    // empty if block
                }
            }
        }
    }

    private class FXDragGestureRecognizer
    extends MouseDragGestureRecognizer {
        FXDragGestureRecognizer(DragSource ds, Component c, int srcActions, DragGestureListener dgl) {
            super(ds, c, srcActions, dgl);
            if (c != null) {
                FXDnDInteropN.this.recognizers.put(c, this);
            }
        }

        @Override
        public void setComponent(Component c) {
            Component old = this.getComponent();
            if (old != null) {
                FXDnDInteropN.this.recognizers.remove(old);
            }
            super.setComponent(c);
            if (c != null) {
                FXDnDInteropN.this.recognizers.put(c, this);
            }
        }

        @Override
        protected void registerListeners() {
            FXDnDInteropN.this.runOnFxThread(() -> {
                if (!FXDnDInteropN.this.isDragSourceListenerInstalled) {
                    SwingNode node = FXDnDInteropN.this.getNode();
                    if (node != null) {
                        node.addEventHandler(javafx.scene.input.MouseEvent.MOUSE_PRESSED, FXDnDInteropN.this.onMousePressHandler);
                        node.addEventHandler(javafx.scene.input.MouseEvent.DRAG_DETECTED, FXDnDInteropN.this.onDragStartHandler);
                        node.addEventHandler(DragEvent.DRAG_DONE, FXDnDInteropN.this.onDragDoneHandler);
                    }
                    FXDnDInteropN.this.isDragSourceListenerInstalled = true;
                }
            });
        }

        @Override
        protected void unregisterListeners() {
            FXDnDInteropN.this.runOnFxThread(() -> {
                if (FXDnDInteropN.this.isDragSourceListenerInstalled) {
                    SwingNode node = FXDnDInteropN.this.getNode();
                    if (node != null) {
                        node.removeEventHandler(javafx.scene.input.MouseEvent.MOUSE_PRESSED, FXDnDInteropN.this.onMousePressHandler);
                        node.removeEventHandler(javafx.scene.input.MouseEvent.DRAG_DETECTED, FXDnDInteropN.this.onDragStartHandler);
                        node.removeEventHandler(DragEvent.DRAG_DONE, FXDnDInteropN.this.onDragDoneHandler);
                    }
                    FXDnDInteropN.this.isDragSourceListenerInstalled = false;
                }
            });
        }

        private void fireEvent(int x, int y, long evTime, int modifiers) {
            this.appendEvent(new MouseEvent(this.getComponent(), 501, evTime, modifiers, x, y, 0, false));
            int initialAction = DragSourceContextWrapper.convertModifiersToDropAction(modifiers, this.getSourceActions());
            this.fireDragGestureRecognized(initialAction, new Point(x, y));
        }
    }

    private class ComponentMapper<T> {
        public int x;
        public int y;
        public T object = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ComponentMapper(Map<Component, T> map, int xArg, int yArg) {
            this.x = xArg;
            this.y = yArg;
            SwingNode node = FXDnDInteropN.this.getNode();
            if (node != null) {
                LightweightFrameWrapper lwFrame = (LightweightFrameWrapper)SwingNodeHelper.getLightweightFrame(node);
                Component c = lwFrame.findComponentAt(lwFrame, this.x, this.y, false);
                if (c == null) {
                    return;
                }
                Object object = c.getTreeLock();
                synchronized (object) {
                    do {
                        this.object = map.get(c);
                    } while (this.object == null && (c = c.getParent()) != null);
                    if (this.object != null) {
                        while (lwFrame.isCompEqual(c, lwFrame) && c != null) {
                            this.x -= c.getX();
                            this.y -= c.getY();
                            c = c.getParent();
                        }
                    }
                }
            }
        }
    }
}

